/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.model.mysql;

import com.oceanbase.obtools.common.utils.StringUtils;
import com.oceanbase.obtools.dbdiff.exception.UnsupportedGrammarException;
import com.oceanbase.obtools.dbdiff.model.AbstractSchema;
import com.oceanbase.obtools.dbdiff.model.AbstractTable;
import java.math.BigDecimal;

public abstract class AbstractMySqlTable
extends AbstractTable {
    private String engine;
    private String version;
    private String rowFormat;
    private String tableRows;
    private String avgRowLength;
    private String dataLength;
    private String maxDataLength;
    private String indexLength;
    private String dataFree;
    private BigDecimal autoIncrement;
    private String createTime;
    private String updateTime;
    private String checkTime;
    private String checksum;
    private String createOptions;
    private String tableCollation;
    private String characterSetName;

    public AbstractMySqlTable(AbstractSchema schema) {
        super(schema);
    }

    @Override
    public String getQuotaCharacter() {
        return "`";
    }

    protected StringBuilder appendTableOptions() throws UnsupportedGrammarException {
        String tableComment;
        String tableCollation;
        String charSetName;
        StringBuilder sb = new StringBuilder();
        BigDecimal autoIncrement = this.getAutoIncrement();
        if (autoIncrement != null && autoIncrement.compareTo(new BigDecimal("0")) > 0) {
            sb.append("\n").append("auto_increment=").append(autoIncrement);
        }
        if (StringUtils.isNotBlank((CharSequence)(charSetName = this.getCharacterSetName()))) {
            sb.append("\n").append("default charset=").append(charSetName);
        }
        if (StringUtils.isNotBlank((CharSequence)(tableCollation = this.getTableCollation())) && !tableCollation.equals(charSetName)) {
            sb.append("\n").append("default collate=").append(tableCollation);
        }
        if (StringUtils.isNotBlank((CharSequence)(tableComment = this.getTableComment()))) {
            sb.append("\n").append("comment='").append(tableComment.replace("'", "''")).append("'");
        }
        return sb;
    }

    protected boolean checkCharsetAndCollation() {
        String characterSetName = this.getCharacterSetName();
        String[] charsetArr = characterSetName.split("_");
        String[] collationArr = this.getTableCollation().split("_");
        if (characterSetName.equalsIgnoreCase(collationArr[0])) {
            return true;
        }
        return charsetArr.length == 2 && characterSetName.equalsIgnoreCase(collationArr[0] + "_" + collationArr[1]);
    }

    public String getEngine() {
        return this.engine;
    }

    public void setEngine(String engine) {
        this.engine = engine;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getRowFormat() {
        return this.rowFormat;
    }

    public void setRowFormat(String rowFormat) {
        this.rowFormat = rowFormat;
    }

    public String getTableRows() {
        return this.tableRows;
    }

    public void setTableRows(String tableRows) {
        this.tableRows = tableRows;
    }

    public String getAvgRowLength() {
        return this.avgRowLength;
    }

    public void setAvgRowLength(String avgRowLength) {
        this.avgRowLength = avgRowLength;
    }

    public String getDataLength() {
        return this.dataLength;
    }

    public void setDataLength(String dataLength) {
        this.dataLength = dataLength;
    }

    public String getMaxDataLength() {
        return this.maxDataLength;
    }

    public void setMaxDataLength(String maxDataLength) {
        this.maxDataLength = maxDataLength;
    }

    public String getIndexLength() {
        return this.indexLength;
    }

    public void setIndexLength(String indexLength) {
        this.indexLength = indexLength;
    }

    public String getDataFree() {
        return this.dataFree;
    }

    public void setDataFree(String dataFree) {
        this.dataFree = dataFree;
    }

    public BigDecimal getAutoIncrement() {
        return this.autoIncrement;
    }

    public void setAutoIncrement(BigDecimal autoIncrement) {
        this.autoIncrement = autoIncrement;
    }

    public String getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(String createTime) {
        this.createTime = createTime;
    }

    public String getUpdateTime() {
        return this.updateTime;
    }

    public void setUpdateTime(String updateTime) {
        this.updateTime = updateTime;
    }

    public String getCheckTime() {
        return this.checkTime;
    }

    public void setCheckTime(String checkTime) {
        this.checkTime = checkTime;
    }

    public String getChecksum() {
        return this.checksum;
    }

    public void setChecksum(String checksum) {
        this.checksum = checksum;
    }

    public String getCreateOptions() {
        return this.createOptions;
    }

    public void setCreateOptions(String createOptions) {
        this.createOptions = createOptions;
    }

    public String getTableCollation() {
        return this.tableCollation;
    }

    public void setTableCollation(String tableCollation) {
        this.tableCollation = tableCollation;
    }

    public String getCharacterSetName() {
        return this.characterSetName;
    }

    public void setCharacterSetName(String characterSetName) {
        this.characterSetName = characterSetName;
    }
}

