/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.model.mysql;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.oceanbase.obtools.common.utils.CollectionUtils;
import com.oceanbase.obtools.common.utils.MapUtils;
import com.oceanbase.obtools.common.utils.StringUtils;
import com.oceanbase.obtools.dbdiff.constants.ConvertCode;
import com.oceanbase.obtools.dbdiff.exception.UnsupportedGrammarException;
import com.oceanbase.obtools.dbdiff.model.AbstractSchema;
import com.oceanbase.obtools.dbdiff.model.AbstractTablePartition;
import com.oceanbase.obtools.dbdiff.model.oboracle22x.ObOracle22xTable;
import com.oceanbase.obtools.dbdiff.model.oracle.AbstractOracleTablePartition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class AbstractMySqlTablePartition
extends AbstractTablePartition {
    private static final Set<String> SUPPORTED_PARTITION_METHODS = Sets.newHashSet();
    private final Collection<MySqlPartitionItem> tablePartitions = new LinkedHashSet<MySqlPartitionItem>();
    private final Map<String, List<MySqlPartitionItem>> tableSubPartitionMapping = new LinkedHashMap<String, List<MySqlPartitionItem>>();
    private String partitionMethod;
    private String partitionExpression;
    private String subPartitionMethod;
    private String subPartitionExpression;
    private int subPartNum;
    private Set<String> columnSet;

    public AbstractMySqlTablePartition(AbstractSchema schema) {
        super(schema);
    }

    @Override
    public String getQuotaCharacter() {
        return "`";
    }

    @Override
    public StringBuilder buildGrammar() throws UnsupportedGrammarException {
        StringBuilder sb = new StringBuilder();
        String partitionMethod = this.getPartTypeMapping().get(this.getPartitionMethod());
        this.checkPartitionMethod(partitionMethod);
        boolean isCompositePartitioned = this.isCompositePartitioned();
        String subPartitionMethod = super.getPartTypeMapping().get(this.getSubPartitionMethod());
        if (isCompositePartitioned) {
            this.checkPartitionMethod(subPartitionMethod);
            return sb.append((CharSequence)this.buildCompositePartitionGrammar(partitionMethod));
        }
        return this.buildPartitionGrammar(partitionMethod);
    }

    private StringBuilder buildPartitionGrammar(String partitionMethod) {
        StringBuilder sb = new StringBuilder();
        Collection<MySqlPartitionItem> partitionItems = this.getTablePartitions();
        if (CollectionUtils.isEmpty(partitionItems)) {
            return sb;
        }
        sb.append("\n").append("PARTITION BY ").append(partitionMethod);
        sb.append((CharSequence)this.enclose(this.getPartitionExpression()));
        boolean isKeyHashPartMethod = "KEY".equals(partitionMethod);
        isKeyHashPartMethod |= "LINEAR KEY".equals(partitionMethod);
        isKeyHashPartMethod |= "HASH".equals(partitionMethod);
        if (isKeyHashPartMethod |= "LINEAR HASH".equals(partitionMethod)) {
            if (partitionItems.size() < 2) {
                return new StringBuilder();
            }
            return sb.append(" PARTITIONS ").append(partitionItems.size());
        }
        sb.append("\n").append("(");
        Map<String, String> partFormatMap = super.getTablePartTemplateMapping();
        partFormatMap.put("LIST", partFormatMap.get("LIST COLUMNS"));
        Iterator<MySqlPartitionItem> iter = this.tablePartitions.iterator();
        while (iter.hasNext()) {
            MySqlPartitionItem partItem = iter.next();
            sb.append("\n\t");
            String partFormat = partFormatMap.get(partitionMethod);
            String partName = this.wrap(partItem.getPartitionName());
            String partDesc = partItem.getPartitionDescription();
            sb.append(String.format(partFormat, partName, partDesc));
            this.appendOptions(sb, partItem);
            if (!iter.hasNext()) continue;
            sb.append(",");
        }
        return sb.append("\n").append(")");
    }

    private StringBuilder buildCompositePartitionGrammar(String partitionMethod) {
        Map<String, List<MySqlPartitionItem>> subPartMap;
        boolean isKeyHashPartMethod;
        Collection<MySqlPartitionItem> partitionItems = this.getTablePartitions();
        StringBuilder sb = new StringBuilder();
        if (CollectionUtils.isEmpty(partitionItems)) {
            return sb;
        }
        sb.append("\n").append("PARTITION BY ").append(partitionMethod);
        sb.append((CharSequence)this.enclose(this.getPartitionExpression()));
        boolean bl = isKeyHashPartMethod = "KEY".equals(partitionMethod) || "LINEAR KEY".equals(partitionMethod) || "HASH".equals(partitionMethod) || "LINEAR HASH".equals(partitionMethod);
        if (isKeyHashPartMethod) {
            if (partitionItems.size() < 2) {
                return new StringBuilder();
            }
            sb.append(" PARTITIONS ").append(partitionItems.size());
        }
        if (MapUtils.isEmpty(subPartMap = this.getTableSubPartitionMapping())) {
            return new StringBuilder(0);
        }
        sb.append("\n").append("SUBPARTITION BY ").append(this.subPartitionMethod);
        sb.append((CharSequence)this.enclose(this.getSubPartitionExpression()));
        boolean isKeyHashSubPartMethod = "KEY".equals(this.subPartitionMethod) || "LINEAR KEY".equals(this.subPartitionMethod) || "HASH".equals(this.subPartitionMethod) || "LINEAR HASH".equals(this.subPartitionMethod);
        int subPartNum = this.getSubPartNum();
        if (isKeyHashSubPartMethod) {
            sb.append("\n").append("SUBPARTITIONS ");
            if (subPartNum > 1) {
                sb.append(subPartNum);
            } else {
                sb.append(subPartMap.values().iterator().next().size());
            }
        }
        sb.append("\n").append("(");
        Map<String, String> partFormatMap = super.getTablePartTemplateMapping();
        partFormatMap.put("LIST", partFormatMap.get("LIST COLUMNS"));
        String partFormat = partFormatMap.get(partitionMethod);
        Map<String, String> subPartFormatMap = super.getTableSubPartTemplateMapping();
        Iterator<MySqlPartitionItem> partIter = partitionItems.iterator();
        while (partIter.hasNext()) {
            MySqlPartitionItem partItem = partIter.next();
            String partName = partItem.getPartitionName();
            Integer partId = partItem.getPartitionOrdinalPosition();
            if (partId == null) continue;
            sb.append("\n\t");
            sb.append(String.format(partFormat, this.wrap(partName), partItem.getPartitionDescription()));
            List<MySqlPartitionItem> subPartItems = subPartMap.get(partId.toString());
            if (!isKeyHashSubPartMethod && CollectionUtils.isNotEmpty(subPartItems)) {
                sb.append("\n\t").append("(");
                Iterator<MySqlPartitionItem> subPartIter = subPartItems.iterator();
                while (subPartIter.hasNext()) {
                    MySqlPartitionItem subPartItem = subPartIter.next();
                    String subPartFormat = subPartFormatMap.get(this.subPartitionMethod);
                    String subPartName = this.wrap(subPartItem.getSubPartitionName());
                    String subPartDesc = subPartItem.getPartitionDescription();
                    sb.append("\n\t\t");
                    sb.append(String.format(subPartFormat, subPartName, subPartDesc));
                    this.appendOptions(sb, subPartItem);
                    if (!subPartIter.hasNext()) continue;
                    sb.append(",");
                }
                sb.append("\n\t").append(")");
            } else {
                this.appendOptions(sb, partItem);
            }
            if (!partIter.hasNext()) continue;
            sb.append(",");
        }
        return sb.append("\n").append(")");
    }

    public Collection<AbstractOracleTablePartition.OracleTablePartitionColumn> parsePartitionColumns(String expr) {
        if (StringUtils.isBlank((CharSequence)expr)) {
            return Lists.newArrayList();
        }
        expr = expr.replaceAll("[`\"]", "").trim();
        Collection<String> columnNames = ObOracle22xTable.parseGenerateExpr(expr, this.getColumnSet());
        int index = 1;
        ArrayList<AbstractOracleTablePartition.OracleTablePartitionColumn> partitionColumns = new ArrayList<AbstractOracleTablePartition.OracleTablePartitionColumn>();
        for (String physicalColumnName : columnNames) {
            AbstractOracleTablePartition.OracleTablePartitionColumn column = new AbstractOracleTablePartition.OracleTablePartitionColumn();
            column.setName(this.getObjectName());
            column.setColumnName(physicalColumnName);
            column.setColumnPosition(index++);
            partitionColumns.add(column);
        }
        return partitionColumns;
    }

    public StringBuilder joinPartColumns() {
        return this.joinColumns(this.getPartitionExpression());
    }

    public StringBuilder joinSubPartColumns() {
        return this.joinColumns(this.getSubPartitionExpression());
    }

    public StringBuilder joinColumns(String expr) {
        Collection<AbstractOracleTablePartition.OracleTablePartitionColumn> cols = this.parsePartitionColumns(expr);
        if (CollectionUtils.isEmpty(cols)) {
            throw new IllegalArgumentException("Table partition columns is null. Object: " + this.getOriginSchemaObjectName());
        }
        return this.enclose(cols.stream().map(e -> e.isExpression() ? e.getColumnName() : this.wrap(e.getColumnName())).collect(Collectors.joining(", ")));
    }

    public Collection<AbstractOracleTablePartition.OracleTablePartitionColumn> getTablePartitionColumns() {
        return this.parsePartitionColumns(this.getPartitionExpression());
    }

    public Collection<AbstractOracleTablePartition.OracleTablePartitionColumn> getTableSubPartitionColumns() {
        return this.parsePartitionColumns(this.getSubPartitionExpression());
    }

    protected void checkPartitionMethod(String partitionMethod) throws UnsupportedGrammarException {
        if (StringUtils.isEmpty((CharSequence)partitionMethod) || !SUPPORTED_PARTITION_METHODS.contains(partitionMethod.toUpperCase(Locale.ROOT))) {
            throw new UnsupportedGrammarException(ConvertCode.MysqlUnsupportedCode.PARTITION_METHOD_NOT_SUPPORT, this.getOriginSchemaObjectName(), "The table partition type: " + partitionMethod + " is unsupported");
        }
    }

    public abstract boolean isCompositePartitioned();

    protected abstract void appendOptions(StringBuilder var1, MySqlPartitionItem var2);

    public Collection<MySqlPartitionItem> getTablePartitions() {
        return this.tablePartitions;
    }

    public Map<String, List<MySqlPartitionItem>> getTableSubPartitionMapping() {
        return this.tableSubPartitionMapping;
    }

    public String getPartitionMethod() {
        return this.partitionMethod;
    }

    public void setPartitionMethod(String partitionMethod) {
        this.partitionMethod = partitionMethod;
    }

    public String getPartitionExpression() {
        return this.partitionExpression;
    }

    public void setPartitionExpression(String partitionExpression) {
        this.partitionExpression = partitionExpression;
    }

    public String getSubPartitionMethod() {
        return this.subPartitionMethod;
    }

    public void setSubPartitionMethod(String subPartitionMethod) {
        this.subPartitionMethod = subPartitionMethod;
    }

    public String getSubPartitionExpression() {
        return this.subPartitionExpression;
    }

    public void setSubPartitionExpression(String subPartitionExpression) {
        this.subPartitionExpression = subPartitionExpression;
    }

    public int getSubPartNum() {
        return this.subPartNum;
    }

    public void setSubPartNum(int subPartNum) {
        this.subPartNum = subPartNum;
    }

    public Set<String> getColumnSet() {
        return this.columnSet;
    }

    public void setColumnSet(Set<String> columnSet) {
        this.columnSet = columnSet;
    }

    static {
        SUPPORTED_PARTITION_METHODS.add("KEY");
        SUPPORTED_PARTITION_METHODS.add("LINEAR KEY");
        SUPPORTED_PARTITION_METHODS.add("HASH");
        SUPPORTED_PARTITION_METHODS.add("LINEAR HASH");
        SUPPORTED_PARTITION_METHODS.add("LIST");
        SUPPORTED_PARTITION_METHODS.add("LIST COLUMNS");
        SUPPORTED_PARTITION_METHODS.add("RANGE");
        SUPPORTED_PARTITION_METHODS.add("RANGE COLUMNS");
    }

    public static class MySqlPartitionItem {
        private String partitionName;
        private String subPartitionName;
        private Integer partitionOrdinalPosition;
        private Integer subPartitionOrdinalPosition;
        private String partitionDescription;
        private String partitionComment;
        private String tablespaceName;

        public int hashCode() {
            return Objects.hash(this.getPartitionName(), this.getPartitionOrdinalPosition(), this.getSubPartitionName(), this.getSubPartitionOrdinalPosition(), this.getPartitionDescription(), this.getPartitionComment());
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof MySqlPartitionItem)) {
                return false;
            }
            MySqlPartitionItem other = (MySqlPartitionItem)obj;
            return Objects.equals(this.getPartitionName(), other.getPartitionName()) && Objects.equals(this.getPartitionOrdinalPosition(), other.getPartitionOrdinalPosition()) && Objects.equals(this.getSubPartitionName(), other.getSubPartitionName()) && Objects.equals(this.getSubPartitionOrdinalPosition(), other.getSubPartitionOrdinalPosition()) && Objects.equals(this.getPartitionDescription(), other.getPartitionDescription()) && Objects.equals(this.getPartitionComment(), other.getPartitionComment());
        }

        public String getPartitionName() {
            return this.partitionName;
        }

        public void setPartitionName(String partitionName) {
            this.partitionName = partitionName;
        }

        public String getSubPartitionName() {
            return this.subPartitionName;
        }

        public void setSubPartitionName(String subPartitionName) {
            this.subPartitionName = subPartitionName;
        }

        public Integer getPartitionOrdinalPosition() {
            return this.partitionOrdinalPosition;
        }

        public void setPartitionOrdinalPosition(Integer partitionOrdinalPosition) {
            this.partitionOrdinalPosition = partitionOrdinalPosition;
        }

        public Integer getSubPartitionOrdinalPosition() {
            return this.subPartitionOrdinalPosition;
        }

        public void setSubPartitionOrdinalPosition(Integer subPartitionOrdinalPosition) {
            this.subPartitionOrdinalPosition = subPartitionOrdinalPosition;
        }

        public String getPartitionDescription() {
            return this.partitionDescription;
        }

        public void setPartitionDescription(String partitionDescription) {
            this.partitionDescription = partitionDescription;
        }

        public String getPartitionComment() {
            return this.partitionComment;
        }

        public void setPartitionComment(String partitionComment) {
            this.partitionComment = partitionComment;
        }

        public String getTablespaceName() {
            return this.tablespaceName;
        }

        public void setTablespaceName(String tablespaceName) {
            this.tablespaceName = tablespaceName;
        }
    }
}

