/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.model.mysql;

import com.oceanbase.obtools.common.collect.Lists;
import com.oceanbase.obtools.common.utils.StringUtils;
import com.oceanbase.obtools.dbdiff.compare.result.CreateObjectDefine;
import com.oceanbase.obtools.dbdiff.compare.result.DropObjectDefine;
import com.oceanbase.obtools.dbdiff.compare.result.ObjectDefine;
import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import com.oceanbase.obtools.dbdiff.exception.UnsupportedGrammarException;
import com.oceanbase.obtools.dbdiff.model.AbstractSchema;
import com.oceanbase.obtools.dbdiff.model.AbstractTrigger;
import com.oceanbase.obtools.dbdiff.model.base.IDelimiter;
import java.util.List;

public abstract class AbstractMySqlTrigger
extends AbstractTrigger
implements IDelimiter {
    private String eventManipulation;
    private String eventObjectCatalog;
    private String eventObjectSchema;
    private String eventObjectTable;
    private long actionOrder;
    private String actionCondition;
    private String actionStatement;
    private String actionOrientation;
    private String actionTiming;
    private String actionReferenceOldTable;
    private String actionReferenceNewTable;
    private String actionReferenceOldRow;
    private String actionReferenceNewRow;
    private String created;
    private String sqlMode;
    private String definer;
    private String characterSetClient;
    private String collationConnection;
    private String databaseCollation;

    public AbstractMySqlTrigger(AbstractSchema schema) {
        super(schema);
    }

    @Override
    public List<ObjectDefine> buildDefinition() throws UnsupportedGrammarException {
        StringBuilder sb = new StringBuilder(256);
        sb.append("CREATE");
        String definer = this.getDefiner();
        if (StringUtils.isNotBlank((CharSequence)definer)) {
            sb.append(" DEFINER=").append(definer);
        }
        sb.append(" TRIGGER ").append(this.getSchemaObjectName());
        sb.append(" ").append(this.getActionTiming());
        sb.append(" ").append(this.getEventManipulation());
        sb.append(" ON ");
        if (this.getGlobal().withSchema()) {
            sb.append(this.wrap(this.getEventObjectSchema())).append(".");
        }
        sb.append(this.wrap(this.getEventObjectTable()));
        sb.append(" FOR EACH ROW");
        sb.append("\n").append(this.getActionStatement());
        return Lists.newArrayList((Object[])new ObjectDefine[]{new CreateObjectDefine(ObjectType.TRIGGER, this.getSimpleObjectName(), this.terminate(sb))});
    }

    @Override
    public DropObjectDefine buildDropDefinition() {
        StringBuilder sb = new StringBuilder(96);
        sb.append("drop trigger ").append(this.getSchemaObjectName());
        return new DropObjectDefine(ObjectType.TRIGGER, this.getSimpleObjectName(), this.terminate(sb));
    }

    @Override
    public String getQuotaCharacter() {
        return "`";
    }

    public String getEventManipulation() {
        return this.eventManipulation;
    }

    public void setEventManipulation(String eventManipulation) {
        this.eventManipulation = eventManipulation;
    }

    public String getEventObjectCatalog() {
        return this.eventObjectCatalog;
    }

    public void setEventObjectCatalog(String eventObjectCatalog) {
        this.eventObjectCatalog = eventObjectCatalog;
    }

    public String getEventObjectSchema() {
        return this.eventObjectSchema;
    }

    public void setEventObjectSchema(String eventObjectSchema) {
        this.eventObjectSchema = eventObjectSchema;
    }

    public String getEventObjectTable() {
        return this.eventObjectTable;
    }

    public void setEventObjectTable(String eventObjectTable) {
        this.eventObjectTable = eventObjectTable;
    }

    public long getActionOrder() {
        return this.actionOrder;
    }

    public void setActionOrder(long actionOrder) {
        this.actionOrder = actionOrder;
    }

    public String getActionCondition() {
        return this.actionCondition;
    }

    public void setActionCondition(String actionCondition) {
        this.actionCondition = actionCondition;
    }

    public String getActionStatement() {
        return this.actionStatement;
    }

    public void setActionStatement(String actionStatement) {
        this.actionStatement = actionStatement;
    }

    public String getActionOrientation() {
        return this.actionOrientation;
    }

    public void setActionOrientation(String actionOrientation) {
        this.actionOrientation = actionOrientation;
    }

    public String getActionTiming() {
        return this.actionTiming;
    }

    public void setActionTiming(String actionTiming) {
        this.actionTiming = actionTiming;
    }

    public String getActionReferenceOldTable() {
        return this.actionReferenceOldTable;
    }

    public void setActionReferenceOldTable(String actionReferenceOldTable) {
        this.actionReferenceOldTable = actionReferenceOldTable;
    }

    public String getActionReferenceNewTable() {
        return this.actionReferenceNewTable;
    }

    public void setActionReferenceNewTable(String actionReferenceNewTable) {
        this.actionReferenceNewTable = actionReferenceNewTable;
    }

    public String getActionReferenceOldRow() {
        return this.actionReferenceOldRow;
    }

    public void setActionReferenceOldRow(String actionReferenceOldRow) {
        this.actionReferenceOldRow = actionReferenceOldRow;
    }

    public String getActionReferenceNewRow() {
        return this.actionReferenceNewRow;
    }

    public void setActionReferenceNewRow(String actionReferenceNewRow) {
        this.actionReferenceNewRow = actionReferenceNewRow;
    }

    public String getCreated() {
        return this.created;
    }

    public void setCreated(String created) {
        this.created = created;
    }

    public String getSqlMode() {
        return this.sqlMode;
    }

    public void setSqlMode(String sqlMode) {
        this.sqlMode = sqlMode;
    }

    public String getDefiner() {
        return this.definer;
    }

    public void setDefiner(String definer) {
        this.definer = definer;
    }

    public String getCharacterSetClient() {
        return this.characterSetClient;
    }

    public void setCharacterSetClient(String characterSetClient) {
        this.characterSetClient = characterSetClient;
    }

    public String getCollationConnection() {
        return this.collationConnection;
    }

    public void setCollationConnection(String collationConnection) {
        this.collationConnection = collationConnection;
    }

    public String getDatabaseCollation() {
        return this.databaseCollation;
    }

    public void setDatabaseCollation(String databaseCollation) {
        this.databaseCollation = databaseCollation;
    }
}

