/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.model.mysql56;

import com.oceanbase.obtools.dbdiff.compare.result.ChangeInfo;
import com.oceanbase.obtools.dbdiff.compare.result.ObjectDefine;
import com.oceanbase.obtools.dbdiff.enums.DbType;
import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import com.oceanbase.obtools.dbdiff.exception.UnmatchedObjectTypeException;
import com.oceanbase.obtools.dbdiff.exception.UnsupportedGrammarException;
import com.oceanbase.obtools.dbdiff.model.AbstractColumn;
import com.oceanbase.obtools.dbdiff.model.mysql.AbstractMySqlColumn;
import com.oceanbase.obtools.dbdiff.model.mysql56.MySql56Schema;
import com.oceanbase.obtools.dbdiff.utils.ChangeUtils;
import java.util.List;
import java.util.Locale;

public class MySql56Column
extends AbstractMySqlColumn {
    public MySql56Column(MySql56Schema schema) {
        super(schema);
    }

    @Override
    public StringBuilder buildGrammar() throws UnsupportedGrammarException {
        String originType;
        String dataType = this.getDataType().toUpperCase(Locale.getDefault());
        Long dataLength = this.getCharacterOctetLength();
        if ("VARCHAR".equals(dataType) && dataLength != null && dataLength > 65535L) {
            originType = this.getColumnType();
            this.setDataType("TEXT".toLowerCase(Locale.getDefault()));
            this.setColumnType("TEXT".toLowerCase(Locale.getDefault()));
            ChangeUtils.warn(ObjectType.TABLE, this.getSimpleObjectName(), ChangeInfo.ChangeType.CONVERT, this.getWrappedName() + " " + originType + " -> " + this.getWrappedName() + " " + this.getColumnType());
        }
        if (DbType.MYSQL_55.getType().equals(this.getDbType().getType()) && DbType.MYSQL_55.isSubsequentFrom(this.getDbType()) && ("TIME".equals(dataType) || "TIMESTAMP".equals(dataType) || "DATETIME".equals(dataType)) && !(originType = this.getColumnType()).equals(this.getDataType())) {
            this.setColumnType(this.getDataType());
            ChangeUtils.warn(ObjectType.TABLE, this.getSimpleObjectName(), ChangeInfo.ChangeType.CONVERT, this.getWrappedName() + " " + originType + " -> " + this.getWrappedName() + " " + this.getColumnType());
        }
        return super.buildGrammar();
    }

    @Override
    public List<ObjectDefine> compareTo(AbstractColumn other) {
        if (!(other instanceof MySql56Column)) {
            throw new UnmatchedObjectTypeException("Raw type is not matched");
        }
        return null;
    }
}

