/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.model.mysql56;

import com.oceanbase.obtools.common.collect.Lists;
import com.oceanbase.obtools.common.utils.StringUtils;
import com.oceanbase.obtools.dbdiff.compare.result.CreateObjectDefine;
import com.oceanbase.obtools.dbdiff.compare.result.ObjectDefine;
import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import com.oceanbase.obtools.dbdiff.exception.UnmatchedObjectTypeException;
import com.oceanbase.obtools.dbdiff.exception.UnsupportedGrammarException;
import com.oceanbase.obtools.dbdiff.model.AbstractIndex;
import com.oceanbase.obtools.dbdiff.model.mysql.AbstractMySqlIndex;
import com.oceanbase.obtools.dbdiff.model.mysql56.MySql56Schema;
import java.util.List;

public class MySql56Index
extends AbstractMySqlIndex {
    public MySql56Index(MySql56Schema schema) {
        super(schema);
    }

    @Override
    public List<ObjectDefine> buildDefinition() throws UnsupportedGrammarException {
        String indexComment;
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE");
        if (this.getNonunique() == 0) {
            sb.append(" ").append((Object)ObjectType.UNIQUE);
            this.addUniqueAttribute();
        }
        sb.append(" INDEX ").append(this.getWrappedIndexName()).append(" ON ");
        sb.append(this.getDefinitionSchemaObjectName()).append((CharSequence)this.joinIndexColumns());
        String visible = this.getVisible();
        if (StringUtils.isNotBlank((CharSequence)visible) && "NO".equals(visible)) {
            sb.append(" invisible");
        }
        if (StringUtils.isNotBlank((CharSequence)(indexComment = this.getIndexComment()))) {
            sb.append(" COMMENT \"").append(indexComment).append("\"");
        }
        return Lists.newArrayList((Object[])new ObjectDefine[]{new CreateObjectDefine(ObjectType.INDEX, this.getIndexType(), this.getSimpleIndexName(), this.terminate(sb))});
    }

    @Override
    public List<ObjectDefine> compareTo(AbstractIndex other) {
        if (!(other instanceof MySql56Index)) {
            throw new UnmatchedObjectTypeException("Raw type is not matched");
        }
        return null;
    }
}

