/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.model.mysql56;

import com.oceanbase.obtools.common.utils.StringUtils;
import com.oceanbase.obtools.dbdiff.configure.Global;
import com.oceanbase.obtools.dbdiff.enums.DbType;
import com.oceanbase.obtools.dbdiff.exception.UnsupportedGrammarException;
import com.oceanbase.obtools.dbdiff.model.AbstractSchema;

public class MySql56Schema
extends AbstractSchema {
    private String defaultCharacterSetName;
    private String defaultCollationName;

    public MySql56Schema(Global global, DbType dbType, String schemaName) {
        super(global, dbType, schemaName);
    }

    public MySql56Schema(Global global, DbType dbType, String catalogName, String schemaName) {
        super(global, dbType, catalogName, schemaName);
    }

    @Override
    public StringBuilder buildGrammar() throws UnsupportedGrammarException {
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE DATABASE IF NOT EXISTS ").append(this.getSchemaName());
        if (StringUtils.isNotBlank((CharSequence)this.defaultCharacterSetName)) {
            sb.append(" CHARACTER SET ").append(this.defaultCharacterSetName);
        }
        if (StringUtils.isNotBlank((CharSequence)this.defaultCollationName)) {
            sb.append(" COLLATE ").append(this.defaultCollationName);
        }
        return sb;
    }

    public String getDefaultCharacterSetName() {
        return this.defaultCharacterSetName;
    }

    public void setDefaultCharacterSetName(String defaultCharacterSetName) {
        this.defaultCharacterSetName = defaultCharacterSetName;
    }

    public String getDefaultCollationName() {
        return this.defaultCollationName;
    }

    public void setDefaultCollationName(String defaultCollationName) {
        this.defaultCollationName = defaultCollationName;
    }
}

