/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.model.mysql56;

import com.google.common.collect.Lists;
import com.oceanbase.obtools.common.utils.MapUtils;
import com.oceanbase.obtools.common.utils.StringUtils;
import com.oceanbase.obtools.dbdiff.compare.result.CreateObjectDefine;
import com.oceanbase.obtools.dbdiff.compare.result.ObjectDefine;
import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import com.oceanbase.obtools.dbdiff.exception.AntlrGrammarException;
import com.oceanbase.obtools.dbdiff.exception.UnmatchedObjectTypeException;
import com.oceanbase.obtools.dbdiff.exception.UnsupportedGrammarException;
import com.oceanbase.obtools.dbdiff.model.AbstractTable;
import com.oceanbase.obtools.dbdiff.model.base.KeyColumn;
import com.oceanbase.obtools.dbdiff.model.mysql.AbstractMySqlConstraint;
import com.oceanbase.obtools.dbdiff.model.mysql.AbstractMySqlTable;
import com.oceanbase.obtools.dbdiff.model.mysql56.MySql56Column;
import com.oceanbase.obtools.dbdiff.model.mysql56.MySql56ForeignKey;
import com.oceanbase.obtools.dbdiff.model.mysql56.MySql56Index;
import com.oceanbase.obtools.dbdiff.model.mysql56.MySql56PrimaryKey;
import com.oceanbase.obtools.dbdiff.model.mysql56.MySql56Schema;
import com.oceanbase.obtools.dbdiff.model.mysql56.MySql56TablePartition;
import com.oceanbase.obtools.dbdiff.model.mysql56.MySql56UniqueKey;
import com.oceanbase.obtools.dbdiff.model.mysql56.MySql80Check;
import com.oceanbase.obtools.dbdiff.resolver.mysql.MysqlTableMetaResolver;
import com.oceanbase.obtools.dbdiff.utils.ChangeUtils;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class MySql56Table
extends AbstractMySqlTable {
    private final Map<String, MySql56Column> columnMapping = new LinkedHashMap<String, MySql56Column>();
    private final Map<String, MySql56Index> indexMapping = new LinkedHashMap<String, MySql56Index>();
    private final Map<String, MySql80Check> checkMapping = new LinkedHashMap<String, MySql80Check>();
    private final Map<String, MySql56UniqueKey> uniqueMapping = new LinkedHashMap<String, MySql56UniqueKey>();
    private final Map<String, MySql56ForeignKey> foreignMapping = new LinkedHashMap<String, MySql56ForeignKey>();
    private MySql56PrimaryKey primaryKey;
    private MySql56TablePartition tablePartition;
    private MySql56Column autoIncrementColumn;

    public MySql56Table(MySql56Schema schema) {
        super(schema);
    }

    @Override
    public List<ObjectDefine> buildDefinition() throws UnsupportedGrammarException {
        StringBuilder sb = new StringBuilder();
        sb.append("create table if not exists ").append(this.getDefinitionSchemaObjectName()).append(" (");
        Collection<MySql56Column> columns = this.getColumnMapping().values();
        Iterator<MySql56Column> iter = columns.iterator();
        while (iter.hasNext()) {
            String characterSetName;
            MySql56Column column = iter.next();
            this.fillAutoIncrement(column);
            Iterator<MySql56UniqueKey> tableCollation = this.getTableCollation();
            if (tableCollation != null && ((String)((Object)tableCollation)).equals(column.getCollationName())) {
                column.setCollationName(null);
            }
            if ((characterSetName = this.getCharacterSetName()) != null && characterSetName.equals(column.getCharacterSetName())) {
                column.setCharacterSetName(null);
            }
            sb.append("\n\t").append((CharSequence)column.buildGrammar());
            if (!iter.hasNext()) continue;
            sb.append(",");
        }
        boolean isInnerKeyExisted = false;
        MySql56PrimaryKey primaryKey = this.getPrimaryKey();
        if (primaryKey != null) {
            if (this.checkInExistedConstraint(primaryKey)) {
                isInnerKeyExisted = true;
            }
            sb.append(",\n\t").append((CharSequence)primaryKey.buildGrammar());
        }
        if (MapUtils.isNotEmpty(this.getCheckMapping())) {
            for (MySql80Check check : this.getCheckMapping().values()) {
                sb.append(",\n\t").append((CharSequence)check.buildGrammar());
            }
        }
        if (MapUtils.isNotEmpty(this.getUniqueMapping())) {
            for (MySql56UniqueKey unique : this.getUniqueMapping().values()) {
                if (this.checkInExistedConstraint(unique)) {
                    isInnerKeyExisted = true;
                }
                sb.append(",\n\t").append((CharSequence)unique.buildGrammar());
            }
        }
        String innerKeyName = null;
        LinkedList<ObjectDefine> subDefines = new LinkedList<ObjectDefine>();
        if (MapUtils.isNotEmpty(this.getIndexMapping())) {
            for (MySql56Index index : this.getIndexMapping().values()) {
                List<KeyColumn> indexColumns = index.getIndexColumns();
                if (this.getAutoIncrementColumn() != null && indexColumns.size() == 1 && indexColumns.get(0).getColumnName().equals(this.getAutoIncrementColumn().getColumnName())) {
                    innerKeyName = index.getIndexName();
                    continue;
                }
                subDefines.addAll(index.buildDefinition());
            }
        }
        if (!isInnerKeyExisted && this.getAutoIncrementColumn() != null && StringUtils.isNotBlank(innerKeyName)) {
            sb.append(",\n\t").append("KEY ").append(this.wrap(innerKeyName)).append(" (").append(this.wrap(this.getAutoIncrementColumn().getColumnName())).append(")");
        }
        if (MapUtils.isNotEmpty(this.getForeignMapping())) {
            for (MySql56ForeignKey foreign : this.getForeignMapping().values()) {
                sb.append(",\n\t").append((CharSequence)foreign.buildGrammar());
            }
        }
        sb.append("\n").append(")");
        sb.append((CharSequence)this.appendTableOptions());
        MySql56TablePartition tablePartition = this.getTablePartition();
        if (tablePartition != null) {
            sb.append((CharSequence)tablePartition.buildGrammar());
        }
        CreateObjectDefine objectDefine = new CreateObjectDefine(ObjectType.TABLE, this.getSimpleObjectName(), this.terminate(sb), subDefines);
        objectDefine.getChangeInfos().addAll(ChangeUtils.findByKey(ObjectType.TABLE, this.getSimpleObjectName()));
        return Lists.newArrayList((Object[])new ObjectDefine[]{objectDefine});
    }

    private void fillAutoIncrement(MySql56Column column) {
        if (column != null && "auto_increment".equalsIgnoreCase(column.getExtra())) {
            this.setAutoIncrementColumn(column);
        }
    }

    private boolean checkInExistedConstraint(AbstractMySqlConstraint constraint) {
        MySql56Column autoIncrColumn = this.getAutoIncrementColumn();
        List<KeyColumn> columns = constraint.getConstraintColumns();
        return autoIncrColumn != null && columns.size() == 1 && columns.get(0).getColumnName().equals(autoIncrColumn.getColumnName());
    }

    @Override
    protected StringBuilder appendTableOptions() throws UnsupportedGrammarException {
        return super.appendTableOptions();
    }

    @Override
    public List<ObjectDefine> compareTo(AbstractTable other) {
        if (!(other instanceof MySql56Table)) {
            throw new UnmatchedObjectTypeException("Raw type is not matched");
        }
        return null;
    }

    @Override
    public void loadMetaFromDDL(String sql) throws AntlrGrammarException {
        MysqlTableMetaResolver resolver = new MysqlTableMetaResolver(this);
        resolver.resolveMetaData(sql);
    }

    public Map<String, MySql56Column> getColumnMapping() {
        return this.columnMapping;
    }

    public Map<String, MySql56Index> getIndexMapping() {
        return this.indexMapping;
    }

    public Map<String, MySql80Check> getCheckMapping() {
        return this.checkMapping;
    }

    public Map<String, MySql56UniqueKey> getUniqueMapping() {
        return this.uniqueMapping;
    }

    public Map<String, MySql56ForeignKey> getForeignMapping() {
        return this.foreignMapping;
    }

    public MySql56PrimaryKey getPrimaryKey() {
        return this.primaryKey;
    }

    public void setPrimaryKey(MySql56PrimaryKey primaryKey) {
        this.primaryKey = primaryKey;
    }

    public MySql56TablePartition getTablePartition() {
        return this.tablePartition;
    }

    public void setTablePartition(MySql56TablePartition tablePartition) {
        this.tablePartition = tablePartition;
    }

    public MySql56Column getAutoIncrementColumn() {
        return this.autoIncrementColumn;
    }

    public void setAutoIncrementColumn(MySql56Column autoIncrementColumn) {
        this.autoIncrementColumn = autoIncrementColumn;
    }
}

