/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.model.mysql56;

import com.oceanbase.obtools.common.collect.Lists;
import com.oceanbase.obtools.common.utils.StringUtils;
import com.oceanbase.obtools.dbdiff.compare.result.CreateObjectDefine;
import com.oceanbase.obtools.dbdiff.compare.result.ObjectDefine;
import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import com.oceanbase.obtools.dbdiff.exception.UnmatchedObjectTypeException;
import com.oceanbase.obtools.dbdiff.exception.UnsupportedGrammarException;
import com.oceanbase.obtools.dbdiff.model.AbstractTablespace;
import com.oceanbase.obtools.dbdiff.model.mysql.AbstractMySqlTablespace;
import com.oceanbase.obtools.dbdiff.model.mysql56.MySql56Schema;
import java.util.List;

public class MySql56Tablespace
extends AbstractMySqlTablespace {
    private String tablespaceType;
    private Long nodeGroupId;
    private String tablespaceComment;
    private String fileId;
    private String fileName;
    private String fileType;
    private String tablespaceName;
    private String tableCatalog;
    private String tableSchema;
    private String tableName;
    private String logfileGroupName;
    private String logfileGroupNumber;
    private String engine;
    private String fulltextKeys;
    private String deletedRows;
    private String updateCount;
    private String freeExtents;
    private Long totalExtents;
    private Long extentSize;
    private Long initialSize;
    private String maximumSize;
    private Long autoExtendSize;
    private String creationTime;
    private String lastUpdateTime;
    private String lastAccessTime;
    private String recoverTime;
    private Long transactionCounter;
    private String version;
    private String rowFormat;
    private Long tableRows;
    private Long avgRowLength;
    private Long dataLength;
    private Long maxDataLength;
    private Long indexLength;
    private Long dataFree;
    private String createTime;
    private String updateTime;
    private String checkTime;
    private String checksum;
    private String status;
    private String extra;

    public MySql56Tablespace(MySql56Schema schema) {
        super(schema);
    }

    @Override
    public List<ObjectDefine> buildDefinition() throws UnsupportedGrammarException {
        String engine;
        String tablespaceComment;
        Long nodeGroupId;
        String maximumSize;
        Long autoExtendSize;
        Long initialSize;
        Long extentSize;
        String objectName = this.getObjectName();
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE");
        sb.append(" TABLESPACE ").append(objectName);
        sb.append(" ADD DATAFILE '").append(this.getFileName()).append("'");
        String logFileGroupName = this.getLogfileGroupName();
        if (StringUtils.isNotBlank((CharSequence)logFileGroupName)) {
            sb.append(" USE LOGFILE GROUP ").append(logFileGroupName);
        }
        if ((extentSize = this.getExtentSize()) != null) {
            sb.append(" EXTENT_SIZE=").append(extentSize);
        }
        if ((initialSize = this.getInitialSize()) != null) {
            sb.append(" INITIAL_SIZE=").append(initialSize);
        }
        if ((autoExtendSize = this.getAutoExtendSize()) != null) {
            sb.append(" AUTOEXTEND_SIZE=").append(autoExtendSize);
        }
        if (StringUtils.isNotBlank((CharSequence)(maximumSize = this.getMaximumSize()))) {
            sb.append(" MAX_SIZE=").append(maximumSize);
        }
        if ((nodeGroupId = this.getNodeGroupId()) != null) {
            sb.append(" NODEGROUP=").append(nodeGroupId);
        }
        if (StringUtils.isNotBlank((CharSequence)(tablespaceComment = this.getTablespaceComment()))) {
            sb.append(" COMMENT='").append(tablespaceComment).append("'");
        }
        if (StringUtils.isNotBlank((CharSequence)(engine = this.getEngine()))) {
            sb.append(" ENGINE=").append(engine);
        }
        return Lists.newArrayList((Object[])new ObjectDefine[]{new CreateObjectDefine(ObjectType.TABLESPACE, objectName, this.terminate(sb))});
    }

    @Override
    public List<ObjectDefine> compareTo(AbstractTablespace other) {
        if (!(other instanceof MySql56Tablespace)) {
            throw new UnmatchedObjectTypeException("Raw type is not matched");
        }
        return null;
    }

    public String getTablespaceType() {
        return this.tablespaceType;
    }

    public void setTablespaceType(String tablespaceType) {
        this.tablespaceType = tablespaceType;
    }

    public Long getNodeGroupId() {
        return this.nodeGroupId;
    }

    public void setNodeGroupId(Long nodeGroupId) {
        this.nodeGroupId = nodeGroupId;
    }

    public String getTablespaceComment() {
        return this.tablespaceComment;
    }

    public void setTablespaceComment(String tablespaceComment) {
        this.tablespaceComment = tablespaceComment;
    }

    public String getFileId() {
        return this.fileId;
    }

    public void setFileId(String fileId) {
        this.fileId = fileId;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getFileType() {
        return this.fileType;
    }

    public void setFileType(String fileType) {
        this.fileType = fileType;
    }

    public String getTablespaceName() {
        return this.tablespaceName;
    }

    public void setTablespaceName(String tablespaceName) {
        this.tablespaceName = tablespaceName;
    }

    public String getTableCatalog() {
        return this.tableCatalog;
    }

    public void setTableCatalog(String tableCatalog) {
        this.tableCatalog = tableCatalog;
    }

    public String getTableSchema() {
        return this.tableSchema;
    }

    public void setTableSchema(String tableSchema) {
        this.tableSchema = tableSchema;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getLogfileGroupName() {
        return this.logfileGroupName;
    }

    public void setLogfileGroupName(String logfileGroupName) {
        this.logfileGroupName = logfileGroupName;
    }

    public String getLogfileGroupNumber() {
        return this.logfileGroupNumber;
    }

    public void setLogfileGroupNumber(String logfileGroupNumber) {
        this.logfileGroupNumber = logfileGroupNumber;
    }

    public String getEngine() {
        return this.engine;
    }

    public void setEngine(String engine) {
        this.engine = engine;
    }

    public String getFulltextKeys() {
        return this.fulltextKeys;
    }

    public void setFulltextKeys(String fulltextKeys) {
        this.fulltextKeys = fulltextKeys;
    }

    public String getDeletedRows() {
        return this.deletedRows;
    }

    public void setDeletedRows(String deletedRows) {
        this.deletedRows = deletedRows;
    }

    public String getUpdateCount() {
        return this.updateCount;
    }

    public void setUpdateCount(String updateCount) {
        this.updateCount = updateCount;
    }

    public String getFreeExtents() {
        return this.freeExtents;
    }

    public void setFreeExtents(String freeExtents) {
        this.freeExtents = freeExtents;
    }

    public Long getTotalExtents() {
        return this.totalExtents;
    }

    public void setTotalExtents(Long totalExtents) {
        this.totalExtents = totalExtents;
    }

    public Long getExtentSize() {
        return this.extentSize;
    }

    public void setExtentSize(Long extentSize) {
        this.extentSize = extentSize;
    }

    public Long getInitialSize() {
        return this.initialSize;
    }

    public void setInitialSize(Long initialSize) {
        this.initialSize = initialSize;
    }

    public String getMaximumSize() {
        return this.maximumSize;
    }

    public void setMaximumSize(String maximumSize) {
        this.maximumSize = maximumSize;
    }

    public Long getAutoExtendSize() {
        return this.autoExtendSize;
    }

    public void setAutoExtendSize(Long autoExtendSize) {
        this.autoExtendSize = autoExtendSize;
    }

    public String getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(String creationTime) {
        this.creationTime = creationTime;
    }

    public String getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public void setLastUpdateTime(String lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
    }

    public String getLastAccessTime() {
        return this.lastAccessTime;
    }

    public void setLastAccessTime(String lastAccessTime) {
        this.lastAccessTime = lastAccessTime;
    }

    public String getRecoverTime() {
        return this.recoverTime;
    }

    public void setRecoverTime(String recoverTime) {
        this.recoverTime = recoverTime;
    }

    public Long getTransactionCounter() {
        return this.transactionCounter;
    }

    public void setTransactionCounter(Long transactionCounter) {
        this.transactionCounter = transactionCounter;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getRowFormat() {
        return this.rowFormat;
    }

    public void setRowFormat(String rowFormat) {
        this.rowFormat = rowFormat;
    }

    public Long getTableRows() {
        return this.tableRows;
    }

    public void setTableRows(Long tableRows) {
        this.tableRows = tableRows;
    }

    public Long getAvgRowLength() {
        return this.avgRowLength;
    }

    public void setAvgRowLength(Long avgRowLength) {
        this.avgRowLength = avgRowLength;
    }

    public Long getDataLength() {
        return this.dataLength;
    }

    public void setDataLength(Long dataLength) {
        this.dataLength = dataLength;
    }

    public Long getMaxDataLength() {
        return this.maxDataLength;
    }

    public void setMaxDataLength(Long maxDataLength) {
        this.maxDataLength = maxDataLength;
    }

    public Long getIndexLength() {
        return this.indexLength;
    }

    public void setIndexLength(Long indexLength) {
        this.indexLength = indexLength;
    }

    public Long getDataFree() {
        return this.dataFree;
    }

    public void setDataFree(Long dataFree) {
        this.dataFree = dataFree;
    }

    public String getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(String createTime) {
        this.createTime = createTime;
    }

    public String getUpdateTime() {
        return this.updateTime;
    }

    public void setUpdateTime(String updateTime) {
        this.updateTime = updateTime;
    }

    public String getCheckTime() {
        return this.checkTime;
    }

    public void setCheckTime(String checkTime) {
        this.checkTime = checkTime;
    }

    public String getChecksum() {
        return this.checksum;
    }

    public void setChecksum(String checksum) {
        this.checksum = checksum;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getExtra() {
        return this.extra;
    }

    public void setExtra(String extra) {
        this.extra = extra;
    }
}

