/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.model.ob;

import com.oceanbase.obtools.common.utils.StringUtils;
import com.oceanbase.obtools.dbdiff.exception.UnsupportedGrammarException;
import com.oceanbase.obtools.dbdiff.model.AbstractSchema;
import com.oceanbase.obtools.dbdiff.model.AbstractTableGroup;
import com.oceanbase.obtools.dbdiff.model.ob.TableGroupPartition;
import com.oceanbase.obtools.dbdiff.model.ob.TableGroupSubPartition;

public abstract class AbstractObTableGroup
extends AbstractTableGroup {
    private long tableGroupId;
    private String locality;
    private String primaryZone;
    private int partLevel;
    private String binding;
    private String comment;
    private int isSubPartTemplate;
    private TableGroupPartition tableGroupPartition;

    public AbstractObTableGroup(AbstractSchema schema) {
        super(schema);
    }

    protected StringBuilder buildTableGroupOptions() {
        StringBuilder sb = new StringBuilder(128);
        if (StringUtils.isNotBlank((CharSequence)this.getLocality())) {
            sb.append(" LOCALITY='").append(this.getLocality()).append("'");
        }
        if (StringUtils.isNotBlank((CharSequence)this.getPrimaryZone())) {
            sb.append(" PRIMARY_ZONE=").append(this.getPrimaryZone());
        }
        if (StringUtils.isNotBlank((CharSequence)this.getBinding())) {
            sb.append(" BINDING=").append(this.getBinding());
        }
        return sb;
    }

    protected StringBuilder buildTablePartitionOption() throws UnsupportedGrammarException {
        TableGroupPartition tableGroupPartition = this.getTableGroupPartition();
        if (tableGroupPartition == null) {
            return new StringBuilder(0);
        }
        return tableGroupPartition.buildGrammar();
    }

    public TableGroupSubPartition getTableGroupSubPartition() {
        if (this.tableGroupPartition == null) {
            throw new IllegalArgumentException("The tablegroup partition description is null");
        }
        return this.tableGroupPartition.getTableGroupSubPartition();
    }

    public long getTableGroupId() {
        return this.tableGroupId;
    }

    public void setTableGroupId(long tableGroupId) {
        this.tableGroupId = tableGroupId;
    }

    public String getLocality() {
        return this.locality;
    }

    public void setLocality(String locality) {
        this.locality = locality;
    }

    public String getPrimaryZone() {
        return this.primaryZone;
    }

    public void setPrimaryZone(String primaryZone) {
        this.primaryZone = primaryZone;
    }

    public int getPartLevel() {
        return this.partLevel;
    }

    public void setPartLevel(int partLevel) {
        this.partLevel = partLevel;
    }

    public String getBinding() {
        return this.binding;
    }

    public void setBinding(String binding) {
        this.binding = binding;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public int getIsSubPartTemplate() {
        return this.isSubPartTemplate;
    }

    public void setIsSubPartTemplate(int isSubPartTemplate) {
        this.isSubPartTemplate = isSubPartTemplate;
    }

    public TableGroupPartition getTableGroupPartition() {
        return this.tableGroupPartition;
    }

    public void setTableGroupPartition(TableGroupPartition tableGroupPartition) {
        this.tableGroupPartition = tableGroupPartition;
    }
}

