/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.model.ob;

import com.oceanbase.obtools.dbdiff.compare.result.ObjectDefine;
import com.oceanbase.obtools.dbdiff.enums.DbType;
import com.oceanbase.obtools.dbdiff.exception.UnmatchedObjectTypeException;
import com.oceanbase.obtools.dbdiff.exception.UnsupportedGrammarException;
import com.oceanbase.obtools.dbdiff.model.AbstractSchema;
import com.oceanbase.obtools.dbdiff.model.AbstractTablePartition;
import com.oceanbase.obtools.dbdiff.model.ob.TableGroupSubPartition;
import com.oceanbase.obtools.dbdiff.model.oracle.AbstractOracleTablePartition;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

public class TableGroupPartition
extends AbstractTablePartition {
    private String partitionType;
    private int partitionColumnNum;
    private int partitionCount;
    private TableGroupSubPartition tableGroupSubPartition;
    private final Collection<AbstractOracleTablePartition.OracleTablePartitionItem> partitionItems = new LinkedHashSet<AbstractOracleTablePartition.OracleTablePartitionItem>();

    public TableGroupPartition(AbstractSchema schema) {
        super(schema);
    }

    @Override
    public StringBuilder buildGrammar() throws UnsupportedGrammarException {
        TableGroupSubPartition subPartition;
        if (!this.isValid()) {
            return new StringBuilder(0);
        }
        this.resolvePartType(this);
        String partType = this.getPartitionType();
        StringBuilder sb = new StringBuilder(512);
        sb.append("\nPARTITION BY ").append(partType);
        boolean isKey = "KEY".equals(partType);
        boolean isListColumns = "LIST COLUMNS".equals(partType);
        boolean isRangeColumns = "RANGE COLUMNS".equals(partType);
        if (isKey || isListColumns || isRangeColumns) {
            sb.append(" ").append(this.getPartitionColumnNum());
        }
        if ((subPartition = this.getTableGroupSubPartition()) == null || !subPartition.isValid()) {
            return sb.append((CharSequence)this.buildPartitionDescription());
        }
        this.resolvePartType(subPartition);
        sb.append("\nSUBPARTITION BY ").append(subPartition.getSubPartitionType());
        if (this.getTableGroupSubPartition().isDefinedByTemplate()) {
            return sb.append((CharSequence)this.buildSubPartitionWithinTemplate());
        }
        return sb.append((CharSequence)this.buildSubPartitionWithoutTemplate());
    }

    private void resolvePartType(AbstractTablePartition partition) {
        if (DbType.OBORACLE_21.getType().equals(this.getDbType().getType())) {
            if (partition instanceof TableGroupPartition) {
                TableGroupPartition part = (TableGroupPartition)partition;
                if ("LIST".equals(part.getPartitionType())) {
                    part.setPartitionType("LIST COLUMNS");
                } else if ("RANGE".equals(part.getPartitionType())) {
                    part.setPartitionType("RANGE COLUMNS");
                }
            } else if (partition instanceof TableGroupSubPartition) {
                TableGroupSubPartition subPart = (TableGroupSubPartition)partition;
                if ("LIST".equals(subPart.getSubPartitionType())) {
                    subPart.setSubPartitionType("LIST COLUMNS");
                } else if ("RANGE".equals(subPart.getSubPartitionType())) {
                    subPart.setSubPartitionType("RANGE COLUMNS");
                }
            }
        }
    }

    private StringBuilder buildPartitionDescription() {
        String partType = this.getPartitionType();
        boolean isKey = "KEY".equals(partType);
        boolean isHash = "HASH".equals(partType);
        StringBuilder sb = new StringBuilder(512);
        if (isKey || isHash) {
            sb.append("\nPARTITIONS ").append(this.getPartitionCount());
        }
        boolean isList = "LIST".equals(partType);
        boolean isRange = "RANGE".equals(partType);
        boolean isListColumns = "LIST COLUMNS".equals(partType);
        boolean isRangeColumns = "RANGE COLUMNS".equals(partType);
        if (isList || isListColumns || isRange || isRangeColumns) {
            String partFormat = this.getPartFormat();
            sb.append("\n(");
            Iterator<AbstractOracleTablePartition.OracleTablePartitionItem> iter = this.getPartitionItems().iterator();
            while (iter.hasNext()) {
                sb.append("\n\t");
                AbstractOracleTablePartition.OracleTablePartitionItem partItem = iter.next();
                String partName = this.wrap(partItem.getPartitionName());
                sb.append(String.format(partFormat, partName, partItem.getHighValue()));
                if (!iter.hasNext()) continue;
                sb.append(",");
            }
            sb.append("\n)");
        }
        return sb;
    }

    private StringBuilder buildSubPartitionWithinTemplate() throws UnsupportedGrammarException {
        TableGroupSubPartition subPartition = this.getTableGroupSubPartition();
        String subPartType = subPartition.getSubPartitionType();
        StringBuilder sb = new StringBuilder(512);
        boolean isKey = "KEY".equals(subPartType);
        boolean isHash = "HASH".equals(subPartType);
        boolean isListColumns = "LIST COLUMNS".equals(subPartType);
        boolean isRangeColumns = "RANGE COLUMNS".equals(subPartType);
        if (isKey || isListColumns || isRangeColumns || this.isNewFeatureFrom32x()) {
            sb.append(" ").append(subPartition.getSubPartitionColumnNum());
        }
        if (isKey || isHash) {
            sb.append(" SUBPARTITIONS ").append(subPartition.getSubPartitionCount());
        } else {
            sb.append((CharSequence)subPartition.buildGrammar());
        }
        return sb.append((CharSequence)this.buildPartitionDescription());
    }

    private StringBuilder buildSubPartitionWithoutTemplate() throws UnsupportedGrammarException {
        TableGroupSubPartition subPartition = this.getTableGroupSubPartition();
        String subPartType = subPartition.getSubPartitionType();
        StringBuilder sb = new StringBuilder(512);
        boolean isKey = "KEY".equals(subPartType);
        boolean isListColumns = "LIST COLUMNS".equals(subPartType);
        boolean isRangeColumns = "RANGE COLUMNS".equals(subPartType);
        if (isKey || isListColumns || isRangeColumns || this.isNewFeatureFrom32x()) {
            sb.append(" ").append(subPartition.getSubPartitionColumnNum());
        }
        sb.append("\n(");
        String partFormat = this.getPartFormat();
        String subPartFormat = subPartition.getSubPartFormat();
        Map<Integer, List<AbstractOracleTablePartition.OracleTablePartitionItem>> map = subPartition.getSubPartitionItemMapping();
        Iterator<AbstractOracleTablePartition.OracleTablePartitionItem> iter = this.getPartitionItems().iterator();
        while (iter.hasNext()) {
            AbstractOracleTablePartition.OracleTablePartitionItem partItem = iter.next();
            String partName = this.wrap(partItem.getPartitionName());
            int partId = partItem.getPartitionPosition();
            sb.append("\n\t");
            sb.append(String.format(partFormat, partName, partItem.getHighValue()));
            sb.append("\n\t(");
            Iterator<AbstractOracleTablePartition.OracleTablePartitionItem> siter = map.get(partId).iterator();
            while (siter.hasNext()) {
                AbstractOracleTablePartition.OracleTablePartitionItem subPartItem = siter.next();
                String subPartName = this.wrap(subPartItem.getPartitionName());
                sb.append("\n\t\t");
                sb.append(String.format(subPartFormat, subPartName, partItem.getHighValue()));
                if (!siter.hasNext()) continue;
                sb.append(",");
            }
            sb.append("\n\t)");
            if (!iter.hasNext()) continue;
            sb.append(",");
        }
        return sb.append("\n)");
    }

    @Override
    public String getQuotaCharacter() {
        DbType dbType = super.getDbType();
        if (dbType != null && dbType.isMySqlType()) {
            return "`";
        }
        return super.getQuotaCharacter();
    }

    public boolean isValid() {
        return this.getPartitionColumnNum() > 0;
    }

    public boolean isNewFeatureFrom32x() {
        boolean isNewFeature;
        TableGroupSubPartition subPartition = this.getTableGroupSubPartition();
        isNewFeature &= (isNewFeature = DbType.OBORACLE_322.getType().equals(this.getDbType().getType())) && DbType.OBORACLE_322.isPriorFrom(this.getDbType());
        return (isNewFeature &= "HASH".equals(subPartition.getSubPartitionType())) && !subPartition.isDefinedByTemplate();
    }

    public String getJdbcFieldName() {
        if ("LIST".equals(this.getPartitionType()) || "LIST COLUMNS".equals(this.getPartitionType())) {
            return "part_list_val";
        }
        return "part_high_bound_val";
    }

    public String getPartFormat() {
        if (DbType.OBORACLE_21.getType().equals(this.getDbType().getType()) && "LIST COLUMNS".equals(this.getPartitionType())) {
            return super.getTablePartTemplateMapping().get("LIST");
        }
        return super.getTablePartTemplateMapping().get(this.getPartitionType());
    }

    @Override
    public List<ObjectDefine> compareTo(AbstractTablePartition other) {
        if (!(other instanceof TableGroupPartition)) {
            throw new UnmatchedObjectTypeException("Raw type is not matched");
        }
        return null;
    }

    public String getPartitionType() {
        return this.partitionType;
    }

    public void setPartitionType(String partitionType) {
        this.partitionType = partitionType;
    }

    public int getPartitionColumnNum() {
        return this.partitionColumnNum;
    }

    public void setPartitionColumnNum(int partitionColumnNum) {
        this.partitionColumnNum = partitionColumnNum;
    }

    public int getPartitionCount() {
        return this.partitionCount;
    }

    public void setPartitionCount(int partitionCount) {
        this.partitionCount = partitionCount;
    }

    public TableGroupSubPartition getTableGroupSubPartition() {
        return this.tableGroupSubPartition;
    }

    public void setTableGroupSubPartition(TableGroupSubPartition tableGroupSubPartition) {
        this.tableGroupSubPartition = tableGroupSubPartition;
    }

    public Collection<AbstractOracleTablePartition.OracleTablePartitionItem> getPartitionItems() {
        return this.partitionItems;
    }
}

