/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.model.ob;

import com.oceanbase.obtools.common.utils.CollectionUtils;
import com.oceanbase.obtools.dbdiff.compare.result.ObjectDefine;
import com.oceanbase.obtools.dbdiff.enums.DbType;
import com.oceanbase.obtools.dbdiff.exception.UnmatchedObjectTypeException;
import com.oceanbase.obtools.dbdiff.exception.UnsupportedGrammarException;
import com.oceanbase.obtools.dbdiff.model.AbstractSchema;
import com.oceanbase.obtools.dbdiff.model.AbstractTablePartition;
import com.oceanbase.obtools.dbdiff.model.ob.TableGroupPartition;
import com.oceanbase.obtools.dbdiff.model.oracle.AbstractOracleTablePartition;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

public class TableGroupSubPartition
extends AbstractTablePartition {
    private String subPartitionType;
    private int subPartitionColumnNum;
    private int subPartitionCount;
    private final Collection<AbstractOracleTablePartition.OracleTablePartitionTemplate> subPartitionTemplates = new LinkedHashSet<AbstractOracleTablePartition.OracleTablePartitionTemplate>();
    private final Map<Integer, List<AbstractOracleTablePartition.OracleTablePartitionItem>> subPartitionItemMapping = new LinkedHashMap<Integer, List<AbstractOracleTablePartition.OracleTablePartitionItem>>();

    public TableGroupSubPartition(AbstractSchema schema) {
        super(schema);
    }

    @Override
    public StringBuilder buildGrammar() throws UnsupportedGrammarException {
        if (this.isDefinedByTemplate()) {
            String subPartFormat = this.getSubPartFormat();
            StringBuilder sb = new StringBuilder(512);
            sb.append("\nSUBPARTITION TEMPLATE (");
            Iterator<AbstractOracleTablePartition.OracleTablePartitionTemplate> iter = this.getSubPartitionTemplates().iterator();
            while (iter.hasNext()) {
                AbstractOracleTablePartition.OracleTablePartitionTemplate subPartTemplate = iter.next();
                String subPartName = this.wrap(subPartTemplate.getSubPartitionName());
                sb.append("\n\t");
                sb.append(String.format(subPartFormat, subPartName, subPartTemplate.getHighBound()));
                if (!iter.hasNext()) continue;
                sb.append(",");
            }
            return sb.append("\n)");
        }
        return new StringBuilder(0);
    }

    @Override
    public String getQuotaCharacter() {
        DbType dbType = super.getDbType();
        if (dbType != null && dbType.isMySqlType()) {
            return "`";
        }
        return super.getQuotaCharacter();
    }

    public boolean isDefinedByTemplate() {
        return CollectionUtils.isNotEmpty(this.getSubPartitionTemplates());
    }

    public boolean isValid() {
        return this.getSubPartitionColumnNum() > 0;
    }

    public String getJdbcFieldName() {
        if ("LIST".equals(this.getSubPartitionType()) || "LIST COLUMNS".equals(this.getSubPartitionType())) {
            return "sub_part_list_val";
        }
        return "sub_part_high_bound_val";
    }

    public String getSubPartFormat() {
        if (DbType.OBORACLE_21.getType().equals(this.getDbType().getType()) && "LIST COLUMNS".equals(this.getSubPartitionType())) {
            return super.getTableSubPartTemplateMapping().get("LIST");
        }
        return super.getTableSubPartTemplateMapping().get(this.getSubPartitionType());
    }

    @Override
    public List<ObjectDefine> compareTo(AbstractTablePartition other) {
        if (!(other instanceof TableGroupPartition)) {
            throw new UnmatchedObjectTypeException("Raw type is not matched");
        }
        return null;
    }

    public String getSubPartitionType() {
        return this.subPartitionType;
    }

    public void setSubPartitionType(String subPartitionType) {
        this.subPartitionType = subPartitionType;
    }

    public int getSubPartitionColumnNum() {
        return this.subPartitionColumnNum;
    }

    public void setSubPartitionColumnNum(int subPartitionColumnNum) {
        this.subPartitionColumnNum = subPartitionColumnNum;
    }

    public int getSubPartitionCount() {
        return this.subPartitionCount;
    }

    public void setSubPartitionCount(int subPartitionCount) {
        this.subPartitionCount = subPartitionCount;
    }

    public Collection<AbstractOracleTablePartition.OracleTablePartitionTemplate> getSubPartitionTemplates() {
        return this.subPartitionTemplates;
    }

    public Map<Integer, List<AbstractOracleTablePartition.OracleTablePartitionItem>> getSubPartitionItemMapping() {
        return this.subPartitionItemMapping;
    }
}

