/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.model.obkv;

import com.google.gson.Gson;
import com.oceanbase.obtools.common.collect.Lists;
import com.oceanbase.obtools.dbdiff.compare.result.CreateObjectDefine;
import com.oceanbase.obtools.dbdiff.compare.result.DropObjectDefine;
import com.oceanbase.obtools.dbdiff.compare.result.ObjectDefine;
import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import com.oceanbase.obtools.dbdiff.exception.UnsupportedGrammarException;
import com.oceanbase.obtools.dbdiff.model.AbstractOwnership;
import com.oceanbase.obtools.dbdiff.model.AbstractSchema;
import com.oceanbase.obtools.dbdiff.model.base.IDefiner;
import com.oceanbase.obtools.dbdiff.model.obkv.ObKVColumn;
import com.oceanbase.obtools.dbdiff.model.obkv.ObKVPrimary;
import com.oceanbase.obtools.dbdiff.model.obkv.ObKVTable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ObKVColumnFamily
extends AbstractOwnership
implements IDefiner {
    private final Map<String, ObKVColumn> columnMapping = new LinkedHashMap<String, ObKVColumn>();
    private ObKVPrimary primaryKey;
    private ObKVTable table;
    private Integer ttl;
    private Integer maxVersion;
    private Integer minVersion;

    public ObKVColumnFamily(AbstractSchema schema) {
        super(schema);
    }

    @Override
    public List<ObjectDefine> buildDefinition() throws UnsupportedGrammarException {
        StringBuilder sb = new StringBuilder();
        sb.append("create table if not exists ").append(this.wrapAndEscape(this.getFullColumnFamilyName())).append(" (");
        Collection<ObKVColumn> columns = this.getColumnMapping().values();
        Iterator<ObKVColumn> iter = columns.iterator();
        while (iter.hasNext()) {
            ObKVColumn column = iter.next();
            sb.append("\n\t").append((CharSequence)column.buildGrammar());
            if (!iter.hasNext()) continue;
            sb.append(",");
        }
        if (this.getPrimaryKey() != null) {
            sb.append(",").append("\n\t").append((CharSequence)this.getPrimaryKey().buildGrammar());
        }
        sb.append("\n").append(")");
        ArrayList<ObjectDefine> subDefines = new ArrayList<ObjectDefine>();
        StringBuilder comment = new StringBuilder();
        comment.append("alter table ").append(this.wrapAndEscape(this.getFullColumnFamilyName())).append(" comment='{\"HColumnDescriptor\": ");
        HashMap<String, Integer> options = new HashMap<String, Integer>();
        if (this.getTtl() != null) {
            options.put("TimeToLive", this.getTtl());
        }
        if (this.getMaxVersion() != null) {
            options.put("MaxVersions", this.getMaxVersion());
        }
        if (this.getMinVersion() != null) {
            options.put("MinVersions", this.getMinVersion());
        }
        comment.append(new Gson().toJson(options)).append("';");
        subDefines.add(new CreateObjectDefine(ObjectType.COMMENT, this.getObjectName(), this.terminate(comment)));
        return Lists.newArrayList((Object[])new ObjectDefine[]{new CreateObjectDefine(ObjectType.TABLE, this.getObjectName(), this.terminate(sb.toString()), subDefines)});
    }

    @Override
    public DropObjectDefine buildDropDefinition() {
        StringBuilder sb = new StringBuilder();
        sb.append("DROP TABLE ").append(this.wrapAndEscape(this.getFullColumnFamilyName()));
        return new DropObjectDefine(ObjectType.TABLE, this.getSimpleObjectName(), this.terminate(sb));
    }

    @Override
    public String getQuotaCharacter() {
        return "`";
    }

    public String getFullColumnFamilyName() {
        return this.table.getObjectName() + "$" + this.getObjectName();
    }

    public Map<String, ObKVColumn> getColumnMapping() {
        return this.columnMapping;
    }

    public ObKVPrimary getPrimaryKey() {
        return this.primaryKey;
    }

    public void setPrimaryKey(ObKVPrimary primaryKey) {
        this.primaryKey = primaryKey;
    }

    public ObKVTable getTable() {
        return this.table;
    }

    public void setTable(ObKVTable table) {
        this.table = table;
    }

    public Integer getTtl() {
        return this.ttl;
    }

    public void setTtl(Integer ttl) {
        this.ttl = ttl;
    }

    public Integer getMaxVersion() {
        return this.maxVersion;
    }

    public void setMaxVersion(Integer maxVersion) {
        this.maxVersion = maxVersion;
    }

    public Integer getMinVersion() {
        return this.minVersion;
    }

    public void setMinVersion(Integer minVersion) {
        this.minVersion = minVersion;
    }
}

