/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.model.obkv;

import com.oceanbase.obtools.common.utils.StringUtils;
import com.oceanbase.obtools.dbdiff.compare.result.ObjectDefine;
import com.oceanbase.obtools.dbdiff.exception.UnmatchedObjectTypeException;
import com.oceanbase.obtools.dbdiff.exception.UnsupportedGrammarException;
import com.oceanbase.obtools.dbdiff.model.AbstractConstraint;
import com.oceanbase.obtools.dbdiff.model.AbstractSchema;
import com.oceanbase.obtools.dbdiff.model.base.KeyColumn;
import com.oceanbase.obtools.dbdiff.model.mysql.AbstractMySqlConstraint;
import java.util.Iterator;
import java.util.List;

public class ObKVPrimary
extends AbstractMySqlConstraint {
    public ObKVPrimary(AbstractSchema schema) {
        super(schema);
    }

    @Override
    public StringBuilder buildGrammar() throws UnsupportedGrammarException {
        StringBuilder sb = new StringBuilder();
        sb.append("primary key ");
        if (StringUtils.isNotBlank((CharSequence)this.getConstraintName())) {
            sb.append(this.getConstraintName()).append(" ");
        }
        StringBuilder columnStr = new StringBuilder();
        Iterator<KeyColumn> iter = this.getConstraintColumns().iterator();
        while (iter.hasNext()) {
            KeyColumn column = iter.next();
            columnStr.append(this.wrapAndEscape(column.getColumnName()));
            if (!iter.hasNext()) continue;
            columnStr.append(",").append(" ");
        }
        sb.append((CharSequence)this.enclose(columnStr));
        return sb;
    }

    @Override
    public List<ObjectDefine> compareTo(AbstractConstraint other) {
        if (!(other instanceof ObKVPrimary)) {
            throw new UnmatchedObjectTypeException("Raw type is not matched");
        }
        return null;
    }
}

