/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.model.obmysql;

import com.oceanbase.obtools.common.utils.StringUtils;
import com.oceanbase.obtools.dbdiff.exception.UnsupportedGrammarException;
import com.oceanbase.obtools.dbdiff.model.AbstractSchema;
import com.oceanbase.obtools.dbdiff.model.base.KeyColumn;
import com.oceanbase.obtools.dbdiff.model.mysql.AbstractMySqlColumn;
import com.oceanbase.obtools.dbdiff.model.mysql.AbstractMySqlConstraint;
import java.util.Map;

public abstract class AbstractObMySqlConstraint
extends AbstractMySqlConstraint {
    private Map<String, ? extends AbstractMySqlColumn> columnMapping;

    public AbstractObMySqlConstraint(AbstractSchema schema) {
        super(schema);
    }

    protected void checkConstraintOnGeneratedColumns() throws UnsupportedGrammarException {
        if (this.getColumnMapping() == null) {
            return;
        }
        for (KeyColumn keyCol : this.getConstraintColumns()) {
            String extra;
            AbstractMySqlColumn column = this.getColumnMapping().get(keyCol.getColumnName());
            if (column == null || StringUtils.isBlank((CharSequence)column.getExtra()) || (extra = column.getExtra()).contains("DEFAULT_GENERATED") || !extra.contains("GENERATED")) continue;
            throw new UnsupportedGrammarException(this.getSchemaObjectName(), "The primary key is unsupported for generated columns");
        }
    }

    public Map<String, ? extends AbstractMySqlColumn> getColumnMapping() {
        return this.columnMapping;
    }

    public void setColumnMapping(Map<String, ? extends AbstractMySqlColumn> columnMapping) {
        this.columnMapping = columnMapping;
    }
}

