/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.model.obmysql14x;

import com.google.common.collect.Lists;
import com.oceanbase.obtools.common.model.Pair;
import com.oceanbase.obtools.common.utils.MapUtils;
import com.oceanbase.obtools.common.utils.NumberUtils;
import com.oceanbase.obtools.common.utils.StringUtils;
import com.oceanbase.obtools.dbdiff.compare.result.AlterObjectDefine;
import com.oceanbase.obtools.dbdiff.compare.result.ChangeInfo;
import com.oceanbase.obtools.dbdiff.compare.result.ObjectDefine;
import com.oceanbase.obtools.dbdiff.compare.result.UnsupportedObjectDefine;
import com.oceanbase.obtools.dbdiff.constants.Constants;
import com.oceanbase.obtools.dbdiff.constants.ConvertCode;
import com.oceanbase.obtools.dbdiff.enums.DbType;
import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import com.oceanbase.obtools.dbdiff.exception.UnmatchedObjectTypeException;
import com.oceanbase.obtools.dbdiff.exception.UnsupportedGrammarException;
import com.oceanbase.obtools.dbdiff.model.AbstractColumn;
import com.oceanbase.obtools.dbdiff.model.mysql.AbstractMySqlColumn;
import com.oceanbase.obtools.dbdiff.model.obmysql14x.ObMySql14xSchema;
import com.oceanbase.obtools.dbdiff.utils.ChangeUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;

public class ObMySql14xColumn
extends AbstractMySqlColumn {
    private static final String BAD_SCALE = "-1";
    private String bitDefaultVal;
    private int prevColumnId;
    private boolean onUpdateCurrentTimestamp;

    public ObMySql14xColumn(ObMySql14xSchema schema) {
        super(schema);
    }

    @Override
    public StringBuilder buildGrammar() throws UnsupportedGrammarException {
        String originExpr;
        String originCollation;
        String columnType = this.getColumnType().trim().toLowerCase(Locale.getDefault());
        String dbType = this.getDbType().getType();
        if (columnType.equalsIgnoreCase("UNKNOWN")) {
            throw new UnsupportedGrammarException(ConvertCode.MysqlUnsupportedCode.COLUMN_TYPE_NOT_SUPPORT, this.getSchemaObjectName(), "The data type: \"" + this.getDataType() + "\" is unsupported in " + this.getDbType());
        }
        if (DbType.OBMYSQL_200.getType().equals(dbType) && !DbType.OBMYSQL_200.isPrior(this.getDbType()) && (columnType.startsWith("set") || columnType.startsWith("enum"))) {
            throw new UnsupportedGrammarException(ConvertCode.MysqlUnsupportedCode.ENUM_OR_SET_TYPE_NOT_SUPPORT, this.getSchemaObjectName(), "The data type: \"" + columnType + "\" is unsupported in " + this.getDbType());
        }
        if ((DbType.OBMYSQL_322.getType().equals(dbType) && DbType.OBMYSQL_322.isSubsequent(this.getDbType()) || DbType.OBMYSQL_CE_313.getType().equals(dbType) && DbType.OBMYSQL_CE_313.isSubsequent(this.getDbType())) && columnType.startsWith("json")) {
            throw new UnsupportedGrammarException(ConvertCode.MysqlUnsupportedCode.JSON_TYPE_NOT_SUPPORT, this.getSchemaObjectName(), "The data type: \"" + columnType + "\" is unsupported in " + this.getDbType());
        }
        if ((DbType.OBMYSQL_324.getType().equals(dbType) && (DbType.OBMYSQL_324.isSubsequent(this.getDbType()) || DbType.OBMYSQL_40.isSame(this.getDbType())) || DbType.OBMYSQL_CE_311.getType().equals(dbType) && DbType.OBMYSQL_CE_41.isSubsequent(this.getDbType())) && (columnType.startsWith("geometry") || columnType.startsWith("point") || columnType.startsWith("linestring") || columnType.startsWith("polygon") || columnType.startsWith("multipoint") || columnType.startsWith("multilinestring") || columnType.startsWith("multipolygon") || columnType.startsWith("geometrycollection"))) {
            throw new UnsupportedGrammarException(ConvertCode.MysqlUnsupportedCode.GIS_TYPE_NOT_SUPPORT, this.getSchemaObjectName(), "The data type: \"" + columnType + "\" is unsupported in " + this.getDbType());
        }
        if (columnType.startsWith("year") | columnType.startsWith("bit") && columnType.endsWith("unsigned")) {
            columnType = columnType.substring(0, columnType.lastIndexOf("unsigned") - 1);
            super.setColumnType(columnType);
        }
        if (columnType.startsWith("geomcollection")) {
            super.setColumnType("geometrycollection");
        }
        this.forceConvertCharset();
        String originCharset = super.getCharacterSetName();
        if ("utf8".equalsIgnoreCase(originCharset)) {
            super.setCharacterSetName("utf8mb4");
            ChangeUtils.warn(ObjectType.TABLE, this.getSchemaObjectName(), ChangeInfo.ChangeType.CONVERT, "The column charset: " + originCharset + " -> " + "utf8mb4");
        }
        if (StringUtils.startsWithIgnoreCase((String)(originCollation = super.getCollationName()), (String)"utf8")) {
            String targetCollation = originCollation.replace("utf8_", "utf8mb4_");
            if (StringUtils.startsWithIgnoreCase((String)targetCollation, (String)"utf8mb4_") && StringUtils.endsWithIgnoreCase((CharSequence)targetCollation, (CharSequence)"_ai_ci")) {
                super.setCollationName("utf8mb4_general_ci");
            } else {
                super.setCollationName(targetCollation);
            }
            if (StringUtils.notEqualsIgnoreCase((CharSequence)originCollation, (CharSequence)targetCollation)) {
                ChangeUtils.warn(ObjectType.TABLE, this.getSchemaObjectName(), ChangeInfo.ChangeType.CONVERT, "The column collation: " + originCollation + " -> " + super.getCollationName());
            }
        }
        String charsetName = super.getCharacterSetName();
        String collationName = super.getCollationName();
        Pair<Set<String>, Set<String>> supportCharsets = this.getSupportCharsets();
        Set charsets = (Set)supportCharsets.getLeft();
        Set collations = (Set)supportCharsets.getRight();
        if (charsetName != null && !charsets.contains(charsetName)) {
            throw new UnsupportedGrammarException(ConvertCode.MysqlUnsupportedCode.COLUMN_CHARSET_NOT_SUPPORT, this.getSchemaObjectName(), "The column charset: \"" + originCharset + "\" is unsupported in " + this.getDbType());
        }
        if (collationName != null && !collations.contains(collationName)) {
            throw new UnsupportedGrammarException(ConvertCode.MysqlUnsupportedCode.COLUMN_COLLATION_NOT_SUPPORT, this.getSchemaObjectName(), "The column collation: \"" + originCollation + "\" is unsupported in " + this.getDbType());
        }
        if (StringUtils.isNotBlank((CharSequence)super.getCharacterSetName()) && StringUtils.isNotBlank((CharSequence)super.getCollationName()) && !this.checkCharsetAndCollation()) {
            throw new UnsupportedGrammarException(ConvertCode.MysqlUnsupportedCode.COLUMN_CHARSET_COLLATION_COMBINATION_NOT_VALID, this.getSchemaObjectName(), "The column " + this.wrap(this.getColumnName()) + " collation: \"" + super.getCollationName() + "\" is not valid for the character set: \"" + super.getCharacterSetName() + "\"");
        }
        if ("FLOAT".equalsIgnoreCase(this.getDataType())) {
            int endIndex = columnType.indexOf(44);
            if (columnType.contains(BAD_SCALE) && endIndex > -1) {
                super.setColumnType(columnType.substring(0, endIndex) + ")");
            }
        }
        if ((DbType.OBMYSQL_40.getType().equals(dbType) && DbType.OBMYSQL_40.isPriorFrom(this.getDbType()) && DbType.OBMYSQL_410.isSubsequent(this.getDbType()) || DbType.OBMYSQL_CE_40.getType().equals(dbType) && DbType.OBMYSQL_CE_40.isPriorFrom(this.getDbType()) && DbType.OBMYSQL_CE_41.isSubsequent(this.getDbType())) && ("FLOAT".equalsIgnoreCase(this.getDataType()) || "DOUBLE".equalsIgnoreCase(this.getDataType())) && this.getNumericScale() != null && this.getNumericScale() > 0) {
            String originColumnType = columnType;
            int index = originColumnType.indexOf(" ");
            if (index != -1) {
                String extra = originColumnType.substring(index);
                columnType = this.getDataType() + extra;
            } else {
                columnType = this.getDataType();
            }
            super.setColumnType(columnType);
            ChangeUtils.info(ObjectType.TABLE, this.getSchemaObjectName(), ChangeInfo.ChangeType.CONVERT, this.getWrappedName() + " " + originColumnType + " -> " + this.getColumnType());
        }
        if (this.isZerofill() && !this.getColumnType().contains("zerofill")) {
            super.setColumnType(this.getColumnType() + " zerofill");
        }
        if (this.isOnUpdateCurrentTimestamp()) {
            StringBuilder sb = new StringBuilder();
            sb.append("on update current_timestamp");
            int beginIndex = columnType.indexOf(40);
            int endIndex = columnType.indexOf(41);
            if (beginIndex > -1 && endIndex > beginIndex) {
                sb.append("(").append(columnType.substring(beginIndex + 1, endIndex)).append(")");
            }
            super.setExtra(sb.toString());
        }
        String extra = super.getExtra();
        String expr = super.getGenerationExpression();
        if (StringUtils.isNotBlank((CharSequence)expr) && StringUtils.notEqualsIgnoreCase((CharSequence)(originExpr = expr), (CharSequence)(expr = expr.replace("\\'", "'").replace("\\\\", "\\")))) {
            super.setGenerationExpression(expr);
            ChangeUtils.warn(ObjectType.TABLE, this.getSchemaObjectName(), ChangeInfo.ChangeType.CONVERT, "The generation expression: " + originExpr + " -> " + expr);
        }
        if ("INVISIBLE".equalsIgnoreCase(extra) && StringUtils.isBlank((CharSequence)expr)) {
            super.setExtra(null);
            ChangeUtils.warn(ObjectType.TABLE, this.getSchemaObjectName(), ChangeInfo.ChangeType.CONVERT, "The invisible column: `" + this.getColumnName() + "` " + this.getColumnType() + " INVISIBLE -> `" + this.getColumnName() + "` " + this.getColumnType());
        }
        return super.buildGrammar();
    }

    protected void forceConvertCharset() {
        String originCharset = super.getCharacterSetName();
        String originCollation = super.getCollationName();
        Pair<Set<String>, Set<String>> supportCharsets = this.getSupportCharsets();
        Set charsets = (Set)supportCharsets.getLeft();
        Set collations = (Set)supportCharsets.getRight();
        if (originCharset != null && charsets.contains(originCharset) && originCollation != null && collations.contains(originCollation)) {
            return;
        }
        Map<String, String> charsetMapping = this.getGlobal().getCharsetMapping();
        if (originCharset != null && MapUtils.isNotEmpty(charsetMapping)) {
            for (Map.Entry<String, String> entry : charsetMapping.entrySet()) {
                if (!FilenameUtils.wildcardMatch((String)originCharset, (String)entry.getKey()) || !StringUtils.isNotBlank((CharSequence)entry.getValue())) continue;
                super.setCharacterSetName(entry.getValue());
                break;
            }
            if (!originCharset.equalsIgnoreCase(super.getCharacterSetName())) {
                ChangeUtils.warn(ObjectType.TABLE, this.getSchemaObjectName(), ChangeInfo.ChangeType.CONVERT, "The column " + this.wrap(this.getColumnName()) + " charset: " + originCharset + " -> " + super.getCharacterSetName());
            }
        }
        Map<String, String> collationMapping = this.getGlobal().getCollationMapping();
        if (originCollation != null && MapUtils.isNotEmpty(collationMapping)) {
            for (Map.Entry<String, String> entry : collationMapping.entrySet()) {
                if (!FilenameUtils.wildcardMatch((String)originCollation, (String)entry.getKey()) || !StringUtils.isNotBlank((CharSequence)entry.getValue())) continue;
                super.setCollationName(entry.getValue());
                break;
            }
            if (!originCollation.equalsIgnoreCase(super.getCollationName())) {
                ChangeUtils.warn(ObjectType.TABLE, this.getSchemaObjectName(), ChangeInfo.ChangeType.CONVERT, "The column " + this.wrap(this.getColumnName()) + " collation: " + originCollation + " -> " + super.getCollationName());
            }
        }
    }

    @Override
    protected StringBuilder buildDefaultValue() {
        String originDbType = this.getOriginDbType().getType();
        String dbType = this.getDbType().getType();
        if (DbType.MYSQL_56.getType().equals(originDbType) || DbType.MARIADB_101.getType().equals(originDbType) || DbType.TIDB_4.getType().equals(originDbType) || DbType.TENCENTDB_MYSQL_56.getType().equals(originDbType)) {
            return super.buildDefaultValue();
        }
        StringBuilder sb = new StringBuilder();
        String columnDefault = super.getColumnDefault();
        boolean isGenerated = super.isColumnDefaultGenerated();
        if (!isGenerated && columnDefault != null) {
            sb.append(" default ");
            if (this.isBuiltinFunction(columnDefault)) {
                if ("CURRENT_TIMESTAMP".equalsIgnoreCase(columnDefault)) {
                    String columnType = this.getColumnType();
                    int beginIndex = columnType.indexOf(40);
                    int endIndex = columnType.indexOf(41);
                    if (beginIndex > -1 && endIndex > beginIndex) {
                        String precision = columnType.substring(beginIndex + 1, endIndex);
                        columnDefault = columnDefault + "(" + precision + ")";
                    }
                }
                sb.append(columnDefault);
            } else if (super.isColumnDefaultGenerated()) {
                sb.append("(").append(columnDefault.replace("'", "''")).append(")");
            } else if ("BIT".equalsIgnoreCase(this.getDataType())) {
                if (DbType.OBMYSQL_211.getType().equals(dbType) && DbType.OBMYSQL_211.isPriorFrom(this.getDbType()) || DbType.OBMYSQL_CE_313.getType().equals(dbType)) {
                    if (columnDefault.startsWith("b")) {
                        sb.append(columnDefault);
                    } else {
                        sb.append("'").append(columnDefault).append("'");
                    }
                } else {
                    Exception flag = null;
                    String fixedValue = this.getBitDefaultVal();
                    if (fixedValue != null) {
                        try {
                            fixedValue = Integer.toBinaryString(Integer.parseInt(fixedValue));
                            sb.append("'").append(fixedValue).append("'");
                        }
                        catch (Exception ex) {
                            flag = ex;
                        }
                    }
                    if (fixedValue == null || flag != null) {
                        sb.setLength(0);
                        ChangeUtils.info(ObjectType.TABLE, this.getSchemaObjectName(), ChangeInfo.ChangeType.DISCARD, this.getColumnName() + " BIT DEFAULT '" + columnDefault + "' -> NULL");
                    }
                }
            } else if (DbType.ORACLE_11GR1.getType().equals(originDbType) || DbType.OBORACLE_22.getType().equals(originDbType)) {
                if (columnDefault.startsWith("'") && columnDefault.endsWith("'")) {
                    sb.append(columnDefault);
                } else {
                    sb.append("'").append(columnDefault.replace("'", "''")).append("'");
                }
            } else {
                sb.append("'").append(columnDefault.replace("'", "''")).append("'");
            }
        }
        if (columnDefault != null && columnDefault.contains("--")) {
            sb.append("\n");
        }
        return sb;
    }

    @Override
    public List<ObjectDefine> compareTo(AbstractColumn other) {
        if (!(other instanceof ObMySql14xColumn)) {
            throw new UnmatchedObjectTypeException("Raw type is not matched");
        }
        ArrayList<ObjectDefine> objectDefines = new ArrayList<ObjectDefine>();
        ObMySql14xColumn target = (ObMySql14xColumn)other;
        boolean isColumnTypeDiff = StringUtils.notEquals((CharSequence)this.getColumnType(), (CharSequence)target.getColumnType());
        boolean isColumnNameDiff = StringUtils.notEquals((CharSequence)this.getColumnName(), (CharSequence)target.getColumnName());
        boolean isCharacterMaximumLengthDiff = NumberUtils.notEquals((Number)this.getCharacterMaximumLength(), (Number)target.getCharacterMaximumLength());
        boolean isCharacterOctetLengthDiff = NumberUtils.notEquals((Number)this.getCharacterOctetLength(), (Number)target.getCharacterOctetLength());
        boolean isNumericPrecisionDiff = NumberUtils.notEquals((Number)this.getNumericPrecision(), (Number)target.getNumericPrecision());
        boolean isNumericScaleDiff = NumberUtils.notEquals((Number)this.getNumericScale(), (Number)target.getNumericScale());
        boolean isDateTimePrecisionDiff = NumberUtils.notEquals((Number)this.getDateTimePrecision(), (Number)target.getDateTimePrecision());
        boolean isExtraDiff = StringUtils.notEquals((CharSequence)this.getExtra(), (CharSequence)target.getExtra());
        boolean isGenerationExpressionDiff = (StringUtils.isNotBlank((CharSequence)this.getGenerationExpression()) || StringUtils.isNotBlank((CharSequence)target.getGenerationExpression())) && StringUtils.notEquals((CharSequence)this.getGenerationExpression(), (CharSequence)target.getGenerationExpression());
        boolean isCommentDiff = StringUtils.notEquals((CharSequence)this.getColumnComment(), (CharSequence)target.getColumnComment());
        try {
            String targetColumnType;
            boolean isOtherDiff = false;
            if (this.getOriginDbType().isObMySqlType() && (isCharacterMaximumLengthDiff || isCharacterOctetLengthDiff || isNumericPrecisionDiff || isNumericScaleDiff || isDateTimePrecisionDiff)) {
                isOtherDiff = true;
            }
            if (this.getOriginDbType().isNativeMySqlType() && (targetColumnType = target.getColumnType()) != null && targetColumnType.contains("int") && targetColumnType.contains("(")) {
                targetColumnType = targetColumnType.substring(0, targetColumnType.indexOf("("));
                isColumnTypeDiff = StringUtils.notEquals((CharSequence)this.getColumnType(), (CharSequence)targetColumnType);
            }
            if (isColumnTypeDiff || isColumnNameDiff || isExtraDiff || isGenerationExpressionDiff || isCommentDiff || isOtherDiff) {
                StringBuilder sb = new StringBuilder();
                sb.append("ALTER TABLE ").append(this.getSchemaObjectName());
                sb.append(" MODIFY ").append((CharSequence)this.buildGrammar()).append(";");
                objectDefines.add(new AlterObjectDefine(ObjectType.TABLE, this.getSimpleObjectName(), sb.toString()));
            }
            return objectDefines;
        }
        catch (UnsupportedGrammarException e) {
            return Lists.newArrayList((Object[])new ObjectDefine[]{new UnsupportedObjectDefine(ObjectType.TABLE, this.getSimpleObjectName(), e.getMessage())});
        }
    }

    private Pair<Set<String>, Set<String>> getSupportCharsets() {
        Set<String> collations;
        Set<String> charsets;
        if (DbType.OBMYSQL_420.getType().equals(this.getDbType().getType()) && DbType.OBMYSQL_420.isPriorFrom(this.getDbType())) {
            charsets = Constants.SUB_V4200_SUPPORTED_CHARSETS;
            collations = Constants.SUB_V4200_SUPPORTED_COLLATIONS;
        } else if (DbType.OBMYSQL_410.getType().equals(this.getDbType().getType()) && DbType.OBMYSQL_410.isPriorFrom(this.getDbType())) {
            charsets = Constants.SUB_V4100_SUPPORTED_CHARSETS;
            collations = Constants.SUB_V4100_SUPPORTED_COLLATIONS;
        } else if (DbType.OBMYSQL_2230.getType().equals(this.getDbType().getType()) && DbType.OBMYSQL_2230.isPriorFrom(this.getDbType())) {
            charsets = Constants.SUB_V2230_SUPPORTED_CHARSETS;
            collations = Constants.SUB_V2230_SUPPORTED_COLLATIONS;
        } else if (this.getDbType().isObMysqlCEType() && DbType.OBMYSQL_CE_42.isPriorFrom(this.getDbType())) {
            charsets = Constants.SUB_V4200_SUPPORTED_CHARSETS;
            collations = Constants.SUB_CEV4200_SUPPORTED_COLLATIONS;
        } else if (this.getDbType().isObMysqlCEType() && DbType.OBMYSQL_CE_41.isPriorFrom(this.getDbType())) {
            charsets = Constants.SUB_V4100_SUPPORTED_CHARSETS;
            collations = Constants.SUB_CEV4100_SUPPORTED_COLLATIONS;
        } else if (this.getDbType().isObMysqlCEType() && DbType.OBMYSQL_CE_40.isPriorFrom(this.getDbType())) {
            charsets = Constants.SUB_V2230_SUPPORTED_CHARSETS;
            collations = Constants.SUB_CEV4000_SUPPORTED_COLLATIONS;
        } else {
            charsets = Constants.PRI_V2230_SUPPORTED_CHARSETS;
            collations = Constants.PRI_V2230_SUPPORTED_COLLATIONS;
        }
        return new Pair(charsets, collations);
    }

    public String getBitDefaultVal() {
        return this.bitDefaultVal;
    }

    public void setBitDefaultVal(String bitDefaultVal) {
        this.bitDefaultVal = bitDefaultVal;
    }

    public int getPrevColumnId() {
        return this.prevColumnId;
    }

    public void setPrevColumnId(int prevColumnId) {
        this.prevColumnId = prevColumnId;
    }

    public boolean isOnUpdateCurrentTimestamp() {
        return this.onUpdateCurrentTimestamp;
    }

    public void setOnUpdateCurrentTimestamp(boolean onUpdateCurrentTimestamp) {
        this.onUpdateCurrentTimestamp = onUpdateCurrentTimestamp;
    }
}

