/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.model.obmysql14x;

import com.google.common.collect.Lists;
import com.oceanbase.obtools.common.utils.StringUtils;
import com.oceanbase.obtools.dbdiff.compare.result.CreateObjectDefine;
import com.oceanbase.obtools.dbdiff.compare.result.DropObjectDefine;
import com.oceanbase.obtools.dbdiff.compare.result.ObjectDefine;
import com.oceanbase.obtools.dbdiff.compare.result.UnsupportedObjectDefine;
import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import com.oceanbase.obtools.dbdiff.exception.UnmatchedObjectTypeException;
import com.oceanbase.obtools.dbdiff.exception.UnsupportedGrammarException;
import com.oceanbase.obtools.dbdiff.model.AbstractConstraint;
import com.oceanbase.obtools.dbdiff.model.obmysql.AbstractObMySqlConstraint;
import com.oceanbase.obtools.dbdiff.model.obmysql14x.ObMySql14xSchema;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class ObMySql14xForeignKey
extends AbstractObMySqlConstraint {
    public ObMySql14xForeignKey(ObMySql14xSchema schema) {
        super(schema);
    }

    @Override
    public StringBuilder buildGrammar() throws UnsupportedGrammarException {
        StringBuilder sb = new StringBuilder();
        sb.append("constraint ").append(this.wrapAndEscape(this.getConstraintName()));
        sb.append(" foreign key").append((CharSequence)this.joinForeignConstraintColumns());
        sb.append(" references ").append(this.getRefOwnerTableName());
        sb.append((CharSequence)this.joinRefConstraintColumns());
        sb.append(this.safetyMapping(DELETE_RULE_MAPPING, this.getDeleteRule()));
        return sb.append(this.safetyMapping(UPDATE_RULE_MAPPING, this.getUpdateRule()));
    }

    @Override
    public List<ObjectDefine> compareTo(AbstractConstraint other) {
        if (!(other instanceof ObMySql14xForeignKey)) {
            throw new UnmatchedObjectTypeException("Raw type is not matched");
        }
        String objectName = this.getSimpleObjectName();
        ArrayList<ObjectDefine> objectDefines = new ArrayList<ObjectDefine>();
        ObMySql14xForeignKey target = (ObMySql14xForeignKey)other;
        String srcForeignColumnString = this.joinForeignConstraintColumns().toString();
        String dstForeignColumnString = target.joinRefConstraintColumns().toString();
        boolean isForeignColumnsDiff = StringUtils.notEquals((CharSequence)srcForeignColumnString, (CharSequence)dstForeignColumnString);
        String srcRefOwnerTableName = this.getRefTableOwner() + "." + this.getRefTableName();
        String dstRefOwnerTableName = target.getRefTableOwner() + "." + target.getRefTableName();
        boolean isRefOwnerTableNameDiff = StringUtils.notEquals((CharSequence)srcRefOwnerTableName, (CharSequence)dstRefOwnerTableName);
        String srcRefColumnString = this.getReferencedColumns().stream().map(e -> e.getColumnName()).collect(Collectors.joining(","));
        String dstRefColumnString = target.getReferencedColumns().stream().map(e -> e.getColumnName()).collect(Collectors.joining(","));
        boolean isRefColumnsDiff = StringUtils.notEquals((CharSequence)srcRefColumnString, (CharSequence)dstRefColumnString);
        try {
            if (isForeignColumnsDiff || isRefOwnerTableNameDiff || isRefColumnsDiff) {
                StringBuilder drop = new StringBuilder();
                drop.append("alter table ").append(this.getSchemaObjectName());
                drop.append(" drop foreign key ").append(this.wrap(target.getConstraintName()));
                StringBuilder add = new StringBuilder();
                add.append("alter table ").append(this.getSchemaObjectName());
                add.append(" add ").append((CharSequence)this.buildGrammar());
                objectDefines.add(new DropObjectDefine(ObjectType.CONSTRAINT, objectName, drop.toString()));
                objectDefines.add(new CreateObjectDefine(ObjectType.CONSTRAINT, objectName, add.toString()));
            }
            return objectDefines;
        }
        catch (UnsupportedGrammarException e2) {
            return Lists.newArrayList((Object[])new ObjectDefine[]{new UnsupportedObjectDefine(ObjectType.CONSTRAINT, objectName, e2.getMessage())});
        }
    }
}

