/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.model.obmysql14x;

import com.oceanbase.obtools.common.collect.Lists;
import com.oceanbase.obtools.common.utils.StringUtils;
import com.oceanbase.obtools.dbdiff.compare.result.ChangeInfo;
import com.oceanbase.obtools.dbdiff.compare.result.CreateObjectDefine;
import com.oceanbase.obtools.dbdiff.compare.result.ObjectDefine;
import com.oceanbase.obtools.dbdiff.compare.result.UnsupportedObjectDefine;
import com.oceanbase.obtools.dbdiff.constants.ConvertCode;
import com.oceanbase.obtools.dbdiff.enums.DbType;
import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import com.oceanbase.obtools.dbdiff.exception.UnmatchedObjectTypeException;
import com.oceanbase.obtools.dbdiff.exception.UnsupportedGrammarException;
import com.oceanbase.obtools.dbdiff.model.AbstractIndex;
import com.oceanbase.obtools.dbdiff.model.base.KeyColumn;
import com.oceanbase.obtools.dbdiff.model.mysql.AbstractMySqlIndex;
import com.oceanbase.obtools.dbdiff.model.obmysql14x.ObMySql14xIndexPartition;
import com.oceanbase.obtools.dbdiff.model.obmysql14x.ObMySql14xSchema;
import com.oceanbase.obtools.dbdiff.utils.ChangeUtils;
import java.util.ArrayList;
import java.util.List;

public class ObMySql14xIndex
extends AbstractMySqlIndex {
    private String locality;
    private ObMySql14xIndexPartition indexPartition;
    private String defineType;

    public ObMySql14xIndex(ObMySql14xSchema schema) {
        super(schema);
    }

    private void preProcessMeta() throws UnsupportedGrammarException {
        String indexType = this.getIndexType();
        String dbType = this.getDbType().getType();
        if ("UNIQUE".equals(indexType)) {
            this.setDefineType("UNIQUE");
        } else if ("GLOBAL".equals(indexType)) {
            this.setLocality("GLOBAL");
        } else if ("LOCAL".equals(indexType)) {
            this.setLocality("LOCAL");
        } else if ("GLOBAL UNIQUE".equals(indexType)) {
            this.setLocality("GLOBAL");
            this.setDefineType("UNIQUE");
        } else if ("LOCAL UNIQUE".equals(indexType)) {
            this.setLocality("LOCAL");
            this.setDefineType("UNIQUE");
        } else if ("FULLTEXT".equals(indexType)) {
            if (DbType.OBMYSQL_2230.getType().equals(dbType) && !DbType.OBMYSQL_2230.isSubsequent(this.getDbType())) {
                ChangeUtils.warn(ObjectType.TABLE, this.getSchemaObjectName(), ChangeInfo.ChangeType.CONVERT, "The FULLTEXT index is disabled v2.2.40+ by default", "-- alter system set _ENABLE_FULLTEXT_INDEX=true;");
            }
            this.setDefineType("FULLTEXT");
        } else if ("SPATIAL".equals(indexType)) {
            if (DbType.OBMYSQL_324.getType().equals(dbType) && DbType.OBMYSQL_324.isSubsequent(this.getDbType())) {
                throw new UnsupportedGrammarException(ConvertCode.MysqlUnsupportedCode.SPATIAL_INDEX_NOT_SUPPORT, this.getSchemaObjectName(), "Spatial index is unsupported until OBMYSQL v3.2.4.0");
            }
            this.setDefineType("SPATIAL");
        }
        for (KeyColumn keyColumn : this.getIndexColumns()) {
            if (!this.getDbType().isPriorObMysql42() || !keyColumn.isExpression()) continue;
            throw new UnsupportedGrammarException(this.getSchemaObjectName(), "The Function-Based Index expression: \"" + keyColumn.getColumnName() + "\" is unsupported in " + this.getDbType());
        }
    }

    @Override
    public List<ObjectDefine> buildDefinition() throws UnsupportedGrammarException {
        String comment;
        ObMySql14xIndexPartition indexPartition;
        this.preProcessMeta();
        StringBuilder sb = new StringBuilder();
        sb.append("create");
        if (StringUtils.isNotBlank((CharSequence)this.getDefineType())) {
            sb.append(" ").append(this.getDefineType());
        }
        sb.append(" index if not exists ").append(this.wrapAndEscape(this.getIndexName()));
        sb.append(" on ").append(this.getSchemaObjectName()).append((CharSequence)this.joinIndexColumns());
        if (StringUtils.isNotBlank((CharSequence)this.getLocality())) {
            sb.append(" ").append(this.getLocality());
        }
        if ((indexPartition = this.getIndexPartition()) != null) {
            sb.append((CharSequence)indexPartition.buildGrammar());
        }
        if (StringUtils.isNotBlank((CharSequence)(comment = this.getComment()))) {
            sb.append(" COMMENT ").append("'" + comment.replace("'", "''") + "'");
        }
        if ("NO".equals(this.getVisible())) {
            sb.append(" invisible");
        }
        return Lists.newArrayList((Object[])new ObjectDefine[]{new CreateObjectDefine(ObjectType.INDEX, this.getIndexType(), this.getSimpleIndexName(), this.terminate(sb))});
    }

    @Override
    public StringBuilder buildGrammar() throws UnsupportedGrammarException {
        String comment;
        ObMySql14xIndexPartition indexPartition;
        this.preProcessMeta();
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)this.getDefineType())) {
            sb.append(this.getDefineType()).append(" ");
        }
        sb.append("INDEX").append(" ").append(this.getWrappedIndexName()).append(" ").append((CharSequence)this.joinIndexColumns());
        if (StringUtils.isNotBlank((CharSequence)this.getLocality())) {
            sb.append(" ").append(this.getLocality());
        }
        if ((indexPartition = this.getIndexPartition()) != null) {
            sb.append((CharSequence)indexPartition.buildGrammar());
        }
        if (StringUtils.isNotBlank((CharSequence)(comment = this.getComment()))) {
            sb.append(" COMMENT ").append("'" + comment.replace("'", "''") + "'");
        }
        if ("NO".equals(this.getVisible())) {
            sb.append(" invisible");
        }
        return sb;
    }

    public boolean isInnerDefineSupported() {
        ObMySql14xIndexPartition indexPartition = this.getIndexPartition();
        return indexPartition == null || "LOCAL".equalsIgnoreCase(indexPartition.getLocality()) || !this.getDbType().isPriorObMysql40();
    }

    @Override
    public List<ObjectDefine> compareTo(AbstractIndex other) {
        if (!(other instanceof ObMySql14xIndex)) {
            throw new UnmatchedObjectTypeException("Raw type is not matched");
        }
        ObMySql14xIndex target = (ObMySql14xIndex)other;
        String srcColumnString = this.joinIndexColumns().toString();
        String dstColumnString = target.joinIndexColumns().toString();
        try {
            if (StringUtils.notEquals((CharSequence)srcColumnString, (CharSequence)dstColumnString) || StringUtils.notEquals((CharSequence)this.getIndexType(), (CharSequence)target.getIndexType()) || StringUtils.notEquals((CharSequence)this.getLocality(), (CharSequence)target.getLocality())) {
                ArrayList objectDefines = Lists.newArrayList((Object[])new ObjectDefine[0]);
                objectDefines.add(this.buildDropDefinition());
                objectDefines.addAll(target.buildDefinition());
                return objectDefines;
            }
            return Lists.newArrayList((Object[])new ObjectDefine[0]);
        }
        catch (UnsupportedGrammarException e) {
            return Lists.newArrayList((Object[])new ObjectDefine[]{new UnsupportedObjectDefine(ObjectType.TABLE, this.getSimpleObjectName(), e.getMessage())});
        }
    }

    public String getLocality() {
        return this.locality;
    }

    public void setLocality(String locality) {
        this.locality = locality;
    }

    public ObMySql14xIndexPartition getIndexPartition() {
        return this.indexPartition;
    }

    public void setIndexPartition(ObMySql14xIndexPartition indexPartition) {
        this.indexPartition = indexPartition;
    }

    public String getDefineType() {
        return this.defineType;
    }

    public void setDefineType(String defineType) {
        this.defineType = defineType;
    }
}

