/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.model.obmysql14x;

import com.google.common.collect.Lists;
import com.oceanbase.obtools.common.utils.CollectionUtils;
import com.oceanbase.obtools.common.utils.StringUtils;
import com.oceanbase.obtools.dbdiff.compare.result.ChangeInfo;
import com.oceanbase.obtools.dbdiff.compare.result.CreateObjectDefine;
import com.oceanbase.obtools.dbdiff.compare.result.DropObjectDefine;
import com.oceanbase.obtools.dbdiff.compare.result.ObjectDefine;
import com.oceanbase.obtools.dbdiff.compare.result.UnsupportedObjectDefine;
import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import com.oceanbase.obtools.dbdiff.exception.UnmatchedObjectTypeException;
import com.oceanbase.obtools.dbdiff.exception.UnsupportedGrammarException;
import com.oceanbase.obtools.dbdiff.model.AbstractConstraint;
import com.oceanbase.obtools.dbdiff.model.base.KeyColumn;
import com.oceanbase.obtools.dbdiff.model.obmysql.AbstractObMySqlConstraint;
import com.oceanbase.obtools.dbdiff.model.obmysql14x.ObMySql14xSchema;
import com.oceanbase.obtools.dbdiff.utils.ChangeUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ObMySql14xPrimaryKey
extends AbstractObMySqlConstraint {
    public ObMySql14xPrimaryKey(ObMySql14xSchema schema) {
        super(schema);
    }

    @Override
    public StringBuilder buildGrammar() throws UnsupportedGrammarException {
        this.checkConstraintOnGeneratedColumns();
        StringBuilder sb = new StringBuilder();
        String constraintName = this.getConstraintName();
        if (StringUtils.isNotBlank((CharSequence)constraintName) && !"PRIMARY".equalsIgnoreCase(constraintName)) {
            sb.append("constraint ").append(this.wrapAndEscape(constraintName)).append(" ");
        }
        return sb.append("primary key").append((CharSequence)this.joinConstraintColumns());
    }

    @Override
    public StringBuilder joinConstraintColumns() {
        StringBuilder target = new StringBuilder();
        List<KeyColumn> cols = this.getConstraintColumns();
        if (CollectionUtils.isEmpty(cols)) {
            return target;
        }
        StringBuilder origin = new StringBuilder();
        Iterator iter = cols.iterator();
        while (iter.hasNext()) {
            KeyColumn col = (KeyColumn)iter.next();
            String wrapped = this.wrapAndCase(col.getColumnName(), "columnCase");
            origin.append(wrapped);
            target.append(wrapped);
            String subPart = col.getSubPart();
            if (StringUtils.isNotBlank((CharSequence)subPart)) {
                origin.append("(").append(subPart).append(")");
            }
            if (!iter.hasNext()) continue;
            origin.append(", ");
            target.append(", ");
        }
        if (StringUtils.notEquals((CharSequence)origin, (CharSequence)target)) {
            ChangeUtils.warn(ObjectType.TABLE, this.getSchemaObjectName(), ChangeInfo.ChangeType.CONVERT, "primary key(" + origin + ") -> primary key(" + target + ")");
        }
        return this.enclose(target);
    }

    @Override
    public List<ObjectDefine> compareTo(AbstractConstraint other) {
        if (!(other instanceof ObMySql14xPrimaryKey)) {
            throw new UnmatchedObjectTypeException("Raw type is not matched");
        }
        try {
            ArrayList<ObjectDefine> objectDefines = new ArrayList<ObjectDefine>();
            ObMySql14xPrimaryKey target = (ObMySql14xPrimaryKey)other;
            String srcColumnString = this.joinConstraintColumns().toString();
            String dstColumnString = target.joinConstraintColumns().toString();
            if (StringUtils.notEquals((CharSequence)srcColumnString, (CharSequence)dstColumnString)) {
                StringBuilder drop = new StringBuilder();
                drop.append("alter table ").append(this.getSchemaObjectName());
                drop.append(" drop primary key;");
                StringBuilder add = new StringBuilder();
                add.append("alter table ").append(this.getSchemaObjectName());
                add.append(" add ").append((CharSequence)this.buildGrammar()).append(";");
                objectDefines.add(new DropObjectDefine(ObjectType.CONSTRAINT, this.getSimpleObjectName(), drop.toString()));
                objectDefines.add(new CreateObjectDefine(ObjectType.CONSTRAINT, this.getSimpleObjectName(), add.toString()));
            }
            return objectDefines;
        }
        catch (UnsupportedGrammarException e) {
            return Lists.newArrayList((Object[])new ObjectDefine[]{new UnsupportedObjectDefine(ObjectType.CONSTRAINT, this.getSimpleObjectName(), e.getMessage())});
        }
    }
}

