/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.model.obmysql14x;

import com.google.common.collect.Lists;
import com.oceanbase.obtools.common.model.Pair;
import com.oceanbase.obtools.common.utils.CollectionUtils;
import com.oceanbase.obtools.common.utils.MapUtils;
import com.oceanbase.obtools.common.utils.NumberUtils;
import com.oceanbase.obtools.common.utils.StringUtils;
import com.oceanbase.obtools.dbdiff.compare.result.AlterObjectDefine;
import com.oceanbase.obtools.dbdiff.compare.result.ChangeInfo;
import com.oceanbase.obtools.dbdiff.compare.result.CreateObjectDefine;
import com.oceanbase.obtools.dbdiff.compare.result.DropObjectDefine;
import com.oceanbase.obtools.dbdiff.compare.result.ObjectDefine;
import com.oceanbase.obtools.dbdiff.compare.result.UnsupportedObjectDefine;
import com.oceanbase.obtools.dbdiff.compare.result.WrapperObjectDefine;
import com.oceanbase.obtools.dbdiff.constants.Constants;
import com.oceanbase.obtools.dbdiff.constants.ConvertCode;
import com.oceanbase.obtools.dbdiff.constants.JdbcType;
import com.oceanbase.obtools.dbdiff.enums.DbType;
import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import com.oceanbase.obtools.dbdiff.exception.UnmatchedObjectTypeException;
import com.oceanbase.obtools.dbdiff.exception.UnsupportedGrammarException;
import com.oceanbase.obtools.dbdiff.mapper.OrikaBeanMapper;
import com.oceanbase.obtools.dbdiff.model.AbstractOwnership;
import com.oceanbase.obtools.dbdiff.model.AbstractTable;
import com.oceanbase.obtools.dbdiff.model.base.KeyColumn;
import com.oceanbase.obtools.dbdiff.model.mysql.AbstractMySqlTable;
import com.oceanbase.obtools.dbdiff.model.mysql.AbstractMySqlTablePartition;
import com.oceanbase.obtools.dbdiff.model.obmysql14x.ObMySql14xColumn;
import com.oceanbase.obtools.dbdiff.model.obmysql14x.ObMySql14xForeignKey;
import com.oceanbase.obtools.dbdiff.model.obmysql14x.ObMySql14xIndex;
import com.oceanbase.obtools.dbdiff.model.obmysql14x.ObMySql14xPrimaryKey;
import com.oceanbase.obtools.dbdiff.model.obmysql14x.ObMySql14xSchema;
import com.oceanbase.obtools.dbdiff.model.obmysql14x.ObMySql14xTablePartition;
import com.oceanbase.obtools.dbdiff.model.obmysql14x.ObMySql14xUniqueKey;
import com.oceanbase.obtools.dbdiff.model.obmysql14x.ObMySql32xCheck;
import com.oceanbase.obtools.dbdiff.model.oboracle22x.ObOracle22xTable;
import com.oceanbase.obtools.dbdiff.model.oracle.AbstractOracleTablePartition;
import com.oceanbase.obtools.dbdiff.utils.ChangeUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;

public class ObMySql14xTable
extends AbstractMySqlTable {
    private final Map<String, ObMySql14xColumn> columnMapping = new LinkedHashMap<String, ObMySql14xColumn>();
    private final Map<String, ObMySql14xIndex> indexMapping = new LinkedHashMap<String, ObMySql14xIndex>();
    private final Map<String, ObMySql32xCheck> checkMapping = new LinkedHashMap<String, ObMySql32xCheck>();
    private final Map<String, ObMySql14xUniqueKey> uniqueMapping = new LinkedHashMap<String, ObMySql14xUniqueKey>();
    private final Map<String, ObMySql14xForeignKey> foreignMapping = new LinkedHashMap<String, ObMySql14xForeignKey>();
    private String visible;
    private String tableGroupName;
    private ObMySql14xPrimaryKey primaryKey;
    private ObMySql14xTablePartition tablePartition;

    public ObMySql14xTable(ObMySql14xSchema schema) {
        super(schema);
    }

    @Override
    public ObMySql14xTable beforeBuildDefinition() throws UnsupportedGrammarException {
        String originDbType = this.getOriginDbType().getType();
        ObMySql14xPrimaryKey primaryKey = this.getPrimaryKey();
        ObMySql14xTablePartition partition = this.getTablePartition();
        Map<String, ObMySql14xUniqueKey> uniqueMapping = this.getUniqueMapping();
        if (super.getGlobal().isOptimum() && primaryKey == null && !uniqueMapping.isEmpty()) {
            primaryKey = this.findAnUniqueAsPrimaryKey(uniqueMapping);
        }
        if (primaryKey != null && partition != null && this.isNonIncludePartitionColumns(primaryKey.getConstraintColumns())) {
            primaryKey = this.includePartitionColumns(partition, primaryKey);
        }
        this.setPrimaryKey(primaryKey);
        if (DbType.POLARX_10.getType().equalsIgnoreCase(originDbType)) {
            Map<String, ObMySql14xIndex> indexMapping = this.getIndexMapping();
            if (MapUtils.isNotEmpty(indexMapping)) {
                indexMapping.keySet().stream().filter(indexName -> indexName.startsWith("auto_shard_key_")).collect(Collectors.toList()).forEach(indexMapping::remove);
            }
            if (primaryKey != null) {
                for (KeyColumn keyColumn : primaryKey.getConstraintColumns()) {
                    String dataType;
                    ObMySql14xColumn column = this.getColumnMapping().get(keyColumn.getColumnName());
                    switch (dataType = column.getDataType().toUpperCase(Locale.getDefault())) {
                        case "INT": {
                            dataType = "BIGINT";
                            column.setDataType(dataType);
                            String columnType = column.getColumnType().toUpperCase(Locale.getDefault());
                            column.setColumnType(columnType.replace("INT", "BIGINT").toLowerCase(Locale.getDefault()));
                            break;
                        }
                    }
                }
            }
        }
        return this;
    }

    @Override
    public List<ObjectDefine> buildDefinition() throws UnsupportedGrammarException {
        Iterator<AbstractOwnership> expand;
        ObMySql14xTablePartition partition = this.getTablePartition();
        StringBuilder sb = new StringBuilder();
        String objectName = this.getDefinitionSchemaObjectName();
        sb.append("create table if not exists ").append(objectName).append(" (");
        Collection<ObMySql14xColumn> columns = this.getColumnMapping().values();
        Iterator<ObMySql14xColumn> iter = columns.iterator();
        while (iter.hasNext()) {
            BigDecimal autoIncrement;
            String charsetName;
            ObMySql14xColumn column = iter.next();
            String tableCollation = this.getTableCollation();
            if (tableCollation != null && tableCollation.equals(column.getCollationName())) {
                column.setCollationName(null);
            }
            if ((charsetName = this.getCharacterSetName()) != null && charsetName.equals(column.getCharacterSetName())) {
                column.setCharacterSetName(null);
            }
            if ((autoIncrement = column.getAutoIncrement()) != null) {
                super.setAutoIncrement(autoIncrement);
            }
            sb.append("\n\t").append((CharSequence)column.buildGrammar());
            if (!iter.hasNext()) continue;
            sb.append(",");
        }
        Map<String, List<String>> columnExpand = this.getGlobal().getColumnExpand();
        if (columnExpand.containsKey(this.getObjectName()) && CollectionUtils.isNotEmpty(expand = columnExpand.get(this.getObjectName()))) {
            sb.append(",");
            String expandStr = expand.stream().map(item -> "\n\t" + item).collect(Collectors.joining(","));
            sb.append(expandStr);
        }
        if (this.primaryKey != null) {
            this.primaryKey.setColumnMapping(this.columnMapping);
            sb.append(",\n\t").append((CharSequence)this.primaryKey.buildGrammar());
        }
        if (MapUtils.isNotEmpty(this.getCheckMapping())) {
            for (ObMySql32xCheck check : this.getCheckMapping().values()) {
                sb.append(",\n\t").append((CharSequence)check.buildGrammar());
            }
        }
        if (MapUtils.isNotEmpty(this.uniqueMapping)) {
            for (ObMySql14xUniqueKey unique : this.uniqueMapping.values()) {
                ObMySql14xIndex index = this.getIndexMapping().get(unique.getConstraintName());
                if (index != null) {
                    unique.setIndexType(index.getIndexType());
                }
                sb.append(",\n\t").append((CharSequence)unique.buildGrammar());
            }
        }
        MapUtils.removeNullValue(this.getIndexMapping());
        for (ObMySql14xIndex index : this.getIndexMapping().values()) {
            if (partition == null || !DbType.OBMYSQL_200.getType().equals(this.getDbType().getType()) || !this.getDbType().isPrior(DbType.OBMYSQL_200)) continue;
            index.setLocality("LOCAL");
        }
        boolean needInternal = this.getGlobal().isDefineIndexInternal();
        LinkedList<ObjectDefine> subDefines = new LinkedList<ObjectDefine>();
        for (ObMySql14xIndex index : this.getIndexMapping().values()) {
            if (needInternal && index.isInnerDefineSupported()) {
                sb.append(",\n\t").append((CharSequence)index.buildGrammar());
                continue;
            }
            subDefines.addAll(index.buildDefinition());
        }
        if (MapUtils.isNotEmpty(this.getForeignMapping())) {
            for (ObMySql14xForeignKey foreign : this.getForeignMapping().values()) {
                sb.append(",\n\t").append((CharSequence)foreign.buildGrammar());
            }
        }
        sb.append("\n").append(")");
        sb.append((CharSequence)this.appendTableOptions());
        if (partition != null) {
            sb.append((CharSequence)partition.buildGrammar());
        }
        CreateObjectDefine objectDefine = new CreateObjectDefine(ObjectType.TABLE, this.getSimpleObjectName(), this.terminate(sb), subDefines);
        objectDefine.getChangeInfos().addAll(ChangeUtils.findByKey(ObjectType.TABLE, this.getSchemaObjectName()));
        return Lists.newArrayList((Object[])new ObjectDefine[]{objectDefine});
    }

    @Override
    protected StringBuilder appendTableOptions() throws UnsupportedGrammarException {
        this.forceConvertCharset();
        String originCharset = super.getCharacterSetName();
        String originCollation = super.getTableCollation();
        if ("utf8".equalsIgnoreCase(originCharset)) {
            super.setCharacterSetName("utf8mb4");
            ChangeUtils.warn(ObjectType.TABLE, this.getSchemaObjectName(), ChangeInfo.ChangeType.CONVERT, "The table charset: " + originCharset + " -> " + "utf8mb4");
        }
        if (StringUtils.startsWithIgnoreCase((String)originCollation, (String)"utf8")) {
            String targetCollation = originCollation.replace("utf8_", "utf8mb4_");
            if (StringUtils.startsWithIgnoreCase((String)originCollation, (String)"utf8mb4_") && StringUtils.endsWithIgnoreCase((CharSequence)originCollation, (CharSequence)"_ai_ci")) {
                targetCollation = "utf8mb4_general_ci";
            }
            super.setTableCollation(targetCollation);
            if (StringUtils.notEqualsIgnoreCase((CharSequence)originCollation, (CharSequence)targetCollation)) {
                ChangeUtils.warn(ObjectType.TABLE, this.getSchemaObjectName(), ChangeInfo.ChangeType.CONVERT, "The table collation: " + originCollation + " -> " + super.getTableCollation());
            }
        }
        String charsetName = super.getCharacterSetName();
        String tableCollation = super.getTableCollation();
        Pair<Set<String>, Set<String>> supportCharsets = this.getSupportCharsets();
        Set charsets = (Set)supportCharsets.getKey();
        Set collations = (Set)supportCharsets.getValue();
        if (charsetName != null && !charsets.contains(charsetName)) {
            throw new UnsupportedGrammarException(ConvertCode.MysqlUnsupportedCode.TABLE_CHARSET_NOT_SUPPORT, this.getSchemaObjectName(), "The table charset: \"" + originCharset + "\" is unsupported in " + this.getDbType());
        }
        if (tableCollation != null && !collations.contains(tableCollation)) {
            throw new UnsupportedGrammarException(ConvertCode.MysqlUnsupportedCode.TABLE_COLLATION_NOT_SUPPORT, this.getSchemaObjectName(), "The table collation: \"" + originCollation + "\" is unsupported in " + this.getDbType());
        }
        if (StringUtils.isNotBlank((CharSequence)super.getCharacterSetName()) && StringUtils.isNotBlank((CharSequence)super.getTableCollation()) && !this.checkCharsetAndCollation()) {
            throw new UnsupportedGrammarException(ConvertCode.MysqlUnsupportedCode.TABLE_CHARSET_COLLATION_COMBINATION_NOT_VALID, this.getSchemaObjectName(), "The table collation: \"" + super.getTableCollation() + "\" is not valid for the character set: \"" + super.getCharacterSetName() + "\"");
        }
        StringBuilder sb = new StringBuilder();
        String tableGroupName = this.getTableGroupName();
        if (StringUtils.isNotBlank((CharSequence)tableGroupName)) {
            sb.append("\n").append("tablegroup=").append(this.wrapAndEscape(tableGroupName));
        }
        return sb.append((CharSequence)super.appendTableOptions());
    }

    protected void forceConvertCharset() {
        String originCharset = super.getCharacterSetName();
        String originCollation = super.getTableCollation();
        Pair<Set<String>, Set<String>> supportCharsets = this.getSupportCharsets();
        Set charsets = (Set)supportCharsets.getKey();
        Set collations = (Set)supportCharsets.getValue();
        if (originCharset != null && charsets.contains(originCharset) && originCollation != null && collations.contains(originCollation)) {
            return;
        }
        Map<String, String> charsetMapping = this.getGlobal().getCharsetMapping();
        if (originCharset != null && MapUtils.isNotEmpty(charsetMapping)) {
            for (Map.Entry<String, String> entry : charsetMapping.entrySet()) {
                if (!FilenameUtils.wildcardMatch((String)originCharset, (String)entry.getKey()) || !StringUtils.isNotBlank((CharSequence)entry.getValue())) continue;
                super.setCharacterSetName(entry.getValue());
                break;
            }
            if (!originCharset.equalsIgnoreCase(super.getCharacterSetName())) {
                ChangeUtils.warn(ObjectType.TABLE, this.getSchemaObjectName(), ChangeInfo.ChangeType.CONVERT, "The table charset: " + originCharset + " -> " + super.getCharacterSetName());
            }
        }
        Map<String, String> collationMapping = this.getGlobal().getCollationMapping();
        if (originCollation != null && MapUtils.isNotEmpty(collationMapping)) {
            for (Map.Entry<String, String> entry : collationMapping.entrySet()) {
                if (!FilenameUtils.wildcardMatch((String)originCollation, (String)entry.getKey()) || !StringUtils.isNotBlank((CharSequence)entry.getValue())) continue;
                super.setTableCollation(entry.getValue());
                break;
            }
            if (!originCollation.equalsIgnoreCase(super.getTableCollation())) {
                ChangeUtils.warn(ObjectType.TABLE, this.getSchemaObjectName(), ChangeInfo.ChangeType.CONVERT, "The table collation: " + originCollation + " -> " + super.getTableCollation());
            }
        }
    }

    private ObMySql14xPrimaryKey findAnUniqueAsPrimaryKey(Map<String, ObMySql14xUniqueKey> uniqueMapping) {
        Collection<String> numericTypes = JdbcType.numerics();
        Collection<String> stringTypes = JdbcType.strings();
        Collection<String> datetimeTypes = JdbcType.datetimes();
        TreeMap<Integer, List> multimap = new TreeMap<Integer, List>();
        block0: for (ObMySql14xUniqueKey uniqueKey : uniqueMapping.values()) {
            List<KeyColumn> keyColumns = uniqueKey.getConstraintColumns();
            Integer totalScore = keyColumns.size();
            for (KeyColumn keyColumn : keyColumns) {
                String columnName = keyColumn.getColumnName();
                ObMySql14xColumn tableColumn = this.getColumnMapping().get(columnName);
                if (tableColumn == null) {
                    throw new IllegalStateException("The unique column: " + this.wrap(columnName) + " is not exists in the table column mapping. Object: " + this.getSchemaObjectName());
                }
                String nullable = tableColumn.getNullable();
                if ("Y".equals(nullable) || "YES".equals(nullable)) continue block0;
                String dataType = tableColumn.getDataType();
                if (numericTypes.contains(dataType)) {
                    totalScore = totalScore + 1;
                    continue;
                }
                if (stringTypes.contains(dataType)) {
                    totalScore = totalScore + 2;
                    continue;
                }
                if (datetimeTypes.contains(dataType)) {
                    totalScore = totalScore + 3;
                    continue;
                }
                totalScore = totalScore + 4;
            }
            List uniqueKeys = multimap.getOrDefault(totalScore, Lists.newArrayList());
            uniqueKeys.add(uniqueKey);
            multimap.putIfAbsent(totalScore, uniqueKeys);
        }
        if (multimap.isEmpty() || ((List)multimap.firstEntry().getValue()).isEmpty()) {
            return null;
        }
        ObMySql14xUniqueKey bestUnique = (ObMySql14xUniqueKey)((List)multimap.firstEntry().getValue()).get(0);
        String bestUniqueName = bestUnique.getConstraintName();
        this.getUniqueMapping().remove(bestUniqueName);
        OrikaBeanMapper beanMapper = new OrikaBeanMapper.Builder().build();
        ObMySql14xPrimaryKey primaryKey = beanMapper.map(bestUnique, ObMySql14xPrimaryKey.class);
        String newPrimaryKeyName = this.getObjectName() + "_PK";
        primaryKey.setConstraintName(newPrimaryKeyName);
        StringBuilder constraintJoiner = bestUnique.joinConstraintColumns();
        ChangeUtils.info(ObjectType.TABLE, this.getSchemaObjectName(), ChangeInfo.ChangeType.CONVERT, "CONSTRAINT " + this.wrap(bestUniqueName) + " UNIQUE" + constraintJoiner + " -> CONSTRAINT " + this.wrap(newPrimaryKeyName) + " PRIMARY KEY" + constraintJoiner);
        return primaryKey;
    }

    private boolean isNonIncludePartitionColumns(List<KeyColumn> columns) {
        Collection<AbstractOracleTablePartition.OracleTablePartitionColumn> subPartitionColumns;
        Collection<AbstractOracleTablePartition.OracleTablePartitionColumn> partitionColumns;
        boolean isIncludePartitionColumns = true;
        ObMySql14xTablePartition partition = this.getTablePartition();
        if (CollectionUtils.isEmpty(partition.getColumnSet())) {
            partition.setColumnSet(this.getColumnMapping().keySet());
        }
        if (CollectionUtils.isNotEmpty(partitionColumns = partition.parsePartitionColumns(partition.getPartitionExpression()))) {
            List partitionColumnNames = partitionColumns.stream().map(AbstractOracleTablePartition.OracleTablePartitionColumn::getColumnName).collect(Collectors.toList());
            isIncludePartitionColumns = columns.stream().map(KeyColumn::getColumnName).collect(Collectors.toList()).removeAll(partitionColumnNames);
        }
        if (CollectionUtils.isNotEmpty(subPartitionColumns = partition.parsePartitionColumns(partition.getSubPartitionExpression()))) {
            List subPartitionColumnNames = subPartitionColumns.stream().map(AbstractOracleTablePartition.OracleTablePartitionColumn::getColumnName).collect(Collectors.toList());
            isIncludePartitionColumns &= columns.stream().map(KeyColumn::getColumnName).collect(Collectors.toList()).removeAll(subPartitionColumnNames);
        }
        return !isIncludePartitionColumns;
    }

    private ObMySql14xPrimaryKey includePartitionColumns(ObMySql14xTablePartition partition, ObMySql14xPrimaryKey primaryKey) throws UnsupportedGrammarException {
        List<String> keyColumnNames = primaryKey.getConstraintColumns().stream().map(KeyColumn::getColumnName).collect(Collectors.toList());
        String dbType = this.getDbType().getType();
        if (DbType.OBMYSQL_2250.getType().equals(dbType) && DbType.OBMYSQL_2250.isPriorFrom(this.getDbType())) {
            for (String keyColumnName : keyColumnNames) {
                ObMySql14xColumn column = this.getColumnMapping().get(keyColumnName);
                if (column == null) {
                    throw new IllegalStateException("The key column: " + this.wrap(keyColumnName) + " is not exists in the table column mapping. Object: " + this.getSchemaObjectName());
                }
                column.setNullable("NO");
            }
            OrikaBeanMapper beanMapper = new OrikaBeanMapper.Builder().build();
            ObMySql14xUniqueKey unique = beanMapper.map(primaryKey, ObMySql14xUniqueKey.class);
            unique.setConstraintName("GEN_" + unique.getConstraintName());
            unique.setIndexType("GLOBAL UNIQUE");
            this.getUniqueMapping().put(unique.getConstraintName(), unique);
            StringBuilder constraintJoiner = unique.joinConstraintColumns();
            ChangeUtils.info(ObjectType.TABLE, this.getSchemaObjectName(), ChangeInfo.ChangeType.CONVERT, "CONSTRAINT " + this.wrap(primaryKey.getConstraintName()) + " PRIMARY KEY" + constraintJoiner + " -> CONSTRAINT " + this.wrap(unique.getConstraintName()) + " UNIQUE " + constraintJoiner + " GLOBAL");
            return null;
        }
        String beforeColumns = keyColumnNames.stream().map(e -> this.wrap((String)e)).collect(Collectors.joining(","));
        if (CollectionUtils.isEmpty(partition.getColumnSet())) {
            partition.setColumnSet(this.getColumnMapping().keySet());
        }
        String partitionExpr = partition.getPartitionExpression();
        Collection<AbstractOracleTablePartition.OracleTablePartitionColumn> partitionColumns = partition.parsePartitionColumns(partitionExpr);
        boolean appendPartitionColumns = this.appendToPrimaryColumns(primaryKey, keyColumnNames, partitionColumns);
        String subPartitionExpr = partition.getSubPartitionExpression();
        Collection<AbstractOracleTablePartition.OracleTablePartitionColumn> subPartitionColumns = partition.parsePartitionColumns(subPartitionExpr);
        boolean appendSubPartitionColumns = this.appendToPrimaryColumns(primaryKey, keyColumnNames, subPartitionColumns);
        String afterColumns = keyColumnNames.stream().map(e -> this.wrap((String)e)).collect(Collectors.joining(","));
        if (appendPartitionColumns || appendSubPartitionColumns) {
            String schemaObjectName = this.getSchemaObjectName();
            StringBuilder enclosedString = this.enclose(beforeColumns);
            ChangeUtils.warn(ObjectType.TABLE, schemaObjectName, ChangeInfo.ChangeType.CONVERT, "PRIMARY KEY" + enclosedString + " -> PRIMARY KEY" + this.enclose(afterColumns), "-- CREATE UNIQUE INDEX \"GEN_" + this.getObjectName() + "_IDX\" ON " + schemaObjectName + enclosedString + " GLOBAL PARTITION BY HASH" + enclosedString + " PARTITIONES n");
        }
        return primaryKey;
    }

    private boolean appendToPrimaryColumns(ObMySql14xPrimaryKey primaryKey, List<String> keyColumnNames, Collection<AbstractOracleTablePartition.OracleTablePartitionColumn> partitionColumns) {
        boolean flag = false;
        if (CollectionUtils.isEmpty(partitionColumns)) {
            return flag;
        }
        for (AbstractOracleTablePartition.OracleTablePartitionColumn column : partitionColumns) {
            String partColumnName = column.getColumnName();
            ObMySql14xColumn tableColumn = this.getColumnMapping().get(partColumnName);
            if (tableColumn == null) {
                throw new IllegalStateException("The (sub)partition column: " + this.wrap(partColumnName) + " is not exists in the table column mapping. Object: " + this.getSchemaObjectName());
            }
            if (StringUtils.isNotBlank((CharSequence)tableColumn.getGenerationExpression())) {
                Set<String> columnSet = this.getColumnMapping().keySet();
                String columnDefault = tableColumn.getColumnDefault();
                Collection<String> physicalColumnNames = ObOracle22xTable.parseGenerateExpr(columnDefault, columnSet);
                for (String physicalColumnName : physicalColumnNames) {
                    if (keyColumnNames.contains(physicalColumnName)) continue;
                    flag = true;
                    keyColumnNames.add(physicalColumnName);
                    primaryKey.getConstraintColumns().add(new KeyColumn(physicalColumnName, keyColumnNames.size()));
                }
                continue;
            }
            if (keyColumnNames.contains(partColumnName)) continue;
            flag = true;
            keyColumnNames.add(partColumnName);
            primaryKey.getConstraintColumns().add(new KeyColumn(partColumnName, keyColumnNames.size()));
        }
        return flag;
    }

    @Override
    public List<ObjectDefine> compareTo(AbstractTable other) {
        if (!(other instanceof ObMySql14xTable)) {
            throw new UnmatchedObjectTypeException("Raw type is not matched");
        }
        ObMySql14xTable target = (ObMySql14xTable)other;
        ArrayList<ObjectDefine> objectDefines = new ArrayList<ObjectDefine>();
        CollectionUtils.addAllIgnoreNull(objectDefines, this.compareColumnMapping(target));
        CollectionUtils.addAllIgnoreNull(objectDefines, this.comparePrimaryKey(target));
        CollectionUtils.addAllIgnoreNull(objectDefines, this.compareUniqueMapping(target));
        CollectionUtils.addAllIgnoreNull(objectDefines, this.compareIndexMapping(target));
        CollectionUtils.addAllIgnoreNull(objectDefines, this.compareForeignMapping(target));
        CollectionUtils.addAllIgnoreNull(objectDefines, this.compareTablePartition(target));
        CollectionUtils.addAllIgnoreNull(objectDefines, this.compareTableOption(target));
        return Lists.newArrayList((Object[])new ObjectDefine[]{new WrapperObjectDefine(ObjectType.TABLE, this.getSimpleObjectName(), objectDefines)});
    }

    private List<ObjectDefine> compareColumnMapping(ObMySql14xTable target) {
        ArrayList<ObjectDefine> objectDefines = new ArrayList<ObjectDefine>();
        Map<String, ObMySql14xColumn> srcColumnMap = this.getColumnMapping();
        Map<String, ObMySql14xColumn> dstColumnMap = target.getColumnMapping();
        if (MapUtils.isNotEmpty(srcColumnMap)) {
            for (Map.Entry<String, ObMySql14xColumn> entry : srcColumnMap.entrySet()) {
                ObMySql14xColumn dstColumn = dstColumnMap.get(entry.getKey());
                if (dstColumn == null) {
                    objectDefines.add(entry.getValue().buildAddDefinition());
                    continue;
                }
                CollectionUtils.addAllIgnoreNull(objectDefines, entry.getValue().compareTo(dstColumn));
            }
        }
        if (MapUtils.isNotEmpty(dstColumnMap)) {
            for (Map.Entry<String, ObMySql14xColumn> entry : dstColumnMap.entrySet()) {
                ObMySql14xColumn srcColumn = srcColumnMap.get(entry.getKey());
                if (srcColumn != null) continue;
                objectDefines.add(entry.getValue().buildDropDefinition());
            }
        }
        return objectDefines;
    }

    private List<ObjectDefine> comparePrimaryKey(ObMySql14xTable target) {
        ArrayList<ObjectDefine> objectDefines = new ArrayList<ObjectDefine>();
        ObMySql14xPrimaryKey srcPrimaryKey = this.getPrimaryKey();
        ObMySql14xPrimaryKey dstPrimaryKey = target.getPrimaryKey();
        if (srcPrimaryKey != null && dstPrimaryKey == null) {
            objectDefines.add(srcPrimaryKey.buildAddDefinition());
        }
        if (srcPrimaryKey == null && dstPrimaryKey != null) {
            objectDefines.add(dstPrimaryKey.buildDropDefinition());
        }
        if (srcPrimaryKey != null && dstPrimaryKey != null) {
            CollectionUtils.addAllIgnoreNull(objectDefines, srcPrimaryKey.compareTo(dstPrimaryKey));
        }
        return objectDefines;
    }

    private List<ObjectDefine> compareUniqueMapping(ObMySql14xTable target) {
        ArrayList<ObjectDefine> objectDefines = new ArrayList<ObjectDefine>();
        HashMap<String, ObMySql14xUniqueKey> srcUniqueColMap = new HashMap<String, ObMySql14xUniqueKey>();
        Map<String, ObMySql14xUniqueKey> srcUniqueMap = this.getUniqueMapping();
        for (Map.Entry<String, ObMySql14xUniqueKey> entry : srcUniqueMap.entrySet()) {
            srcUniqueColMap.put(entry.getValue().joinConstraintColumns().toString(), entry.getValue());
        }
        HashMap<String, ObMySql14xUniqueKey> dstUniqueColMap = new HashMap<String, ObMySql14xUniqueKey>();
        Map<String, ObMySql14xUniqueKey> dstUniqueMap = target.getUniqueMapping();
        for (Map.Entry<String, ObMySql14xUniqueKey> entry : dstUniqueMap.entrySet()) {
            dstUniqueColMap.put(entry.getValue().joinConstraintColumns().toString(), entry.getValue());
        }
        if (MapUtils.isNotEmpty(srcUniqueMap)) {
            for (Map.Entry<String, ObMySql14xUniqueKey> entry : srcUniqueMap.entrySet()) {
                ObMySql14xUniqueKey dstUnique = dstUniqueMap.get(entry.getKey());
                if (dstUnique == null) {
                    dstUnique = (ObMySql14xUniqueKey)dstUniqueColMap.get(entry.getValue().joinConstraintColumns().toString());
                    if (dstUnique == null) {
                        objectDefines.add(entry.getValue().buildAddDefinition());
                        continue;
                    }
                    objectDefines.add(dstUnique.buildRenameDefinition(entry.getKey(), target.getSchemaName()));
                    continue;
                }
                CollectionUtils.addAllIgnoreNull(objectDefines, entry.getValue().compareTo(dstUnique));
            }
        }
        if (MapUtils.isNotEmpty(dstUniqueMap)) {
            for (Map.Entry<String, ObMySql14xUniqueKey> entry : dstUniqueMap.entrySet()) {
                ObMySql14xUniqueKey srcUnique = srcUniqueMap.get(entry.getKey());
                if (srcUnique != null || (srcUnique = (ObMySql14xUniqueKey)srcUniqueColMap.get(entry.getValue().joinConstraintColumns().toString())) != null) continue;
                objectDefines.add(entry.getValue().buildDropDefinition());
            }
        }
        return objectDefines;
    }

    private List<ObjectDefine> compareForeignMapping(ObMySql14xTable target) {
        HashMap<String, ObMySql14xForeignKey> srcFkColMap = new HashMap<String, ObMySql14xForeignKey>();
        Map<String, ObMySql14xForeignKey> srcForeignMap = this.getForeignMapping();
        for (Map.Entry<String, ObMySql14xForeignKey> entry : srcForeignMap.entrySet()) {
            srcFkColMap.put(entry.getValue().buildUniqueReference(), entry.getValue());
        }
        HashMap<String, ObMySql14xForeignKey> dstFkColMap = new HashMap<String, ObMySql14xForeignKey>();
        Map<String, ObMySql14xForeignKey> dstForeignMap = target.getForeignMapping();
        for (Map.Entry<String, ObMySql14xForeignKey> entry : dstForeignMap.entrySet()) {
            dstFkColMap.put(entry.getValue().buildUniqueReference(), entry.getValue());
        }
        ArrayList<ObjectDefine> objectDefines = new ArrayList<ObjectDefine>();
        if (MapUtils.isNotEmpty(srcForeignMap)) {
            for (Map.Entry<String, ObMySql14xForeignKey> entry : srcForeignMap.entrySet()) {
                ObMySql14xForeignKey dstRef = dstForeignMap.get(entry.getKey());
                if (dstRef == null) {
                    dstRef = (ObMySql14xForeignKey)dstFkColMap.get(entry.getValue().buildUniqueReference());
                    if (dstRef == null) {
                        objectDefines.add(entry.getValue().buildAddDefinition());
                        continue;
                    }
                    objectDefines.add(dstRef.buildRenameDefinition(entry.getKey(), target.getSchemaName()));
                    continue;
                }
                CollectionUtils.addAllIgnoreNull(objectDefines, entry.getValue().compareTo(dstRef));
            }
        }
        if (MapUtils.isNotEmpty(dstForeignMap)) {
            for (Map.Entry<String, ObMySql14xForeignKey> entry : dstForeignMap.entrySet()) {
                ObMySql14xForeignKey srcRef = srcForeignMap.get(entry.getKey());
                if (srcRef != null || (srcRef = (ObMySql14xForeignKey)srcFkColMap.get(entry.getValue().buildUniqueReference())) != null) continue;
                objectDefines.add(entry.getValue().buildDropDefinition());
            }
        }
        return objectDefines;
    }

    private List<ObjectDefine> compareIndexMapping(ObMySql14xTable target) {
        HashMap<String, ObMySql14xIndex> srcIdxColMap = new HashMap<String, ObMySql14xIndex>();
        Map<String, ObMySql14xIndex> srcIndexMap = this.getIndexMapping();
        for (Map.Entry<String, ObMySql14xIndex> entry : srcIndexMap.entrySet()) {
            srcIdxColMap.put(entry.getValue().joinIndexColumns().toString(), entry.getValue());
        }
        HashMap<String, ObMySql14xIndex> dstIdxColMap = new HashMap<String, ObMySql14xIndex>();
        Map<String, ObMySql14xIndex> dstIndexMap = target.getIndexMapping();
        for (Map.Entry<String, ObMySql14xIndex> entry : dstIndexMap.entrySet()) {
            dstIdxColMap.put(entry.getValue().joinIndexColumns().toString(), entry.getValue());
        }
        ArrayList<ObjectDefine> objectDefines = new ArrayList<ObjectDefine>();
        if (MapUtils.isNotEmpty(srcIndexMap)) {
            String objectName = this.getSimpleObjectName();
            for (Map.Entry<String, ObMySql14xIndex> entry : srcIndexMap.entrySet()) {
                ObMySql14xIndex dstIndex = dstIndexMap.get(entry.getKey());
                if (dstIndex == null) {
                    dstIndex = (ObMySql14xIndex)dstIdxColMap.get(entry.getValue().joinIndexColumns().toString());
                    if (dstIndex == null) {
                        try {
                            ObMySql14xIndex srcIdx = entry.getValue();
                            objectDefines.addAll(srcIdx.buildDefinition());
                        }
                        catch (UnsupportedGrammarException e) {
                            objectDefines.add(new UnsupportedObjectDefine(ObjectType.INDEX, objectName, e.getMessage()));
                        }
                        continue;
                    }
                    objectDefines.add(dstIndex.buildRenameDefinition(entry.getKey()));
                    continue;
                }
                CollectionUtils.addAllIgnoreNull(objectDefines, entry.getValue().compareTo(dstIndex));
            }
        }
        if (MapUtils.isNotEmpty(dstIndexMap)) {
            for (Map.Entry<String, ObMySql14xIndex> entry : dstIndexMap.entrySet()) {
                ObMySql14xIndex srcIndex = srcIndexMap.get(entry.getKey());
                if (srcIndex != null || (srcIndex = (ObMySql14xIndex)srcIdxColMap.get(entry.getValue().joinIndexColumns().toString())) != null) continue;
                objectDefines.add(entry.getValue().buildDropDefinition());
            }
        }
        return objectDefines;
    }

    private List<ObjectDefine> compareTablePartition(ObMySql14xTable target) {
        StringBuilder sb;
        ArrayList<ObjectDefine> objectDefines = new ArrayList<ObjectDefine>();
        ObMySql14xTablePartition srcTablePartition = this.getTablePartition();
        ObMySql14xTablePartition dstTablePartition = target.getTablePartition();
        if (srcTablePartition == null && dstTablePartition != null) {
            sb = new StringBuilder();
            sb.append("ALTER TABLE ").append(target.getSchemaObjectName()).append(" REMOVE PARTITIONING");
            objectDefines.add(new DropObjectDefine(ObjectType.TABLE, this.getSimpleObjectName(), this.terminate(sb)));
        }
        if (srcTablePartition != null) {
            try {
                if (dstTablePartition == null || !this.compareTablePartitionDefinition(srcTablePartition, dstTablePartition)) {
                    sb = new StringBuilder();
                    sb.append("ALTER TABLE ").append(target.getSchemaObjectName()).append((CharSequence)srcTablePartition.buildGrammar());
                    objectDefines.add(new AlterObjectDefine(ObjectType.TABLE, this.getSimpleObjectName(), this.terminate(sb)));
                }
            }
            catch (UnsupportedGrammarException e) {
                return Lists.newArrayList((Object[])new ObjectDefine[]{new UnsupportedObjectDefine(ObjectType.TABLE, this.getSimpleObjectName(), e.getMessage())});
            }
        }
        return objectDefines;
    }

    private boolean compareTablePartitionDefinition(ObMySql14xTablePartition source, ObMySql14xTablePartition target) {
        String srcPartitionType = source.getPartitionMethod();
        String dstPartitionType = target.getPartitionMethod();
        String srcSubPartitionType = source.getSubPartitionMethod();
        String dstSubPartitionType = target.getSubPartitionMethod();
        String srcColumnString = source.joinPartColumns().toString();
        String dstColumnString = target.joinPartColumns().toString();
        String srcSubColumnString = null;
        if (CollectionUtils.isNotEmpty(source.getTableSubPartitionColumns())) {
            srcSubColumnString = source.joinSubPartColumns().toString();
        }
        String dstSubColumnString = null;
        if (CollectionUtils.isNotEmpty(target.getTableSubPartitionColumns())) {
            dstSubColumnString = target.joinSubPartColumns().toString();
        }
        boolean isHashPart = "HASH".equals(srcPartitionType);
        int srcPartNum = source.getPartNum();
        int dstPartNum = target.getPartNum();
        if (StringUtils.notEquals((CharSequence)srcPartitionType, (CharSequence)dstPartitionType) && StringUtils.notEquals((CharSequence)srcColumnString, (CharSequence)dstColumnString) || StringUtils.notEquals((CharSequence)srcSubPartitionType, (CharSequence)dstSubPartitionType) && StringUtils.notEquals((CharSequence)srcSubColumnString, (CharSequence)dstSubColumnString) || isHashPart && NumberUtils.notEquals((Number)srcPartNum, (Number)dstPartNum)) {
            return false;
        }
        ArrayList<String> srcPartNameList = new ArrayList<String>();
        ArrayList<String> srcPartDescList = new ArrayList<String>();
        for (AbstractMySqlTablePartition.MySqlPartitionItem item : source.getTablePartitions()) {
            srcPartNameList.add(item.getPartitionName());
            srcPartDescList.add(item.getPartitionDescription());
        }
        ArrayList<String> dstPartNameList = new ArrayList<String>();
        ArrayList<String> dstPartDescList = new ArrayList<String>();
        for (AbstractMySqlTablePartition.MySqlPartitionItem item : target.getTablePartitions()) {
            dstPartNameList.add(item.getPartitionName());
            dstPartDescList.add(item.getPartitionDescription());
        }
        return srcPartNameList.equals(dstPartNameList) && srcPartDescList.equals(dstPartDescList);
    }

    private List<ObjectDefine> compareTableOption(ObMySql14xTable target) {
        ArrayList<ObjectDefine> objectDefines = new ArrayList<ObjectDefine>();
        if (StringUtils.notEquals((CharSequence)this.getTableComment(), (CharSequence)target.getTableComment())) {
            StringBuilder sb = new StringBuilder();
            sb.append("ALTER TABLE ").append(target.getSchemaObjectName());
            sb.append(" COMMENT= '").append(this.getTableComment()).append("'").append(";");
            objectDefines.add(new AlterObjectDefine(ObjectType.TABLE, this.getSimpleObjectName(), sb.toString()));
        }
        return objectDefines;
    }

    private Pair<Set<String>, Set<String>> getSupportCharsets() {
        Set<String> collations;
        Set<String> charsets;
        if (DbType.OBMYSQL_420.getType().equals(this.getDbType().getType()) && DbType.OBMYSQL_420.isPriorFrom(this.getDbType())) {
            charsets = Constants.SUB_V4200_SUPPORTED_CHARSETS;
            collations = Constants.SUB_V4200_SUPPORTED_COLLATIONS;
        } else if (DbType.OBMYSQL_410.getType().equals(this.getDbType().getType()) && DbType.OBMYSQL_410.isPriorFrom(this.getDbType())) {
            charsets = Constants.SUB_V4100_SUPPORTED_CHARSETS;
            collations = Constants.SUB_V4100_SUPPORTED_COLLATIONS;
        } else if (DbType.OBMYSQL_2230.getType().equals(this.getDbType().getType()) && DbType.OBMYSQL_2230.isPriorFrom(this.getDbType())) {
            charsets = Constants.SUB_V2230_SUPPORTED_CHARSETS;
            collations = Constants.SUB_V2230_SUPPORTED_COLLATIONS;
        } else if (this.getDbType().isObMysqlCEType() && DbType.OBMYSQL_CE_42.isPriorFrom(this.getDbType())) {
            charsets = Constants.SUB_V4200_SUPPORTED_CHARSETS;
            collations = Constants.SUB_CEV4200_SUPPORTED_COLLATIONS;
        } else if (this.getDbType().isObMysqlCEType() && DbType.OBMYSQL_CE_41.isPriorFrom(this.getDbType())) {
            charsets = Constants.SUB_V4100_SUPPORTED_CHARSETS;
            collations = Constants.SUB_CEV4100_SUPPORTED_COLLATIONS;
        } else if (this.getDbType().isObMysqlCEType() && DbType.OBMYSQL_CE_40.isPriorFrom(this.getDbType())) {
            charsets = Constants.SUB_V2230_SUPPORTED_CHARSETS;
            collations = Constants.SUB_CEV4000_SUPPORTED_COLLATIONS;
        } else {
            charsets = Constants.PRI_V2230_SUPPORTED_CHARSETS;
            collations = Constants.PRI_V2230_SUPPORTED_COLLATIONS;
        }
        return new Pair(charsets, collations);
    }

    public Map<String, ObMySql14xColumn> getColumnMapping() {
        return this.columnMapping;
    }

    public Map<String, ObMySql14xIndex> getIndexMapping() {
        return this.indexMapping;
    }

    public Map<String, ObMySql32xCheck> getCheckMapping() {
        return this.checkMapping;
    }

    public Map<String, ObMySql14xUniqueKey> getUniqueMapping() {
        return this.uniqueMapping;
    }

    public Map<String, ObMySql14xForeignKey> getForeignMapping() {
        return this.foreignMapping;
    }

    public String getVisible() {
        return this.visible;
    }

    public void setVisible(String visible) {
        this.visible = visible;
    }

    public String getTableGroupName() {
        return this.tableGroupName;
    }

    public void setTableGroupName(String tableGroupName) {
        this.tableGroupName = tableGroupName;
    }

    public ObMySql14xPrimaryKey getPrimaryKey() {
        return this.primaryKey;
    }

    public void setPrimaryKey(ObMySql14xPrimaryKey primaryKey) {
        this.primaryKey = primaryKey;
    }

    public ObMySql14xTablePartition getTablePartition() {
        return this.tablePartition;
    }

    public void setTablePartition(ObMySql14xTablePartition tablePartition) {
        this.tablePartition = tablePartition;
    }
}

