/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.model.obmysql14x;

import com.oceanbase.obtools.common.collect.Lists;
import com.oceanbase.obtools.dbdiff.compare.result.CreateObjectDefine;
import com.oceanbase.obtools.dbdiff.compare.result.DropObjectDefine;
import com.oceanbase.obtools.dbdiff.compare.result.ObjectDefine;
import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import com.oceanbase.obtools.dbdiff.exception.UnmatchedObjectTypeException;
import com.oceanbase.obtools.dbdiff.exception.UnsupportedGrammarException;
import com.oceanbase.obtools.dbdiff.model.AbstractTableGroup;
import com.oceanbase.obtools.dbdiff.model.ob.AbstractObTableGroup;
import com.oceanbase.obtools.dbdiff.model.obmysql14x.ObMySql14xSchema;
import java.util.List;

public class ObMySql14xTableGroup
extends AbstractObTableGroup {
    public ObMySql14xTableGroup(ObMySql14xSchema schema) {
        super(schema);
    }

    @Override
    public List<ObjectDefine> buildDefinition() throws UnsupportedGrammarException {
        String tableGroupName = this.getObjectName();
        StringBuilder sb = new StringBuilder(256);
        sb.append("CREATE TABLEGROUP IF NOT EXISTS ").append(this.wrapAndEscape(tableGroupName));
        sb.append((CharSequence)super.buildTableGroupOptions());
        sb.append((CharSequence)super.buildTablePartitionOption());
        return Lists.newArrayList((Object[])new ObjectDefine[]{new CreateObjectDefine(ObjectType.TABLE_GROUP, tableGroupName, this.terminate(sb))});
    }

    @Override
    public String getQuotaCharacter() {
        return "`";
    }

    @Override
    public DropObjectDefine buildDropDefinition() {
        String tableGroupName = this.getObjectName();
        StringBuilder sb = new StringBuilder(128);
        sb.append("DROP TABLEGROUP IF EXISTS ").append(this.wrapAndEscape(tableGroupName));
        return new DropObjectDefine(ObjectType.TABLE_GROUP, tableGroupName, this.terminate(sb));
    }

    @Override
    public List<ObjectDefine> compareTo(AbstractTableGroup other) {
        if (!(other instanceof ObMySql14xTableGroup)) {
            throw new UnmatchedObjectTypeException("Raw type is not matched");
        }
        return null;
    }
}

