/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.model.obmysql14x;

import com.oceanbase.obtools.common.utils.MapUtils;
import com.oceanbase.obtools.common.utils.StringUtils;
import com.oceanbase.obtools.dbdiff.compare.result.ChangeInfo;
import com.oceanbase.obtools.dbdiff.compare.result.ObjectDefine;
import com.oceanbase.obtools.dbdiff.enums.DbType;
import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import com.oceanbase.obtools.dbdiff.exception.UnmatchedObjectTypeException;
import com.oceanbase.obtools.dbdiff.exception.UnsupportedGrammarException;
import com.oceanbase.obtools.dbdiff.model.AbstractTablePartition;
import com.oceanbase.obtools.dbdiff.model.mysql.AbstractMySqlTablePartition;
import com.oceanbase.obtools.dbdiff.model.obmysql14x.ObMySql14xSchema;
import com.oceanbase.obtools.dbdiff.utils.ChangeUtils;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ObMySql14xTablePartition
extends AbstractMySqlTablePartition {
    public static final int PART_LEVEL_1 = new Integer(1);
    public static final int PART_LEVEL_2 = new Integer(2);
    private int partNum;
    private int subPartNum;
    private int partLevel;
    private boolean subPartTemplate;

    public ObMySql14xTablePartition(ObMySql14xSchema schema) {
        super(schema);
    }

    @Override
    public StringBuilder buildGrammar() throws UnsupportedGrammarException {
        boolean partitionNCondition;
        String subPartMethod;
        String partMethod = super.getPartTypeMapping().getOrDefault(this.getPartitionMethod(), this.getPartitionMethod());
        this.checkPartitionMethod(partMethod);
        String originPartMethod = partMethod;
        if ("LINEAR KEY".equals(partMethod)) {
            partMethod = "KEY";
        } else if ("LINEAR HASH".equals(partMethod)) {
            partMethod = "HASH";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("\n").append("PARTITION BY ").append(partMethod);
        sb.append((CharSequence)this.enclose(this.getPartitionExpression()));
        Collection<AbstractMySqlTablePartition.MySqlPartitionItem> partitionItems = this.getTablePartitions();
        boolean isCompositePartitioned = this.isCompositePartitioned();
        boolean isPrior2271 = DbType.OBMYSQL_2271.getType().equals(this.getDbType().getType()) && this.getDbType().isPrior(DbType.OBMYSQL_2271);
        boolean isCommunityEdition = DbType.OBMYSQL_CE_313.getType().equals(this.getDbType().getType());
        boolean isKeyHashPart = partMethod.contains("KEY") || partMethod.contains("HASH");
        DbType originDbType = this.getOriginDbType();
        boolean isOriginPrior2271 = DbType.OBMYSQL_14.getType().equals(originDbType.getType()) && DbType.OBMYSQL_2271.isSubsequent(originDbType);
        boolean isOriginSubsequent40 = DbType.OBMYSQL_14.getType().equals(originDbType.getType()) && DbType.OBMYSQL_40.isPriorFrom(originDbType) || DbType.OBMYSQL_CE_313.getType().equals(originDbType.getType()) && DbType.OBMYSQL_CE_40.isPriorFrom(originDbType);
        Map<String, String> partFormatMap = super.getTablePartTemplateMapping();
        partFormatMap.put("LIST", partFormatMap.get("LIST COLUMNS"));
        String partFormat = partFormatMap.get(partMethod);
        boolean changed = false;
        StringBuilder prev = new StringBuilder();
        StringBuilder post = new StringBuilder();
        if (StringUtils.notEqualsIgnoreCase((CharSequence)originPartMethod, (CharSequence)partMethod)) {
            changed = true;
            prev.append("partition by ").append(originPartMethod);
            post.append("partition by ").append(partMethod);
        }
        if (StringUtils.isNotEmpty((CharSequence)(subPartMethod = super.getPartTypeMapping().getOrDefault(this.getSubPartitionMethod(), this.getSubPartitionMethod())))) {
            this.checkPartitionMethod(subPartMethod);
        }
        if (isCompositePartitioned) {
            String originSubPartMethod = subPartMethod;
            if ("LINEAR KEY".equals(subPartMethod)) {
                subPartMethod = "KEY";
            } else if ("LINEAR HASH".equals(subPartMethod)) {
                subPartMethod = "HASH";
            }
            if (StringUtils.notEquals((CharSequence)originSubPartMethod, (CharSequence)subPartMethod)) {
                changed = true;
                prev.append(" ... subpartition by ").append(originSubPartMethod);
                post.append(" ... subpartition by ").append(subPartMethod);
            }
        }
        if (changed) {
            ChangeUtils.warn(ObjectType.TABLE, this.getSchemaObjectName(), ChangeInfo.ChangeType.CONVERT, prev.append(" -> ").append((CharSequence)post).toString());
        }
        Map<String, String> subPartFormatMap = super.getTableSubPartTemplateMapping();
        subPartFormatMap.put("LIST", subPartFormatMap.get("LIST COLUMNS"));
        String subPartFormat = subPartFormatMap.get(subPartMethod);
        Map<String, List<AbstractMySqlTablePartition.MySqlPartitionItem>> subPartMap = super.getTableSubPartitionMapping();
        boolean isKeyHashSubPart = false;
        boolean isSubPartitionsN = false;
        if (isCompositePartitioned) {
            boolean bl = isKeyHashSubPart = subPartMethod.contains("KEY") || subPartMethod.contains("HASH");
            if (StringUtils.isNotBlank((CharSequence)subPartMethod)) {
                this.checkPartitionMethod(subPartMethod);
                sb.append("\n").append("SUBPARTITION BY ").append(subPartMethod);
                sb.append((CharSequence)this.enclose(this.getSubPartitionExpression()));
            }
            if (isOriginPrior2271 && isKeyHashSubPart) {
                this.setSubPartTemplate(false);
            }
            if (isKeyHashSubPart && (isPrior2271 || !this.isSubPartTemplate() && this.withEqualSubPartCount())) {
                sb.append("\n").append("SUBPARTITIONS ");
                if (MapUtils.isEmpty(subPartMap) && this.getSubPartNum() > 0) {
                    sb.append(this.getSubPartNum());
                } else {
                    sb.append(subPartMap.values().iterator().next().size());
                }
                isSubPartitionsN = true;
            }
            if (!isSubPartitionsN && ((!isPrior2271 || isCommunityEdition) && this.isSubPartTemplate() || isPrior2271 && !isKeyHashSubPart || isOriginPrior2271 && this.isSubPartTemplate())) {
                String partId = "-1";
                if (isOriginSubsequent40) {
                    partId = "1";
                }
                List<AbstractMySqlTablePartition.MySqlPartitionItem> subPartItems = subPartMap.get(partId);
                sb.append("\n").append("subpartition template (");
                Iterator<AbstractMySqlTablePartition.MySqlPartitionItem> subPartIter = subPartItems.iterator();
                while (subPartIter.hasNext()) {
                    AbstractMySqlTablePartition.MySqlPartitionItem subPartItem = subPartIter.next();
                    String subPartName = subPartItem.getSubPartitionName();
                    int index = subPartName.indexOf(115);
                    if (index != -1) {
                        subPartName = subPartName.substring(index + 1);
                    }
                    String subPartDesc = subPartItem.getPartitionDescription();
                    sb.append("\n\t");
                    if (isKeyHashSubPart) {
                        sb.append(String.format(subPartFormat, this.wrap(subPartName)));
                    } else {
                        sb.append(String.format(subPartFormat, this.wrap(subPartName), subPartDesc));
                    }
                    this.appendOptions(sb, subPartItem);
                    if (!subPartIter.hasNext()) continue;
                    sb.append(",");
                }
                sb.append("\n").append(")");
            }
        }
        boolean bl = partitionNCondition = isKeyHashPart && (isPrior2271 || !isCompositePartitioned);
        if (partitionNCondition) {
            return sb.append(" PARTITIONS ").append(partitionItems.size());
        }
        boolean isNoneSubPartTemplate = !isPrior2271 || !isKeyHashSubPart;
        boolean isCommunityMysql = DbType.MYSQL_56.getType().equals(super.getOriginDbType().getType());
        sb.append("\n").append("(");
        boolean isSubPartDefined = MapUtils.isNotEmpty(subPartMap) & !subPartMap.containsKey("-1");
        Iterator<AbstractMySqlTablePartition.MySqlPartitionItem> partIter = partitionItems.iterator();
        while (partIter.hasNext()) {
            AbstractMySqlTablePartition.MySqlPartitionItem partItem = partIter.next();
            String partName = partItem.getPartitionName();
            String partId = String.valueOf(partItem.getPartitionOrdinalPosition());
            sb.append("\n\t");
            if (isKeyHashPart) {
                sb.append(String.format(partFormat, this.wrap(partName)));
            } else {
                String partDesc = partItem.getPartitionDescription();
                sb.append(String.format(partFormat, this.wrap(partName), partDesc));
            }
            if (isCompositePartitioned && !this.isSubPartTemplate() && !isCommunityMysql && isNoneSubPartTemplate && isSubPartDefined && !isSubPartitionsN) {
                List<AbstractMySqlTablePartition.MySqlPartitionItem> subPartItems = subPartMap.get(partId);
                sb.append("\n\t").append("(");
                Iterator<AbstractMySqlTablePartition.MySqlPartitionItem> subPartIter = subPartItems.iterator();
                while (subPartIter.hasNext()) {
                    AbstractMySqlTablePartition.MySqlPartitionItem subPartItem = subPartIter.next();
                    String subPartName = this.wrap(subPartItem.getSubPartitionName());
                    sb.append("\n\t\t");
                    if (isKeyHashSubPart) {
                        sb.append(String.format(subPartFormat, this.wrap(subPartName)));
                    } else {
                        String subPartDesc = subPartItem.getPartitionDescription();
                        sb.append(String.format(subPartFormat, this.wrap(subPartName), subPartDesc));
                    }
                    this.appendOptions(sb, subPartItem);
                    if (!subPartIter.hasNext()) continue;
                    sb.append(",");
                }
                sb.append("\n\t").append(")");
            } else {
                this.appendOptions(sb, partItem);
            }
            if (!partIter.hasNext()) continue;
            sb.append(",");
        }
        return sb.append("\n").append(")");
    }

    @Override
    protected void appendOptions(StringBuilder sb, AbstractMySqlTablePartition.MySqlPartitionItem partItem) {
    }

    @Override
    public List<ObjectDefine> compareTo(AbstractTablePartition other) {
        if (!(other instanceof ObMySql14xTablePartition)) {
            throw new UnmatchedObjectTypeException("Raw type is not matched");
        }
        return null;
    }

    @Override
    public boolean isCompositePartitioned() {
        return this.getPartLevel() > PART_LEVEL_1 || StringUtils.isNotBlank((CharSequence)this.getSubPartitionMethod()) && StringUtils.isNotBlank((CharSequence)this.getSubPartitionExpression());
    }

    private boolean withEqualSubPartCount() {
        Map<String, List<AbstractMySqlTablePartition.MySqlPartitionItem>> subPartMap = super.getTableSubPartitionMapping();
        if (MapUtils.isEmpty(subPartMap)) {
            return true;
        }
        int count = subPartMap.values().iterator().next().size();
        for (List<AbstractMySqlTablePartition.MySqlPartitionItem> items : subPartMap.values()) {
            if (items.size() == count) continue;
            return false;
        }
        return true;
    }

    public int getPartNum() {
        return this.partNum;
    }

    public void setPartNum(int partNum) {
        this.partNum = partNum;
    }

    @Override
    public int getSubPartNum() {
        return this.subPartNum;
    }

    @Override
    public void setSubPartNum(int subPartNum) {
        this.subPartNum = subPartNum;
    }

    public int getPartLevel() {
        return this.partLevel;
    }

    public void setPartLevel(int partLevel) {
        this.partLevel = partLevel;
    }

    public boolean isSubPartTemplate() {
        return this.subPartTemplate;
    }

    public void setSubPartTemplate(boolean subPartTemplate) {
        this.subPartTemplate = subPartTemplate;
    }
}

