/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.model.obmysql14x;

import com.google.common.collect.Lists;
import com.oceanbase.obtools.common.utils.StringUtils;
import com.oceanbase.obtools.dbdiff.compare.result.CreateObjectDefine;
import com.oceanbase.obtools.dbdiff.compare.result.DropObjectDefine;
import com.oceanbase.obtools.dbdiff.compare.result.ObjectDefine;
import com.oceanbase.obtools.dbdiff.compare.result.UnsupportedObjectDefine;
import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import com.oceanbase.obtools.dbdiff.exception.UnmatchedObjectTypeException;
import com.oceanbase.obtools.dbdiff.exception.UnsupportedGrammarException;
import com.oceanbase.obtools.dbdiff.model.AbstractConstraint;
import com.oceanbase.obtools.dbdiff.model.obmysql.AbstractObMySqlConstraint;
import com.oceanbase.obtools.dbdiff.model.obmysql14x.ObMySql14xIndexPartition;
import com.oceanbase.obtools.dbdiff.model.obmysql14x.ObMySql14xSchema;
import java.util.ArrayList;
import java.util.List;

public class ObMySql14xUniqueKey
extends AbstractObMySqlConstraint {
    private String locality;
    private ObMySql14xIndexPartition indexPartition;

    public ObMySql14xUniqueKey(ObMySql14xSchema schema) {
        super(schema);
    }

    @Override
    public StringBuilder buildGrammar() throws UnsupportedGrammarException {
        if (this.getDbType().isPriorObMysql40()) {
            return this.buildGrammarPrior40();
        }
        return this.buildGrammarSubsequentFrom40();
    }

    private StringBuilder buildGrammarPrior40() {
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)this.getConstraintName())) {
            sb.append("constraint ").append(this.wrapAndEscape(this.getConstraintName())).append(" ");
        }
        sb.append("unique key").append((CharSequence)this.joinConstraintColumns());
        String indexType = this.getIndexType();
        if ("GLOBAL".equals(indexType) || "GLOBAL UNIQUE".equals(indexType)) {
            this.setLocality("GLOBAL");
        } else if ("LOCAL".equals(indexType) || "LOCAL UNIQUE".equals(indexType)) {
            this.setLocality("LOCAL");
        }
        if (StringUtils.isNotEmpty((CharSequence)this.getLocality())) {
            sb.append(" ").append(this.getLocality());
        }
        return sb;
    }

    private StringBuilder buildGrammarSubsequentFrom40() throws UnsupportedGrammarException {
        if (this.getIndexPartition() == null || "LOCAL".equals(this.getIndexPartition().getLocality())) {
            return this.buildGrammarPrior40();
        }
        StringBuilder sb = new StringBuilder();
        sb.append("unique key ");
        if (StringUtils.isNotBlank((CharSequence)this.getConstraintName())) {
            sb.append(this.wrapAndEscape(this.getConstraintName())).append(" ");
        }
        sb.append((CharSequence)this.joinConstraintColumns());
        sb.append((CharSequence)this.getIndexPartition().buildGrammar());
        return sb;
    }

    @Override
    public List<ObjectDefine> compareTo(AbstractConstraint other) {
        if (!(other instanceof ObMySql14xUniqueKey)) {
            throw new UnmatchedObjectTypeException("Raw type is not matched");
        }
        try {
            ArrayList<ObjectDefine> objectDefines = new ArrayList<ObjectDefine>();
            ObMySql14xUniqueKey target = (ObMySql14xUniqueKey)other;
            String srcColumnString = this.joinConstraintColumns().toString();
            String dstColumnString = target.joinConstraintColumns().toString();
            if (StringUtils.notEquals((CharSequence)srcColumnString, (CharSequence)dstColumnString)) {
                StringBuilder drop = new StringBuilder();
                drop.append("alter table ").append(this.getSchemaObjectName());
                drop.append(" drop index ").append(this.wrap(target.getConstraintName()));
                StringBuilder add = new StringBuilder();
                add.append("alter table ").append(this.getSchemaObjectName());
                add.append(" add ").append((CharSequence)this.buildGrammar()).append(";");
                objectDefines.add(new DropObjectDefine(ObjectType.CONSTRAINT, this.getSimpleObjectName(), drop.toString()));
                objectDefines.add(new CreateObjectDefine(ObjectType.CONSTRAINT, this.getSimpleObjectName(), add.toString()));
            }
            return objectDefines;
        }
        catch (UnsupportedGrammarException e) {
            return Lists.newArrayList((Object[])new ObjectDefine[]{new UnsupportedObjectDefine(ObjectType.CONSTRAINT, this.getSimpleObjectName(), e.getMessage())});
        }
    }

    public String getLocality() {
        return this.locality;
    }

    public void setLocality(String locality) {
        this.locality = locality;
    }

    public ObMySql14xIndexPartition getIndexPartition() {
        return this.indexPartition;
    }

    public void setIndexPartition(ObMySql14xIndexPartition indexPartition) {
        this.indexPartition = indexPartition;
    }
}

