/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.model.obmysql14x;

import com.oceanbase.obtools.common.collect.Lists;
import com.oceanbase.obtools.dbdiff.compare.result.AlterObjectDefine;
import com.oceanbase.obtools.dbdiff.compare.result.CreateObjectDefine;
import com.oceanbase.obtools.dbdiff.compare.result.ObjectDefine;
import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import com.oceanbase.obtools.dbdiff.exception.UnmatchedObjectTypeException;
import com.oceanbase.obtools.dbdiff.exception.UnsupportedGrammarException;
import com.oceanbase.obtools.dbdiff.model.AbstractView;
import com.oceanbase.obtools.dbdiff.model.mysql.AbstractMySqlView;
import com.oceanbase.obtools.dbdiff.model.obmysql14x.ObMySql14xSchema;
import com.oceanbase.obtools.dbdiff.utils.TextUtils;
import java.util.ArrayList;
import java.util.List;

public class ObMySql14xView
extends AbstractMySqlView {
    public ObMySql14xView(ObMySql14xSchema schema) {
        super(schema);
    }

    @Override
    public List<ObjectDefine> buildDefinition() throws UnsupportedGrammarException {
        String text = this.getText();
        if (this.isFullText()) {
            return Lists.newArrayList((Object[])new ObjectDefine[]{new CreateObjectDefine(ObjectType.VIEW, this.getSimpleObjectName(), this.terminate(text))});
        }
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE OR REPLACE");
        sb.append(" VIEW ").append(this.getDefinitionSchemaObjectName());
        sb.append(" AS ");
        sb.append(text);
        return Lists.newArrayList((Object[])new ObjectDefine[]{new CreateObjectDefine(ObjectType.VIEW, this.getSimpleObjectName(), this.terminate(sb))});
    }

    @Override
    public List<ObjectDefine> compareTo(AbstractView other) {
        if (!(other instanceof ObMySql14xView)) {
            throw new UnmatchedObjectTypeException("Raw type is not matched");
        }
        ObMySql14xView target = (ObMySql14xView)other;
        String srcSchema = this.getOriginSchemaName();
        String targetSchema = target.getOriginSchemaName();
        String newSrcText = TextUtils.replace(this.getText(), "`" + srcSchema + "`", "`" + targetSchema + "`");
        ArrayList objectDefines = Lists.newArrayList((Object[])new ObjectDefine[0]);
        if (!newSrcText.equals(target.getText())) {
            StringBuilder sb = new StringBuilder();
            sb.append("ALTER VIEW ").append(target.getSchemaObjectName()).append(" AS ");
            sb.append(newSrcText);
            objectDefines.add(new AlterObjectDefine(ObjectType.VIEW, this.getSimpleObjectName(), this.terminate(sb)));
        }
        return objectDefines;
    }
}

