/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.model.obmysql14x;

import com.oceanbase.obtools.common.utils.StringUtils;
import com.oceanbase.obtools.dbdiff.compare.result.ObjectDefine;
import com.oceanbase.obtools.dbdiff.constants.ConvertCode;
import com.oceanbase.obtools.dbdiff.enums.DbType;
import com.oceanbase.obtools.dbdiff.exception.UnmatchedObjectTypeException;
import com.oceanbase.obtools.dbdiff.exception.UnsupportedGrammarException;
import com.oceanbase.obtools.dbdiff.model.AbstractConstraint;
import com.oceanbase.obtools.dbdiff.model.obmysql.AbstractObMySqlConstraint;
import com.oceanbase.obtools.dbdiff.model.obmysql14x.ObMySql14xSchema;
import java.util.List;

public class ObMySql32xCheck
extends AbstractObMySqlConstraint {
    private String checkClause;

    public ObMySql32xCheck(ObMySql14xSchema schema) {
        super(schema);
    }

    @Override
    public StringBuilder buildGrammar() throws UnsupportedGrammarException {
        StringBuilder sb = new StringBuilder();
        if (DbType.OBMYSQL_323.getType().equals(this.getDbType().getType()) && DbType.OBMYSQL_323.isSubsequent(this.getDbType())) {
            sb.append("check ").append(this.getCheckClause()).append(" is unsupported until OBMYSQL v3.2.3.0");
            throw new UnsupportedGrammarException(ConvertCode.MysqlUnsupportedCode.CHECK_CONSTRAINT_NOT_SUPPORT, this.getSchemaObjectName(), sb.toString());
        }
        if (StringUtils.isNotBlank((CharSequence)this.getConstraintName())) {
            sb.append("constraint ").append(this.wrapAndEscape(this.getConstraintName())).append(" ");
        }
        return sb.append("check ").append(this.getCheckClause());
    }

    @Override
    public List<ObjectDefine> compareTo(AbstractConstraint other) {
        if (!(other instanceof ObMySql32xCheck)) {
            throw new UnmatchedObjectTypeException("Raw type is not matched");
        }
        return null;
    }

    public String getCheckClause() {
        return this.checkClause;
    }

    public void setCheckClause(String checkClause) {
        this.checkClause = checkClause;
    }
}

