/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.model.obmysql14x;

import com.oceanbase.obtools.dbdiff.compare.result.DropObjectDefine;
import com.oceanbase.obtools.dbdiff.compare.result.ObjectDefine;
import com.oceanbase.obtools.dbdiff.compare.result.UnsupportedObjectDefine;
import com.oceanbase.obtools.dbdiff.enums.DbType;
import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import com.oceanbase.obtools.dbdiff.exception.UnmatchedObjectTypeException;
import com.oceanbase.obtools.dbdiff.exception.UnsupportedGrammarException;
import com.oceanbase.obtools.dbdiff.model.AbstractTrigger;
import com.oceanbase.obtools.dbdiff.model.mysql.AbstractMySqlTrigger;
import com.oceanbase.obtools.dbdiff.model.obmysql14x.ObMySql14xSchema;
import java.util.ArrayList;
import java.util.List;

public class ObMySql32xTrigger
extends AbstractMySqlTrigger {
    public ObMySql32xTrigger(ObMySql14xSchema schema) {
        super(schema);
    }

    @Override
    public List<ObjectDefine> buildDefinition() throws UnsupportedGrammarException {
        if (DbType.OBMYSQL_322.getType().equals(this.getDbType().getType()) && DbType.OBMYSQL_322.isSubsequent(this.getDbType())) {
            throw new UnsupportedGrammarException(this.getSchemaObjectName(), "TRIGGER is supported until obmysql v3.2.2 later");
        }
        return super.buildDefinition();
    }

    @Override
    public List<ObjectDefine> compareTo(AbstractTrigger other) {
        if (!(other instanceof ObMySql32xTrigger)) {
            throw new UnmatchedObjectTypeException("Raw type is not matched");
        }
        ObMySql32xTrigger target = (ObMySql32xTrigger)other;
        ArrayList<ObjectDefine> objectDefines = new ArrayList<ObjectDefine>();
        if (!(this.getActionTiming().equals(target.getActionTiming()) && this.getEventManipulation().equals(target.getEventManipulation()) && this.getEventObjectTable().equals(target.getEventObjectTable()) && this.getActionStatement().equals(target.getActionStatement()))) {
            StringBuilder sb = new StringBuilder();
            sb.append("DROP TRIGGER ").append(target.getSchemaObjectName());
            try {
                objectDefines.add(new DropObjectDefine(ObjectType.TRIGGER, this.getSimpleObjectName(), this.terminate(sb), this.buildDefinition()));
            }
            catch (UnsupportedGrammarException e) {
                objectDefines.add(new UnsupportedObjectDefine(ObjectType.TRIGGER, this.getSimpleObjectName(), e.getMessage()));
            }
        }
        return objectDefines;
    }
}

