/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.model.oboracle22x;

import com.google.common.collect.Lists;
import com.oceanbase.obtools.common.utils.StringUtils;
import com.oceanbase.obtools.dbdiff.compare.result.AlterObjectDefine;
import com.oceanbase.obtools.dbdiff.compare.result.ChangeInfo;
import com.oceanbase.obtools.dbdiff.compare.result.DropObjectDefine;
import com.oceanbase.obtools.dbdiff.compare.result.ObjectDefine;
import com.oceanbase.obtools.dbdiff.compare.result.UnsupportedObjectDefine;
import com.oceanbase.obtools.dbdiff.enums.DbType;
import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import com.oceanbase.obtools.dbdiff.exception.UnmatchedObjectTypeException;
import com.oceanbase.obtools.dbdiff.exception.UnsupportedGrammarException;
import com.oceanbase.obtools.dbdiff.mapper.MapField;
import com.oceanbase.obtools.dbdiff.mapper.expression.ExpressionRewriterFactory;
import com.oceanbase.obtools.dbdiff.model.AbstractConstraint;
import com.oceanbase.obtools.dbdiff.model.mysql56.MySql80Check;
import com.oceanbase.obtools.dbdiff.model.oboracle.AbstractObOracleConstraint;
import com.oceanbase.obtools.dbdiff.model.oboracle22x.ObOracle22xSchema;
import com.oceanbase.obtools.dbdiff.utils.ChangeUtils;
import java.util.ArrayList;
import java.util.List;

public class ObOracle22xCheck
extends AbstractObOracleConstraint {
    private boolean complete = false;
    @MapField(targetClass=MySql80Check.class, targetField="checkClause")
    private String searchCondition;

    public ObOracle22xCheck(ObOracle22xSchema schema) {
        super(schema);
    }

    @Override
    public StringBuilder buildGrammar() throws UnsupportedGrammarException {
        StringBuilder sb = new StringBuilder();
        String searchCondition = this.getSearchCondition();
        if (StringUtils.isBlank((CharSequence)searchCondition)) {
            ChangeUtils.warn(ObjectType.TABLE, this.getSchemaObjectName(), ChangeInfo.ChangeType.DISCARD, "The CHECK constraint is discarded as SEARCH_CONDITION is NULL");
            return sb;
        }
        searchCondition = ExpressionRewriterFactory.getRewriter(this.getGlobal(), this.getOriginDbType()).rewriteCheckExpr(searchCondition.trim());
        if (this.isComplete()) {
            return sb.append(searchCondition);
        }
        if (StringUtils.isNotBlank((CharSequence)this.getConstraintName()) && this.isUserGenerated()) {
            sb.append("CONSTRAINT ").append(this.wrap(this.getConstraintName())).append(" ");
        }
        if (searchCondition.startsWith("(") && searchCondition.endsWith(")")) {
            sb.append("CHECK ").append(searchCondition);
        } else {
            sb.append("CHECK (").append(searchCondition).append(")");
        }
        String status = this.getStatus();
        String validated = this.getValidated();
        if (super.getSchema().isDumpOperation()) {
            sb.append(this.safetyMapping(OPTION_MAPPING, status));
            return sb.append(this.safetyMapping(OPTION_MAPPING, validated));
        }
        StringBuilder discard = new StringBuilder(sb);
        discard.append(this.safetyMapping(OPTION_MAPPING, status));
        discard.append(this.safetyMapping(OPTION_MAPPING, validated));
        if ("DISABLED".equalsIgnoreCase(status)) {
            ChangeUtils.warn(ObjectType.TABLE, this.getSchemaObjectName(), ChangeInfo.ChangeType.DISCARD, discard + " -> [NULL]");
            return new StringBuilder(0);
        }
        StringBuilder alter = new StringBuilder();
        alter.append("ALTER TABLE ").append(this.getSchemaObjectName());
        alter.append(" ADD ").append((CharSequence)sb);
        if (DbType.OBORACLE_2270.isPriorFrom(this.getDbType())) {
            alter.append(this.safetyMapping(OPTION_MAPPING, status));
            alter.append(this.safetyMapping(OPTION_MAPPING, validated));
        }
        ChangeUtils.warn(ObjectType.TABLE, this.getSchemaObjectName(), ChangeInfo.ChangeType.DISCARD, discard + " -> [NULL]", this.terminate(alter));
        return new StringBuilder(0);
    }

    @Override
    public List<ObjectDefine> compareTo(AbstractConstraint other) {
        if (!(other instanceof ObOracle22xCheck)) {
            throw new UnmatchedObjectTypeException("Raw type is not matched");
        }
        String objectName = this.getSimpleObjectName();
        ArrayList<ObjectDefine> objectDefines = new ArrayList<ObjectDefine>();
        ObOracle22xCheck target = (ObOracle22xCheck)other;
        String srcConstraintName = this.getConstraintName();
        String dstConstraintName = target.getConstraintName();
        String srcSearchCondition = this.getSearchCondition();
        String dstSearchCondition = target.getSearchCondition();
        try {
            if (StringUtils.notEquals((CharSequence)srcSearchCondition, (CharSequence)dstSearchCondition) && StringUtils.notEquals((CharSequence)srcSearchCondition, (CharSequence)dstSearchCondition.replaceAll("[`\"]", "")) && StringUtils.notEquals((CharSequence)srcSearchCondition.replaceAll("[`\"]", ""), (CharSequence)dstSearchCondition)) {
                StringBuilder drop = new StringBuilder();
                drop.append("ALTER TABLE ").append(this.getSchemaObjectName());
                drop.append(" DROP CONSTRAINT ").append(this.wrap(dstConstraintName)).append(" CASCADE;");
                StringBuilder add = new StringBuilder();
                add.append("ALTER TABLE ").append(this.getSchemaObjectName());
                add.append(" ADD ").append((CharSequence)this.buildGrammar()).append(";");
                objectDefines.add(new DropObjectDefine(ObjectType.TABLE, objectName, drop.toString(), Lists.newArrayList((Object[])new ObjectDefine[]{new AlterObjectDefine(ObjectType.TABLE, objectName, add.toString())})));
            }
            if (StringUtils.notEquals((CharSequence)srcConstraintName, (CharSequence)dstConstraintName)) {
                StringBuilder sb = new StringBuilder();
                sb.append("ALTER TABLE ").append(this.getSchemaObjectName()).append(" RENAME CONSTRAINT ");
                sb.append(this.wrap(dstConstraintName)).append(" TO ").append(this.wrap(srcConstraintName)).append(";");
                objectDefines.add(new AlterObjectDefine(ObjectType.TABLE, objectName, sb.toString()));
            }
            return objectDefines;
        }
        catch (UnsupportedGrammarException e) {
            return Lists.newArrayList((Object[])new ObjectDefine[]{new UnsupportedObjectDefine(ObjectType.TABLE, objectName, e.getMessage())});
        }
    }

    public boolean isComplete() {
        return this.complete;
    }

    public void setComplete(boolean complete) {
        this.complete = complete;
    }

    @Override
    public String getSearchCondition() {
        return this.searchCondition;
    }

    @Override
    public void setSearchCondition(String searchCondition) {
        this.searchCondition = searchCondition;
    }
}

