/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.model.oboracle22x;

import com.google.common.collect.Lists;
import com.oceanbase.obtools.common.utils.NumberUtils;
import com.oceanbase.obtools.common.utils.StringUtils;
import com.oceanbase.obtools.dbdiff.compare.result.AlterObjectDefine;
import com.oceanbase.obtools.dbdiff.compare.result.ChangeInfo;
import com.oceanbase.obtools.dbdiff.compare.result.ObjectDefine;
import com.oceanbase.obtools.dbdiff.compare.result.UnsupportedObjectDefine;
import com.oceanbase.obtools.dbdiff.configure.Global;
import com.oceanbase.obtools.dbdiff.enums.DbType;
import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import com.oceanbase.obtools.dbdiff.exception.UnmatchedObjectTypeException;
import com.oceanbase.obtools.dbdiff.exception.UnsupportedGrammarException;
import com.oceanbase.obtools.dbdiff.model.AbstractColumn;
import com.oceanbase.obtools.dbdiff.model.oboracle22x.ObOracle22xSchema;
import com.oceanbase.obtools.dbdiff.model.oboracle22x.ObOracle22xSequence;
import com.oceanbase.obtools.dbdiff.model.oboracle22x.ObOracle22xTrigger;
import com.oceanbase.obtools.dbdiff.model.oracle.AbstractOracleColumn;
import com.oceanbase.obtools.dbdiff.utils.ChangeUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ObOracle22xColumn
extends AbstractOracleColumn {
    private static final int MAX_CHAR_BYTE_LEN = 2000;
    private static final int MAX_VARCHAR_BYTE_LEN = Short.MAX_VALUE;
    private final Map<String, ObOracle22xSequence> sequenceMapping = new HashMap<String, ObOracle22xSequence>();
    private final Map<String, ObOracle22xTrigger> triggerMapping = new HashMap<String, ObOracle22xTrigger>();

    public ObOracle22xColumn(ObOracle22xSchema schema) {
        super(schema);
    }

    @Override
    public StringBuilder buildGrammar() throws UnsupportedGrammarException {
        String columnDefault;
        String dataType = this.getDataType();
        if (dataType == null) {
            throw new IllegalArgumentException("The data type is null");
        }
        if (dataType.startsWith("INTERVAL DAY()")) {
            dataType = dataType.replace("INTERVAL DAY()", "INTERVAL DAY(0)");
        } else if (dataType.startsWith("INTERVAL YEAR()")) {
            dataType = dataType.replace("INTERVAL YEAR()", "INTERVAL YEAR(0)");
        }
        StringBuilder sb = new StringBuilder();
        String columnName = this.getGrammarColumnName();
        sb.append(columnName);
        DbType originDbType = super.getOriginDbType();
        if (!"YES".equals(this.getVirtualColumn()) || originDbType == null || !DbType.OBORACLE_22.getType().equals(originDbType.getType())) {
            this.appendDataType(columnName, dataType, sb);
        }
        if ("YES".equals(this.getHiddenColumn())) {
            sb.append(" INVISIBLE");
        }
        if (StringUtils.isNotBlank((CharSequence)this.getInlineCheckGrammar())) {
            sb.append(" ").append(this.getInlineCheckGrammar());
        }
        if ((columnDefault = this.getColumnDefault()) != null) {
            if ("YES".equals(this.getVirtualColumn())) {
                sb.append(" GENERATED ALWAYS AS");
                sb.append((CharSequence)this.enclose(columnDefault)).append(" VIRTUAL");
            } else {
                columnDefault = columnDefault.trim();
                if (DbType.OBORACLE_2272.getType().equals(this.getOriginDbType().getType()) && (this.isCharType() || this.isVarcharType()) && columnDefault.startsWith("'") && !columnDefault.endsWith("'")) {
                    columnDefault = columnDefault + "'";
                }
                sb.append(" DEFAULT ").append(columnDefault);
                if (columnDefault.contains("--")) {
                    sb.append("\n");
                }
            }
        }
        if ("N".equals(this.getNullable()) || "NO".equals(this.getNullable())) {
            sb.append(" NOT NULL");
        }
        return sb;
    }

    private StringBuilder appendDataType(String columnName, String dataType, StringBuilder sb) throws UnsupportedGrammarException {
        sb.append(" ").append(dataType);
        switch (dataType) {
            case "XML": 
            case "BFILE": 
            case "BINARY": {
                throw new UnsupportedGrammarException(this.getOriginSchemaObjectName(), "The column: " + columnName + " " + dataType + " is unsupported");
            }
            case "XMLTYPE": {
                if (!this.getDbType().isPrior(DbType.OBORACLE_420)) break;
                throw new UnsupportedGrammarException(this.getOriginSchemaObjectName(), "The column: " + columnName + " " + dataType + " is unsupported");
            }
            case "ROWID": 
            case "UROWID": {
                if (this.getDbType().isPrior(DbType.OBORACLE_2270)) {
                    throw new UnsupportedGrammarException(this.getOriginSchemaObjectName(), "The column: " + columnName + " " + dataType + " is unsupported");
                }
            }
            case "NCLOB": {
                if (this.getDbType().isPrior(DbType.OBORACLE_2250)) {
                    throw new UnsupportedGrammarException(this.getOriginSchemaObjectName(), "The column: " + columnName + " " + dataType + " is unsupported");
                }
            }
            case "DATE": 
            case "CLOB": 
            case "BLOB": 
            case "BINARY_FLOAT": 
            case "BINARY_DOUBLE": {
                break;
            }
            case "FLOAT": {
                Integer dataPrecision = this.getDataPrecision();
                if (dataPrecision == null || dataPrecision <= 0) break;
                sb.append("(").append(dataPrecision).append(")");
                break;
            }
            case "JSON": {
                if (!this.getDbType().isPrior(DbType.OBORACLE_410)) break;
                throw new UnsupportedGrammarException(this.getOriginSchemaObjectName(), "The column: " + columnName + " " + dataType + " is unsupported");
            }
            case "NUMBER": {
                Integer dataPrecision = this.getDataPrecision();
                Integer dataScale = this.getDataScale();
                if (dataPrecision != null && dataPrecision > 0) {
                    sb.append("(").append(dataPrecision);
                    if (dataScale != null && dataScale > -1) {
                        sb.append(",").append(dataScale);
                    }
                    sb.append(")");
                    break;
                }
                if (dataScale == null || dataScale <= -1) break;
                sb.append("(*,").append(dataScale).append(")");
                break;
            }
            default: {
                if (dataType.startsWith("TIMESTAMP") || dataType.startsWith("INTERVAL")) break;
                String charUsed = this.getCharUsed();
                Long originLength = this.getCharLength();
                if ("B".equals(charUsed)) {
                    String changedInfo = columnName + " " + dataType + "(" + originLength + " BYTE) -> ";
                    if (Global.ByteUsedType.EXPAND_LEN_IF_BYTE_USED == super.getGlobal().getByteUsedType()) {
                        Long charLength = Double.valueOf(Math.ceil((double)originLength.longValue() * 1.5)).longValue();
                        if (this.isCharType()) {
                            charLength = charLength >= 2000L ? 2000L : charLength;
                        }
                        if (this.isVarcharType()) {
                            charLength = charLength >= 32767L ? 32767L : charLength;
                        }
                        sb.append("(").append(charLength).append(" BYTE)");
                        ChangeUtils.info(ObjectType.TABLE, this.getSchemaObjectName(), ChangeInfo.ChangeType.CONVERT, changedInfo + columnName + " " + dataType + "(" + charLength + " BYTE)");
                        break;
                    }
                    if (Global.ByteUsedType.FORCE_CHAR_IF_BYTE_USED == super.getGlobal().getByteUsedType()) {
                        String suffix = !this.isUnicodeType() ? " CHAR)" : ")";
                        sb.append("(").append(originLength).append(suffix);
                        ChangeUtils.info(ObjectType.TABLE, this.getSchemaObjectName(), ChangeInfo.ChangeType.CONVERT, changedInfo + columnName + " " + dataType + "(" + originLength + suffix);
                        break;
                    }
                    if (Global.ByteUsedType.IGNORE_BYTE_IF_BYTE_USED == super.getGlobal().getByteUsedType()) {
                        sb.append("(").append(originLength).append(")");
                        ChangeUtils.info(ObjectType.TABLE, this.getSchemaObjectName(), ChangeInfo.ChangeType.CONVERT, changedInfo + columnName + " " + dataType + "(" + originLength + ")");
                        break;
                    }
                    sb.append("(").append(originLength).append(" BYTE)");
                    break;
                }
                if ("C".equals(charUsed)) {
                    sb.append("(").append(originLength).append(!this.isUnicodeType() ? " CHAR)" : ")");
                    break;
                }
                Long dataLength = this.getDataLength();
                if (dataLength == null || dataLength <= 0L) break;
                sb.append("(").append(this.getDataLength()).append(")");
            }
        }
        return sb;
    }

    @Override
    public List<ObjectDefine> compareTo(AbstractColumn other) {
        if (!(other instanceof ObOracle22xColumn)) {
            throw new UnmatchedObjectTypeException("Raw type is not matched");
        }
        ArrayList<ObjectDefine> objectDefines = new ArrayList<ObjectDefine>();
        ObOracle22xColumn target = (ObOracle22xColumn)other;
        boolean isDataTypeDiff = StringUtils.notEquals((CharSequence)this.getDataType(), (CharSequence)target.getDataType());
        boolean isColumnNameDiff = StringUtils.notEquals((CharSequence)this.getColumnName(), (CharSequence)target.getColumnName());
        boolean isDataPrecDiff = NumberUtils.notEquals((Number)this.getDataPrecision(), (Number)target.getDataPrecision());
        boolean isDataScaleDiff = NumberUtils.notEquals((Number)this.getDataScale(), (Number)target.getDataScale());
        boolean isCharUsedDiff = StringUtils.notEquals((CharSequence)this.getCharUsed(), (CharSequence)target.getCharUsed());
        boolean isCharLengthDiff = NumberUtils.notEquals((Number)this.getCharLength(), (Number)target.getCharLength());
        boolean isHiddenColumnDiff = StringUtils.notEquals((CharSequence)this.getHiddenColumn(), (CharSequence)target.getHiddenColumn());
        boolean isNullableDiff = StringUtils.notEquals((CharSequence)this.getNullable(), (CharSequence)target.getNullable());
        boolean isInlineCheckDiff = StringUtils.notEquals((CharSequence)this.getInlineCheckGrammar(), (CharSequence)target.getInlineCheckGrammar());
        boolean isColumnDefaultDiff = StringUtils.notEquals((CharSequence)this.getColumnDefault(), (CharSequence)target.getColumnDefault());
        boolean isVirtualColumnDiff = StringUtils.notEquals((CharSequence)this.getVirtualColumn(), (CharSequence)target.getVirtualColumn());
        try {
            StringBuilder sb;
            if (isDataTypeDiff || isColumnNameDiff || isDataPrecDiff || isDataScaleDiff || isCharUsedDiff || isCharLengthDiff || isHiddenColumnDiff || isNullableDiff || isInlineCheckDiff || isColumnDefaultDiff || isVirtualColumnDiff) {
                sb = new StringBuilder();
                sb.append("ALTER TABLE ").append(this.getSchemaObjectName());
                sb.append(" MODIFY ").append((CharSequence)this.buildGrammar()).append(";");
                objectDefines.add(new AlterObjectDefine(ObjectType.TABLE, this.getSimpleObjectName(), sb.toString()));
            }
            if (StringUtils.notEquals((CharSequence)this.getColumnComment(), (CharSequence)target.getColumnComment())) {
                sb = new StringBuilder();
                sb.append("COMMENT ON COLUMN ");
                sb.append(this.getSchemaObjectName()).append(".").append(this.getWrappedName());
                sb.append(" IS '").append(this.getColumnComment()).append("'").append(";");
                objectDefines.add(new AlterObjectDefine(ObjectType.TABLE, this.getSimpleObjectName(), sb.toString()));
            }
            return objectDefines;
        }
        catch (UnsupportedGrammarException e) {
            return Lists.newArrayList((Object[])new ObjectDefine[]{new UnsupportedObjectDefine(ObjectType.TABLE, this.getSimpleObjectName(), e.getMessage())});
        }
    }

    public Map<String, ObOracle22xSequence> getSequenceMapping() {
        return this.sequenceMapping;
    }

    public Map<String, ObOracle22xTrigger> getTriggerMapping() {
        return this.triggerMapping;
    }
}

