/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.model.oboracle22x;

import com.google.common.collect.Lists;
import com.oceanbase.obtools.common.utils.StringUtils;
import com.oceanbase.obtools.dbdiff.compare.result.AlterObjectDefine;
import com.oceanbase.obtools.dbdiff.compare.result.ChangeInfo;
import com.oceanbase.obtools.dbdiff.compare.result.DropObjectDefine;
import com.oceanbase.obtools.dbdiff.compare.result.ObjectDefine;
import com.oceanbase.obtools.dbdiff.compare.result.UnsupportedObjectDefine;
import com.oceanbase.obtools.dbdiff.enums.DbType;
import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import com.oceanbase.obtools.dbdiff.exception.UnmatchedObjectTypeException;
import com.oceanbase.obtools.dbdiff.exception.UnsupportedGrammarException;
import com.oceanbase.obtools.dbdiff.model.AbstractConstraint;
import com.oceanbase.obtools.dbdiff.model.oboracle.AbstractObOracleConstraint;
import com.oceanbase.obtools.dbdiff.model.oboracle22x.ObOracle22xSchema;
import com.oceanbase.obtools.dbdiff.utils.ChangeUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class ObOracle22xForeignKey
extends AbstractObOracleConstraint {
    private static final List<String> SUPPORTED_DELETE_RULES = Lists.newArrayList((Object[])new String[]{"C", "CASCADE", "N", "SET NULL"});

    public ObOracle22xForeignKey(ObOracle22xSchema schema) {
        super(schema);
    }

    @Override
    public StringBuilder buildGrammar() throws UnsupportedGrammarException {
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)this.getConstraintName())) {
            sb.append("CONSTRAINT ").append(this.wrap(this.getConstraintName())).append(" ");
        }
        sb.append("FOREIGN KEY").append((CharSequence)this.joinForeignConstraintColumns());
        sb.append(" REFERENCES ").append(this.getRefOwnerTableName());
        sb.append((CharSequence)this.joinRefConstraintColumns());
        if (SUPPORTED_DELETE_RULES.contains(this.getDeleteRule())) {
            sb.append(this.safetyMapping(DELETE_RULE_MAPPING, this.getDeleteRule()));
        }
        String status = this.getStatus();
        String validated = this.getValidated();
        if (super.getSchema().isDumpOperation()) {
            return sb;
        }
        StringBuilder discard = new StringBuilder(sb);
        discard.append(this.safetyMapping(OPTION_MAPPING, status));
        discard.append(this.safetyMapping(OPTION_MAPPING, validated));
        if ("DISABLED".equalsIgnoreCase(status)) {
            ChangeUtils.info(ObjectType.TABLE, this.getSchemaObjectName(), ChangeInfo.ChangeType.DISCARD, discard + " -> [NULL]");
            return new StringBuilder(0);
        }
        StringBuilder alter = new StringBuilder();
        alter.append("ALTER TABLE ").append(this.getSchemaObjectName());
        alter.append(" ADD ").append((CharSequence)sb);
        if (DbType.OBORACLE_2270.isPriorFrom(this.getDbType())) {
            alter.append(this.safetyMapping(OPTION_MAPPING, status));
            alter.append(this.safetyMapping(OPTION_MAPPING, validated));
        }
        ChangeUtils.warn(ObjectType.TABLE, this.getSchemaObjectName(), ChangeInfo.ChangeType.DISCARD, discard + " -> [NULL]", this.terminate(alter));
        return new StringBuilder(0);
    }

    @Override
    public List<ObjectDefine> compareTo(AbstractConstraint other) {
        if (!(other instanceof ObOracle22xForeignKey)) {
            throw new UnmatchedObjectTypeException("Raw type is not matched");
        }
        String objectName = this.getSimpleObjectName();
        ArrayList<ObjectDefine> objectDefines = new ArrayList<ObjectDefine>();
        ObOracle22xForeignKey target = (ObOracle22xForeignKey)other;
        String srcForeignColumnString = this.joinForeignConstraintColumns().toString();
        String dstForeignColumnString = target.joinRefConstraintColumns().toString();
        boolean isForeignColumnsDiff = StringUtils.notEquals((CharSequence)srcForeignColumnString, (CharSequence)dstForeignColumnString);
        String srcRefOwnerTableName = this.getRefTableOwner() + "." + this.getRefTableName();
        String dstRefOwnerTableName = target.getRefTableOwner() + "." + target.getRefTableName();
        boolean isRefOwnerTableNameDiff = StringUtils.notEquals((CharSequence)srcRefOwnerTableName, (CharSequence)dstRefOwnerTableName);
        String srcRefColumnString = this.getReferencedColumns().stream().map(e -> e.getColumnName()).collect(Collectors.joining(","));
        String dstRefColumnString = target.getReferencedColumns().stream().map(e -> e.getColumnName()).collect(Collectors.joining(","));
        boolean isRefColumnsDiff = StringUtils.notEquals((CharSequence)srcRefColumnString, (CharSequence)dstRefColumnString);
        try {
            if (isForeignColumnsDiff || isRefOwnerTableNameDiff || isRefColumnsDiff) {
                StringBuilder drop = new StringBuilder();
                drop.append("ALTER TABLE ").append(this.getSchemaObjectName());
                drop.append(" DROP CONSTRAINT ").append(this.wrap(target.getConstraintName())).append(" CASCADE;");
                StringBuilder add = new StringBuilder();
                add.append("ALTER TABLE ").append(this.getSchemaObjectName());
                add.append(" ADD ").append((CharSequence)this.buildGrammar()).append(";");
                objectDefines.add(new DropObjectDefine(ObjectType.CONSTRAINT, objectName, drop.toString()));
                objectDefines.add(new AlterObjectDefine(ObjectType.CONSTRAINT, objectName, add.toString()));
            }
            return objectDefines;
        }
        catch (UnsupportedGrammarException e2) {
            return Lists.newArrayList((Object[])new ObjectDefine[]{new UnsupportedObjectDefine(ObjectType.CONSTRAINT, objectName, e2.getMessage())});
        }
    }
}

