/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.model.oboracle22x;

import com.oceanbase.obtools.common.collect.Lists;
import com.oceanbase.obtools.common.utils.NumberUtils;
import com.oceanbase.obtools.common.utils.StringUtils;
import com.oceanbase.obtools.dbdiff.compare.result.AlterObjectDefine;
import com.oceanbase.obtools.dbdiff.compare.result.ChangeInfo;
import com.oceanbase.obtools.dbdiff.compare.result.CreateObjectDefine;
import com.oceanbase.obtools.dbdiff.compare.result.DropObjectDefine;
import com.oceanbase.obtools.dbdiff.compare.result.ObjectDefine;
import com.oceanbase.obtools.dbdiff.compare.result.UnsupportedObjectDefine;
import com.oceanbase.obtools.dbdiff.enums.DbType;
import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import com.oceanbase.obtools.dbdiff.exception.UnmatchedObjectTypeException;
import com.oceanbase.obtools.dbdiff.exception.UnsupportedGrammarException;
import com.oceanbase.obtools.dbdiff.mapper.expression.ExpressionRewriterFactory;
import com.oceanbase.obtools.dbdiff.model.AbstractIndex;
import com.oceanbase.obtools.dbdiff.model.oboracle22x.ObOracle22xIndexPartition;
import com.oceanbase.obtools.dbdiff.model.oboracle22x.ObOracle22xSchema;
import com.oceanbase.obtools.dbdiff.model.oracle.AbstractOracleIndex;
import com.oceanbase.obtools.dbdiff.model.oracle.AbstractOracleIndexPartition;
import com.oceanbase.obtools.dbdiff.utils.ChangeUtils;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ObOracle22xIndex
extends AbstractOracleIndex {
    private String segmentCreated;
    private ObOracle22xIndexPartition indexPartition;

    public ObOracle22xIndex(ObOracle22xSchema schema) {
        super(schema);
    }

    @Override
    public List<ObjectDefine> buildDefinition() throws UnsupportedGrammarException {
        String comment;
        ObOracle22xIndexPartition indexPartition;
        this.preProcessMeta();
        String indexType = this.getIndexType();
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE");
        String indexName = this.getSchemaIndexName();
        sb.append(this.safetyMapping(this.getUniqueRuleMapping(), this.getUniqueness()));
        if (this.getUniqueRuleMapping().containsKey(this.getUniqueness())) {
            this.addUniqueAttribute();
        }
        sb.append(" INDEX ").append(indexName);
        sb.append(" ON ").append(this.getDefinitionSchemaObjectName()).append((CharSequence)this.joinIndexColumns());
        if (StringUtils.contains((String)indexType, (String)"NORMAL/REV")) {
            sb.append(" REVERSE");
        }
        if ((indexPartition = this.getIndexPartition()) != null) {
            sb.append((CharSequence)indexPartition.buildGrammar());
        }
        if (StringUtils.isNotBlank((CharSequence)(comment = this.getComment()))) {
            sb.append(" COMMENT ").append("'" + comment.replace("'", "''") + "'");
        }
        if ("INVISIBLE".equals(this.getVisibility())) {
            sb.append(" INVISIBLE");
        }
        return Lists.newArrayList((Object[])new ObjectDefine[]{new CreateObjectDefine(ObjectType.INDEX, this.getIndexType(), this.getSimpleIndexName(), this.terminate(sb))});
    }

    @Override
    public StringBuilder buildGrammar() throws UnsupportedGrammarException {
        String comment;
        ObOracle22xIndexPartition indexPartition;
        this.preProcessMeta();
        StringBuilder sb = new StringBuilder();
        String indexName = this.getSchemaIndexName();
        String indexType = this.getIndexType();
        sb.append(this.safetyMapping(this.getUniqueRuleMapping(), this.getUniqueness()));
        if (this.getUniqueRuleMapping().containsKey(this.getUniqueness())) {
            this.addUniqueAttribute();
        }
        sb.append("INDEX ").append(indexName);
        sb.append(" ").append((CharSequence)this.joinIndexColumns());
        if (StringUtils.contains((String)indexType, (String)"NORMAL/REV")) {
            sb.append(" REVERSE");
        }
        if ((indexPartition = this.getIndexPartition()) != null) {
            sb.append((CharSequence)indexPartition.buildGrammar());
        }
        if (StringUtils.isNotBlank((CharSequence)(comment = this.getComment()))) {
            sb.append(" COMMENT ").append("'" + comment.replace("'", "''") + "'");
        }
        if ("INVISIBLE".equals(this.getVisibility())) {
            sb.append(" INVISIBLE");
        }
        return sb;
    }

    private void preProcessMeta() throws UnsupportedGrammarException {
        String indexType = this.getIndexType();
        if ("DOMAIN".equals(indexType)) {
            throw new UnsupportedGrammarException(this.getOriginSchemaObjectName(), "The domain index is unsupported");
        }
        boolean isReverseIndex = StringUtils.contains((String)indexType, (String)"NORMAL/REV");
        if (DbType.OBORACLE_2271.isSubsequentFrom(super.getDbType()) && isReverseIndex) {
            throw new UnsupportedGrammarException(this.getOriginSchemaObjectName(), "The reverse index is unsupported");
        }
        if ("YES".equals(this.getJoinIndex())) {
            throw new UnsupportedGrammarException(this.getOriginSchemaObjectName(), "The join index is unsupported");
        }
        if ("BITMAP".equals(indexType)) {
            ChangeUtils.warn(ObjectType.TABLE, this.getSchemaObjectName(), ChangeInfo.ChangeType.CONVERT, "BITMAP INDEX " + this.getSchemaIndexName() + " -> INDEX");
        }
    }

    public boolean isInnerDefineSupported() {
        if ("UNIQUE".equalsIgnoreCase(this.getUniqueness())) {
            return false;
        }
        DbType dbType = this.getDbType();
        if (DbType.OBORACLE_410.isPriorFrom(dbType)) {
            return false;
        }
        return this.getIndexPartition() == null;
    }

    @Override
    public StringBuilder joinIndexColumns() {
        ArrayList originIndexColumns = new ArrayList();
        ArrayList changeIndexColumns = new ArrayList();
        this.getIndexColumns().stream().filter(e -> !"I".equals(e.getColumnOrder())).forEach(e -> {
            String columnOrder;
            String columnName = ExpressionRewriterFactory.getRewriter(this.getGlobal(), this.getOriginDbType()).rewriteIndexExpr(e.getColumnName());
            if (!e.isExpression()) {
                columnName = this.wrap(columnName);
            }
            if (StringUtils.isNotBlank((CharSequence)(columnOrder = this.getCollationMapping().get(e.getColumnOrder())))) {
                originIndexColumns.add(columnName + columnOrder);
                changeIndexColumns.add(columnName + " " + "ASC");
            } else {
                originIndexColumns.add(columnName);
                changeIndexColumns.add(columnName);
            }
        });
        ArrayList includeIndexColumns = new ArrayList();
        this.getIndexColumns().stream().filter(e -> "I".equals(e.getColumnOrder())).forEach(e -> {
            String columnName = e.getColumnName();
            if (!e.isExpression()) {
                columnName = this.wrap(columnName);
            }
            includeIndexColumns.add(columnName);
        });
        StringBuilder originIndexClause = new StringBuilder();
        originIndexClause.append((CharSequence)this.enclose(originIndexColumns.stream().collect(Collectors.joining(", "))));
        StringBuilder changeIndexClause = new StringBuilder();
        changeIndexClause.append((CharSequence)this.enclose(changeIndexColumns.stream().collect(Collectors.joining(", "))));
        if (!includeIndexColumns.isEmpty()) {
            String includeClause = includeIndexColumns.stream().collect(Collectors.joining(", "));
            originIndexClause.append(" INCLUDE").append((CharSequence)this.enclose(includeClause));
            changeIndexClause.append(" STORING").append((CharSequence)this.enclose(includeClause));
        }
        if (StringUtils.notEquals((CharSequence)originIndexClause, (CharSequence)changeIndexClause)) {
            ChangeUtils.warn(ObjectType.TABLE, this.getSchemaObjectName(), ChangeInfo.ChangeType.CONVERT, originIndexClause + " -> " + changeIndexClause);
        }
        return changeIndexClause;
    }

    @Override
    public List<ObjectDefine> compareTo(AbstractIndex other) {
        if (!(other instanceof ObOracle22xIndex)) {
            throw new UnmatchedObjectTypeException("Raw type is not matched");
        }
        ObOracle22xIndex target = (ObOracle22xIndex)other;
        String srcColumnString = this.joinIndexColumns().toString();
        String dstColumnString = target.joinIndexColumns().toString();
        ObOracle22xIndexPartition srcIndexPartition = this.getIndexPartition();
        ObOracle22xIndexPartition dstIndexPartition = target.getIndexPartition();
        try {
            if (StringUtils.notEquals((CharSequence)srcColumnString, (CharSequence)dstColumnString) || srcIndexPartition == null && dstIndexPartition != null || srcIndexPartition != null && dstIndexPartition == null || StringUtils.notEquals((CharSequence)this.getIndexType(), (CharSequence)target.getIndexType()) || StringUtils.notEquals((CharSequence)this.getUniqueness(), (CharSequence)target.getUniqueness())) {
                ArrayList objectDefines = Lists.newArrayList((Object[])new ObjectDefine[0]);
                objectDefines.add(this.buildDropDefinition());
                objectDefines.addAll(target.buildDefinition());
                return objectDefines;
            }
            if (srcIndexPartition != null && dstIndexPartition != null) {
                return this.compareIndexPartition(this, target);
            }
            return Lists.newArrayList((Object[])new ObjectDefine[0]);
        }
        catch (UnsupportedGrammarException e) {
            return Lists.newArrayList((Object[])new ObjectDefine[]{new UnsupportedObjectDefine(ObjectType.INDEX, this.getSimpleObjectName(), e.getMessage())});
        }
    }

    private List<ObjectDefine> compareIndexPartition(ObOracle22xIndex source, ObOracle22xIndex target) throws UnsupportedGrammarException {
        String objectName = source.getSimpleObjectName();
        ObOracle22xIndexPartition srcIdxPartition = source.getIndexPartition();
        ObOracle22xIndexPartition dstIdxPartition = target.getIndexPartition();
        String srcLocality = srcIdxPartition.getLocality();
        String dstLocality = dstIdxPartition.getLocality();
        ArrayList<ObjectDefine> objectDefines = new ArrayList<ObjectDefine>();
        if (StringUtils.notEquals((CharSequence)srcLocality, (CharSequence)dstLocality)) {
            objectDefines.add(this.buildDropDefinition());
            objectDefines.addAll(target.buildDefinition());
            return objectDefines;
        }
        if (dstLocality != null && "GLOBAL".equals(srcLocality)) {
            String dstColumnString;
            String srcPartType = srcIdxPartition.getPartitioningType();
            String dstPartType = dstIdxPartition.getPartitioningType();
            String srcSubPartType = srcIdxPartition.getSubPartitioningType();
            String dstSubPartType = dstIdxPartition.getSubPartitioningType();
            boolean isHashPart = "HASH".equals(srcPartType);
            boolean isHashSubPart = "HASH".equals(srcSubPartType);
            Integer srcPartitionCount = srcIdxPartition.getPartitionCount();
            Integer dstPartitionCount = dstIdxPartition.getPartitionCount();
            Integer srcDefSubPartitionCount = srcIdxPartition.getDefSubPartitionCount();
            Integer dstDefSubPartitionCount = dstIdxPartition.getDefSubPartitionCount();
            String srcColumnString = srcIdxPartition.getIndexPartitionColumns().stream().map(e -> e.getColumnName()).collect(Collectors.joining(","));
            if (StringUtils.notEquals((CharSequence)srcColumnString, (CharSequence)(dstColumnString = dstIdxPartition.getIndexPartitionColumns().stream().map(e -> e.getColumnName()).collect(Collectors.joining(",")))) || StringUtils.notEquals((CharSequence)srcPartType, (CharSequence)dstPartType) || StringUtils.notEquals((CharSequence)srcSubPartType, (CharSequence)dstSubPartType) || isHashPart && NumberUtils.notEquals((Number)srcPartitionCount, (Number)dstPartitionCount) || isHashSubPart && NumberUtils.notEquals((Number)srcDefSubPartitionCount, (Number)dstDefSubPartitionCount)) {
                StringBuilder sb = new StringBuilder();
                objectDefines.add(this.buildDropDefinition());
                sb.append("DROP INDEX ").append(target.getWrappedIndexName());
                objectDefines.addAll(target.buildDefinition());
                return Lists.newArrayList((Object[])new ObjectDefine[]{new DropObjectDefine(ObjectType.INDEX, objectName, this.terminate(sb), this.buildDefinition())});
            }
            if (!isHashPart) {
                StringBuilder sb;
                LinkedHashMap<String, AbstractOracleIndexPartition.OracleIndexPartitionItem> srcPartNameMap = new LinkedHashMap<String, AbstractOracleIndexPartition.OracleIndexPartitionItem>();
                LinkedHashMap<String, AbstractOracleIndexPartition.OracleIndexPartitionItem> srcPartValueMap = new LinkedHashMap<String, AbstractOracleIndexPartition.OracleIndexPartitionItem>();
                for (AbstractOracleIndexPartition.OracleIndexPartitionItem item : srcIdxPartition.getIndexPartitions()) {
                    srcPartNameMap.putIfAbsent(item.getPartitionName(), item);
                    srcPartValueMap.putIfAbsent(item.getHighValue(), item);
                }
                LinkedHashMap<String, AbstractOracleIndexPartition.OracleIndexPartitionItem> dstPartNameMap = new LinkedHashMap<String, AbstractOracleIndexPartition.OracleIndexPartitionItem>();
                LinkedHashMap<String, AbstractOracleIndexPartition.OracleIndexPartitionItem> dstPartValueMap = new LinkedHashMap<String, AbstractOracleIndexPartition.OracleIndexPartitionItem>();
                for (AbstractOracleIndexPartition.OracleIndexPartitionItem oracleIndexPartitionItem : dstIdxPartition.getIndexPartitions()) {
                    dstPartNameMap.putIfAbsent(oracleIndexPartitionItem.getPartitionName(), oracleIndexPartitionItem);
                    dstPartValueMap.putIfAbsent(oracleIndexPartitionItem.getHighValue(), oracleIndexPartitionItem);
                }
                for (Map.Entry entry : srcPartNameMap.entrySet()) {
                    String srcHighValue = ((AbstractOracleIndexPartition.OracleIndexPartitionItem)entry.getValue()).getHighValue();
                    AbstractOracleIndexPartition.OracleIndexPartitionItem dstPartItem = (AbstractOracleIndexPartition.OracleIndexPartitionItem)dstPartNameMap.get(entry.getKey());
                    if (dstPartItem == null) {
                        dstPartItem = (AbstractOracleIndexPartition.OracleIndexPartitionItem)dstPartValueMap.get(srcHighValue);
                        if (dstPartItem == null) {
                            sb = new StringBuilder();
                            sb.append("ALTER TABLE ").append(source.getSchemaObjectName());
                            sb.append(" ADD PARTITION ").append(this.wrap((String)entry.getKey()));
                            objectDefines.add(new AlterObjectDefine(ObjectType.INDEX, objectName, this.terminate(sb)));
                            continue;
                        }
                        sb = new StringBuilder();
                        sb.append("ALTER TABLE ").append(source.getSchemaObjectName()).append(" RENAME PARTITION ");
                        sb.append(this.wrap(dstPartItem.getPartitionName())).append(" TO ").append(this.wrap((String)entry.getKey()));
                        objectDefines.add(new AlterObjectDefine(ObjectType.INDEX, objectName, this.terminate(sb)));
                        continue;
                    }
                    String dstHighValue = dstPartItem.getHighValue();
                    if (!StringUtils.notEquals((CharSequence)srcHighValue, (CharSequence)dstHighValue)) continue;
                    StringBuilder drop = new StringBuilder();
                    drop.append("ALTER TABLE ").append(source.getSchemaObjectName());
                    drop.append(" DROP PARTITION ").append(this.wrap(dstPartItem.getPartitionName()));
                    StringBuilder add = new StringBuilder();
                    add.append("ALTER TABLE ").append(source.getSchemaObjectName());
                    add.append(" ADD PARTITION ").append(this.wrap((String)entry.getKey()));
                    objectDefines.add(new DropObjectDefine(ObjectType.INDEX, objectName, this.terminate(drop), Lists.newArrayList((Object[])new ObjectDefine[]{new AlterObjectDefine(ObjectType.INDEX, objectName, this.terminate(add))})));
                }
                for (Map.Entry entry : dstPartNameMap.entrySet()) {
                    String dstHighValue = ((AbstractOracleIndexPartition.OracleIndexPartitionItem)entry.getValue()).getHighValue();
                    AbstractOracleIndexPartition.OracleIndexPartitionItem srcPartItem = (AbstractOracleIndexPartition.OracleIndexPartitionItem)srcPartNameMap.get(entry.getKey());
                    if (srcPartItem != null || (srcPartItem = (AbstractOracleIndexPartition.OracleIndexPartitionItem)srcPartValueMap.get(dstHighValue)) != null) continue;
                    sb = new StringBuilder();
                    sb.append("ALTER TABLE ").append(source.getSchemaObjectName());
                    sb.append(" DROP PARTITION ").append(this.wrap((String)entry.getKey()));
                    objectDefines.add(new DropObjectDefine(ObjectType.INDEX, objectName, this.terminate(sb)));
                }
            }
        }
        return objectDefines;
    }

    public String getSegmentCreated() {
        return this.segmentCreated;
    }

    public void setSegmentCreated(String segmentCreated) {
        this.segmentCreated = segmentCreated;
    }

    public ObOracle22xIndexPartition getIndexPartition() {
        return this.indexPartition;
    }

    public void setIndexPartition(ObOracle22xIndexPartition indexPartition) {
        this.indexPartition = indexPartition;
    }
}

