/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.model.oboracle22x;

import com.google.common.collect.Lists;
import com.oceanbase.obtools.common.utils.StringUtils;
import com.oceanbase.obtools.dbdiff.compare.result.AlterObjectDefine;
import com.oceanbase.obtools.dbdiff.compare.result.DropObjectDefine;
import com.oceanbase.obtools.dbdiff.compare.result.ObjectDefine;
import com.oceanbase.obtools.dbdiff.compare.result.UnsupportedObjectDefine;
import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import com.oceanbase.obtools.dbdiff.exception.UnmatchedObjectTypeException;
import com.oceanbase.obtools.dbdiff.exception.UnsupportedGrammarException;
import com.oceanbase.obtools.dbdiff.model.AbstractConstraint;
import com.oceanbase.obtools.dbdiff.model.oboracle.AbstractObOracleConstraint;
import com.oceanbase.obtools.dbdiff.model.oboracle22x.ObOracle22xSchema;
import java.util.ArrayList;
import java.util.List;

public class ObOracle22xPrimaryKey
extends AbstractObOracleConstraint {
    public ObOracle22xPrimaryKey(ObOracle22xSchema schema) {
        super(schema);
    }

    @Override
    public StringBuilder buildGrammar() throws UnsupportedGrammarException {
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)this.getConstraintName())) {
            sb.append("CONSTRAINT ").append(this.wrap(this.getConstraintName())).append(" ");
        }
        sb.append("PRIMARY KEY").append((CharSequence)this.joinConstraintColumns());
        String status = this.getStatus();
        String validated = this.getValidated();
        if (super.getSchema().isDumpOperation()) {
            return sb;
        }
        if ("DISABLED".equalsIgnoreCase(status) || "NOT VALIDATED".equalsIgnoreCase(validated)) {
            sb.append(this.safetyMapping(OPTION_MAPPING, status));
            sb.append(this.safetyMapping(OPTION_MAPPING, validated));
        }
        return sb;
    }

    @Override
    public List<ObjectDefine> compareTo(AbstractConstraint other) {
        if (!(other instanceof ObOracle22xPrimaryKey)) {
            throw new UnmatchedObjectTypeException("Raw type is not matched");
        }
        try {
            String dstColumnString;
            String srcColumnString;
            ArrayList<ObjectDefine> objectDefines = new ArrayList<ObjectDefine>();
            ObOracle22xPrimaryKey target = (ObOracle22xPrimaryKey)other;
            if (StringUtils.notEquals((CharSequence)this.getConstraintName(), (CharSequence)target.getConstraintName())) {
                StringBuilder alter = new StringBuilder("ALTER TABLE ");
                alter.append(this.getSchemaObjectName()).append(" RENAME CONSTRAINT ");
                alter.append(this.wrap(target.getConstraintName()));
                alter.append(" TO ").append(this.wrap(this.getConstraintName())).append(";");
                objectDefines.add(new DropObjectDefine(ObjectType.TABLE, this.getSimpleObjectName(), alter.toString()));
            }
            if (StringUtils.notEquals((CharSequence)(srcColumnString = this.joinConstraintColumns().toString()), (CharSequence)(dstColumnString = target.joinConstraintColumns().toString()))) {
                StringBuilder drop = new StringBuilder();
                drop.append("ALTER TABLE ").append(this.getSchemaObjectName());
                drop.append(" DROP CONSTRAINT ").append(this.wrap(target.getConstraintName())).append(" CASCADE;");
                StringBuilder add = new StringBuilder();
                add.append("ALTER TABLE ").append(this.getSchemaObjectName());
                add.append(" ADD ").append((CharSequence)this.buildGrammar()).append(";");
                objectDefines.add(new DropObjectDefine(ObjectType.CONSTRAINT, this.getSimpleObjectName(), drop.toString()));
                objectDefines.add(new AlterObjectDefine(ObjectType.CONSTRAINT, this.getSimpleObjectName(), add.toString()));
            }
            return objectDefines;
        }
        catch (UnsupportedGrammarException e) {
            return Lists.newArrayList((Object[])new ObjectDefine[]{new UnsupportedObjectDefine(ObjectType.CONSTRAINT, this.getSimpleObjectName(), e.getMessage())});
        }
    }
}

