/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.model.oboracle22x;

import com.oceanbase.obtools.common.collect.Lists;
import com.oceanbase.obtools.dbdiff.compare.result.ObjectDefine;
import com.oceanbase.obtools.dbdiff.compare.result.UnsupportedObjectDefine;
import com.oceanbase.obtools.dbdiff.enums.DbType;
import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import com.oceanbase.obtools.dbdiff.exception.UnmatchedObjectTypeException;
import com.oceanbase.obtools.dbdiff.exception.UnsupportedGrammarException;
import com.oceanbase.obtools.dbdiff.model.AbstractProcedure;
import com.oceanbase.obtools.dbdiff.model.oboracle22x.ObOracle22xSchema;
import com.oceanbase.obtools.dbdiff.model.oracle.AbstractOracleProcedure;
import java.util.ArrayList;
import java.util.List;

public class ObOracle22xProcedure
extends AbstractOracleProcedure {
    public ObOracle22xProcedure(ObOracle22xSchema schema) {
        super(schema);
    }

    @Override
    public List<ObjectDefine> buildDefinition() throws UnsupportedGrammarException {
        DbType originType = this.getOriginDbType();
        if (!originType.isOracleType()) {
            throw new UnsupportedGrammarException(this.getSchemaObjectName(), "Origin dbType is not allowed to convert to OBORACLE procedures: " + originType);
        }
        return super.buildDefinition();
    }

    @Override
    public List<ObjectDefine> compareTo(AbstractProcedure other) {
        if (!(other instanceof ObOracle22xProcedure)) {
            throw new UnmatchedObjectTypeException("Raw type is not matched");
        }
        ObOracle22xProcedure target = (ObOracle22xProcedure)other;
        ArrayList objectDefines = Lists.newArrayList((Object[])new ObjectDefine[0]);
        if (!this.getText().equals(target.getText())) {
            try {
                objectDefines.addAll(this.buildDefinition());
            }
            catch (UnsupportedGrammarException e) {
                objectDefines.add(new UnsupportedObjectDefine(ObjectType.PROCEDURE, this.getSimpleObjectName(), e.getMessage()));
            }
        }
        return objectDefines;
    }
}

