/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.model.oboracle22x;

import com.oceanbase.obtools.dbdiff.compare.result.AlterObjectDefine;
import com.oceanbase.obtools.dbdiff.compare.result.DropObjectDefine;
import com.oceanbase.obtools.dbdiff.compare.result.ObjectDefine;
import com.oceanbase.obtools.dbdiff.compare.result.UnsupportedObjectDefine;
import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import com.oceanbase.obtools.dbdiff.exception.UnmatchedObjectTypeException;
import com.oceanbase.obtools.dbdiff.exception.UnsupportedGrammarException;
import com.oceanbase.obtools.dbdiff.model.AbstractSequence;
import com.oceanbase.obtools.dbdiff.model.oboracle22x.ObOracle22xSchema;
import com.oceanbase.obtools.dbdiff.model.oracle.AbstractOracleSequence;
import java.util.ArrayList;
import java.util.List;

public class ObOracle22xSequence
extends AbstractOracleSequence {
    public ObOracle22xSequence(ObOracle22xSchema schema) {
        super(schema);
    }

    @Override
    public List<ObjectDefine> compareTo(AbstractSequence other) {
        if (!(other instanceof ObOracle22xSequence)) {
            throw new UnmatchedObjectTypeException("Raw type is not matched");
        }
        ObOracle22xSequence target = (ObOracle22xSequence)other;
        ArrayList<ObjectDefine> objectDefines = new ArrayList<ObjectDefine>();
        boolean isPropDiff = this.getIncrement().compareTo(target.getIncrement()) != 0 || this.getMinValue().compareTo(target.getMinValue()) != 0 || this.getMaxValue().compareTo(target.getMaxValue()) != 0 || this.getCycle().compareTo(target.getCycle()) != 0 || this.getCache().compareTo(target.getCache()) != 0 || this.getOrder().compareTo(target.getOrder()) != 0;
        StringBuilder sb = new StringBuilder();
        if (this.getStart().compareTo(target.getStart()) != 0) {
            sb.append("DROP SEQUENCE ").append(target.getSchemaObjectName());
            try {
                objectDefines.add(new DropObjectDefine(ObjectType.SEQUENCE, this.getSimpleObjectName(), this.terminate(sb), this.buildDefinition()));
            }
            catch (UnsupportedGrammarException e) {
                objectDefines.add(new UnsupportedObjectDefine(ObjectType.SEQUENCE, this.getSimpleObjectName(), e.getMessage()));
            }
        } else if (isPropDiff) {
            sb.append("ALTER SEQUENCE ").append(target.getSchemaObjectName());
            sb.append((CharSequence)this.buildSequenceGrammar());
            objectDefines.add(new AlterObjectDefine(ObjectType.SEQUENCE, this.getSimpleObjectName(), this.terminate(sb)));
        }
        return objectDefines;
    }
}

