/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.model.oboracle22x;

import com.google.common.collect.Sets;
import com.oceanbase.obtools.common.collect.Lists;
import com.oceanbase.obtools.common.utils.CollectionUtils;
import com.oceanbase.obtools.common.utils.MapUtils;
import com.oceanbase.obtools.common.utils.NumberUtils;
import com.oceanbase.obtools.common.utils.StringUtils;
import com.oceanbase.obtools.dbdiff.compare.result.AlterObjectDefine;
import com.oceanbase.obtools.dbdiff.compare.result.ChangeInfo;
import com.oceanbase.obtools.dbdiff.compare.result.CreateObjectDefine;
import com.oceanbase.obtools.dbdiff.compare.result.DropObjectDefine;
import com.oceanbase.obtools.dbdiff.compare.result.ObjectDefine;
import com.oceanbase.obtools.dbdiff.compare.result.UnsupportedObjectDefine;
import com.oceanbase.obtools.dbdiff.compare.result.WrapperObjectDefine;
import com.oceanbase.obtools.dbdiff.constants.JdbcType;
import com.oceanbase.obtools.dbdiff.enums.DbType;
import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import com.oceanbase.obtools.dbdiff.exception.UnmatchedObjectTypeException;
import com.oceanbase.obtools.dbdiff.exception.UnsupportedGrammarException;
import com.oceanbase.obtools.dbdiff.mapper.OrikaBeanMapper;
import com.oceanbase.obtools.dbdiff.model.AbstractConstraint;
import com.oceanbase.obtools.dbdiff.model.AbstractIndex;
import com.oceanbase.obtools.dbdiff.model.AbstractTable;
import com.oceanbase.obtools.dbdiff.model.base.IDefiner;
import com.oceanbase.obtools.dbdiff.model.base.KeyColumn;
import com.oceanbase.obtools.dbdiff.model.oboracle.AbstractObOracleConstraint;
import com.oceanbase.obtools.dbdiff.model.oboracle22x.ObOracle22xCheck;
import com.oceanbase.obtools.dbdiff.model.oboracle22x.ObOracle22xColumn;
import com.oceanbase.obtools.dbdiff.model.oboracle22x.ObOracle22xForeignKey;
import com.oceanbase.obtools.dbdiff.model.oboracle22x.ObOracle22xIndex;
import com.oceanbase.obtools.dbdiff.model.oboracle22x.ObOracle22xPrimaryKey;
import com.oceanbase.obtools.dbdiff.model.oboracle22x.ObOracle22xSchema;
import com.oceanbase.obtools.dbdiff.model.oboracle22x.ObOracle22xSequence;
import com.oceanbase.obtools.dbdiff.model.oboracle22x.ObOracle22xTablePartition;
import com.oceanbase.obtools.dbdiff.model.oboracle22x.ObOracle22xUniqueKey;
import com.oceanbase.obtools.dbdiff.model.oracle.AbstractOracleTable;
import com.oceanbase.obtools.dbdiff.model.oracle.AbstractOracleTablePartition;
import com.oceanbase.obtools.dbdiff.utils.ChangeUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;

public class ObOracle22xTable
extends AbstractOracleTable {
    public static final ArrayList<String> DEFAULT_DELIM_TOKENS = new ArrayList();
    private final Map<String, ObOracle22xColumn> columnMapping = new LinkedHashMap<String, ObOracle22xColumn>();
    private final Map<String, ObOracle22xIndex> indexMapping = new LinkedHashMap<String, ObOracle22xIndex>();
    private final Map<String, ObOracle22xUniqueKey> uniqueMapping = new LinkedHashMap<String, ObOracle22xUniqueKey>();
    private final Map<String, ObOracle22xForeignKey> foreignMapping = new LinkedHashMap<String, ObOracle22xForeignKey>();
    private final Map<String, ObOracle22xCheck> checkMapping = new LinkedHashMap<String, ObOracle22xCheck>();
    private String tableGroupName;
    private ObOracle22xPrimaryKey primaryKey;
    private ObOracle22xTablePartition tablePartition;

    public ObOracle22xTable(ObOracle22xSchema schema) {
        super(schema);
    }

    public static Collection<String> parseGenerateExpr(String expr, Set<String> columnSet) {
        if (StringUtils.isBlank((CharSequence)expr)) {
            return Sets.newLinkedHashSet();
        }
        if (CollectionUtils.isEmpty(columnSet)) {
            throw new IllegalArgumentException("The column set is null");
        }
        int length = expr.length();
        char[] src = expr.toCharArray();
        LinkedHashSet<String> physicalColumnNames = new LinkedHashSet<String>();
        for (String tableColumnName : columnSet) {
            int count = tableColumnName.length();
            int searchTimes = length - count + 1;
            for (int i = 0; i < searchTimes; ++i) {
                String search = String.copyValueOf(src, i, count);
                if (!tableColumnName.equals(search)) continue;
                int prevIdx = i - 1;
                int nextIdx = i + count;
                if (prevIdx > -1 && !DEFAULT_DELIM_TOKENS.contains(String.valueOf(src[prevIdx])) || nextIdx < length && !DEFAULT_DELIM_TOKENS.contains(String.valueOf(src[nextIdx]))) continue;
                physicalColumnNames.add(tableColumnName);
            }
        }
        return physicalColumnNames;
    }

    @Override
    public IDefiner beforeBuildDefinition() throws UnsupportedGrammarException {
        this.preCheck();
        String originDbType = this.getOriginDbType().getType();
        ObOracle22xPrimaryKey primaryKey = this.getPrimaryKey();
        ObOracle22xTablePartition partition = this.getTablePartition();
        Map<String, ObOracle22xUniqueKey> uniqueMapping = this.getUniqueMapping();
        if (!uniqueMapping.isEmpty()) {
            HashSet<String> changedKeys = new HashSet<String>();
            for (Map.Entry<String, ObOracle22xUniqueKey> entry : uniqueMapping.entrySet()) {
                String uniqueName;
                String keyName = entry.getKey();
                if (keyName.equals(uniqueName = entry.getValue().getConstraintName())) continue;
                changedKeys.add(keyName);
            }
            changedKeys.forEach(k -> {
                ObOracle22xUniqueKey uniqueKey = (ObOracle22xUniqueKey)uniqueMapping.get(k);
                uniqueMapping.remove(k);
                uniqueMapping.put(uniqueKey.getConstraintName(), uniqueKey);
            });
        }
        if (super.getGlobal().isOptimum() && primaryKey == null && !uniqueMapping.isEmpty()) {
            primaryKey = this.findAnUniqueAsPrimaryKey(uniqueMapping);
        }
        if (primaryKey == null && !uniqueMapping.isEmpty() && partition != null && this.getDbType().isPrior(DbType.OBORACLE_2250)) {
            throw new UnsupportedGrammarException(this.getOriginSchemaObjectName(), "Create global index on no primary key table is unsupported");
        }
        if (primaryKey != null && partition != null && this.isNonIncludePartitionColumns(primaryKey)) {
            primaryKey = this.includePartitionColumns(partition, primaryKey);
        }
        this.setPrimaryKey(primaryKey);
        if (DbType.PGSQL_10.getType().equalsIgnoreCase(originDbType)) {
            HashSet indexKeyColumns = new HashSet();
            if (primaryKey != null) {
                indexKeyColumns.addAll(primaryKey.getConstraintColumns().stream().map(KeyColumn::getColumnName).collect(Collectors.toList()));
            }
            if (MapUtils.isNotEmpty(uniqueMapping)) {
                uniqueMapping.values().stream().map(AbstractConstraint::getConstraintColumns).map(columns -> columns.stream().map(KeyColumn::getColumnName).collect(Collectors.toList())).forEach(indexKeyColumns::addAll);
            }
            if (MapUtils.isNotEmpty(this.getIndexMapping())) {
                this.getIndexMapping().values().stream().map(AbstractIndex::getIndexColumns).map(columns -> columns.stream().map(KeyColumn::getColumnName).collect(Collectors.toList())).forEach(indexKeyColumns::addAll);
            }
            for (String columnName : indexKeyColumns) {
                String dataType;
                ObOracle22xColumn column = this.getColumnMapping().get(columnName);
                if (column == null) continue;
                switch (dataType = column.getDataType().toUpperCase(Locale.getDefault())) {
                    case "CLOB": {
                        dataType = "VARCHAR2";
                        column.setDataType(dataType);
                        column.setCharLength(16384L);
                        column.setCharUsed("B");
                        ChangeUtils.warn(ObjectType.TABLE, this.getSchemaObjectName(), ChangeInfo.ChangeType.CONVERT, column.getWrappedName() + " " + "CLOB" + " -> " + column.getWrappedName() + " " + "VARCHAR2" + "(" + column.getDataLength() + ")");
                        break;
                    }
                }
            }
        }
        return this;
    }

    @Override
    public List<ObjectDefine> buildDefinition() throws UnsupportedGrammarException {
        StringBuilder grammar;
        List<String> expand;
        StringBuilder sb = new StringBuilder();
        String objectName = this.getDefinitionSchemaObjectName();
        sb.append("CREATE ");
        if ("Y".equals(this.getTemporary())) {
            sb.append("GLOBAL TEMPORARY ");
        }
        sb.append("TABLE ").append(objectName).append(" (");
        LinkedList<ObjectDefine> subDefines = new LinkedList<ObjectDefine>();
        String tableComment = this.getTableComment();
        if (StringUtils.isNotBlank((CharSequence)tableComment)) {
            tableComment = String.format("COMMENT ON TABLE %s IS '%s'", objectName, tableComment.replace("'", "''"));
            subDefines.add(new CreateObjectDefine(ObjectType.COMMENT, objectName, this.terminate(tableComment)));
        }
        Iterator<ObOracle22xColumn> iter = this.getColumnMapping().values().iterator();
        while (iter.hasNext()) {
            String colComment;
            ObOracle22xColumn col = iter.next();
            sb.append("\n\t").append((CharSequence)col.buildGrammar());
            if (iter.hasNext()) {
                sb.append(",");
            }
            if (!StringUtils.isNotBlank((CharSequence)(colComment = col.getColumnComment()))) continue;
            String wrappedName = col.getWrappedName();
            colComment = String.format("COMMENT ON COLUMN %s.%s IS '%s'", objectName, wrappedName, colComment.replace("'", "''"));
            subDefines.add(new CreateObjectDefine(ObjectType.COMMENT, wrappedName, this.terminate(colComment)));
        }
        Map<String, List<String>> columnExpand = this.getGlobal().getColumnExpand();
        if (columnExpand.containsKey(this.getObjectName()) && CollectionUtils.isNotEmpty(expand = columnExpand.get(this.getObjectName()))) {
            sb.append(",");
            String expandStr = expand.stream().map(item -> "\n\t" + item).collect(Collectors.joining(","));
            sb.append(expandStr);
        }
        ObOracle22xPrimaryKey primaryKey = this.getPrimaryKey();
        ObOracle22xTablePartition partition = this.getTablePartition();
        Map<String, ObOracle22xUniqueKey> uniqueMapping = this.getUniqueMapping();
        if (primaryKey != null) {
            primaryKey.setUsingIndexMapping(this.getIndexMapping());
            Iterator<AbstractObOracleConstraint> grammar2 = primaryKey.buildGrammar();
            if (StringUtils.isNotBlank((CharSequence)((Object)grammar2))) {
                sb.append(",").append("\n\t").append((CharSequence)((Object)grammar2));
            }
        }
        if (MapUtils.isNotEmpty(uniqueMapping)) {
            for (ObOracle22xUniqueKey uniqueKey : uniqueMapping.values()) {
                uniqueKey.setUsingIndexMapping(this.getIndexMapping());
                grammar = uniqueKey.buildGrammar();
                if (!StringUtils.isNotBlank((CharSequence)grammar)) continue;
                sb.append(",").append("\n\t").append((CharSequence)grammar);
            }
        }
        if (MapUtils.isNotEmpty(this.getCheckMapping())) {
            for (ObOracle22xCheck check : this.getCheckMapping().values()) {
                grammar = check.buildGrammar();
                if (!StringUtils.isNotBlank((CharSequence)grammar)) continue;
                sb.append(",").append("\n\t").append((CharSequence)grammar);
            }
        }
        if (MapUtils.isNotEmpty(this.getForeignMapping())) {
            for (ObOracle22xForeignKey foreignKey : this.getForeignMapping().values()) {
                grammar = foreignKey.buildGrammar();
                if (!StringUtils.isNotBlank((CharSequence)grammar)) continue;
                sb.append(",").append("\n\t").append((CharSequence)grammar);
            }
        }
        boolean needInternal = this.getGlobal().isDefineIndexInternal();
        if (MapUtils.isNotEmpty(this.getIndexMapping())) {
            Collection<ObOracle22xIndex> indexes = this.getIndexMapping().values();
            Iterator<ObOracle22xIndex> it = indexes.iterator();
            while (it.hasNext()) {
                ObOracle22xIndex index = it.next();
                if (this.isAlreadyIndexed(index)) {
                    it.remove();
                    ChangeUtils.warn(ObjectType.TABLE, this.getSchemaObjectName(), ChangeInfo.ChangeType.DISCARD, "The index \"" + index.getIndexName() + "\" has been removed as it's already indexed on the same columns with constraint");
                    continue;
                }
                if (needInternal && index.isInnerDefineSupported()) {
                    sb.append(",").append("\n\t").append((CharSequence)index.buildGrammar());
                    continue;
                }
                subDefines.addAll(index.buildDefinition());
            }
        }
        sb.append("\n").append(")").append((CharSequence)this.appendTableOptions());
        if (partition != null) {
            sb.append((CharSequence)partition.buildGrammar());
        }
        ArrayList<ObjectDefine> preDefines = new ArrayList<ObjectDefine>();
        for (ObOracle22xColumn column : this.getColumnMapping().values()) {
            Collection<ObOracle22xSequence> sequences = column.getSequenceMapping().values();
            for (ObOracle22xSequence sequence : sequences) {
                preDefines.addAll(sequence.buildDefinition());
            }
        }
        CreateObjectDefine objectDefine = new CreateObjectDefine(ObjectType.TABLE, this.getSimpleObjectName(), this.terminate(sb), subDefines, preDefines);
        objectDefine.getChangeInfos().addAll(ChangeUtils.findByKey(ObjectType.TABLE, this.getSchemaObjectName()));
        return Lists.newArrayList((Object[])new ObjectDefine[]{objectDefine});
    }

    private boolean isNonIncludePartitionColumns(ObOracle22xPrimaryKey primaryKey) {
        Collection<AbstractOracleTablePartition.OracleTablePartitionColumn> subPartitionColumns;
        boolean isIncludePartitionColumns = true;
        Collection<AbstractOracleTablePartition.OracleTablePartitionColumn> partitionColumns = this.getTablePartition().getTablePartitionColumns();
        if (CollectionUtils.isNotEmpty(partitionColumns)) {
            List partitionColumnNames = partitionColumns.stream().map(e -> e.getColumnName()).collect(Collectors.toList());
            isIncludePartitionColumns &= primaryKey.getConstraintColumns().stream().map(e -> e.getColumnName()).collect(Collectors.toList()).removeAll(partitionColumnNames);
        }
        if (CollectionUtils.isNotEmpty(subPartitionColumns = this.getTablePartition().getTableSubPartitionColumns())) {
            List subPartitionColumnNames = subPartitionColumns.stream().map(e -> e.getColumnName()).collect(Collectors.toList());
            isIncludePartitionColumns &= primaryKey.getConstraintColumns().stream().map(e -> e.getColumnName()).collect(Collectors.toList()).removeAll(subPartitionColumnNames);
        }
        return !isIncludePartitionColumns;
    }

    private boolean isAlreadyIndexed(ObOracle22xIndex index) {
        if (index == null) {
            return false;
        }
        List<KeyColumn> indexColumns = index.getIndexColumns();
        if (this.getPrimaryKey() != null && this.isAlreadyIndexed(indexColumns, this.getPrimaryKey().getConstraintColumns())) {
            return true;
        }
        if (MapUtils.isNotEmpty(this.getUniqueMapping())) {
            for (ObOracle22xUniqueKey uniqueKey : this.getUniqueMapping().values()) {
                if (!this.isAlreadyIndexed(indexColumns, uniqueKey.getConstraintColumns())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isAlreadyIndexed(Collection<KeyColumn> indexColumns, Collection<KeyColumn> constColumns) {
        if (indexColumns.size() != constColumns.size()) {
            return false;
        }
        String indexCols = indexColumns.stream().map(e -> {
            String col = e.getColumnName();
            if (col.startsWith("`") && col.endsWith("`") || col.startsWith("\"") && col.endsWith("\"")) {
                col = col.substring(1, col.length() - 1);
            }
            return col;
        }).collect(Collectors.joining(","));
        return indexCols.equals(constColumns.stream().map(e -> e.getColumnName()).collect(Collectors.joining(",")));
    }

    private ObOracle22xPrimaryKey findAnUniqueAsPrimaryKey(Map<String, ObOracle22xUniqueKey> uniqueMapping) {
        Collection<String> numericTypes = JdbcType.numerics();
        Collection<String> stringTypes = JdbcType.strings();
        Collection<String> datetimeTypes = JdbcType.datetimes();
        TreeMap<Integer, List> multimap = new TreeMap<Integer, List>();
        block0: for (ObOracle22xUniqueKey uniqueKey : uniqueMapping.values()) {
            if ("DISABLED".equalsIgnoreCase(uniqueKey.getStatus())) continue;
            List<KeyColumn> keyColumns = uniqueKey.getConstraintColumns();
            Integer totalScore = keyColumns.size();
            for (KeyColumn keyColumn : keyColumns) {
                String columnName = keyColumn.getColumnName();
                ObOracle22xColumn tableColumn = this.getColumnMapping().get(columnName);
                if (tableColumn == null) {
                    throw new IllegalStateException("The unique column: " + this.wrap(columnName) + " is not exists in the table column mapping. Object: " + this.getSchemaObjectName());
                }
                String nullable = tableColumn.getNullable();
                if ("Y".equals(nullable) || "YES".equals(nullable)) continue block0;
                String dataType = tableColumn.getDataType();
                if (numericTypes.contains(dataType)) {
                    totalScore = totalScore + 1;
                    continue;
                }
                if (stringTypes.contains(dataType)) {
                    totalScore = totalScore + 2;
                    continue;
                }
                if (datetimeTypes.contains(dataType)) {
                    totalScore = totalScore + 3;
                    continue;
                }
                totalScore = totalScore + 4;
            }
            List uniqueKeys = multimap.getOrDefault(totalScore, Lists.newArrayList((Object[])new ObOracle22xUniqueKey[0]));
            uniqueKeys.add(uniqueKey);
            multimap.putIfAbsent(totalScore, uniqueKeys);
        }
        if (multimap.isEmpty() || ((List)multimap.firstEntry().getValue()).isEmpty()) {
            return null;
        }
        ObOracle22xUniqueKey bestUnique = (ObOracle22xUniqueKey)((List)multimap.firstEntry().getValue()).get(0);
        String bestUniqueName = bestUnique.getConstraintName();
        this.getUniqueMapping().remove(bestUniqueName);
        OrikaBeanMapper beanMapper = new OrikaBeanMapper.Builder().build();
        ObOracle22xPrimaryKey primaryKey = beanMapper.map(bestUnique, ObOracle22xPrimaryKey.class);
        String newPrimaryKeyName = ("PK_" + primaryKey.getConstraintName()).toUpperCase(Locale.getDefault());
        primaryKey.setConstraintName(newPrimaryKeyName);
        StringBuilder constraintJoiner = bestUnique.joinConstraintColumns();
        ChangeUtils.info(ObjectType.TABLE, this.getSchemaObjectName(), ChangeInfo.ChangeType.CONVERT, "CONSTRAINT " + this.wrapAndEscape(bestUniqueName) + " UNIQUE" + constraintJoiner + " -> CONSTRAINT " + this.wrap(newPrimaryKeyName) + " PRIMARY KEY" + constraintJoiner);
        return primaryKey;
    }

    private ObOracle22xPrimaryKey includePartitionColumns(ObOracle22xTablePartition partition, ObOracle22xPrimaryKey primaryKey) {
        List<String> keyColumnNames = primaryKey.getConstraintColumns().stream().map(e -> e.getColumnName()).collect(Collectors.toList());
        if (DbType.OBORACLE_2250.isPriorFrom(this.getDbType())) {
            for (String keyColumnName : keyColumnNames) {
                ObOracle22xColumn column = this.getColumnMapping().get(keyColumnName);
                if (column == null) {
                    throw new IllegalStateException("The key column: " + this.wrap(keyColumnName) + " is not exists in the table column mapping. Object: " + this.getSchemaObjectName());
                }
                column.setNullable("NO");
            }
            OrikaBeanMapper beanMapper = new OrikaBeanMapper.Builder().build();
            ObOracle22xUniqueKey unique = beanMapper.map(primaryKey, ObOracle22xUniqueKey.class);
            this.getUniqueMapping().put(unique.getConstraintName(), unique);
            StringBuilder constraintJoiner = unique.joinConstraintColumns();
            ChangeUtils.info(ObjectType.TABLE, this.getSchemaObjectName(), ChangeInfo.ChangeType.CONVERT, "CONSTRAINT " + this.wrap(unique.getConstraintName()) + " PRIMARY KEY" + constraintJoiner + " -> CONSTRAINT " + this.wrap(unique.getConstraintName()) + " UNIQUE" + constraintJoiner);
            primaryKey = null;
            return null;
        }
        String beforeColumns = keyColumnNames.stream().map(e -> this.wrap((String)e)).collect(Collectors.joining(","));
        boolean flag1 = this.appendToPrimaryColumns(primaryKey, keyColumnNames, partition.getTablePartitionColumns());
        boolean flag2 = this.appendToPrimaryColumns(primaryKey, keyColumnNames, partition.getTableSubPartitionColumns());
        String afterColumns = keyColumnNames.stream().map(e -> this.wrap((String)e)).collect(Collectors.joining(","));
        if (flag1 || flag2) {
            String schemaObjectName = this.getSchemaObjectName();
            StringBuilder enclosedString = this.enclose(beforeColumns);
            ChangeUtils.warn(ObjectType.TABLE, schemaObjectName, ChangeInfo.ChangeType.CONVERT, "PRIMARY KEY" + enclosedString + " -> PRIMARY KEY" + this.enclose(afterColumns), "-- CREATE UNIQUE INDEX \"GEN_" + this.getObjectName() + "_IDX\" ON " + schemaObjectName + enclosedString + " GLOBAL PARTITION BY HASH" + enclosedString + " PARTITIONES n");
        }
        return primaryKey;
    }

    private boolean appendToPrimaryColumns(ObOracle22xPrimaryKey primaryKey, List<String> keyColumnNames, Collection<AbstractOracleTablePartition.OracleTablePartitionColumn> partitionColumns) {
        boolean flag = false;
        if (CollectionUtils.isEmpty(partitionColumns)) {
            return flag;
        }
        for (AbstractOracleTablePartition.OracleTablePartitionColumn column : partitionColumns) {
            String partColumnName = column.getColumnName();
            ObOracle22xColumn tableColumn = this.getColumnMapping().get(partColumnName);
            if (tableColumn == null) {
                throw new IllegalStateException("The (sub)partition column: " + this.wrap(partColumnName) + " is not exists in the table column mapping. Object: " + this.getSchemaObjectName());
            }
            if ("YES".equals(tableColumn.getVirtualColumn())) {
                Set<String> columnSet = this.getColumnMapping().keySet();
                String columnDefault = tableColumn.getColumnDefault();
                Collection<String> physicalColumnNames = ObOracle22xTable.parseGenerateExpr(columnDefault, columnSet);
                for (String physicalColumnName : physicalColumnNames) {
                    if (keyColumnNames.contains(physicalColumnName)) continue;
                    flag = true;
                    keyColumnNames.add(physicalColumnName);
                    primaryKey.getConstraintColumns().add(new KeyColumn(physicalColumnName, keyColumnNames.size()));
                }
                continue;
            }
            if (keyColumnNames.contains(partColumnName)) continue;
            flag = true;
            keyColumnNames.add(partColumnName);
            primaryKey.getConstraintColumns().add(new KeyColumn(partColumnName, keyColumnNames.size()));
        }
        return flag;
    }

    private StringBuilder appendTableOptions() throws UnsupportedGrammarException {
        String tableGroupName;
        String duration;
        String rowMovement;
        Integer maxTrans;
        Integer iniTrans;
        Integer pctUsed;
        StringBuilder sb = new StringBuilder();
        Integer pctFree = this.getPctFree();
        if (pctFree != null && pctFree > 0) {
            sb.append(" PCTFREE ").append(pctFree);
        }
        if ((pctUsed = this.getPctUsed()) != null && pctUsed > 0) {
            sb.append(" PCTUSED ").append(pctUsed);
        }
        if ((iniTrans = this.getIniTrans()) != null && iniTrans > 0) {
            sb.append(" INITRANS ").append(iniTrans);
        }
        if ((maxTrans = this.getMaxTrans()) != null && maxTrans > 0) {
            sb.append(" MAXTRANS ").append(maxTrans);
        }
        boolean isCompressed = "ENABLED".equals(this.getCompression());
        String compressFor = this.safetyMapping(this.getCompressMapping(), this.getCompressFor());
        if (isCompressed && StringUtils.isNotBlank((CharSequence)compressFor)) {
            sb.append(compressFor);
        }
        if ("ENABLE".equals(rowMovement = super.getRowMovement()) && "ENABLED".equals(rowMovement)) {
            sb.append(" ENABLE ROW MOVEMENT");
        }
        if ("SYS$TRANSACTION".equals(duration = this.getDuration())) {
            sb.append(" ON COMMIT DELETE ROWS");
        } else if ("SYS$SESSION".equals(duration)) {
            sb.append(" ON COMMIT PRESERVE ROWS");
        }
        String tablespaceName = this.getTablespaceName();
        if (StringUtils.isNotBlank((CharSequence)tablespaceName)) {
            sb.append(" TABLESPACE ").append(this.wrapAndEscape(tablespaceName));
        }
        if (StringUtils.isNotBlank((CharSequence)(tableGroupName = this.getTableGroupName()))) {
            sb.append(" TABLEGROUP ").append(this.wrapAndEscape(tableGroupName));
        }
        return sb;
    }

    @Override
    public List<ObjectDefine> compareTo(AbstractTable other) {
        if (!(other instanceof ObOracle22xTable)) {
            throw new UnmatchedObjectTypeException("Raw type is not matched");
        }
        ObOracle22xTable target = (ObOracle22xTable)other;
        ArrayList<ObjectDefine> objectDefines = new ArrayList<ObjectDefine>();
        CollectionUtils.addAllIgnoreNull(objectDefines, this.compareColumnMapping(target));
        CollectionUtils.addAllIgnoreNull(objectDefines, this.comparePrimaryKey(target));
        CollectionUtils.addAllIgnoreNull(objectDefines, this.compareUniqueMapping(target));
        CollectionUtils.addAllIgnoreNull(objectDefines, this.compareCheckMapping(target));
        CollectionUtils.addAllIgnoreNull(objectDefines, this.compareIndexMapping(target));
        CollectionUtils.addAllIgnoreNull(objectDefines, this.compareForeignMapping(target));
        CollectionUtils.addAllIgnoreNull(objectDefines, this.compareTablePartition(target));
        CollectionUtils.addAllIgnoreNull(objectDefines, this.compareTableOption(target));
        if (CollectionUtils.isEmpty(objectDefines)) {
            return null;
        }
        return Lists.newArrayList((Object[])new ObjectDefine[]{new WrapperObjectDefine(ObjectType.TABLE, this.getSimpleObjectName(), objectDefines)});
    }

    private List<ObjectDefine> compareColumnMapping(ObOracle22xTable target) {
        ArrayList<ObjectDefine> objectDefines = new ArrayList<ObjectDefine>();
        Map<String, ObOracle22xColumn> srcColumnMap = this.getColumnMapping();
        Map<String, ObOracle22xColumn> dstColumnMap = target.getColumnMapping();
        if (MapUtils.isNotEmpty(srcColumnMap)) {
            for (Map.Entry<String, ObOracle22xColumn> entry : srcColumnMap.entrySet()) {
                ObOracle22xColumn dstColumn = dstColumnMap.get(entry.getKey());
                if (dstColumn == null) {
                    objectDefines.add(entry.getValue().buildAddDefinition());
                    continue;
                }
                CollectionUtils.addAllIgnoreNull(objectDefines, entry.getValue().compareTo(dstColumn));
            }
        }
        if (MapUtils.isNotEmpty(dstColumnMap)) {
            for (Map.Entry<String, ObOracle22xColumn> entry : dstColumnMap.entrySet()) {
                ObOracle22xColumn srcColumn = srcColumnMap.get(entry.getKey());
                if (srcColumn != null) continue;
                objectDefines.add(entry.getValue().buildDropDefinition());
            }
        }
        return objectDefines;
    }

    private List<ObjectDefine> comparePrimaryKey(ObOracle22xTable target) {
        ArrayList<ObjectDefine> objectDefines = new ArrayList<ObjectDefine>();
        ObOracle22xPrimaryKey srcPrimaryKey = this.getPrimaryKey();
        ObOracle22xPrimaryKey dstPrimaryKey = target.getPrimaryKey();
        if (srcPrimaryKey != null && dstPrimaryKey == null) {
            objectDefines.add(srcPrimaryKey.buildAddDefinition());
        }
        if (srcPrimaryKey == null && dstPrimaryKey != null) {
            objectDefines.add(dstPrimaryKey.buildDropDefinition());
        }
        if (srcPrimaryKey != null && dstPrimaryKey != null) {
            CollectionUtils.addAllIgnoreNull(objectDefines, srcPrimaryKey.compareTo(dstPrimaryKey));
        }
        return objectDefines;
    }

    private List<ObjectDefine> compareUniqueMapping(ObOracle22xTable target) {
        ArrayList<ObjectDefine> objectDefines = new ArrayList<ObjectDefine>();
        HashMap<String, ObOracle22xUniqueKey> srcUniqueColMap = new HashMap<String, ObOracle22xUniqueKey>();
        Map<String, ObOracle22xUniqueKey> srcUniqueMap = this.getUniqueMapping();
        for (Map.Entry<String, ObOracle22xUniqueKey> entry : srcUniqueMap.entrySet()) {
            srcUniqueColMap.put(entry.getValue().joinConstraintColumns().toString(), entry.getValue());
        }
        HashMap<String, ObOracle22xUniqueKey> dstUniqueColMap = new HashMap<String, ObOracle22xUniqueKey>();
        Map<String, ObOracle22xUniqueKey> dstUniqueMap = target.getUniqueMapping();
        for (Map.Entry<String, ObOracle22xUniqueKey> entry : dstUniqueMap.entrySet()) {
            dstUniqueColMap.put(entry.getValue().joinConstraintColumns().toString(), entry.getValue());
        }
        if (MapUtils.isNotEmpty(srcUniqueMap)) {
            for (Map.Entry<String, ObOracle22xUniqueKey> entry : srcUniqueMap.entrySet()) {
                ObOracle22xUniqueKey dstUnique = dstUniqueMap.get(entry.getKey());
                if (dstUnique == null) {
                    dstUnique = (ObOracle22xUniqueKey)dstUniqueColMap.get(entry.getValue().joinConstraintColumns().toString());
                    if (dstUnique == null) {
                        objectDefines.add(entry.getValue().buildAddDefinition());
                        continue;
                    }
                    objectDefines.add(dstUnique.buildRenameDefinition(entry.getKey(), target.getSchemaName()));
                    continue;
                }
                CollectionUtils.addAllIgnoreNull(objectDefines, entry.getValue().compareTo(dstUnique));
            }
        }
        if (MapUtils.isNotEmpty(dstUniqueMap)) {
            for (Map.Entry<String, ObOracle22xUniqueKey> entry : dstUniqueMap.entrySet()) {
                ObOracle22xUniqueKey srcUnique = srcUniqueMap.get(entry.getKey());
                if (srcUnique != null || (srcUnique = (ObOracle22xUniqueKey)srcUniqueColMap.get(entry.getValue().joinConstraintColumns().toString())) != null) continue;
                objectDefines.add(entry.getValue().buildDropDefinition());
            }
        }
        return objectDefines;
    }

    private List<ObjectDefine> compareForeignMapping(ObOracle22xTable target) {
        HashMap<String, ObOracle22xForeignKey> srcFkColMap = new HashMap<String, ObOracle22xForeignKey>();
        Map<String, ObOracle22xForeignKey> srcForeignMap = this.getForeignMapping();
        for (Map.Entry<String, ObOracle22xForeignKey> entry : srcForeignMap.entrySet()) {
            srcFkColMap.put(entry.getValue().buildUniqueReference(), entry.getValue());
        }
        HashMap<String, ObOracle22xForeignKey> dstFkColMap = new HashMap<String, ObOracle22xForeignKey>();
        Map<String, ObOracle22xForeignKey> dstForeignMap = target.getForeignMapping();
        for (Map.Entry<String, ObOracle22xForeignKey> entry : dstForeignMap.entrySet()) {
            dstFkColMap.put(entry.getValue().buildUniqueReference(), entry.getValue());
        }
        ArrayList<ObjectDefine> objectDefines = new ArrayList<ObjectDefine>();
        if (MapUtils.isNotEmpty(srcForeignMap)) {
            for (Map.Entry<String, ObOracle22xForeignKey> entry : srcForeignMap.entrySet()) {
                ObOracle22xForeignKey dstRef = dstForeignMap.get(entry.getKey());
                if (dstRef == null) {
                    dstRef = (ObOracle22xForeignKey)dstFkColMap.get(entry.getValue().buildUniqueReference());
                    if (dstRef == null) {
                        objectDefines.add(entry.getValue().buildAddDefinition());
                        continue;
                    }
                    objectDefines.add(dstRef.buildRenameDefinition(entry.getKey(), target.getSchemaName()));
                    continue;
                }
                CollectionUtils.addAllIgnoreNull(objectDefines, entry.getValue().compareTo(dstRef));
            }
        }
        if (MapUtils.isNotEmpty(dstForeignMap)) {
            for (Map.Entry<String, ObOracle22xForeignKey> entry : dstForeignMap.entrySet()) {
                ObOracle22xForeignKey srcRef = srcForeignMap.get(entry.getKey());
                if (srcRef != null || (srcRef = (ObOracle22xForeignKey)srcFkColMap.get(entry.getValue().buildUniqueReference())) != null) continue;
                objectDefines.add(entry.getValue().buildDropDefinition());
            }
        }
        return objectDefines;
    }

    private List<ObjectDefine> compareCheckMapping(ObOracle22xTable target) {
        HashMap<String, ObOracle22xCheck> srcChkConMap = new HashMap<String, ObOracle22xCheck>();
        Map<String, ObOracle22xCheck> srcCheckMap = this.getCheckMapping();
        for (Map.Entry<String, ObOracle22xCheck> entry : srcCheckMap.entrySet()) {
            srcChkConMap.put(entry.getValue().getSearchCondition(), entry.getValue());
        }
        HashMap<String, ObOracle22xCheck> dstChkConMap = new HashMap<String, ObOracle22xCheck>();
        Map<String, ObOracle22xCheck> dstCheckMap = target.getCheckMapping();
        for (Map.Entry<String, ObOracle22xCheck> entry : dstCheckMap.entrySet()) {
            dstChkConMap.put(entry.getValue().getSearchCondition(), entry.getValue());
        }
        ArrayList<ObjectDefine> objectDefines = new ArrayList<ObjectDefine>();
        if (MapUtils.isNotEmpty(srcCheckMap)) {
            for (Map.Entry<String, ObOracle22xCheck> entry : srcCheckMap.entrySet()) {
                ObOracle22xCheck dstCheck = dstCheckMap.get(entry.getKey());
                if (dstCheck == null) {
                    dstCheck = (ObOracle22xCheck)dstChkConMap.get(entry.getValue().getSearchCondition());
                    if (dstCheck == null) {
                        objectDefines.add(entry.getValue().buildAddDefinition());
                        continue;
                    }
                    objectDefines.add(dstCheck.buildRenameDefinition(entry.getKey(), target.getSchemaName()));
                    continue;
                }
                CollectionUtils.addAllIgnoreNull(objectDefines, entry.getValue().compareTo(dstCheck));
            }
        }
        if (MapUtils.isNotEmpty(dstCheckMap)) {
            for (Map.Entry<String, ObOracle22xCheck> entry : dstCheckMap.entrySet()) {
                ObOracle22xCheck srcCheck = srcCheckMap.get(entry.getKey());
                if (srcCheck != null || (srcCheck = (ObOracle22xCheck)srcChkConMap.get(entry.getValue().getSearchCondition())) != null) continue;
                objectDefines.add(entry.getValue().buildDropDefinition());
            }
        }
        return objectDefines;
    }

    private List<ObjectDefine> compareIndexMapping(ObOracle22xTable target) {
        HashMap<String, ObOracle22xIndex> srcIdxColMap = new HashMap<String, ObOracle22xIndex>();
        Map<String, ObOracle22xIndex> srcIndexMap = this.getIndexMapping();
        for (Map.Entry<String, ObOracle22xIndex> entry : srcIndexMap.entrySet()) {
            srcIdxColMap.put(entry.getValue().joinIndexColumns().toString(), entry.getValue());
        }
        HashMap<String, ObOracle22xIndex> dstIdxColMap = new HashMap<String, ObOracle22xIndex>();
        Map<String, ObOracle22xIndex> dstIndexMap = target.getIndexMapping();
        for (Map.Entry<String, ObOracle22xIndex> entry : dstIndexMap.entrySet()) {
            dstIdxColMap.put(entry.getValue().joinIndexColumns().toString(), entry.getValue());
        }
        ArrayList<ObjectDefine> objectDefines = new ArrayList<ObjectDefine>();
        if (MapUtils.isNotEmpty(srcIndexMap)) {
            String objectName = this.getSimpleObjectName();
            for (Map.Entry<String, ObOracle22xIndex> entry : srcIndexMap.entrySet()) {
                ObOracle22xIndex dstIndex = dstIndexMap.get(entry.getKey());
                if (dstIndex == null) {
                    dstIndex = (ObOracle22xIndex)dstIdxColMap.get(entry.getValue().joinIndexColumns().toString());
                    if (dstIndex == null) {
                        try {
                            objectDefines.addAll(entry.getValue().buildDefinition());
                        }
                        catch (UnsupportedGrammarException e) {
                            objectDefines.add(new UnsupportedObjectDefine(ObjectType.INDEX, objectName, e.getMessage()));
                        }
                        continue;
                    }
                    objectDefines.add(dstIndex.buildRenameDefinition(entry.getKey()));
                    continue;
                }
                CollectionUtils.addAllIgnoreNull(objectDefines, entry.getValue().compareTo(dstIndex));
            }
        }
        if (MapUtils.isNotEmpty(dstIndexMap)) {
            for (Map.Entry<String, ObOracle22xIndex> entry : dstIndexMap.entrySet()) {
                ObOracle22xIndex srcIndex = srcIndexMap.get(entry.getKey());
                if (srcIndex != null || (srcIndex = (ObOracle22xIndex)srcIdxColMap.get(entry.getValue().joinIndexColumns().toString())) != null) continue;
                objectDefines.add(entry.getValue().buildDropDefinition());
            }
        }
        return objectDefines;
    }

    private List<ObjectDefine> compareTablePartition(ObOracle22xTable target) {
        ArrayList<ObjectDefine> objectDefines = new ArrayList<ObjectDefine>();
        if (this.getTablePartition() != null && target.getTablePartition() == null) {
            String partitionType = this.getTablePartition().getPartitioningType();
            partitionType = this.getTablePartition().getPartTypeMapping().get(partitionType);
            for (AbstractOracleTablePartition.OracleTablePartitionItem item : this.getTablePartition().getTablePartitions()) {
                String template = this.getTablePartition().getTablePartTemplateMapping().get(partitionType);
                String highValue = item.getHighValue();
                String partName = this.wrap(item.getPartitionName());
                StringBuilder add = new StringBuilder();
                add.append("ALTER TABLE ").append(this.getSchemaObjectName()).append(" ADD ");
                if (highValue == null) {
                    add.append(String.format(template, partName));
                } else {
                    add.append(String.format(template, partName, highValue));
                }
                StringBuilder drop = new StringBuilder();
                drop.append("ALTER TABLE ").append(this.getSchemaObjectName());
                drop.append(" DROP PARTITION ").append(partName).append(";");
                objectDefines.add(new DropObjectDefine(ObjectType.TABLE, this.getSimpleObjectName(), this.terminate(drop), Lists.newArrayList((Object[])new ObjectDefine[]{new AlterObjectDefine(ObjectType.TABLE, this.getSimpleObjectName(), this.terminate(add))})));
            }
        }
        if (this.getTablePartition() == null && target.getTablePartition() != null) {
            for (AbstractOracleTablePartition.OracleTablePartitionItem item : target.getTablePartition().getTablePartitions()) {
                StringBuilder sb = new StringBuilder();
                sb.append("ALTER TABLE ").append(this.getSchemaObjectName());
                sb.append(" DROP ").append(this.wrap(item.getPartitionName())).append(" UPDATE GLOBAL INDEXES");
                objectDefines.add(new DropObjectDefine(ObjectType.TABLE, this.getSimpleObjectName(), this.terminate(sb)));
            }
        }
        if (this.getTablePartition() != null && target.getTablePartition() != null) {
            return this.compareTablePartitionDefinition(this, target);
        }
        return objectDefines;
    }

    private List<ObjectDefine> compareTablePartitionDefinition(ObOracle22xTable source, ObOracle22xTable target) {
        String objectName = this.getSimpleObjectName();
        ObOracle22xTablePartition srcTabPart = source.getTablePartition();
        ObOracle22xTablePartition dstTabPart = target.getTablePartition();
        String srcPartitionType = srcTabPart.getPartitioningType();
        String dstPartitionType = dstTabPart.getPartitioningType();
        String srcSubPartitionType = srcTabPart.getSubPartitioningType();
        String dstSubPartitionType = dstTabPart.getSubPartitioningType();
        String srcColumnString = srcTabPart.joinPartColumns().toString();
        String dstColumnString = dstTabPart.joinPartColumns().toString();
        String srcSubColumnString = null;
        if (CollectionUtils.isNotEmpty(srcTabPart.getTableSubPartitionColumns())) {
            srcSubColumnString = srcTabPart.joinSubPartColumns().toString();
        }
        String dstSubColumnString = null;
        if (CollectionUtils.isNotEmpty(dstTabPart.getTableSubPartitionColumns())) {
            dstSubColumnString = dstTabPart.joinSubPartColumns().toString();
        }
        boolean isHashPart = "HASH".equals(srcPartitionType);
        boolean isHashSubPart = "HASH".equals(srcSubPartitionType);
        Integer srcPartitionCount = srcTabPart.getPartitionCount();
        Integer dstPartitionCount = dstTabPart.getPartitionCount();
        Integer srcDefSubPartitionCount = srcTabPart.getDefSubPartitionCount();
        Integer dstDefSubPartitionCount = dstTabPart.getDefSubPartitionCount();
        try {
            if (StringUtils.notEquals((CharSequence)srcPartitionType, (CharSequence)dstPartitionType) && StringUtils.notEquals((CharSequence)srcColumnString, (CharSequence)dstColumnString) || StringUtils.notEquals((CharSequence)srcSubPartitionType, (CharSequence)dstSubPartitionType) && StringUtils.notEquals((CharSequence)srcSubColumnString, (CharSequence)dstSubColumnString) || isHashPart && NumberUtils.notEquals((Number)srcPartitionCount, (Number)dstPartitionCount) || isHashSubPart && NumberUtils.notEquals((Number)srcDefSubPartitionCount, (Number)dstDefSubPartitionCount)) {
                StringBuilder sb = new StringBuilder();
                sb.append("DROP TABLE ").append(this.getSchemaObjectName());
                return Lists.newArrayList((Object[])new ObjectDefine[]{new DropObjectDefine(ObjectType.TABLE, objectName, this.terminate(sb), this.buildDefinition())});
            }
        }
        catch (UnsupportedGrammarException e2) {
            return Lists.newArrayList((Object[])new ObjectDefine[]{new UnsupportedObjectDefine(ObjectType.TABLE, objectName, e2.getMessage())});
        }
        String srcTemplateString = srcTabPart.getTablePartitionTemplates().stream().map(e -> "\tSUBPARTITION " + e.getSubPartitionName()).collect(Collectors.joining(",\n"));
        String dstTemplateString = dstTabPart.getTablePartitionTemplates().stream().map(e -> "\tSUBPARTITION " + e.getSubPartitionName()).collect(Collectors.joining(",\n"));
        if (StringUtils.notEquals((CharSequence)srcTemplateString, (CharSequence)dstTemplateString)) {
            StringBuilder sb = new StringBuilder();
            sb.append("ALTER TABLE ").append(this.getSchemaObjectName());
            sb.append(" SET SUBPARTITION TEMPLATE (\n").append(srcTemplateString).append("\n)");
            return Lists.newArrayList((Object[])new ObjectDefine[]{new AlterObjectDefine(ObjectType.TABLE, objectName, this.terminate(sb))});
        }
        ArrayList<ObjectDefine> objectDefines = new ArrayList<ObjectDefine>();
        LinkedHashMap<String, AbstractOracleTablePartition.OracleTablePartitionItem> srcPartNameMap = new LinkedHashMap<String, AbstractOracleTablePartition.OracleTablePartitionItem>();
        LinkedHashMap<String, AbstractOracleTablePartition.OracleTablePartitionItem> srcPartValueMap = new LinkedHashMap<String, AbstractOracleTablePartition.OracleTablePartitionItem>();
        for (AbstractOracleTablePartition.OracleTablePartitionItem item : srcTabPart.getTablePartitions()) {
            srcPartNameMap.putIfAbsent(item.getPartitionName(), item);
            srcPartValueMap.putIfAbsent(item.getUniformHighValue(), item);
        }
        LinkedHashMap<String, AbstractOracleTablePartition.OracleTablePartitionItem> dstPartNameMap = new LinkedHashMap<String, AbstractOracleTablePartition.OracleTablePartitionItem>();
        LinkedHashMap<String, AbstractOracleTablePartition.OracleTablePartitionItem> dstPartValueMap = new LinkedHashMap<String, AbstractOracleTablePartition.OracleTablePartitionItem>();
        for (AbstractOracleTablePartition.OracleTablePartitionItem item : dstTabPart.getTablePartitions()) {
            dstPartNameMap.putIfAbsent(item.getPartitionName(), item);
            dstPartValueMap.putIfAbsent(item.getUniformHighValue(), item);
        }
        Map<String, List<AbstractOracleTablePartition.OracleTablePartitionItem>> srcSubPartMapping = srcTabPart.getTableSubPartitionMapping();
        Map<String, List<AbstractOracleTablePartition.OracleTablePartitionItem>> dstSubPartMapping = dstTabPart.getTableSubPartitionMapping();
        String template = this.getTablePartition().getTablePartTemplateMapping().get(srcPartitionType);
        for (Map.Entry entry : srcPartNameMap.entrySet()) {
            String srcPartName = (String)entry.getKey();
            String srcHighValue = ((AbstractOracleTablePartition.OracleTablePartitionItem)entry.getValue()).getUniformHighValue();
            AbstractOracleTablePartition.OracleTablePartitionItem dstPartItem = (AbstractOracleTablePartition.OracleTablePartitionItem)dstPartNameMap.get(srcPartName);
            if (dstPartItem == null) {
                StringBuilder sb;
                dstPartItem = (AbstractOracleTablePartition.OracleTablePartitionItem)dstPartValueMap.get(srcHighValue);
                if (dstPartItem == null) {
                    sb = new StringBuilder();
                    sb.append("ALTER TABLE ").append(this.getSchemaObjectName()).append(" ADD ");
                    if (srcHighValue == null) {
                        sb.append(String.format(template, this.wrap(srcPartName)));
                    } else {
                        sb.append(String.format(template, this.wrap(srcPartName), srcHighValue));
                    }
                    objectDefines.add(new AlterObjectDefine(ObjectType.TABLE, objectName, this.terminate(sb)));
                } else {
                    sb = new StringBuilder();
                    sb.append("ALTER TABLE ").append(this.getSchemaObjectName()).append(" RENAME PARTITION ");
                    sb.append(this.wrap(dstPartItem.getPartitionName())).append(" TO ");
                    sb.append(this.wrap(srcPartName));
                    objectDefines.add(new AlterObjectDefine(ObjectType.TABLE, objectName, this.terminate(sb)));
                }
            } else if (StringUtils.notEquals((CharSequence)srcHighValue, (CharSequence)dstPartItem.getUniformHighValue())) {
                StringBuilder drop = new StringBuilder();
                drop.append("ALTER TABLE ").append(this.getSchemaObjectName());
                drop.append(" DROP PARTITION ").append(this.wrap(dstPartItem.getPartitionName()));
                StringBuilder add = new StringBuilder();
                add.append("ALTER TABLE ").append(this.getSchemaObjectName()).append(" ADD ");
                if (srcHighValue == null) {
                    add.append(String.format(template, this.wrap(srcPartName)));
                } else {
                    add.append(String.format(template, this.wrap(srcPartName), srcHighValue));
                }
                objectDefines.add(new DropObjectDefine(ObjectType.TABLE, objectName, this.terminate(drop), Lists.newArrayList((Object[])new ObjectDefine[]{new AlterObjectDefine(ObjectType.TABLE, objectName, this.terminate(add))})));
            }
            if (!MapUtils.isNotEmpty(srcSubPartMapping)) continue;
            LinkedHashMap<String, AbstractOracleTablePartition.OracleTablePartitionItem> srcSubPartNameMap = new LinkedHashMap<String, AbstractOracleTablePartition.OracleTablePartitionItem>();
            LinkedHashMap srcSubPartValueMap = new LinkedHashMap();
            if (CollectionUtils.isNotEmpty((Collection)srcSubPartMapping.get(srcPartName))) {
                for (AbstractOracleTablePartition.OracleTablePartitionItem item2 : srcSubPartMapping.get(srcPartName)) {
                    srcSubPartNameMap.putIfAbsent(item2.getPartitionName(), item2);
                    srcSubPartValueMap.putIfAbsent(item2.getUniformHighValue(), item2);
                }
            }
            LinkedHashMap<String, AbstractOracleTablePartition.OracleTablePartitionItem> dstSubPartNameMap = new LinkedHashMap<String, AbstractOracleTablePartition.OracleTablePartitionItem>();
            LinkedHashMap<String, AbstractOracleTablePartition.OracleTablePartitionItem> dstSubPartValueMap = new LinkedHashMap<String, AbstractOracleTablePartition.OracleTablePartitionItem>();
            if (CollectionUtils.isNotEmpty((Collection)dstSubPartMapping.get(srcPartName))) {
                for (AbstractOracleTablePartition.OracleTablePartitionItem oracleTablePartitionItem : dstSubPartMapping.get(srcPartName)) {
                    dstSubPartNameMap.putIfAbsent(oracleTablePartitionItem.getPartitionName(), oracleTablePartitionItem);
                    dstSubPartValueMap.putIfAbsent(oracleTablePartitionItem.getUniformHighValue(), oracleTablePartitionItem);
                }
            }
            String string = this.getTablePartition().getTableSubPartTemplateMapping().get(srcSubPartitionType);
            for (Map.Entry subEntry : srcPartNameMap.entrySet()) {
                String srcSubPartName = (String)subEntry.getKey();
                String srcSubHighValue = ((AbstractOracleTablePartition.OracleTablePartitionItem)subEntry.getValue()).getUniformHighValue();
                AbstractOracleTablePartition.OracleTablePartitionItem dstSubPartItem = (AbstractOracleTablePartition.OracleTablePartitionItem)dstSubPartNameMap.get(srcSubPartName);
                if (dstSubPartItem == null) {
                    StringBuilder sb;
                    dstSubPartItem = (AbstractOracleTablePartition.OracleTablePartitionItem)dstSubPartValueMap.get(srcSubHighValue);
                    if (dstSubPartItem == null) {
                        sb = new StringBuilder();
                        sb.append("ALTER TABLE ").append(this.getSchemaObjectName()).append(" ADD ");
                        if (srcSubHighValue == null) {
                            sb.append(String.format(string, this.wrap(srcSubPartName)));
                        } else {
                            sb.append(String.format(string, this.wrap(srcSubPartName), srcSubHighValue));
                        }
                        objectDefines.add(new AlterObjectDefine(ObjectType.TABLE, objectName, this.terminate(sb)));
                        continue;
                    }
                    sb = new StringBuilder();
                    sb.append("ALTER TABLE ").append(this.getSchemaObjectName()).append(" RENAME SUBPARTITION ");
                    sb.append(this.wrap(dstSubPartItem.getPartitionName()));
                    sb.append(" TO ").append(this.wrap(srcSubPartName));
                    objectDefines.add(new AlterObjectDefine(ObjectType.TABLE, objectName, this.terminate(sb)));
                    continue;
                }
                if (!StringUtils.notEquals((CharSequence)srcSubHighValue, (CharSequence)dstSubPartItem.getUniformHighValue())) continue;
                StringBuilder drop = new StringBuilder("ALTER TABLE ");
                drop.append(this.getSchemaObjectName()).append(" DROP SUBPARTITION ");
                drop.append(this.wrap(dstSubPartItem.getPartitionName()));
                StringBuilder add = new StringBuilder("ALTER TABLE ");
                add.append(this.getSchemaObjectName()).append(" ADD ");
                if (srcSubHighValue == null) {
                    add.append(String.format(string, this.wrap(srcSubPartName)));
                } else {
                    add.append(String.format(string, this.wrap(srcSubPartName), srcSubHighValue));
                }
                objectDefines.add(new DropObjectDefine(ObjectType.TABLE, objectName, this.terminate(drop), Lists.newArrayList((Object[])new ObjectDefine[]{new AlterObjectDefine(ObjectType.TABLE, objectName, this.terminate(add))})));
            }
        }
        for (Map.Entry entry : dstPartNameMap.entrySet()) {
            String dstPartName = (String)entry.getKey();
            AbstractOracleTablePartition.OracleTablePartitionItem srcPartItem = (AbstractOracleTablePartition.OracleTablePartitionItem)srcPartNameMap.get(dstPartName);
            if (srcPartItem == null && (srcPartItem = (AbstractOracleTablePartition.OracleTablePartitionItem)srcPartValueMap.get(((AbstractOracleTablePartition.OracleTablePartitionItem)entry.getValue()).getUniformHighValue())) == null) {
                StringBuilder sb = new StringBuilder();
                sb.append("ALTER TABLE ").append(source.getSchemaObjectName());
                sb.append(" DROP PARTITION ").append(this.wrap(dstPartName));
                objectDefines.add(new DropObjectDefine(ObjectType.TABLE, objectName, this.terminate(sb)));
            }
            if (!MapUtils.isNotEmpty(srcSubPartMapping)) continue;
            LinkedHashMap<String, AbstractOracleTablePartition.OracleTablePartitionItem> srcSubPartNameMap = new LinkedHashMap<String, AbstractOracleTablePartition.OracleTablePartitionItem>();
            LinkedHashMap<String, AbstractOracleTablePartition.OracleTablePartitionItem> srcSubPartValueMap = new LinkedHashMap<String, AbstractOracleTablePartition.OracleTablePartitionItem>();
            if (CollectionUtils.isNotEmpty((Collection)srcSubPartMapping.get(dstPartName))) {
                for (AbstractOracleTablePartition.OracleTablePartitionItem item : srcSubPartMapping.get(dstPartName)) {
                    srcSubPartNameMap.putIfAbsent(item.getPartitionName(), item);
                    srcSubPartValueMap.putIfAbsent(item.getUniformHighValue(), item);
                }
            }
            LinkedHashMap<String, AbstractOracleTablePartition.OracleTablePartitionItem> dstSubPartNameMap = new LinkedHashMap<String, AbstractOracleTablePartition.OracleTablePartitionItem>();
            LinkedHashMap<String, AbstractOracleTablePartition.OracleTablePartitionItem> dstSubPartValueMap = new LinkedHashMap<String, AbstractOracleTablePartition.OracleTablePartitionItem>();
            if (CollectionUtils.isNotEmpty((Collection)dstSubPartMapping.get(dstPartName))) {
                for (AbstractOracleTablePartition.OracleTablePartitionItem oracleTablePartitionItem : dstSubPartMapping.get(dstPartName)) {
                    dstSubPartNameMap.putIfAbsent(oracleTablePartitionItem.getPartitionName(), oracleTablePartitionItem);
                    dstSubPartValueMap.putIfAbsent(oracleTablePartitionItem.getUniformHighValue(), oracleTablePartitionItem);
                }
            }
            for (Map.Entry entry2 : dstSubPartNameMap.entrySet()) {
                AbstractOracleTablePartition.OracleTablePartitionItem oracleTablePartitionItem;
                AbstractOracleTablePartition.OracleTablePartitionItem oracleTablePartitionItem2 = (AbstractOracleTablePartition.OracleTablePartitionItem)srcSubPartNameMap.get(entry2.getKey());
                if (oracleTablePartitionItem2 != null || (oracleTablePartitionItem = (AbstractOracleTablePartition.OracleTablePartitionItem)srcSubPartValueMap.get(((AbstractOracleTablePartition.OracleTablePartitionItem)entry2.getValue()).getUniformHighValue())) != null) continue;
                StringBuilder sb = new StringBuilder();
                sb.append("ALTER TABLE ").append(source.getSchemaObjectName());
                sb.append(" DROP PARTITION ").append(this.wrap((String)entry2.getKey()));
                objectDefines.add(new DropObjectDefine(ObjectType.TABLE, objectName, this.terminate(sb)));
            }
        }
        return objectDefines;
    }

    private List<ObjectDefine> compareTableOption(ObOracle22xTable target) {
        ArrayList<ObjectDefine> objectDefines = new ArrayList<ObjectDefine>();
        if (StringUtils.notEquals((CharSequence)this.getTableComment(), (CharSequence)target.getTableComment())) {
            StringBuilder sb = new StringBuilder();
            sb.append("COMMENT ON TABLE ").append(target.getSchemaObjectName());
            sb.append(" IS '").append(this.getTableComment()).append("'").append(";");
            objectDefines.add(new AlterObjectDefine(ObjectType.TABLE, this.getSimpleObjectName(), sb.toString()));
        }
        return objectDefines;
    }

    public Map<String, ObOracle22xColumn> getColumnMapping() {
        return this.columnMapping;
    }

    public Map<String, ObOracle22xIndex> getIndexMapping() {
        return this.indexMapping;
    }

    public Map<String, ObOracle22xUniqueKey> getUniqueMapping() {
        return this.uniqueMapping;
    }

    public Map<String, ObOracle22xForeignKey> getForeignMapping() {
        return this.foreignMapping;
    }

    public Map<String, ObOracle22xCheck> getCheckMapping() {
        return this.checkMapping;
    }

    public String getTableGroupName() {
        return this.tableGroupName;
    }

    public void setTableGroupName(String tableGroupName) {
        this.tableGroupName = tableGroupName;
    }

    public ObOracle22xPrimaryKey getPrimaryKey() {
        return this.primaryKey;
    }

    public void setPrimaryKey(ObOracle22xPrimaryKey primaryKey) {
        this.primaryKey = primaryKey;
    }

    public ObOracle22xTablePartition getTablePartition() {
        return this.tablePartition;
    }

    public void setTablePartition(ObOracle22xTablePartition tablePartition) {
        this.tablePartition = tablePartition;
    }

    static {
        DEFAULT_DELIM_TOKENS.add("`");
        DEFAULT_DELIM_TOKENS.add(",");
        DEFAULT_DELIM_TOKENS.add(";");
        DEFAULT_DELIM_TOKENS.add(" ");
        DEFAULT_DELIM_TOKENS.add("(");
        DEFAULT_DELIM_TOKENS.add(")");
        DEFAULT_DELIM_TOKENS.add("+");
        DEFAULT_DELIM_TOKENS.add("-");
        DEFAULT_DELIM_TOKENS.add("*");
        DEFAULT_DELIM_TOKENS.add("/");
        DEFAULT_DELIM_TOKENS.add("%");
        DEFAULT_DELIM_TOKENS.add("=");
        DEFAULT_DELIM_TOKENS.add(">");
        DEFAULT_DELIM_TOKENS.add("<");
        DEFAULT_DELIM_TOKENS.add("|");
        DEFAULT_DELIM_TOKENS.add("$");
        DEFAULT_DELIM_TOKENS.add("!");
        DEFAULT_DELIM_TOKENS.add("||");
        DEFAULT_DELIM_TOKENS.add("&");
        DEFAULT_DELIM_TOKENS.add("~");
        DEFAULT_DELIM_TOKENS.add("\n");
        DEFAULT_DELIM_TOKENS.add("\t");
        DEFAULT_DELIM_TOKENS.add("\"");
    }
}

