/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.model.oboracle22x;

import com.oceanbase.obtools.common.utils.CollectionUtils;
import com.oceanbase.obtools.common.utils.StringUtils;
import com.oceanbase.obtools.dbdiff.compare.result.ChangeInfo;
import com.oceanbase.obtools.dbdiff.compare.result.ObjectDefine;
import com.oceanbase.obtools.dbdiff.enums.DbType;
import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import com.oceanbase.obtools.dbdiff.exception.UnmatchedObjectTypeException;
import com.oceanbase.obtools.dbdiff.exception.UnsupportedGrammarException;
import com.oceanbase.obtools.dbdiff.model.AbstractTablePartition;
import com.oceanbase.obtools.dbdiff.model.oboracle22x.ObOracle22xSchema;
import com.oceanbase.obtools.dbdiff.model.oracle.AbstractOracleTablePartition;
import com.oceanbase.obtools.dbdiff.utils.ChangeUtils;
import java.util.Iterator;
import java.util.List;

public class ObOracle22xTablePartition
extends AbstractOracleTablePartition {
    public ObOracle22xTablePartition(ObOracle22xSchema schema) {
        super(schema);
    }

    @Override
    public StringBuilder buildGrammar() throws UnsupportedGrammarException {
        String partitionType = this.getPartTypeMapping().get(this.getPartitioningType());
        if (StringUtils.isBlank((CharSequence)partitionType) || "SYSTEM".equals(partitionType) || "REFERENCE".equals(partitionType)) {
            throw new UnsupportedGrammarException(this.getOriginSchemaObjectName(), "The table partition type: " + this.getPartitioningType() + " is unsupported");
        }
        if (this.isComposite()) {
            if (DbType.OBORACLE_2273.isSubsequent(this.getDbType())) {
                return this.buildCompositePartitionGrammar(partitionType);
            }
            return super.buildCompositePartitionGrammar(partitionType);
        }
        return super.buildNonCompositePartitionGrammar(partitionType);
    }

    @Override
    protected StringBuilder buildIntervalExpr(String partitionType, String interval) {
        if (DbType.OBORACLE_2270.getType().equals(this.getDbType().getType()) && DbType.OBORACLE_40.isSubsequent(this.getDbType())) {
            ChangeUtils.warn(ObjectType.TABLE, this.getSchemaObjectName(), ChangeInfo.ChangeType.DISCARD, super.buildIntervalExpr(partitionType, interval) + " -> [NULL]", "-- ALTER TABLE " + this.getSchemaObjectName() + " ADD PARTITION <PARTNAME> VALUES LESS THAN (-expr-)");
            return new StringBuilder(0);
        }
        return super.buildIntervalExpr(partitionType, interval);
    }

    @Override
    protected StringBuilder buildCompositePartitionGrammar(String partitionType) throws UnsupportedGrammarException {
        String subPartitionType = this.getPartTypeMapping().get(this.getSubPartitioningType());
        if (StringUtils.isBlank((CharSequence)subPartitionType)) {
            throw new UnsupportedGrammarException(this.getOriginSchemaObjectName(), "The table subpartition type is null");
        }
        super.setPartitioningKeyCount(Math.max(super.getPartitioningKeyCount(), 1));
        super.setSubPartitioningKeyCount(Math.max(super.getSubPartitioningKeyCount(), 1));
        if (this.getDbType() != null && this.getDbType().isPrior(DbType.OBORACLE_2271)) {
            if (partitionType.equals(subPartitionType) && CollectionUtils.isNotEmpty(this.getTableSubPartitionColumns())) {
                throw new UnsupportedGrammarException(this.getOriginSchemaObjectName(), "The composite table partition: [" + partitionType + " + " + subPartitionType + "] is unsupported");
            }
            boolean isHashSubPartition = "HASH".equals(subPartitionType);
            if (isHashSubPartition && CollectionUtils.isNotEmpty(this.getTablePartitionTemplates())) {
                super.setDefSubPartitionCount(this.getTablePartitionTemplates().size());
                super.getTablePartitionTemplates().clear();
                ChangeUtils.info(ObjectType.TABLE, this.getSchemaObjectName(), ChangeInfo.ChangeType.CONVERT, "SUBPARTITION TEMPLATE (....) -> SUBPARTITIONS " + super.getDefSubPartitionCount());
            }
        }
        return super.buildCompositePartitionGrammar(partitionType);
    }

    @Override
    protected StringBuilder buildCompositePartitionGrammarWithoutTemplate(String partitionType, String subPartitionType) throws UnsupportedGrammarException {
        if (this.getDbType() != null && this.getDbType().isPrior(DbType.OBORACLE_2270)) {
            if (!"HASH".equals(subPartitionType)) {
                throw new UnsupportedGrammarException(this.getOriginSchemaObjectName(), "The table subpartition must be declared as SUBPARTITION TEMPLATE");
            }
            StringBuilder sb = new StringBuilder();
            Integer defSubPartitionCount = this.getDefSubPartitionCount();
            if (defSubPartitionCount != null && defSubPartitionCount > 0) {
                sb.append("\n").append("SUBPARTITIONS ").append(defSubPartitionCount);
            }
            sb.append("\n").append("(");
            String partFormat = this.getTablePartTemplateMapping().get(partitionType);
            Iterator<AbstractOracleTablePartition.OracleTablePartitionItem> iter = this.getTablePartitions().iterator();
            while (iter.hasNext()) {
                boolean isUserSpecified;
                AbstractOracleTablePartition.OracleTablePartitionItem partItem = iter.next();
                String partName = partItem.getPartitionName();
                sb.append("\n\t");
                sb.append(String.format(partFormat, this.wrap(partName), partItem.getHighValue()));
                List<AbstractOracleTablePartition.OracleTablePartitionItem> subPartItems = this.getTableSubPartitionMapping().get(partName);
                if (CollectionUtils.isNotEmpty(subPartItems) && ((isUserSpecified = subPartItems.stream().filter(e -> e != null).anyMatch(e -> "N".equals(e.getGenerated()) || "NO".equals(e.getGenerated()))) || defSubPartitionCount != null && !defSubPartitionCount.equals(partItem.getSubPartitionCount()))) {
                    throw new UnsupportedGrammarException(this.getOriginSchemaObjectName(), "The individual hash subpartition is unsupported");
                }
                if (!iter.hasNext()) continue;
                sb.append(",");
            }
            return sb.append("\n").append(")");
        }
        return super.buildCompositePartitionGrammarWithoutTemplate(partitionType, subPartitionType);
    }

    @Override
    public List<ObjectDefine> compareTo(AbstractTablePartition other) {
        if (!(other instanceof ObOracle22xTablePartition)) {
            throw new UnmatchedObjectTypeException("Raw type is not matched");
        }
        return null;
    }
}

