/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.model.oboracle22x;

import com.oceanbase.obtools.common.collect.Lists;
import com.oceanbase.obtools.common.utils.CollectionUtils;
import com.oceanbase.obtools.dbdiff.compare.result.CreateObjectDefine;
import com.oceanbase.obtools.dbdiff.compare.result.ObjectDefine;
import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import com.oceanbase.obtools.dbdiff.exception.UnmatchedObjectTypeException;
import com.oceanbase.obtools.dbdiff.exception.UnsupportedGrammarException;
import com.oceanbase.obtools.dbdiff.model.AbstractView;
import com.oceanbase.obtools.dbdiff.model.oboracle22x.ObOracle22xColumn;
import com.oceanbase.obtools.dbdiff.model.oboracle22x.ObOracle22xPrimaryKey;
import com.oceanbase.obtools.dbdiff.model.oboracle22x.ObOracle22xSchema;
import com.oceanbase.obtools.dbdiff.model.oboracle22x.ObOracle22xUniqueKey;
import com.oceanbase.obtools.dbdiff.model.oracle.AbstractOracleView;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ObOracle22xView
extends AbstractOracleView {
    private ObOracle22xPrimaryKey primaryKey;
    private final Map<String, ObOracle22xColumn> columnMapping = new LinkedHashMap<String, ObOracle22xColumn>();
    private final Map<String, ObOracle22xUniqueKey> uniqueMapping = new LinkedHashMap<String, ObOracle22xUniqueKey>();

    public ObOracle22xView(ObOracle22xSchema schema) {
        super(schema);
    }

    @Override
    public List<ObjectDefine> buildDefinition() throws UnsupportedGrammarException {
        String text = this.getText();
        if (this.isFullText()) {
            return Lists.newArrayList((Object[])new ObjectDefine[]{new CreateObjectDefine(ObjectType.VIEW, this.getSimpleObjectName(), this.terminate(text))});
        }
        StringBuilder sb = new StringBuilder();
        String objectName = this.getDefinitionSchemaObjectName();
        sb.append("CREATE OR REPLACE VIEW ").append(objectName);
        Collection<ObOracle22xColumn> columns = this.getColumnMapping().values();
        if (CollectionUtils.isNotEmpty(columns)) {
            sb.append(" (");
            Iterator<ObOracle22xColumn> iter1 = this.getColumnMapping().values().iterator();
            while (iter1.hasNext()) {
                sb.append("\n\t").append(this.wrapAndCase(iter1.next().getColumnName(), "columnCase"));
                if (!iter1.hasNext()) continue;
                sb.append(",");
            }
            ObOracle22xPrimaryKey primaryKey = this.getPrimaryKey();
            if (primaryKey != null) {
                sb.append(",").append("\n\t").append((CharSequence)primaryKey.buildGrammar());
            }
            Iterator<ObOracle22xUniqueKey> iter2 = this.getUniqueMapping().values().iterator();
            while (iter2.hasNext()) {
                sb.append(",").append("\n\t").append((CharSequence)iter2.next().buildGrammar());
            }
            sb.append(")");
        }
        sb.append(" AS ").append("\n").append(text);
        return Lists.newArrayList((Object[])new ObjectDefine[]{new CreateObjectDefine(ObjectType.VIEW, this.getSimpleObjectName(), this.terminate(sb))});
    }

    @Override
    public List<ObjectDefine> compareTo(AbstractView other) {
        if (!(other instanceof ObOracle22xView)) {
            throw new UnmatchedObjectTypeException("Raw type is not matched");
        }
        return null;
    }

    public ObOracle22xPrimaryKey getPrimaryKey() {
        return this.primaryKey;
    }

    public void setPrimaryKey(ObOracle22xPrimaryKey primaryKey) {
        this.primaryKey = primaryKey;
    }

    public Map<String, ObOracle22xColumn> getColumnMapping() {
        return this.columnMapping;
    }

    public Map<String, ObOracle22xUniqueKey> getUniqueMapping() {
        return this.uniqueMapping;
    }
}

