/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.model.oracle;

import com.oceanbase.obtools.dbdiff.compare.result.AlterObjectDefine;
import com.oceanbase.obtools.dbdiff.compare.result.ObjectDefine;
import com.oceanbase.obtools.dbdiff.compare.result.UnsupportedObjectDefine;
import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import com.oceanbase.obtools.dbdiff.exception.UnsupportedGrammarException;
import com.oceanbase.obtools.dbdiff.model.AbstractColumn;
import com.oceanbase.obtools.dbdiff.model.AbstractSchema;
import com.oceanbase.obtools.dbdiff.model.oracle.AbstractOracleSequence;

public abstract class AbstractOracleColumn
extends AbstractColumn {
    private String dataTypeMod;
    private String dataTypeOwner;
    private Long dataLength;
    private Integer dataPrecision;
    private Integer dataScale;
    private Integer defaultLength;
    private Integer numDistinct;
    private String lowValue;
    private String highValue;
    private String density;
    private String numNulls;
    private String numBuckets;
    private String lastAnalyzed;
    private String sampleSize;
    private String characterSetName;
    private Integer charColDeclLength;
    private String globalStats;
    private String userStats;
    private String avgColLen;
    private Long charLength;
    private String charUsed;
    private String v80FmtImage;
    private String dataUpgraded;
    private String hiddenColumn;
    private String virtualColumn;
    private int segmentColumnId;
    private int internalColumnId;
    private String histogram;
    private String qualifiedColName;
    private String userGenerated;
    private String defaultOnNull;
    private String identityColumn;
    private String generationType;
    private String inlineCheckGrammar;
    private AbstractOracleSequence identityExpr;

    public AbstractOracleColumn(AbstractSchema schema) {
        super(schema);
    }

    @Override
    public ObjectDefine buildAddDefinition() {
        try {
            StringBuilder sb = new StringBuilder();
            sb.append("ALTER TABLE ").append(this.getSchemaObjectName());
            sb.append(" ADD ").append((CharSequence)this.buildGrammar()).append(";");
            return new AlterObjectDefine(ObjectType.TABLE, this.getSimpleObjectName(), sb.toString());
        }
        catch (UnsupportedGrammarException e) {
            return new UnsupportedObjectDefine(ObjectType.TABLE, this.getSimpleObjectName(), e.getMessage());
        }
    }

    public boolean isCharType() {
        return "CHAR".equalsIgnoreCase(this.getDataType()) || "NCHAR".equalsIgnoreCase(this.getDataType()) || "CHARACTER".equalsIgnoreCase(this.getDataType());
    }

    public boolean isVarcharType() {
        return "VARCHAR2".equalsIgnoreCase(this.getDataType()) || "NVARCHAR2".equalsIgnoreCase(this.getDataType());
    }

    public boolean isUnicodeType() {
        return "NCHAR".equalsIgnoreCase(this.getDataType()) || "NVARCHAR2".equalsIgnoreCase(this.getDataType());
    }

    public String getDataTypeMod() {
        return this.dataTypeMod;
    }

    public void setDataTypeMod(String dataTypeMod) {
        this.dataTypeMod = dataTypeMod;
    }

    public String getDataTypeOwner() {
        return this.dataTypeOwner;
    }

    public void setDataTypeOwner(String dataTypeOwner) {
        this.dataTypeOwner = dataTypeOwner;
    }

    public Long getDataLength() {
        return this.dataLength;
    }

    public void setDataLength(Long dataLength) {
        this.dataLength = dataLength;
    }

    public Integer getDataPrecision() {
        return this.dataPrecision;
    }

    public void setDataPrecision(Integer dataPrecision) {
        this.dataPrecision = dataPrecision;
    }

    public Integer getDataScale() {
        return this.dataScale;
    }

    public void setDataScale(Integer dataScale) {
        this.dataScale = dataScale;
    }

    public Integer getDefaultLength() {
        return this.defaultLength;
    }

    public void setDefaultLength(Integer defaultLength) {
        this.defaultLength = defaultLength;
    }

    public Integer getNumDistinct() {
        return this.numDistinct;
    }

    public void setNumDistinct(Integer numDistinct) {
        this.numDistinct = numDistinct;
    }

    public String getLowValue() {
        return this.lowValue;
    }

    public void setLowValue(String lowValue) {
        this.lowValue = lowValue;
    }

    public String getHighValue() {
        return this.highValue;
    }

    public void setHighValue(String highValue) {
        this.highValue = highValue;
    }

    public String getDensity() {
        return this.density;
    }

    public void setDensity(String density) {
        this.density = density;
    }

    public String getNumNulls() {
        return this.numNulls;
    }

    public void setNumNulls(String numNulls) {
        this.numNulls = numNulls;
    }

    public String getNumBuckets() {
        return this.numBuckets;
    }

    public void setNumBuckets(String numBuckets) {
        this.numBuckets = numBuckets;
    }

    public String getLastAnalyzed() {
        return this.lastAnalyzed;
    }

    public void setLastAnalyzed(String lastAnalyzed) {
        this.lastAnalyzed = lastAnalyzed;
    }

    public String getSampleSize() {
        return this.sampleSize;
    }

    public void setSampleSize(String sampleSize) {
        this.sampleSize = sampleSize;
    }

    public String getCharacterSetName() {
        return this.characterSetName;
    }

    public void setCharacterSetName(String characterSetName) {
        this.characterSetName = characterSetName;
    }

    public Integer getCharColDeclLength() {
        return this.charColDeclLength;
    }

    public void setCharColDeclLength(Integer charColDeclLength) {
        this.charColDeclLength = charColDeclLength;
    }

    public String getGlobalStats() {
        return this.globalStats;
    }

    public void setGlobalStats(String globalStats) {
        this.globalStats = globalStats;
    }

    public String getUserStats() {
        return this.userStats;
    }

    public void setUserStats(String userStats) {
        this.userStats = userStats;
    }

    public String getAvgColLen() {
        return this.avgColLen;
    }

    public void setAvgColLen(String avgColLen) {
        this.avgColLen = avgColLen;
    }

    public Long getCharLength() {
        return this.charLength;
    }

    public void setCharLength(Long charLength) {
        this.charLength = charLength;
    }

    public String getCharUsed() {
        return this.charUsed;
    }

    public void setCharUsed(String charUsed) {
        this.charUsed = charUsed;
    }

    public String getV80FmtImage() {
        return this.v80FmtImage;
    }

    public void setV80FmtImage(String v80FmtImage) {
        this.v80FmtImage = v80FmtImage;
    }

    public String getDataUpgraded() {
        return this.dataUpgraded;
    }

    public void setDataUpgraded(String dataUpgraded) {
        this.dataUpgraded = dataUpgraded;
    }

    public String getHiddenColumn() {
        return this.hiddenColumn;
    }

    public void setHiddenColumn(String hiddenColumn) {
        this.hiddenColumn = hiddenColumn;
    }

    public String getVirtualColumn() {
        return this.virtualColumn;
    }

    public void setVirtualColumn(String virtualColumn) {
        this.virtualColumn = virtualColumn;
    }

    public int getSegmentColumnId() {
        return this.segmentColumnId;
    }

    public void setSegmentColumnId(int segmentColumnId) {
        this.segmentColumnId = segmentColumnId;
    }

    public int getInternalColumnId() {
        return this.internalColumnId;
    }

    public void setInternalColumnId(int internalColumnId) {
        this.internalColumnId = internalColumnId;
    }

    public String getHistogram() {
        return this.histogram;
    }

    public void setHistogram(String histogram) {
        this.histogram = histogram;
    }

    public String getQualifiedColName() {
        return this.qualifiedColName;
    }

    public void setQualifiedColName(String qualifiedColName) {
        this.qualifiedColName = qualifiedColName;
    }

    public String getUserGenerated() {
        return this.userGenerated;
    }

    public void setUserGenerated(String userGenerated) {
        this.userGenerated = userGenerated;
    }

    public String getDefaultOnNull() {
        return this.defaultOnNull;
    }

    public void setDefaultOnNull(String defaultOnNull) {
        this.defaultOnNull = defaultOnNull;
    }

    public String getIdentityColumn() {
        return this.identityColumn;
    }

    public void setIdentityColumn(String identityColumn) {
        this.identityColumn = identityColumn;
    }

    public String getGenerationType() {
        return this.generationType;
    }

    public void setGenerationType(String generationType) {
        this.generationType = generationType;
    }

    public String getInlineCheckGrammar() {
        return this.inlineCheckGrammar;
    }

    public void setInlineCheckGrammar(String inlineCheckGrammar) {
        this.inlineCheckGrammar = inlineCheckGrammar;
    }

    public AbstractOracleSequence getIdentityExpr() {
        return this.identityExpr;
    }

    public void setIdentityExpr(AbstractOracleSequence identityExpr) {
        this.identityExpr = identityExpr;
    }
}

