/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.model.oracle;

import com.oceanbase.obtools.common.collect.Lists;
import com.oceanbase.obtools.common.utils.StringUtils;
import com.oceanbase.obtools.dbdiff.compare.result.CreateObjectDefine;
import com.oceanbase.obtools.dbdiff.compare.result.ObjectDefine;
import com.oceanbase.obtools.dbdiff.enums.DbType;
import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import com.oceanbase.obtools.dbdiff.exception.UnsupportedGrammarException;
import com.oceanbase.obtools.dbdiff.model.AbstractDatabaseLink;
import com.oceanbase.obtools.dbdiff.model.AbstractSchema;
import java.util.List;

public abstract class AbstractOracleDatabaseLink
extends AbstractDatabaseLink {
    private static final int SHARED_FLAG = 3;
    private String owner;
    private String username;
    private String host;
    private String created;
    private String password;
    private int flag;
    private String authUsr;
    private String authPwd;
    private String passwordx;
    private String authPwdx;

    public AbstractOracleDatabaseLink(AbstractSchema schema) {
        super(schema);
    }

    @Override
    public List<ObjectDefine> buildDefinition() throws UnsupportedGrammarException {
        DbType dbType;
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE");
        String owner = this.getOwner();
        if (this.getFlag() == 3) {
            sb.append(" SHARED");
        }
        if ("PUBLIC".equals(owner)) {
            sb.append(" PUBLIC");
        }
        sb.append(" DATABASE LINK ").append(this.getSchemaObjectName());
        String username = this.getUsername();
        if (StringUtils.isNotBlank((CharSequence)username)) {
            sb.append("\nCONNECT TO ");
            if ("CURRENT_USER".equals(username)) {
                sb.append("CURRENT_USER");
            } else {
                sb.append(this.wrap(username));
                if (StringUtils.isNotBlank((CharSequence)this.getPasswordx())) {
                    sb.append(" IDENTIFIED BY VALUES '").append(this.getPasswordx()).append("'");
                }
            }
        }
        if (StringUtils.isNotBlank((CharSequence)this.getAuthUsr())) {
            sb.append("\nAUTHENTICATED BY ").append(this.wrap(this.getAuthUsr()));
            if (StringUtils.isNotBlank((CharSequence)this.getAuthPwdx())) {
                sb.append(" IDENTIFIED BY VALUES '").append(this.getAuthPwdx()).append("'");
            }
        }
        if (StringUtils.isNotBlank((CharSequence)this.getHost())) {
            sb.append("\nUSING '").append(this.getHost()).append("'");
        }
        if ((dbType = super.getDbType()) != null && DbType.ORACLE_11GR1.getType().equals(dbType.getType())) {
            return Lists.newArrayList((Object[])new ObjectDefine[]{new CreateObjectDefine(ObjectType.DBLINK, this.getSimpleObjectName(), sb.toString())});
        }
        return Lists.newArrayList((Object[])new ObjectDefine[]{new CreateObjectDefine(ObjectType.DBLINK, this.getSimpleObjectName(), this.terminate(sb))});
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getCreated() {
        return this.created;
    }

    public void setCreated(String created) {
        this.created = created;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public int getFlag() {
        return this.flag;
    }

    public void setFlag(int flag) {
        this.flag = flag;
    }

    public String getAuthUsr() {
        return this.authUsr;
    }

    public void setAuthUsr(String authUsr) {
        this.authUsr = authUsr;
    }

    public String getAuthPwd() {
        return this.authPwd;
    }

    public void setAuthPwd(String authPwd) {
        this.authPwd = authPwd;
    }

    public String getPasswordx() {
        return this.passwordx;
    }

    public void setPasswordx(String passwordx) {
        this.passwordx = passwordx;
    }

    public String getAuthPwdx() {
        return this.authPwdx;
    }

    public void setAuthPwdx(String authPwdx) {
        this.authPwdx = authPwdx;
    }
}

