/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.model.oracle;

import com.oceanbase.obtools.common.utils.CollectionUtils;
import com.oceanbase.obtools.common.utils.StringUtils;
import com.oceanbase.obtools.dbdiff.exception.UnsupportedGrammarException;
import com.oceanbase.obtools.dbdiff.model.AbstractIndexPartition;
import com.oceanbase.obtools.dbdiff.model.AbstractSchema;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public abstract class AbstractOracleIndexPartition
extends AbstractIndexPartition {
    private final List<OracleIndexPartitionItem> indexPartitions = new ArrayList<OracleIndexPartitionItem>();
    private final Map<String, List<OracleIndexPartitionItem>> indexSubPartitionMapping = new LinkedHashMap<String, List<OracleIndexPartitionItem>>();
    private final List<OracleIndexPartitionColumn> indexPartitionColumns = new ArrayList<OracleIndexPartitionColumn>();
    private final List<OracleIndexPartitionColumn> indexSubPartitionColumns = new ArrayList<OracleIndexPartitionColumn>();
    private String partitioningType;
    private String subPartitioningType;
    private Integer partitionCount;
    private Integer defSubPartitionCount;
    private Integer partitioningKeyCount;
    private Integer subPartitioningKeyCount;
    private String locality;
    private String alignment;
    private String defTablespaceName;
    private String defPctFree;
    private String defIniTrans;
    private String defMaxTrans;
    private String defInitialExtent;
    private String defNextExtent;
    private String defMinExtents;
    private String defMaxExtents;
    private String defMaxSize;
    private String defPctIncrease;
    private String defFreelists;
    private String defFreelistGroups;
    private String defLogging;
    private String defBufferPool;
    private String defFlashCache;
    private String defCellFlashCache;
    private String defParameters;
    private String interval;

    public AbstractOracleIndexPartition(AbstractSchema schema) {
        super(schema);
    }

    public boolean isComposite() {
        String subPartitioningType = this.getSubPartitioningType();
        return subPartitioningType != null && !"NONE".equals(subPartitioningType);
    }

    @Override
    public StringBuilder buildGrammar() throws UnsupportedGrammarException {
        if ("LOCAL".equals(this.getLocality())) {
            return new StringBuilder(" LOCAL");
        }
        if (CollectionUtils.isEmpty(this.getIndexPartitions())) {
            return new StringBuilder(" " + this.getLocality());
        }
        String partitionType = this.getPartTypeMapping().get(this.getPartitioningType());
        if (StringUtils.isBlank((CharSequence)partitionType)) {
            throw new UnsupportedGrammarException(this.getOriginSchemaObjectName(), "The index partition type: " + this.getPartitioningType() + " is unsupported");
        }
        StringBuilder sb = new StringBuilder();
        sb.append("\n").append("GLOBAL PARTITION BY ").append(partitionType);
        sb.append((CharSequence)this.joinColumns(this.getIndexPartitionColumns()));
        if ("HASH".equals(partitionType)) {
            return sb.append(" PARTITIONS ").append(this.getPartitionCount());
        }
        String partitionFormat = this.getTablePartTemplateMapping().get(partitionType);
        Iterator<OracleIndexPartitionItem> iter = this.getIndexPartitions().iterator();
        sb.append("\n").append("(");
        while (iter.hasNext()) {
            sb.append("\n\t");
            OracleIndexPartitionItem indexItem = iter.next();
            String partName = this.wrap(indexItem.getPartitionName());
            sb.append(String.format(partitionFormat, partName, indexItem.getHighValue()));
            if (!iter.hasNext()) continue;
            sb.append(",");
        }
        return sb.append("\n").append(")");
    }

    protected StringBuilder joinColumns(Collection<OracleIndexPartitionColumn> cols) {
        if (CollectionUtils.isEmpty(cols)) {
            throw new IllegalArgumentException("Index partition columns is null. Object: " + this.getOriginSchemaObjectName());
        }
        return this.enclose(cols.stream().map(e -> this.wrapAndCase(e.getColumnName(), "columnCase")).collect(Collectors.joining(", ")));
    }

    public List<OracleIndexPartitionItem> getIndexPartitions() {
        return this.indexPartitions;
    }

    public Map<String, List<OracleIndexPartitionItem>> getIndexSubPartitionMapping() {
        return this.indexSubPartitionMapping;
    }

    public List<OracleIndexPartitionColumn> getIndexPartitionColumns() {
        return this.indexPartitionColumns;
    }

    public List<OracleIndexPartitionColumn> getIndexSubPartitionColumns() {
        return this.indexSubPartitionColumns;
    }

    public String getPartitioningType() {
        return this.partitioningType;
    }

    public void setPartitioningType(String partitioningType) {
        this.partitioningType = partitioningType;
    }

    public String getSubPartitioningType() {
        return this.subPartitioningType;
    }

    public void setSubPartitioningType(String subPartitioningType) {
        this.subPartitioningType = subPartitioningType;
    }

    public Integer getPartitionCount() {
        return this.partitionCount;
    }

    public void setPartitionCount(Integer partitionCount) {
        this.partitionCount = partitionCount;
    }

    public Integer getDefSubPartitionCount() {
        return this.defSubPartitionCount;
    }

    public void setDefSubPartitionCount(Integer defSubPartitionCount) {
        this.defSubPartitionCount = defSubPartitionCount;
    }

    public Integer getPartitioningKeyCount() {
        return this.partitioningKeyCount;
    }

    public void setPartitioningKeyCount(Integer partitioningKeyCount) {
        this.partitioningKeyCount = partitioningKeyCount;
    }

    public Integer getSubPartitioningKeyCount() {
        return this.subPartitioningKeyCount;
    }

    public void setSubPartitioningKeyCount(Integer subPartitioningKeyCount) {
        this.subPartitioningKeyCount = subPartitioningKeyCount;
    }

    public String getLocality() {
        return this.locality;
    }

    public void setLocality(String locality) {
        this.locality = locality;
    }

    public String getAlignment() {
        return this.alignment;
    }

    public void setAlignment(String alignment) {
        this.alignment = alignment;
    }

    public String getDefTablespaceName() {
        return this.defTablespaceName;
    }

    public void setDefTablespaceName(String defTablespaceName) {
        this.defTablespaceName = defTablespaceName;
    }

    public String getDefPctFree() {
        return this.defPctFree;
    }

    public void setDefPctFree(String defPctFree) {
        this.defPctFree = defPctFree;
    }

    public String getDefIniTrans() {
        return this.defIniTrans;
    }

    public void setDefIniTrans(String defIniTrans) {
        this.defIniTrans = defIniTrans;
    }

    public String getDefMaxTrans() {
        return this.defMaxTrans;
    }

    public void setDefMaxTrans(String defMaxTrans) {
        this.defMaxTrans = defMaxTrans;
    }

    public String getDefInitialExtent() {
        return this.defInitialExtent;
    }

    public void setDefInitialExtent(String defInitialExtent) {
        this.defInitialExtent = defInitialExtent;
    }

    public String getDefNextExtent() {
        return this.defNextExtent;
    }

    public void setDefNextExtent(String defNextExtent) {
        this.defNextExtent = defNextExtent;
    }

    public String getDefMinExtents() {
        return this.defMinExtents;
    }

    public void setDefMinExtents(String defMinExtents) {
        this.defMinExtents = defMinExtents;
    }

    public String getDefMaxExtents() {
        return this.defMaxExtents;
    }

    public void setDefMaxExtents(String defMaxExtents) {
        this.defMaxExtents = defMaxExtents;
    }

    public String getDefMaxSize() {
        return this.defMaxSize;
    }

    public void setDefMaxSize(String defMaxSize) {
        this.defMaxSize = defMaxSize;
    }

    public String getDefPctIncrease() {
        return this.defPctIncrease;
    }

    public void setDefPctIncrease(String defPctIncrease) {
        this.defPctIncrease = defPctIncrease;
    }

    public String getDefFreelists() {
        return this.defFreelists;
    }

    public void setDefFreelists(String defFreelists) {
        this.defFreelists = defFreelists;
    }

    public String getDefFreelistGroups() {
        return this.defFreelistGroups;
    }

    public void setDefFreelistGroups(String defFreelistGroups) {
        this.defFreelistGroups = defFreelistGroups;
    }

    public String getDefLogging() {
        return this.defLogging;
    }

    public void setDefLogging(String defLogging) {
        this.defLogging = defLogging;
    }

    public String getDefBufferPool() {
        return this.defBufferPool;
    }

    public void setDefBufferPool(String defBufferPool) {
        this.defBufferPool = defBufferPool;
    }

    public String getDefFlashCache() {
        return this.defFlashCache;
    }

    public void setDefFlashCache(String defFlashCache) {
        this.defFlashCache = defFlashCache;
    }

    public String getDefCellFlashCache() {
        return this.defCellFlashCache;
    }

    public void setDefCellFlashCache(String defCellFlashCache) {
        this.defCellFlashCache = defCellFlashCache;
    }

    public String getDefParameters() {
        return this.defParameters;
    }

    public void setDefParameters(String defParameters) {
        this.defParameters = defParameters;
    }

    public String getInterval() {
        return this.interval;
    }

    public void setInterval(String interval) {
        this.interval = interval;
    }

    public static class OracleIndexPartitionColumn {
        private String name;
        private String objectType;
        private String columnName;
        private Integer columnPosition;

        public int hashCode() {
            if (this.columnPosition == null || this.columnPosition < 0) {
                return Objects.hash(this.columnName, this.columnPosition);
            }
            return Objects.hash(this.columnPosition);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            OracleIndexPartitionColumn other = (OracleIndexPartitionColumn)obj;
            if (this.columnPosition == null || this.columnPosition < 0) {
                return Objects.deepEquals(other.columnName, this.columnName) && Objects.deepEquals(other.columnPosition, this.columnPosition);
            }
            return Objects.deepEquals(other.columnPosition, this.columnPosition);
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getObjectType() {
            return this.objectType;
        }

        public void setObjectType(String objectType) {
            this.objectType = objectType;
        }

        public String getColumnName() {
            return this.columnName;
        }

        public void setColumnName(String columnName) {
            this.columnName = columnName;
        }

        public Integer getColumnPosition() {
            return this.columnPosition;
        }

        public void setColumnPosition(Integer columnPosition) {
            this.columnPosition = columnPosition;
        }
    }

    public static class OracleIndexPartitionItem {
        private String composite;
        private String partitionName;
        private Integer subPartitionCount;
        private String subPartitionName;
        private String highValue;
        private Integer highValueLength;
        private Integer partitionPosition;
        private Integer subPartitionPosition;
        private String status;
        private String tablespaceName;
        private String pctFree;
        private String iniTrans;
        private String maxTrans;
        private String initialExtent;
        private String nextExtent;
        private String minExtent;
        private String maxExtent;
        private String maxSize;
        private String pctIncrease;
        private String freeLists;
        private String freeListGroups;
        private String logging;
        private String compression;
        private String blevel;
        private String leafBlocks;
        private String distinctKeys;
        private String avgLeafBlocksPerKey;
        private String avgDataBlocksPerKey;
        private String clusteringFactor;
        private String numRows;
        private String sampleSize;
        private String lastAnalyzed;
        private String bufferPool;
        private String flashCache;
        private String cellFlashCache;
        private String userStats;
        private String pctDirectAccess;
        private String globalStats;
        private String domidxOpstatus;
        private String parameters;
        private String interval;
        private String segmentCreated;

        public int hashCode() {
            if (this.partitionPosition == null || this.partitionPosition > -1) {
                return Objects.hash(this.partitionName, this.partitionPosition);
            }
            return Objects.hash(this.partitionPosition);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            OracleIndexPartitionItem other = (OracleIndexPartitionItem)obj;
            if (this.partitionPosition == null || this.partitionPosition > -1) {
                return Objects.deepEquals(other.partitionName, this.partitionName) && Objects.deepEquals(other.partitionPosition, this.partitionPosition);
            }
            return Objects.deepEquals(other.partitionPosition, this.partitionPosition);
        }

        public String getComposite() {
            return this.composite;
        }

        public void setComposite(String composite) {
            this.composite = composite;
        }

        public String getPartitionName() {
            return this.partitionName;
        }

        public void setPartitionName(String partitionName) {
            this.partitionName = partitionName;
        }

        public Integer getSubPartitionCount() {
            return this.subPartitionCount;
        }

        public void setSubPartitionCount(Integer subPartitionCount) {
            this.subPartitionCount = subPartitionCount;
        }

        public String getSubPartitionName() {
            return this.subPartitionName;
        }

        public void setSubPartitionName(String subPartitionName) {
            this.subPartitionName = subPartitionName;
        }

        public String getHighValue() {
            return this.highValue;
        }

        public void setHighValue(String highValue) {
            this.highValue = highValue;
        }

        public Integer getHighValueLength() {
            return this.highValueLength;
        }

        public void setHighValueLength(Integer highValueLength) {
            this.highValueLength = highValueLength;
        }

        public Integer getPartitionPosition() {
            return this.partitionPosition;
        }

        public void setPartitionPosition(Integer partitionPosition) {
            this.partitionPosition = partitionPosition;
        }

        public Integer getSubPartitionPosition() {
            return this.subPartitionPosition;
        }

        public void setSubPartitionPosition(Integer subPartitionPosition) {
            this.subPartitionPosition = subPartitionPosition;
        }

        public String getStatus() {
            return this.status;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public String getTablespaceName() {
            return this.tablespaceName;
        }

        public void setTablespaceName(String tablespaceName) {
            this.tablespaceName = tablespaceName;
        }

        public String getPctFree() {
            return this.pctFree;
        }

        public void setPctFree(String pctFree) {
            this.pctFree = pctFree;
        }

        public String getIniTrans() {
            return this.iniTrans;
        }

        public void setIniTrans(String iniTrans) {
            this.iniTrans = iniTrans;
        }

        public String getMaxTrans() {
            return this.maxTrans;
        }

        public void setMaxTrans(String maxTrans) {
            this.maxTrans = maxTrans;
        }

        public String getInitialExtent() {
            return this.initialExtent;
        }

        public void setInitialExtent(String initialExtent) {
            this.initialExtent = initialExtent;
        }

        public String getNextExtent() {
            return this.nextExtent;
        }

        public void setNextExtent(String nextExtent) {
            this.nextExtent = nextExtent;
        }

        public String getMinExtent() {
            return this.minExtent;
        }

        public void setMinExtent(String minExtent) {
            this.minExtent = minExtent;
        }

        public String getMaxExtent() {
            return this.maxExtent;
        }

        public void setMaxExtent(String maxExtent) {
            this.maxExtent = maxExtent;
        }

        public String getMaxSize() {
            return this.maxSize;
        }

        public void setMaxSize(String maxSize) {
            this.maxSize = maxSize;
        }

        public String getPctIncrease() {
            return this.pctIncrease;
        }

        public void setPctIncrease(String pctIncrease) {
            this.pctIncrease = pctIncrease;
        }

        public String getFreeLists() {
            return this.freeLists;
        }

        public void setFreeLists(String freeLists) {
            this.freeLists = freeLists;
        }

        public String getFreeListGroups() {
            return this.freeListGroups;
        }

        public void setFreeListGroups(String freeListGroups) {
            this.freeListGroups = freeListGroups;
        }

        public String getLogging() {
            return this.logging;
        }

        public void setLogging(String logging) {
            this.logging = logging;
        }

        public String getCompression() {
            return this.compression;
        }

        public void setCompression(String compression) {
            this.compression = compression;
        }

        public String getBlevel() {
            return this.blevel;
        }

        public void setBlevel(String blevel) {
            this.blevel = blevel;
        }

        public String getLeafBlocks() {
            return this.leafBlocks;
        }

        public void setLeafBlocks(String leafBlocks) {
            this.leafBlocks = leafBlocks;
        }

        public String getDistinctKeys() {
            return this.distinctKeys;
        }

        public void setDistinctKeys(String distinctKeys) {
            this.distinctKeys = distinctKeys;
        }

        public String getAvgLeafBlocksPerKey() {
            return this.avgLeafBlocksPerKey;
        }

        public void setAvgLeafBlocksPerKey(String avgLeafBlocksPerKey) {
            this.avgLeafBlocksPerKey = avgLeafBlocksPerKey;
        }

        public String getAvgDataBlocksPerKey() {
            return this.avgDataBlocksPerKey;
        }

        public void setAvgDataBlocksPerKey(String avgDataBlocksPerKey) {
            this.avgDataBlocksPerKey = avgDataBlocksPerKey;
        }

        public String getClusteringFactor() {
            return this.clusteringFactor;
        }

        public void setClusteringFactor(String clusteringFactor) {
            this.clusteringFactor = clusteringFactor;
        }

        public String getNumRows() {
            return this.numRows;
        }

        public void setNumRows(String numRows) {
            this.numRows = numRows;
        }

        public String getSampleSize() {
            return this.sampleSize;
        }

        public void setSampleSize(String sampleSize) {
            this.sampleSize = sampleSize;
        }

        public String getLastAnalyzed() {
            return this.lastAnalyzed;
        }

        public void setLastAnalyzed(String lastAnalyzed) {
            this.lastAnalyzed = lastAnalyzed;
        }

        public String getBufferPool() {
            return this.bufferPool;
        }

        public void setBufferPool(String bufferPool) {
            this.bufferPool = bufferPool;
        }

        public String getFlashCache() {
            return this.flashCache;
        }

        public void setFlashCache(String flashCache) {
            this.flashCache = flashCache;
        }

        public String getCellFlashCache() {
            return this.cellFlashCache;
        }

        public void setCellFlashCache(String cellFlashCache) {
            this.cellFlashCache = cellFlashCache;
        }

        public String getUserStats() {
            return this.userStats;
        }

        public void setUserStats(String userStats) {
            this.userStats = userStats;
        }

        public String getPctDirectAccess() {
            return this.pctDirectAccess;
        }

        public void setPctDirectAccess(String pctDirectAccess) {
            this.pctDirectAccess = pctDirectAccess;
        }

        public String getGlobalStats() {
            return this.globalStats;
        }

        public void setGlobalStats(String globalStats) {
            this.globalStats = globalStats;
        }

        public String getDomidxOpstatus() {
            return this.domidxOpstatus;
        }

        public void setDomidxOpstatus(String domidxOpstatus) {
            this.domidxOpstatus = domidxOpstatus;
        }

        public String getParameters() {
            return this.parameters;
        }

        public void setParameters(String parameters) {
            this.parameters = parameters;
        }

        public String getInterval() {
            return this.interval;
        }

        public void setInterval(String interval) {
            this.interval = interval;
        }

        public String getSegmentCreated() {
            return this.segmentCreated;
        }

        public void setSegmentCreated(String segmentCreated) {
            this.segmentCreated = segmentCreated;
        }
    }
}

