/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.model.oracle;

import com.oceanbase.obtools.common.collect.Lists;
import com.oceanbase.obtools.dbdiff.compare.result.CreateObjectDefine;
import com.oceanbase.obtools.dbdiff.compare.result.ObjectDefine;
import com.oceanbase.obtools.dbdiff.enums.DbType;
import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import com.oceanbase.obtools.dbdiff.exception.UnsupportedGrammarException;
import com.oceanbase.obtools.dbdiff.model.AbstractSchema;
import com.oceanbase.obtools.dbdiff.model.AbstractSequence;
import java.math.BigDecimal;
import java.util.List;

public abstract class AbstractOracleSequence
extends AbstractSequence {
    private static final BigDecimal MAX_VALUE = BigDecimal.valueOf(Long.MAX_VALUE);

    public AbstractOracleSequence(AbstractSchema schema) {
        super(schema);
    }

    @Override
    public List<ObjectDefine> buildDefinition() throws UnsupportedGrammarException {
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE SEQUENCE ").append(this.getSchemaObjectName()).append((CharSequence)this.buildSequenceGrammar());
        DbType dbType = super.getDbType();
        if (dbType != null && DbType.ORACLE_11GR1.getType().equals(dbType.getType())) {
            return Lists.newArrayList((Object[])new ObjectDefine[]{new CreateObjectDefine(ObjectType.SEQUENCE, this.getSimpleObjectName(), sb.toString())});
        }
        return Lists.newArrayList((Object[])new ObjectDefine[]{new CreateObjectDefine(ObjectType.SEQUENCE, this.getSimpleObjectName(), this.terminate(sb))});
    }

    @Override
    public StringBuilder buildSequenceGrammar() {
        BigDecimal min;
        BigDecimal increment;
        StringBuilder sb = new StringBuilder(32);
        BigDecimal start = this.getStart();
        if (start != null) {
            BigDecimal min2 = this.getMinValue();
            BigDecimal max = this.getMaxValue();
            if (min2 != null && start.compareTo(min2) > -1 && max != null) {
                sb.append(" START WITH ").append(start);
            }
        }
        if ((increment = this.getIncrement()) != null) {
            sb.append(" INCREMENT BY ").append(increment);
        }
        if ((min = this.getMinValue()) != null) {
            sb.append(" MINVALUE ").append(min);
        } else {
            sb.append(" NOMINVALUE");
        }
        BigDecimal max = this.getMaxValue();
        if (max != null && max.compareTo(MAX_VALUE) <= 0) {
            sb.append(" MAXVALUE ").append(max);
            String cycle = this.getCycle();
            if ("Y".equals(cycle) || "YES".equals(cycle)) {
                sb.append(" CYCLE");
            } else {
                sb.append(" NOCYCLE");
            }
        } else {
            sb.append(" NOMAXVALUE");
        }
        if (DbType.OBORACLE_22.getType().equals(this.getDbType().getType()) && !DbType.OBORACLE_22.getType().equals(this.getOriginDbType().getType())) {
            if (max != null) {
                BigDecimal tempMin = min == null ? BigDecimal.ONE : min;
                double tempIncr = increment == null ? BigDecimal.ONE.doubleValue() : increment.doubleValue();
                int tempCache = (int)(Math.ceil(max.subtract(tempMin).doubleValue()) / Math.abs(tempIncr));
                tempCache = Math.min(tempCache <= 1 ? 20 : tempCache, 3000);
                return sb.append(" CACHE ").append(tempCache).append(" NOORDER");
            }
            return sb.append(" NOCACHE NOORDER");
        }
        BigDecimal cache = this.getCache();
        if (cache != null && cache.compareTo(BigDecimal.ONE) > 0) {
            if (max != null && cache.compareTo(max) == 0) {
                sb.append(" CACHE ").append(BigDecimal.ONE);
            } else {
                sb.append(" CACHE ").append(cache);
            }
        } else {
            sb.append(" NOCACHE");
        }
        String order = this.getOrder();
        if ("Y".equals(order) || "YES".equals(order)) {
            sb.append(" ORDER");
        } else {
            sb.append(" NOORDER");
        }
        return sb;
    }

    @Override
    public StringBuilder buildIdentityGrammar() {
        StringBuilder sb = new StringBuilder(32);
        sb.append(" AS IDENTITY (");
        sb.append(this.buildSequenceGrammar().toString().trim());
        return sb.append(")");
    }
}

