/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.model.oracle;

import com.oceanbase.obtools.common.collect.Lists;
import com.oceanbase.obtools.common.utils.StringUtils;
import com.oceanbase.obtools.dbdiff.compare.result.CreateObjectDefine;
import com.oceanbase.obtools.dbdiff.compare.result.ObjectDefine;
import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import com.oceanbase.obtools.dbdiff.exception.UnsupportedGrammarException;
import com.oceanbase.obtools.dbdiff.model.AbstractSchema;
import com.oceanbase.obtools.dbdiff.model.AbstractSynonym;
import java.util.List;

public abstract class AbstractOracleSynonym
extends AbstractSynonym {
    protected static final String DISTINCT_SUFFIX = "__used_for_distinct_public";
    private String owner;
    private String dbLink;

    public AbstractOracleSynonym(AbstractSchema schema) {
        super(schema);
    }

    @Override
    public List<ObjectDefine> buildDefinition() throws UnsupportedGrammarException {
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE OR REPLACE");
        boolean isPublicSynonym = "PUBLIC".equals(this.getOwner());
        if (isPublicSynonym) {
            sb.append(" PUBLIC");
        }
        sb.append(" SYNONYM ");
        boolean isWithSchema = super.getGlobal().withSchema();
        String objectName = this.getObjectName();
        if (objectName.endsWith(DISTINCT_SUFFIX)) {
            objectName = objectName.substring(0, objectName.length() - DISTINCT_SUFFIX.length());
        }
        boolean isTheSameName = StringUtils.equals((CharSequence)objectName, (CharSequence)this.getTableName());
        if (!"PUBLIC".equals(this.getOwner()) && (isWithSchema || isTheSameName)) {
            sb.append(this.wrap(this.getOwner())).append(".");
        }
        sb.append(this.wrap(objectName)).append(" FOR ");
        if (StringUtils.isNotBlank((CharSequence)this.getTableOwner()) && (isWithSchema || isTheSameName)) {
            sb.append(this.wrap(this.getTableOwner())).append(".");
        }
        sb.append(this.wrap(this.getTableName()));
        if (StringUtils.isNotBlank((CharSequence)this.getDbLink())) {
            sb.append("@").append(this.wrap(this.getDbLink()));
        }
        if (isPublicSynonym) {
            return Lists.newArrayList((Object[])new ObjectDefine[]{new CreateObjectDefine(ObjectType.PUBLIC_SYNONYM, this.getSimpleObjectName(), this.terminate(sb))});
        }
        return Lists.newArrayList((Object[])new ObjectDefine[]{new CreateObjectDefine(ObjectType.SYNONYM, this.getSimpleObjectName(), this.terminate(sb))});
    }

    @Override
    public String getSimpleObjectName() {
        String objectName;
        StringBuilder sb = new StringBuilder();
        if (this.getGlobal().withSchema()) {
            sb.append(this.getSchemaName()).append(".");
        }
        if ((objectName = this.getObjectName()).endsWith(DISTINCT_SUFFIX)) {
            objectName = objectName.substring(0, objectName.length() - DISTINCT_SUFFIX.length());
        }
        return sb.append(objectName).toString();
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String getDbLink() {
        return this.dbLink;
    }

    public void setDbLink(String dbLink) {
        this.dbLink = dbLink;
    }
}

