/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.model.oracle;

import com.oceanbase.obtools.common.utils.CollectionUtils;
import com.oceanbase.obtools.common.utils.StringUtils;
import com.oceanbase.obtools.dbdiff.exception.UnsupportedGrammarException;
import com.oceanbase.obtools.dbdiff.model.AbstractSchema;
import com.oceanbase.obtools.dbdiff.model.AbstractTablePartition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public abstract class AbstractOracleTablePartition
extends AbstractTablePartition {
    private final Collection<OracleTablePartitionItem> tablePartitions = new ArrayList<OracleTablePartitionItem>();
    private final Collection<OracleTablePartitionColumn> tablePartitionColumns = new ArrayList<OracleTablePartitionColumn>();
    private String tablePartitionExpression;
    private final Collection<OracleTablePartitionColumn> tableSubPartitionColumns = new ArrayList<OracleTablePartitionColumn>();
    private String tableSubPartitionExpression;
    private final Collection<OracleTablePartitionTemplate> tablePartitionTemplates = new ArrayList<OracleTablePartitionTemplate>();
    private final Map<String, List<OracleTablePartitionItem>> tableSubPartitionMapping = new LinkedHashMap<String, List<OracleTablePartitionItem>>();
    private String partitioningType;
    private String subPartitioningType;
    private Integer partitionCount;
    private Integer defSubPartitionCount;
    private Integer partitioningKeyCount;
    private Integer subPartitioningKeyCount;
    private String status;
    private String defTablespaceName;
    private Integer defPctFree;
    private Integer defPctUsed;
    private Integer defIniTrans;
    private Integer defMaxTrans;
    private String defInitialExtent;
    private String defNextExtent;
    private String defMinExtents;
    private String defMaxExtents;
    private String defMaxSize;
    private String defPctIncrease;
    private Integer defFreeLists;
    private Integer defFreeListGroups;
    private String defLogging;
    private String defCompression;
    private String defCompressFor;
    private String defBufferPool;
    private String defFlashCache;
    private String defCellFlashCache;
    private String refPtnConstraintName;
    private String interval;
    private String isNested;
    private String defSegmentCreation;

    public AbstractOracleTablePartition(AbstractSchema schema) {
        super(schema);
    }

    public boolean isComposite() {
        String subPartitionType = this.getSubPartitioningType();
        return subPartitionType != null && !"NONE".equals(subPartitionType) && CollectionUtils.isNotEmpty(this.getTableSubPartitionColumns());
    }

    protected StringBuilder buildCompositePartitionGrammar(String partitionType) throws UnsupportedGrammarException {
        String subPartitionType;
        StringBuilder sb = new StringBuilder();
        sb.append("\n").append("PARTITION BY ").append(partitionType);
        if ("REFERENCE".equals(partitionType)) {
            sb.append((CharSequence)this.enclose(this.getRefPtnConstraintName()));
        } else if (StringUtils.isNotBlank((CharSequence)this.getTablePartitionExpression())) {
            sb.append((CharSequence)this.enclose(this.getTablePartitionExpression()));
        } else {
            Integer partitioningKeyCount = this.getPartitioningKeyCount();
            if (partitioningKeyCount != null && partitioningKeyCount > 0) {
                sb.append((CharSequence)this.joinColumns(this.getTablePartitionColumns()));
            }
        }
        String interval = this.getInterval();
        if ("RANGE".equals(partitionType) && StringUtils.isNotBlank((CharSequence)interval)) {
            sb.append((CharSequence)this.buildIntervalExpr(partitionType, interval));
        }
        if (StringUtils.isBlank((CharSequence)(subPartitionType = this.getPartTypeMapping().get(this.getSubPartitioningType())))) {
            throw new UnsupportedGrammarException(this.getOriginSchemaObjectName(), "The table subpartition type: " + this.getSubPartitioningType() + " is unsupported");
        }
        sb.append("\n").append("SUBPARTITION BY ").append(subPartitionType);
        if (StringUtils.isNotBlank((CharSequence)this.getTableSubPartitionExpression())) {
            sb.append(this.getTableSubPartitionExpression());
        } else {
            Integer subPartitionKeyCount = this.getSubPartitioningKeyCount();
            if (subPartitionKeyCount != null && subPartitionKeyCount > 0) {
                sb.append((CharSequence)this.joinColumns(this.getTableSubPartitionColumns()));
            }
        }
        if (this.checkWithTemplate()) {
            return sb.append((CharSequence)this.buildCompositePartitionGrammarWithTemplate(partitionType, subPartitionType));
        }
        return sb.append((CharSequence)this.buildCompositePartitionGrammarWithoutTemplate(partitionType, subPartitionType));
    }

    protected boolean checkWithTemplate() {
        if (CollectionUtils.isEmpty(this.getTablePartitionTemplates())) {
            return false;
        }
        int num = 0;
        for (List<OracleTablePartitionItem> subPartItem : this.getTableSubPartitionMapping().values()) {
            if (CollectionUtils.isEmpty(subPartItem)) continue;
            if (num > 0 && num != subPartItem.size()) {
                return false;
            }
            num = subPartItem.size();
        }
        return num == this.getTablePartitionTemplates().size();
    }

    protected StringBuilder buildIntervalExpr(String partitionType, String interval) {
        StringBuilder sb = new StringBuilder();
        sb.append(" INTERVAL").append((CharSequence)this.enclose(interval));
        return sb;
    }

    protected StringBuilder buildCompositePartitionGrammarWithTemplate(String partitionType, String subPartitionType) throws UnsupportedGrammarException {
        StringBuilder sb = new StringBuilder();
        String subPartFormat = this.getTableSubPartTemplateMapping().get(subPartitionType);
        sb.append("\n").append("SUBPARTITION TEMPLATE");
        sb.append("\n").append("(");
        Iterator<OracleTablePartitionTemplate> iter = this.getTablePartitionTemplates().iterator();
        while (iter.hasNext()) {
            OracleTablePartitionTemplate template = iter.next();
            sb.append("\n\t");
            sb.append(String.format(subPartFormat, this.wrap(template.getSubPartitionName()), template.getHighBound()));
            if (!iter.hasNext()) continue;
            sb.append(",");
        }
        sb.append("\n").append(")");
        String partFormat = this.getTablePartTemplateMapping().get(partitionType);
        sb.append("\n").append("(");
        Iterator<OracleTablePartitionItem> iter2 = this.getTablePartitions().iterator();
        while (iter2.hasNext()) {
            OracleTablePartitionItem partItem = iter2.next();
            sb.append("\n\t");
            sb.append(String.format(partFormat, this.wrap(partItem.getPartitionName()), partItem.getHighValue()));
            if (!iter2.hasNext()) continue;
            sb.append(",");
        }
        return sb.append("\n").append(")");
    }

    protected StringBuilder buildCompositePartitionGrammarWithoutTemplate(String partitionType, String subPartitionType) throws UnsupportedGrammarException {
        StringBuilder sb = new StringBuilder();
        sb.append("\n").append("(");
        String partFormat = this.getTablePartTemplateMapping().get(partitionType);
        String subPartFormat = this.getTableSubPartTemplateMapping().get(subPartitionType);
        Iterator<OracleTablePartitionItem> iter = this.getTablePartitions().iterator();
        block0: while (iter.hasNext()) {
            OracleTablePartitionItem partItem = iter.next();
            String partName = partItem.getPartitionName();
            sb.append("\n\t");
            sb.append(String.format(partFormat, this.wrap(partName), partItem.getHighValue()));
            List<OracleTablePartitionItem> subPartItems = this.getTableSubPartitionMapping().get(partName);
            if (CollectionUtils.isNotEmpty(subPartItems)) {
                boolean isFirstSubPartItem = true;
                Iterator<OracleTablePartitionItem> subIter = subPartItems.iterator();
                while (subIter.hasNext()) {
                    OracleTablePartitionItem subPartItem = subIter.next();
                    boolean isGenerated = "Y".equals(subPartItem.getGenerated());
                    if (this.getDbType().isOceanbaseType()) {
                        isGenerated = false;
                    }
                    if (!isGenerated && isFirstSubPartItem) {
                        sb.append("\n\t").append("(");
                        isFirstSubPartItem = false;
                    }
                    if (isGenerated) {
                        int itemSize = subPartItems.size();
                        if (itemSize > 1) {
                            sb.append("\n\t\tSUBPARTITIONS ").append(itemSize);
                        }
                        if (!iter.hasNext()) continue block0;
                        sb.append(",");
                        continue block0;
                    }
                    String subPartName = this.wrap(subPartItem.getSubPartitionName());
                    sb.append("\n\t\t");
                    sb.append(String.format(subPartFormat, subPartName, subPartItem.getHighValue()));
                    if (!subIter.hasNext()) continue;
                    sb.append(",");
                }
                sb.append("\n\t").append(")");
            }
            if (!iter.hasNext()) continue;
            sb.append(",");
        }
        return sb.append("\n").append(")");
    }

    protected StringBuilder buildNonCompositePartitionGrammar(String partitionType) throws UnsupportedGrammarException {
        Collection<OracleTablePartitionItem> tablePartitions;
        StringBuilder sb = new StringBuilder();
        sb.append("\n").append("PARTITION BY ").append(partitionType);
        if ("REFERENCE".equals(partitionType)) {
            return sb.append((CharSequence)this.enclose(this.getRefPtnConstraintName()));
        }
        if (StringUtils.isNotBlank((CharSequence)this.getTablePartitionExpression())) {
            sb.append((CharSequence)this.enclose(this.getTablePartitionExpression()));
        } else {
            Integer partitioningKeyCount = this.getPartitioningKeyCount();
            if (partitioningKeyCount != null && partitioningKeyCount > 0) {
                sb.append((CharSequence)this.joinColumns(this.getTablePartitionColumns()));
            }
        }
        String interval = this.getInterval();
        if ("RANGE".equals(partitionType) && StringUtils.isNotBlank((CharSequence)interval)) {
            sb.append((CharSequence)this.buildIntervalExpr(partitionType, interval));
        }
        if (CollectionUtils.isEmpty(tablePartitions = this.getTablePartitions())) {
            return sb;
        }
        String partFormat = this.getTablePartTemplateMapping().get(partitionType);
        sb.append("\n").append("(");
        Iterator<OracleTablePartitionItem> iter = tablePartitions.iterator();
        while (iter.hasNext()) {
            OracleTablePartitionItem partItem = iter.next();
            sb.append("\n\t");
            String highValue = partItem.getHighValue();
            String partName = this.wrap(partItem.getPartitionName());
            if (highValue == null) {
                sb.append(String.format(partFormat, partName));
            } else {
                sb.append(String.format(partFormat, partName, highValue));
            }
            if (!iter.hasNext()) continue;
            sb.append(",");
        }
        return sb.append("\n").append(")");
    }

    public StringBuilder joinPartColumns() {
        return this.joinColumns(this.getTablePartitionColumns());
    }

    public StringBuilder joinSubPartColumns() {
        return this.joinColumns(this.getTableSubPartitionColumns());
    }

    protected StringBuilder joinColumns(Collection<OracleTablePartitionColumn> cols) {
        if (CollectionUtils.isEmpty(cols)) {
            throw new IllegalArgumentException("Table partition columns is null. Object: " + this.getOriginSchemaObjectName());
        }
        return this.enclose(cols.stream().map(e -> ((OracleTablePartitionColumn)e).isExpression ? e.getColumnName() : this.wrapAndCase(e.getColumnName(), "columnCase")).collect(Collectors.joining(", ")));
    }

    public Collection<OracleTablePartitionItem> getTablePartitions() {
        return this.tablePartitions;
    }

    public Collection<OracleTablePartitionColumn> getTablePartitionColumns() {
        return this.tablePartitionColumns;
    }

    public String getTablePartitionExpression() {
        return this.tablePartitionExpression;
    }

    public void setTablePartitionExpression(String tablePartitionExpression) {
        this.tablePartitionExpression = tablePartitionExpression;
    }

    public Collection<OracleTablePartitionColumn> getTableSubPartitionColumns() {
        return this.tableSubPartitionColumns;
    }

    public String getTableSubPartitionExpression() {
        return this.tableSubPartitionExpression;
    }

    public void setTableSubPartitionExpression(String tableSubPartitionExpression) {
        this.tableSubPartitionExpression = tableSubPartitionExpression;
    }

    public Collection<OracleTablePartitionTemplate> getTablePartitionTemplates() {
        return this.tablePartitionTemplates;
    }

    public Map<String, List<OracleTablePartitionItem>> getTableSubPartitionMapping() {
        return this.tableSubPartitionMapping;
    }

    public String getPartitioningType() {
        return this.partitioningType;
    }

    public void setPartitioningType(String partitioningType) {
        this.partitioningType = partitioningType;
    }

    public String getSubPartitioningType() {
        return this.subPartitioningType;
    }

    public void setSubPartitioningType(String subPartitioningType) {
        this.subPartitioningType = subPartitioningType;
    }

    public Integer getPartitionCount() {
        return this.partitionCount;
    }

    public void setPartitionCount(Integer partitionCount) {
        this.partitionCount = partitionCount;
    }

    public Integer getDefSubPartitionCount() {
        return this.defSubPartitionCount;
    }

    public void setDefSubPartitionCount(Integer defSubPartitionCount) {
        this.defSubPartitionCount = defSubPartitionCount;
    }

    public Integer getPartitioningKeyCount() {
        return this.partitioningKeyCount;
    }

    public void setPartitioningKeyCount(Integer partitioningKeyCount) {
        this.partitioningKeyCount = partitioningKeyCount;
    }

    public Integer getSubPartitioningKeyCount() {
        return this.subPartitioningKeyCount;
    }

    public void setSubPartitioningKeyCount(Integer subPartitioningKeyCount) {
        this.subPartitioningKeyCount = subPartitioningKeyCount;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getDefTablespaceName() {
        return this.defTablespaceName;
    }

    public void setDefTablespaceName(String defTablespaceName) {
        this.defTablespaceName = defTablespaceName;
    }

    public Integer getDefPctFree() {
        return this.defPctFree;
    }

    public void setDefPctFree(Integer defPctFree) {
        this.defPctFree = defPctFree;
    }

    public Integer getDefPctUsed() {
        return this.defPctUsed;
    }

    public void setDefPctUsed(Integer defPctUsed) {
        this.defPctUsed = defPctUsed;
    }

    public Integer getDefIniTrans() {
        return this.defIniTrans;
    }

    public void setDefIniTrans(Integer defIniTrans) {
        this.defIniTrans = defIniTrans;
    }

    public Integer getDefMaxTrans() {
        return this.defMaxTrans;
    }

    public void setDefMaxTrans(Integer defMaxTrans) {
        this.defMaxTrans = defMaxTrans;
    }

    public String getDefInitialExtent() {
        return this.defInitialExtent;
    }

    public void setDefInitialExtent(String defInitialExtent) {
        this.defInitialExtent = defInitialExtent;
    }

    public String getDefNextExtent() {
        return this.defNextExtent;
    }

    public void setDefNextExtent(String defNextExtent) {
        this.defNextExtent = defNextExtent;
    }

    public String getDefMinExtents() {
        return this.defMinExtents;
    }

    public void setDefMinExtents(String defMinExtents) {
        this.defMinExtents = defMinExtents;
    }

    public String getDefMaxExtents() {
        return this.defMaxExtents;
    }

    public void setDefMaxExtents(String defMaxExtents) {
        this.defMaxExtents = defMaxExtents;
    }

    public String getDefMaxSize() {
        return this.defMaxSize;
    }

    public void setDefMaxSize(String defMaxSize) {
        this.defMaxSize = defMaxSize;
    }

    public String getDefPctIncrease() {
        return this.defPctIncrease;
    }

    public void setDefPctIncrease(String defPctIncrease) {
        this.defPctIncrease = defPctIncrease;
    }

    public Integer getDefFreeLists() {
        return this.defFreeLists;
    }

    public void setDefFreeLists(Integer defFreeLists) {
        this.defFreeLists = defFreeLists;
    }

    public Integer getDefFreeListGroups() {
        return this.defFreeListGroups;
    }

    public void setDefFreeListGroups(Integer defFreeListGroups) {
        this.defFreeListGroups = defFreeListGroups;
    }

    public String getDefLogging() {
        return this.defLogging;
    }

    public void setDefLogging(String defLogging) {
        this.defLogging = defLogging;
    }

    public String getDefCompression() {
        return this.defCompression;
    }

    public void setDefCompression(String defCompression) {
        this.defCompression = defCompression;
    }

    public String getDefCompressFor() {
        return this.defCompressFor;
    }

    public void setDefCompressFor(String defCompressFor) {
        this.defCompressFor = defCompressFor;
    }

    public String getDefBufferPool() {
        return this.defBufferPool;
    }

    public void setDefBufferPool(String defBufferPool) {
        this.defBufferPool = defBufferPool;
    }

    public String getDefFlashCache() {
        return this.defFlashCache;
    }

    public void setDefFlashCache(String defFlashCache) {
        this.defFlashCache = defFlashCache;
    }

    public String getDefCellFlashCache() {
        return this.defCellFlashCache;
    }

    public void setDefCellFlashCache(String defCellFlashCache) {
        this.defCellFlashCache = defCellFlashCache;
    }

    public String getRefPtnConstraintName() {
        return this.refPtnConstraintName;
    }

    public void setRefPtnConstraintName(String refPtnConstraintName) {
        this.refPtnConstraintName = refPtnConstraintName;
    }

    public String getInterval() {
        return this.interval;
    }

    public void setInterval(String interval) {
        this.interval = interval;
    }

    public String getIsNested() {
        return this.isNested;
    }

    public void setIsNested(String isNested) {
        this.isNested = isNested;
    }

    public String getDefSegmentCreation() {
        return this.defSegmentCreation;
    }

    public void setDefSegmentCreation(String defSegmentCreation) {
        this.defSegmentCreation = defSegmentCreation;
    }

    public static class OracleTablePartitionItem {
        private String tableName;
        private String composite;
        private String partitionName;
        private Integer subPartitionCount;
        private String subPartitionName;
        private String highValue;
        private Integer highValueLength;
        private Integer partitionPosition;
        private String tablespaceName;
        private Integer pctFree;
        private Integer pctUsed;
        private Integer iniTrans;
        private Integer maxTrans;
        private Integer initialExtent;
        private Integer nextExtent;
        private Integer minExtent;
        private Integer maxExtent;
        private Integer maxSize;
        private Integer pctIncrease;
        private Integer freeLists;
        private Integer freeListGroups;
        private String logging;
        private String compression;
        private String compressFor;
        private Integer numRows;
        private Integer blocks;
        private Integer emptyBlocks;
        private Integer avgSpace;
        private Integer chainCnt;
        private Integer avgRowLen;
        private Integer sampleSize;
        private Date lastAnalyzed;
        private String bufferPool;
        private String flashCache;
        private String cellFlashCache;
        private String globalStats;
        private String userStats;
        private String isNested;
        private String parentTablePartition;
        private String interval;
        private String segmentCreated;
        private String generated;

        public String getUniformHighValue() {
            if (this.getHighValue() == null) {
                return "High value is null";
            }
            return Arrays.stream(this.getHighValue().split(",")).filter(e -> e != null).map(e -> {
                if ((e = e.trim()).startsWith("'") && e.endsWith("'")) {
                    return e;
                }
                return "'" + e + "'";
            }).collect(Collectors.joining(","));
        }

        public int hashCode() {
            if (this.partitionPosition == null || this.partitionPosition < 0) {
                return Objects.hash(this.partitionName, this.partitionPosition);
            }
            return Objects.hash(this.partitionPosition);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            OracleTablePartitionItem other = (OracleTablePartitionItem)obj;
            if (this.partitionPosition == null || this.partitionPosition < 0) {
                return Objects.deepEquals(other.partitionName, this.partitionName) && Objects.deepEquals(other.partitionPosition, this.partitionPosition);
            }
            return Objects.deepEquals(other.partitionPosition, this.partitionPosition);
        }

        public String getTableName() {
            return this.tableName;
        }

        public void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public String getComposite() {
            return this.composite;
        }

        public void setComposite(String composite) {
            this.composite = composite;
        }

        public String getPartitionName() {
            return this.partitionName;
        }

        public void setPartitionName(String partitionName) {
            this.partitionName = partitionName;
        }

        public Integer getSubPartitionCount() {
            return this.subPartitionCount;
        }

        public void setSubPartitionCount(Integer subPartitionCount) {
            this.subPartitionCount = subPartitionCount;
        }

        public String getSubPartitionName() {
            return this.subPartitionName;
        }

        public void setSubPartitionName(String subPartitionName) {
            this.subPartitionName = subPartitionName;
        }

        public String getHighValue() {
            return this.highValue;
        }

        public void setHighValue(String highValue) {
            this.highValue = highValue;
        }

        public Integer getHighValueLength() {
            return this.highValueLength;
        }

        public void setHighValueLength(Integer highValueLength) {
            this.highValueLength = highValueLength;
        }

        public Integer getPartitionPosition() {
            return this.partitionPosition;
        }

        public void setPartitionPosition(Integer partitionPosition) {
            this.partitionPosition = partitionPosition;
        }

        public String getTablespaceName() {
            return this.tablespaceName;
        }

        public void setTablespaceName(String tablespaceName) {
            this.tablespaceName = tablespaceName;
        }

        public Integer getPctFree() {
            return this.pctFree;
        }

        public void setPctFree(Integer pctFree) {
            this.pctFree = pctFree;
        }

        public Integer getPctUsed() {
            return this.pctUsed;
        }

        public void setPctUsed(Integer pctUsed) {
            this.pctUsed = pctUsed;
        }

        public Integer getIniTrans() {
            return this.iniTrans;
        }

        public void setIniTrans(Integer iniTrans) {
            this.iniTrans = iniTrans;
        }

        public Integer getMaxTrans() {
            return this.maxTrans;
        }

        public void setMaxTrans(Integer maxTrans) {
            this.maxTrans = maxTrans;
        }

        public Integer getInitialExtent() {
            return this.initialExtent;
        }

        public void setInitialExtent(Integer initialExtent) {
            this.initialExtent = initialExtent;
        }

        public Integer getNextExtent() {
            return this.nextExtent;
        }

        public void setNextExtent(Integer nextExtent) {
            this.nextExtent = nextExtent;
        }

        public Integer getMinExtent() {
            return this.minExtent;
        }

        public void setMinExtent(Integer minExtent) {
            this.minExtent = minExtent;
        }

        public Integer getMaxExtent() {
            return this.maxExtent;
        }

        public void setMaxExtent(Integer maxExtent) {
            this.maxExtent = maxExtent;
        }

        public Integer getMaxSize() {
            return this.maxSize;
        }

        public void setMaxSize(Integer maxSize) {
            this.maxSize = maxSize;
        }

        public Integer getPctIncrease() {
            return this.pctIncrease;
        }

        public void setPctIncrease(Integer pctIncrease) {
            this.pctIncrease = pctIncrease;
        }

        public Integer getFreeLists() {
            return this.freeLists;
        }

        public void setFreeLists(Integer freeLists) {
            this.freeLists = freeLists;
        }

        public Integer getFreeListGroups() {
            return this.freeListGroups;
        }

        public void setFreeListGroups(Integer freeListGroups) {
            this.freeListGroups = freeListGroups;
        }

        public String getLogging() {
            return this.logging;
        }

        public void setLogging(String logging) {
            this.logging = logging;
        }

        public String getCompression() {
            return this.compression;
        }

        public void setCompression(String compression) {
            this.compression = compression;
        }

        public String getCompressFor() {
            return this.compressFor;
        }

        public void setCompressFor(String compressFor) {
            this.compressFor = compressFor;
        }

        public Integer getNumRows() {
            return this.numRows;
        }

        public void setNumRows(Integer numRows) {
            this.numRows = numRows;
        }

        public Integer getBlocks() {
            return this.blocks;
        }

        public void setBlocks(Integer blocks) {
            this.blocks = blocks;
        }

        public Integer getEmptyBlocks() {
            return this.emptyBlocks;
        }

        public void setEmptyBlocks(Integer emptyBlocks) {
            this.emptyBlocks = emptyBlocks;
        }

        public Integer getAvgSpace() {
            return this.avgSpace;
        }

        public void setAvgSpace(Integer avgSpace) {
            this.avgSpace = avgSpace;
        }

        public Integer getChainCnt() {
            return this.chainCnt;
        }

        public void setChainCnt(Integer chainCnt) {
            this.chainCnt = chainCnt;
        }

        public Integer getAvgRowLen() {
            return this.avgRowLen;
        }

        public void setAvgRowLen(Integer avgRowLen) {
            this.avgRowLen = avgRowLen;
        }

        public Integer getSampleSize() {
            return this.sampleSize;
        }

        public void setSampleSize(Integer sampleSize) {
            this.sampleSize = sampleSize;
        }

        public Date getLastAnalyzed() {
            return this.lastAnalyzed;
        }

        public void setLastAnalyzed(Date lastAnalyzed) {
            this.lastAnalyzed = lastAnalyzed;
        }

        public String getBufferPool() {
            return this.bufferPool;
        }

        public void setBufferPool(String bufferPool) {
            this.bufferPool = bufferPool;
        }

        public String getFlashCache() {
            return this.flashCache;
        }

        public void setFlashCache(String flashCache) {
            this.flashCache = flashCache;
        }

        public String getCellFlashCache() {
            return this.cellFlashCache;
        }

        public void setCellFlashCache(String cellFlashCache) {
            this.cellFlashCache = cellFlashCache;
        }

        public String getGlobalStats() {
            return this.globalStats;
        }

        public void setGlobalStats(String globalStats) {
            this.globalStats = globalStats;
        }

        public String getUserStats() {
            return this.userStats;
        }

        public void setUserStats(String userStats) {
            this.userStats = userStats;
        }

        public String getIsNested() {
            return this.isNested;
        }

        public void setIsNested(String isNested) {
            this.isNested = isNested;
        }

        public String getParentTablePartition() {
            return this.parentTablePartition;
        }

        public void setParentTablePartition(String parentTablePartition) {
            this.parentTablePartition = parentTablePartition;
        }

        public String getInterval() {
            return this.interval;
        }

        public void setInterval(String interval) {
            this.interval = interval;
        }

        public String getSegmentCreated() {
            return this.segmentCreated;
        }

        public void setSegmentCreated(String segmentCreated) {
            this.segmentCreated = segmentCreated;
        }

        public String getGenerated() {
            return this.generated;
        }

        public void setGenerated(String generated) {
            this.generated = generated;
        }
    }

    public static class OracleTablePartitionTemplate {
        private String subPartitionName;
        private Integer subPartitionPosition;
        private String tablespaceName;
        private String highBound;
        private String compression;
        private String indexing;
        private String readOnly;

        public String getSubPartitionName() {
            return this.subPartitionName;
        }

        public void setSubPartitionName(String subPartitionName) {
            this.subPartitionName = subPartitionName;
        }

        public Integer getSubPartitionPosition() {
            return this.subPartitionPosition;
        }

        public void setSubPartitionPosition(Integer subPartitionPosition) {
            this.subPartitionPosition = subPartitionPosition;
        }

        public String getTablespaceName() {
            return this.tablespaceName;
        }

        public void setTablespaceName(String tablespaceName) {
            this.tablespaceName = tablespaceName;
        }

        public String getHighBound() {
            return this.highBound;
        }

        public void setHighBound(String highBound) {
            this.highBound = highBound;
        }

        public String getCompression() {
            return this.compression;
        }

        public void setCompression(String compression) {
            this.compression = compression;
        }

        public String getIndexing() {
            return this.indexing;
        }

        public void setIndexing(String indexing) {
            this.indexing = indexing;
        }

        public String getReadOnly() {
            return this.readOnly;
        }

        public void setReadOnly(String readOnly) {
            this.readOnly = readOnly;
        }
    }

    public static class OracleTablePartitionColumn {
        private String name;
        private String objectType;
        private String columnName;
        private Integer columnPosition;
        private Integer collatedColumnId;
        private boolean isExpression;

        public OracleTablePartitionColumn(String columnName) {
            this.columnName = columnName;
        }

        public OracleTablePartitionColumn() {
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getObjectType() {
            return this.objectType;
        }

        public void setObjectType(String objectType) {
            this.objectType = objectType;
        }

        public String getColumnName() {
            return this.columnName;
        }

        public void setColumnName(String columnName) {
            this.columnName = columnName;
        }

        public Integer getColumnPosition() {
            return this.columnPosition;
        }

        public void setColumnPosition(Integer columnPosition) {
            this.columnPosition = columnPosition;
        }

        public Integer getCollatedColumnId() {
            return this.collatedColumnId;
        }

        public void setCollatedColumnId(Integer collatedColumnId) {
            this.collatedColumnId = collatedColumnId;
        }

        public boolean isExpression() {
            return this.isExpression;
        }

        public void setExpression(boolean isExpression) {
            this.isExpression = isExpression;
        }
    }
}

