/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.model.oracle11g;

import com.oceanbase.obtools.common.utils.StringUtils;
import com.oceanbase.obtools.dbdiff.compare.result.ObjectDefine;
import com.oceanbase.obtools.dbdiff.enums.DbType;
import com.oceanbase.obtools.dbdiff.exception.UnmatchedObjectTypeException;
import com.oceanbase.obtools.dbdiff.exception.UnsupportedGrammarException;
import com.oceanbase.obtools.dbdiff.model.AbstractColumn;
import com.oceanbase.obtools.dbdiff.model.oracle.AbstractOracleColumn;
import com.oceanbase.obtools.dbdiff.model.oracle11g.Oracle11gSchema;
import java.util.List;

public class Oracle11gColumn
extends AbstractOracleColumn {
    public Oracle11gColumn(Oracle11gSchema schema) {
        super(schema);
    }

    @Override
    public StringBuilder buildGrammar() throws UnsupportedGrammarException {
        String dataType = this.getDataType();
        if (dataType == null) {
            throw new IllegalArgumentException("DataType is null");
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.getGrammarColumnName()).append(" ");
        String dataTypeOwner = this.getDataTypeOwner();
        if (StringUtils.isNotBlank((CharSequence)dataTypeOwner)) {
            sb.append(this.wrap(dataTypeOwner)).append(".").append(this.wrap(dataType));
        } else {
            if (DbType.ORACLE_21C.getType().equals(this.getDbType().getType()) && DbType.ORACLE_21C.isSubsequent(this.getDbType()) && "JSON".equals(dataType)) {
                throw new UnsupportedGrammarException(this.getSchemaObjectName(), "The data type: \"" + dataType + "\" is unsupported in " + this.getDbType());
            }
            sb.append(dataType);
            switch (dataType) {
                case "DATE": 
                case "ROWID": 
                case "CLOB": 
                case "BLOB": 
                case "NCLOB": 
                case "BINARY_FLOAT": 
                case "BINARY_DOUBLE": 
                case "JSON": {
                    break;
                }
                case "FLOAT": {
                    Integer dataPrecision = this.getDataPrecision();
                    if (dataPrecision == null || dataPrecision <= 0) break;
                    sb.append("(").append(dataPrecision).append(")");
                    break;
                }
                case "NUMBER": {
                    Integer dataPrecision = this.getDataPrecision();
                    Integer dataScale = this.getDataScale();
                    if (dataPrecision != null && dataPrecision > 0) {
                        sb.append("(").append(dataPrecision);
                        if (dataScale != null && dataScale != 0) {
                            sb.append(",").append(dataScale);
                        }
                        sb.append(")");
                        break;
                    }
                    if (dataScale == null || dataScale <= -1) break;
                    sb.append("(*,").append(dataScale).append(")");
                    break;
                }
                case "NCHAR": 
                case "NVARCHAR2": {
                    if (DbType.OBORACLE_2220.getType().equals(this.getOriginDbType().getType()) && StringUtils.isBlank((CharSequence)this.getCharUsed()) && this.getCharLength() == 0L) {
                        sb.append("(").append(this.getDataLength()).append(")");
                        break;
                    }
                    sb.append("(").append(this.getCharLength()).append(")");
                    break;
                }
                default: {
                    if (dataType.startsWith("TIMESTAMP") || dataType.startsWith("INTERVAL")) break;
                    String charUsed = this.getCharUsed();
                    if ("B".equals(charUsed)) {
                        sb.append("(").append(this.getCharLength()).append(" BYTE)");
                        break;
                    }
                    if ("C".equals(charUsed)) {
                        sb.append("(").append(this.getCharLength()).append(" CHAR)");
                        break;
                    }
                    Long dataLength = this.getDataLength();
                    if (dataLength == null || dataLength <= 0L) break;
                    sb.append("(").append(dataLength).append(")");
                }
            }
        }
        String hiddenColumn = this.getHiddenColumn();
        if (this.getDbType().isSubsequentFrom(DbType.ORACLE_12CR1) && "YES".equals(hiddenColumn)) {
            sb.append(" INVISIBLE");
        }
        if ("YES".equals(this.getIdentityColumn())) {
            sb.append(" GENERATED ").append(this.getGenerationType());
            if (this.getIdentityExpr() != null) {
                sb.append((CharSequence)this.getIdentityExpr().buildIdentityGrammar());
            }
        } else {
            String columnDefault = this.getColumnDefault();
            if (columnDefault != null) {
                if ("YES".equals(this.getVirtualColumn())) {
                    sb.append(" GENERATED ALWAYS AS");
                    sb.append((CharSequence)this.enclose(columnDefault)).append(" VIRTUAL");
                } else {
                    sb.append(" DEFAULT ");
                    if ("YES".equals(this.getDefaultOnNull())) {
                        sb.append("ON NULL ");
                    }
                    columnDefault = columnDefault.trim();
                    if (DbType.OBORACLE_2272.getType().equals(this.getOriginDbType().getType()) && (this.isCharType() || this.isVarcharType()) && columnDefault.startsWith("'") && !columnDefault.endsWith("'")) {
                        columnDefault = columnDefault + "'";
                    }
                    sb.append(columnDefault);
                    if (columnDefault.contains("--")) {
                        sb.append("\n");
                    }
                }
            }
        }
        if ("N".equals(this.getNullable())) {
            sb.append(" NOT NULL");
        }
        return sb;
    }

    @Override
    public List<ObjectDefine> compareTo(AbstractColumn other) {
        if (!(other instanceof Oracle11gColumn)) {
            throw new UnmatchedObjectTypeException("Raw type is not matched");
        }
        return null;
    }
}

