/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.model.oracle11g;

import com.oceanbase.obtools.dbdiff.compare.result.ChangeInfo;
import com.oceanbase.obtools.dbdiff.compare.result.ObjectDefine;
import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import com.oceanbase.obtools.dbdiff.exception.UnmatchedObjectTypeException;
import com.oceanbase.obtools.dbdiff.exception.UnsupportedGrammarException;
import com.oceanbase.obtools.dbdiff.model.AbstractConstraint;
import com.oceanbase.obtools.dbdiff.model.oracle.AbstractOracleConstraint;
import com.oceanbase.obtools.dbdiff.model.oracle11g.Oracle11gSchema;
import com.oceanbase.obtools.dbdiff.utils.ChangeUtils;
import java.util.List;

public class Oracle11gForeignKey
extends AbstractOracleConstraint {
    public Oracle11gForeignKey(Oracle11gSchema schema) {
        super(schema);
    }

    @Override
    public StringBuilder buildGrammar() throws UnsupportedGrammarException {
        StringBuilder sb = new StringBuilder();
        if ("USER NAME".equals(this.getGenerated())) {
            sb.append("CONSTRAINT ").append(this.wrap(this.getConstraintName())).append(" ");
        }
        sb.append("FOREIGN KEY").append((CharSequence)this.joinForeignConstraintColumns());
        sb.append(" REFERENCES ").append(this.getRefOwnerTableName());
        sb.append((CharSequence)this.joinRefConstraintColumns());
        sb.append(this.safetyMapping(DELETE_RULE_MAPPING, this.getDeleteRule()));
        sb.append(this.safetyMapping(OPTION_MAPPING, this.getDeferrable()));
        sb.append(this.safetyMapping(OPTION_MAPPING, this.getDeferred()));
        sb.append(this.safetyMapping(OPTION_MAPPING, this.getRely()));
        String status = this.getStatus();
        String validated = this.getValidated();
        StringBuilder discard = new StringBuilder(sb);
        discard.append(this.safetyMapping(OPTION_MAPPING, status));
        discard.append(this.safetyMapping(OPTION_MAPPING, validated));
        if ("DISABLED".equalsIgnoreCase(status)) {
            ChangeUtils.info(ObjectType.TABLE, this.getSchemaObjectName(), ChangeInfo.ChangeType.DISCARD, discard + " -> [NULL]");
            return new StringBuilder(0);
        }
        StringBuilder alter = new StringBuilder();
        alter.append("ALTER TABLE ").append(this.getSchemaObjectName());
        alter.append(" ADD ").append((CharSequence)sb);
        alter.append(this.safetyMapping(OPTION_MAPPING, status));
        alter.append(this.safetyMapping(OPTION_MAPPING, validated));
        ChangeUtils.warn(ObjectType.TABLE, this.getSchemaObjectName(), ChangeInfo.ChangeType.DISCARD, discard + " -> [NULL]", alter.toString());
        return new StringBuilder(0);
    }

    @Override
    public List<ObjectDefine> compareTo(AbstractConstraint other) {
        if (!(other instanceof Oracle11gForeignKey)) {
            throw new UnmatchedObjectTypeException("Raw type is not matched");
        }
        return null;
    }
}

