/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.model.oracle11g;

import com.google.common.collect.Lists;
import com.oceanbase.obtools.dbdiff.compare.result.CreateObjectDefine;
import com.oceanbase.obtools.dbdiff.compare.result.ObjectDefine;
import com.oceanbase.obtools.dbdiff.enums.DbType;
import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import com.oceanbase.obtools.dbdiff.exception.UnmatchedObjectTypeException;
import com.oceanbase.obtools.dbdiff.exception.UnsupportedGrammarException;
import com.oceanbase.obtools.dbdiff.model.AbstractFunction;
import com.oceanbase.obtools.dbdiff.model.oracle11g.Oracle11gSchema;
import java.util.List;

public class Oracle11gFunction
extends AbstractFunction {
    private String editionable;

    public Oracle11gFunction(Oracle11gSchema schema) {
        super(schema);
    }

    @Override
    public List<ObjectDefine> buildDefinition() throws UnsupportedGrammarException {
        DbType originType = this.getOriginDbType();
        if (!originType.isOracleType()) {
            throw new UnsupportedGrammarException(this.getSchemaObjectName(), "Origin dbType is not allowed to convert to ORACLE functions: " + originType);
        }
        StringBuilder sb = new StringBuilder();
        if (!this.isFullText()) {
            sb.append("CREATE OR REPLACE ");
            if ("N".equals(this.getEditionable())) {
                sb.append("NONEDITIONABLE ");
            }
        }
        sb.append(this.getText());
        return Lists.newArrayList((Object[])new ObjectDefine[]{new CreateObjectDefine(ObjectType.FUNCTION, this.getSimpleObjectName(), sb.toString())});
    }

    @Override
    public List<ObjectDefine> compareTo(AbstractFunction other) {
        if (!(other instanceof Oracle11gFunction)) {
            throw new UnmatchedObjectTypeException("Raw type is not matched");
        }
        return null;
    }

    public String getEditionable() {
        return this.editionable;
    }

    public void setEditionable(String editionable) {
        this.editionable = editionable;
    }
}

