/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.model.oracle11g;

import com.oceanbase.obtools.common.collect.Lists;
import com.oceanbase.obtools.common.utils.StringUtils;
import com.oceanbase.obtools.dbdiff.compare.result.CreateObjectDefine;
import com.oceanbase.obtools.dbdiff.compare.result.ObjectDefine;
import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import com.oceanbase.obtools.dbdiff.exception.UnmatchedObjectTypeException;
import com.oceanbase.obtools.dbdiff.exception.UnsupportedGrammarException;
import com.oceanbase.obtools.dbdiff.model.AbstractIndex;
import com.oceanbase.obtools.dbdiff.model.oracle.AbstractOracleIndex;
import com.oceanbase.obtools.dbdiff.model.oracle11g.Oracle11gIndexPartition;
import com.oceanbase.obtools.dbdiff.model.oracle11g.Oracle11gSchema;
import java.util.List;

public class Oracle11gIndex
extends AbstractOracleIndex {
    private Oracle11gIndexPartition indexPartition;

    public Oracle11gIndex(Oracle11gSchema schema) {
        super(schema);
    }

    @Override
    public List<ObjectDefine> buildDefinition() throws UnsupportedGrammarException {
        String indexType = this.getIndexType();
        if ("DOMAIN".equals(indexType)) {
            throw new UnsupportedGrammarException(this.getOriginSchemaObjectName(), "The domain index is unsupported");
        }
        if ("CLUSTER".equals(indexType)) {
            throw new UnsupportedGrammarException(this.getOriginSchemaObjectName(), "The cluster index is unsupported");
        }
        if ("YES".equals(this.getJoinIndex())) {
            throw new UnsupportedGrammarException(this.getOriginSchemaObjectName(), "The join index is unsupported");
        }
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE");
        if ("BITMAP".equals(indexType)) {
            sb.append(" BITMAP");
        } else {
            sb.append(this.safetyMapping(this.getUniqueRuleMapping(), this.getUniqueness()));
        }
        if (this.getUniqueRuleMapping().containsKey(this.getUniqueness())) {
            this.addUniqueAttribute();
        }
        String indexName = this.getSchemaIndexName();
        sb.append(" INDEX ").append(indexName).append(" ON ");
        sb.append(this.getDefinitionSchemaObjectName()).append((CharSequence)this.joinIndexColumns());
        Oracle11gIndexPartition indexPartition = this.getIndexPartition();
        if (indexPartition != null) {
            sb.append((CharSequence)indexPartition.buildGrammar());
        }
        sb.append((CharSequence)this.appendIndexOptions());
        return Lists.newArrayList((Object[])new ObjectDefine[]{new CreateObjectDefine(ObjectType.INDEX, this.getIndexType(), this.getSimpleIndexName(), this.terminate(sb))});
    }

    private StringBuilder appendIndexOptions() {
        String logging;
        Integer iniTrans;
        StringBuilder sb = new StringBuilder();
        Integer pctFree = this.getPctFree();
        if (pctFree != null && pctFree > 0) {
            sb.append(" PCTFREE ").append(pctFree);
        }
        if ((iniTrans = this.getIniTrans()) != null && iniTrans > 0) {
            sb.append(" INITRANS ").append(iniTrans);
        }
        if ("YES".equals(logging = this.getLogging())) {
            sb.append(" LOGGING");
        } else if ("NO".equals(logging)) {
            sb.append(" NOLOGGING");
        }
        String tablespaceName = this.getTablespaceName();
        if (StringUtils.isNotBlank((CharSequence)tablespaceName)) {
            sb.append(" TABLESPACE ").append(this.wrap(tablespaceName));
        }
        Integer prefixLength = this.getPrefixLength();
        boolean isCompressed = "ENABLED".equals(this.getCompression());
        if (isCompressed && prefixLength != null && prefixLength > 0) {
            sb.append(" COMPRESS ").append(prefixLength);
        }
        if (StringUtils.contains((String)this.getIndexType(), (String)"NORMAL/REV")) {
            sb.append(" REVERSE");
        }
        if ("INVISIBLE".equals(this.getVisibility())) {
            sb.append(" INVISIBLE");
        }
        if ("UNUSABLE".equals(this.getStatus())) {
            sb.append(" UNUSABLE");
        }
        return sb;
    }

    @Override
    public List<ObjectDefine> compareTo(AbstractIndex other) {
        if (!(other instanceof Oracle11gIndex)) {
            throw new UnmatchedObjectTypeException("Raw type is not matched");
        }
        return null;
    }

    public Oracle11gIndexPartition getIndexPartition() {
        return this.indexPartition;
    }

    public void setIndexPartition(Oracle11gIndexPartition indexPartition) {
        this.indexPartition = indexPartition;
    }
}

