/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.model.oracle11g;

import com.oceanbase.obtools.dbdiff.compare.result.ChangeInfo;
import com.oceanbase.obtools.dbdiff.compare.result.ObjectDefine;
import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import com.oceanbase.obtools.dbdiff.exception.UnmatchedObjectTypeException;
import com.oceanbase.obtools.dbdiff.exception.UnsupportedGrammarException;
import com.oceanbase.obtools.dbdiff.model.AbstractConstraint;
import com.oceanbase.obtools.dbdiff.model.oracle.AbstractOracleConstraint;
import com.oceanbase.obtools.dbdiff.model.oracle11g.Oracle11gSchema;
import com.oceanbase.obtools.dbdiff.utils.ChangeUtils;
import java.util.List;

public class Oracle11gPrimaryKey
extends AbstractOracleConstraint {
    public Oracle11gPrimaryKey(Oracle11gSchema schema) {
        super(schema);
    }

    @Override
    public StringBuilder buildGrammar() throws UnsupportedGrammarException {
        StringBuilder sb = new StringBuilder();
        if ("USER NAME".equals(this.getGenerated())) {
            sb.append("CONSTRAINT ").append(this.wrap(this.getConstraintName())).append(" ");
        }
        sb.append("PRIMARY KEY").append((CharSequence)this.joinConstraintColumns());
        sb.append(this.safetyMapping(OPTION_MAPPING, this.getDeferrable()));
        sb.append(this.safetyMapping(OPTION_MAPPING, this.getDeferred()));
        sb.append(this.safetyMapping(OPTION_MAPPING, this.getRely()));
        String status = this.getStatus();
        String validated = this.getValidated();
        if (super.getSchema().isDumpOperation()) {
            return sb;
        }
        if ("DISABLED".equalsIgnoreCase(status) || "NOT VALIDATED".equalsIgnoreCase(validated)) {
            StringBuilder discard = new StringBuilder(sb);
            discard.append(this.safetyMapping(OPTION_MAPPING, status));
            discard.append(this.safetyMapping(OPTION_MAPPING, validated));
            ChangeUtils.warn(ObjectType.TABLE, this.getSchemaObjectName(), ChangeInfo.ChangeType.DISCARD, discard + " -> [NULL]");
            return new StringBuilder(0);
        }
        return sb;
    }

    @Override
    public List<ObjectDefine> compareTo(AbstractConstraint other) {
        if (!(other instanceof Oracle11gPrimaryKey)) {
            throw new UnmatchedObjectTypeException("Raw type is not matched");
        }
        return null;
    }
}

