/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.model.oracle11g;

import com.oceanbase.obtools.dbdiff.compare.result.ObjectDefine;
import com.oceanbase.obtools.dbdiff.enums.DbType;
import com.oceanbase.obtools.dbdiff.exception.UnmatchedObjectTypeException;
import com.oceanbase.obtools.dbdiff.model.AbstractSequence;
import com.oceanbase.obtools.dbdiff.model.oracle.AbstractOracleSequence;
import com.oceanbase.obtools.dbdiff.model.oracle11g.Oracle11gSchema;
import java.util.List;

public class Oracle11gSequence
extends AbstractOracleSequence {
    private boolean identityExpr;
    private String scaleFlag;
    private String extendFlag;
    private String shardedFlag;
    private String sessionFlag;
    private String keepValue;

    public Oracle11gSequence(Oracle11gSchema schema) {
        super(schema);
    }

    @Override
    public StringBuilder buildSequenceGrammar() {
        boolean isOracleType;
        DbType dbType = super.getDbType();
        StringBuilder sb = super.buildSequenceGrammar();
        boolean bl = isOracleType = dbType != null && DbType.ORACLE_11GR2.getType().equals(dbType.getType());
        if (isOracleType && DbType.ORACLE_11GR2.isPrior(dbType)) {
            if ("Y".equals(this.getKeepValue())) {
                sb.append(" KEEP");
            } else {
                sb.append(" NOKEEP");
            }
            if (!this.isIdentityExpr()) {
                if ("Y".equals(this.getSessionFlag())) {
                    sb.append(" SESSION");
                } else {
                    sb.append(" GLOBAL");
                }
            }
        }
        if (isOracleType && DbType.ORACLE_12CR1.isPrior(dbType)) {
            if ("Y".equals(this.getScaleFlag())) {
                sb.append(" SCALE");
                if ("Y".equals(this.getExtendFlag())) {
                    sb.append(" EXTEND");
                } else {
                    sb.append(" NOEXTEND");
                }
            } else {
                sb.append(" NOSCALE");
            }
        }
        if (isOracleType && DbType.ORACLE_18C.isPrior(dbType) && "Y".equals(this.getShardedFlag())) {
            sb.append(" SHARD EXTEND");
        }
        return sb;
    }

    @Override
    public List<ObjectDefine> compareTo(AbstractSequence other) {
        if (!(other instanceof Oracle11gSequence)) {
            throw new UnmatchedObjectTypeException("Raw type is not matched");
        }
        return null;
    }

    public boolean isIdentityExpr() {
        return this.identityExpr;
    }

    public void setIdentityExpr(boolean identityExpr) {
        this.identityExpr = identityExpr;
    }

    public String getScaleFlag() {
        return this.scaleFlag;
    }

    public void setScaleFlag(String scaleFlag) {
        this.scaleFlag = scaleFlag;
    }

    public String getExtendFlag() {
        return this.extendFlag;
    }

    public void setExtendFlag(String extendFlag) {
        this.extendFlag = extendFlag;
    }

    public String getShardedFlag() {
        return this.shardedFlag;
    }

    public void setShardedFlag(String shardedFlag) {
        this.shardedFlag = shardedFlag;
    }

    public String getSessionFlag() {
        return this.sessionFlag;
    }

    public void setSessionFlag(String sessionFlag) {
        this.sessionFlag = sessionFlag;
    }

    public String getKeepValue() {
        return this.keepValue;
    }

    public void setKeepValue(String keepValue) {
        this.keepValue = keepValue;
    }
}

