/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.model.oracle11g;

import com.oceanbase.obtools.common.collect.Lists;
import com.oceanbase.obtools.common.utils.StringUtils;
import com.oceanbase.obtools.dbdiff.compare.result.CreateObjectDefine;
import com.oceanbase.obtools.dbdiff.compare.result.ObjectDefine;
import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import com.oceanbase.obtools.dbdiff.exception.UnmatchedObjectTypeException;
import com.oceanbase.obtools.dbdiff.exception.UnsupportedGrammarException;
import com.oceanbase.obtools.dbdiff.model.AbstractSynonym;
import com.oceanbase.obtools.dbdiff.model.oracle.AbstractOracleSynonym;
import com.oceanbase.obtools.dbdiff.model.oracle11g.Oracle11gSchema;
import java.util.List;

public class Oracle11gSynonym
extends AbstractOracleSynonym {
    private String editionable;

    public Oracle11gSynonym(Oracle11gSchema schema) {
        super(schema);
    }

    @Override
    public List<ObjectDefine> buildDefinition() throws UnsupportedGrammarException {
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE OR REPLACE");
        if ("Y".equals(this.getEditionable())) {
            sb.append(" EDITIONABLE");
        } else if ("N".equals(this.getEditionable())) {
            sb.append(" NONEDITIONABLE");
        }
        boolean isPublicSynonym = "PUBLIC".equals(this.getOwner());
        if (isPublicSynonym) {
            sb.append(" PUBLIC");
        }
        sb.append(" SYNONYM ");
        String objectName = this.getObjectName();
        if (objectName.endsWith("__used_for_distinct_public")) {
            objectName = objectName.substring(0, objectName.length() - "__used_for_distinct_public".length());
        }
        boolean isWithSchema = super.getGlobal().withSchema();
        boolean isTheSameName = StringUtils.equals((CharSequence)objectName, (CharSequence)this.getTableName());
        if (!"PUBLIC".equals(this.getOwner()) && (isWithSchema || isTheSameName)) {
            sb.append(this.wrap(this.getOwner())).append(".");
        }
        sb.append(this.wrap(objectName));
        sb.append(" FOR ");
        if (StringUtils.isNotBlank((CharSequence)this.getTableOwner()) && (isWithSchema || isTheSameName)) {
            sb.append(this.wrap(this.getTableOwner())).append(".");
        }
        sb.append(this.wrap(this.getTableName()));
        if (StringUtils.isNotBlank((CharSequence)this.getDbLink())) {
            sb.append("@").append(this.wrap(this.getDbLink()));
        }
        ObjectType objectType = isPublicSynonym ? ObjectType.PUBLIC_SYNONYM : ObjectType.SYNONYM;
        return Lists.newArrayList((Object[])new ObjectDefine[]{new CreateObjectDefine(objectType, this.getSimpleObjectName(), sb.toString())});
    }

    @Override
    public List<ObjectDefine> compareTo(AbstractSynonym other) {
        if (!(other instanceof Oracle11gSynonym)) {
            throw new UnmatchedObjectTypeException("Raw type is not matched");
        }
        return null;
    }

    public String getEditionable() {
        return this.editionable;
    }

    public void setEditionable(String editionable) {
        this.editionable = editionable;
    }
}

