/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.model.oracle11g;

import com.oceanbase.obtools.common.collect.Lists;
import com.oceanbase.obtools.common.utils.MapUtils;
import com.oceanbase.obtools.common.utils.StringUtils;
import com.oceanbase.obtools.dbdiff.compare.result.ChangeInfo;
import com.oceanbase.obtools.dbdiff.compare.result.CreateObjectDefine;
import com.oceanbase.obtools.dbdiff.compare.result.ObjectDefine;
import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import com.oceanbase.obtools.dbdiff.exception.UnmatchedObjectTypeException;
import com.oceanbase.obtools.dbdiff.exception.UnsupportedGrammarException;
import com.oceanbase.obtools.dbdiff.model.AbstractTable;
import com.oceanbase.obtools.dbdiff.model.base.KeyColumn;
import com.oceanbase.obtools.dbdiff.model.oracle.AbstractOracleConstraint;
import com.oceanbase.obtools.dbdiff.model.oracle.AbstractOracleTable;
import com.oceanbase.obtools.dbdiff.model.oracle11g.Oracle11gCheck;
import com.oceanbase.obtools.dbdiff.model.oracle11g.Oracle11gColumn;
import com.oceanbase.obtools.dbdiff.model.oracle11g.Oracle11gForeignKey;
import com.oceanbase.obtools.dbdiff.model.oracle11g.Oracle11gIndex;
import com.oceanbase.obtools.dbdiff.model.oracle11g.Oracle11gPrimaryKey;
import com.oceanbase.obtools.dbdiff.model.oracle11g.Oracle11gSchema;
import com.oceanbase.obtools.dbdiff.model.oracle11g.Oracle11gTablePartition;
import com.oceanbase.obtools.dbdiff.model.oracle11g.Oracle11gUniqueKey;
import com.oceanbase.obtools.dbdiff.utils.ChangeUtils;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class Oracle11gTable
extends AbstractOracleTable {
    private final Map<String, Oracle11gColumn> columnMapping = new LinkedHashMap<String, Oracle11gColumn>();
    private final Map<String, Oracle11gIndex> indexMapping = new LinkedHashMap<String, Oracle11gIndex>();
    private final Map<String, Oracle11gUniqueKey> uniqueMapping = new LinkedHashMap<String, Oracle11gUniqueKey>();
    private final Map<String, Oracle11gForeignKey> foreignMapping = new LinkedHashMap<String, Oracle11gForeignKey>();
    private final Map<String, Oracle11gCheck> checkMapping = new LinkedHashMap<String, Oracle11gCheck>();
    private Oracle11gPrimaryKey primaryKey;
    private Oracle11gTablePartition tablePartition;

    public Oracle11gTable(Oracle11gSchema schema) {
        super(schema);
    }

    @Override
    public List<ObjectDefine> buildDefinition() throws UnsupportedGrammarException {
        StringBuilder grammar;
        Iterator<AbstractOracleConstraint> grammar2;
        this.preCheck();
        StringBuilder sb = new StringBuilder();
        String objectName = this.getDefinitionSchemaObjectName();
        sb.append("CREATE ");
        if ("Y".equals(this.getTemporary())) {
            sb.append("GLOBAL TEMPORARY ");
        }
        sb.append("TABLE ").append(objectName).append(" (");
        LinkedList<ObjectDefine> subDefines = new LinkedList<ObjectDefine>();
        String tableComment = this.getTableComment();
        if (StringUtils.isNotBlank((CharSequence)tableComment)) {
            tableComment = String.format("COMMENT ON TABLE %s IS '%s'", objectName, tableComment.replace("'", "''"));
            subDefines.add(new CreateObjectDefine(ObjectType.COMMENT, objectName, this.terminate(tableComment)));
        }
        Iterator<Oracle11gColumn> iterator = this.getColumnMapping().values().iterator();
        while (iterator.hasNext()) {
            String colComment;
            Oracle11gColumn col = iterator.next();
            sb.append("\n\t").append((CharSequence)col.buildGrammar());
            if (iterator.hasNext()) {
                sb.append(",");
            }
            if (!StringUtils.isNotBlank((CharSequence)(colComment = col.getColumnComment()))) continue;
            String wrappedName = col.getWrappedName();
            colComment = String.format("COMMENT ON COLUMN %s.%s IS '%s'", objectName, wrappedName, colComment.replace("'", "''"));
            subDefines.add(new CreateObjectDefine(ObjectType.COMMENT, wrappedName, this.terminate(colComment)));
        }
        if (this.getPrimaryKey() != null && StringUtils.isNotBlank((CharSequence)((Object)(grammar2 = this.getPrimaryKey().buildGrammar())))) {
            sb.append(",").append("\n\t").append((CharSequence)((Object)grammar2));
        }
        if (MapUtils.isNotEmpty(this.getUniqueMapping())) {
            for (Oracle11gUniqueKey uniqueKey : this.getUniqueMapping().values()) {
                uniqueKey.setUsingIndexMapping(this.getIndexMapping());
                grammar = uniqueKey.buildGrammar();
                if (!StringUtils.isNotBlank((CharSequence)grammar)) continue;
                sb.append(",").append("\n\t").append((CharSequence)grammar);
            }
        }
        if (MapUtils.isNotEmpty(this.getCheckMapping())) {
            for (Oracle11gCheck check : this.getCheckMapping().values()) {
                grammar = check.buildGrammar();
                if (!StringUtils.isNotBlank((CharSequence)grammar)) continue;
                sb.append(",").append("\n\t").append((CharSequence)grammar);
            }
        }
        if (MapUtils.isNotEmpty(this.getForeignMapping())) {
            for (Oracle11gForeignKey foreignKey : this.getForeignMapping().values()) {
                grammar = foreignKey.buildGrammar();
                if (!StringUtils.isNotBlank((CharSequence)grammar)) continue;
                sb.append(",").append("\n\t").append((CharSequence)grammar);
            }
        }
        sb.append("\n").append(")").append((CharSequence)this.appendAttributeClause());
        Oracle11gTablePartition partition = this.getTablePartition();
        if (partition != null) {
            sb.append((CharSequence)partition.buildGrammar());
        }
        boolean isCompressed = "ENABLED".equals(this.getCompression());
        String compressFor = this.safetyMapping(this.getCompressMapping(), this.getCompressFor());
        if (isCompressed && StringUtils.isNotBlank((CharSequence)compressFor)) {
            sb.append(compressFor);
        }
        if (MapUtils.isNotEmpty(this.getIndexMapping())) {
            Collection<Oracle11gIndex> indexes = this.getIndexMapping().values();
            Iterator<Oracle11gIndex> it = indexes.iterator();
            while (it.hasNext()) {
                Oracle11gIndex index = it.next();
                if (this.isAlreadyIndexed(index)) {
                    it.remove();
                    ChangeUtils.warn(ObjectType.TABLE, objectName, ChangeInfo.ChangeType.DISCARD, "The index \"" + index.getIndexName() + "\" has been removed as it's already indexed on the same columns with constraint");
                    continue;
                }
                subDefines.addAll(index.buildDefinition());
            }
        }
        CreateObjectDefine objectDefine = new CreateObjectDefine(ObjectType.TABLE, this.getSimpleObjectName(), this.terminate(sb), subDefines);
        objectDefine.getChangeInfos().addAll(ChangeUtils.findByKey(ObjectType.TABLE, this.getSchemaObjectName()));
        return Lists.newArrayList((Object[])new ObjectDefine[]{objectDefine});
    }

    private boolean isAlreadyIndexed(Oracle11gIndex index) {
        if (index == null) {
            return false;
        }
        List<KeyColumn> indexColumns = index.getIndexColumns();
        if (this.getPrimaryKey() != null && this.isAlreadyIndexed(indexColumns, this.getPrimaryKey().getConstraintColumns())) {
            return true;
        }
        if (MapUtils.isNotEmpty(this.getUniqueMapping())) {
            for (Oracle11gUniqueKey uniqueKey : this.getUniqueMapping().values()) {
                if (!this.isAlreadyIndexed(indexColumns, uniqueKey.getConstraintColumns())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isAlreadyIndexed(Collection<KeyColumn> indexColumns, Collection<KeyColumn> constColumns) {
        if (indexColumns.size() != constColumns.size()) {
            return false;
        }
        String indexCols = indexColumns.stream().map(e -> {
            boolean needFormat2;
            String col = e.getColumnName();
            boolean needFormat1 = col.startsWith("`") && col.endsWith("`");
            boolean bl = needFormat2 = col.startsWith("\"") && col.endsWith("\"");
            if (needFormat1 || needFormat2) {
                col = col.substring(1, col.length() - 1);
            }
            return col;
        }).collect(Collectors.joining(","));
        return indexCols.equals(constColumns.stream().map(KeyColumn::getColumnName).collect(Collectors.joining(",")));
    }

    protected StringBuilder appendAttributeClause() {
        String logging;
        String storeTableName;
        String nestedTableName;
        String tablespaceName;
        Integer maxTrans;
        Integer iniTrans;
        Integer pctUsed;
        Integer pctFree;
        StringBuilder sb = new StringBuilder();
        String iotType = this.getIotType();
        if (StringUtils.isNotBlank((CharSequence)iotType)) {
            sb.append(" ORGANIZATION INDEX");
        }
        if ((pctFree = this.getPctFree()) != null && pctFree > 0) {
            sb.append(" PCTFREE ").append(pctFree);
        }
        if ((pctUsed = this.getPctUsed()) != null && pctUsed > 0) {
            sb.append(" PCTUSED ").append(pctUsed);
        }
        if ((iniTrans = this.getIniTrans()) != null && iniTrans > 0) {
            sb.append(" INITRANS ").append(iniTrans);
        }
        if ((maxTrans = this.getMaxTrans()) != null && maxTrans > 0) {
            sb.append(" MAXTRANS ").append(maxTrans);
        }
        if (!(!StringUtils.isNotBlank((CharSequence)(tablespaceName = this.getTablespaceName())) || "TEMP".equalsIgnoreCase(tablespaceName) || "USERS".equalsIgnoreCase(tablespaceName) || "SYSTEM".equalsIgnoreCase(tablespaceName) || "SYSAUX".equalsIgnoreCase(tablespaceName))) {
            sb.append(" TABLESPACE ").append(this.wrap(tablespaceName));
        }
        if (StringUtils.isNotBlank((CharSequence)(nestedTableName = this.getNestedTableName()))) {
            sb.append(" NESTED TABLE ").append(this.wrap(nestedTableName));
        }
        if (StringUtils.isNotBlank((CharSequence)(storeTableName = this.getStoreTableName()))) {
            sb.append(" STORE AS ").append(this.wrap(storeTableName));
        }
        if ("YES".equals(logging = this.getLogging())) {
            sb.append(" LOGGING");
        } else if ("NO".equals(logging)) {
            sb.append(" NOLOGGING");
        }
        String duration = this.getDuration();
        if ("SYS$TRANSACTION".equals(duration)) {
            sb.append(" ON COMMIT DELETE ROWS");
        } else if ("SYS$SESSION".equals(duration)) {
            sb.append(" ON COMMIT PRESERVE ROWS");
        }
        return sb;
    }

    @Override
    public List<ObjectDefine> compareTo(AbstractTable other) {
        if (!(other instanceof Oracle11gTable)) {
            throw new UnmatchedObjectTypeException("Raw type is not matched");
        }
        return null;
    }

    public Map<String, Oracle11gColumn> getColumnMapping() {
        return this.columnMapping;
    }

    public Map<String, Oracle11gIndex> getIndexMapping() {
        return this.indexMapping;
    }

    public Map<String, Oracle11gUniqueKey> getUniqueMapping() {
        return this.uniqueMapping;
    }

    public Map<String, Oracle11gForeignKey> getForeignMapping() {
        return this.foreignMapping;
    }

    public Map<String, Oracle11gCheck> getCheckMapping() {
        return this.checkMapping;
    }

    public Oracle11gPrimaryKey getPrimaryKey() {
        return this.primaryKey;
    }

    public void setPrimaryKey(Oracle11gPrimaryKey primaryKey) {
        this.primaryKey = primaryKey;
    }

    public Oracle11gTablePartition getTablePartition() {
        return this.tablePartition;
    }

    public void setTablePartition(Oracle11gTablePartition tablePartition) {
        this.tablePartition = tablePartition;
    }
}

