/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.model.oracle11g;

import com.oceanbase.obtools.common.collect.Lists;
import com.oceanbase.obtools.common.utils.StringUtils;
import com.oceanbase.obtools.dbdiff.compare.result.CreateObjectDefine;
import com.oceanbase.obtools.dbdiff.compare.result.ObjectDefine;
import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import com.oceanbase.obtools.dbdiff.exception.UnmatchedObjectTypeException;
import com.oceanbase.obtools.dbdiff.exception.UnsupportedGrammarException;
import com.oceanbase.obtools.dbdiff.model.AbstractTablespace;
import com.oceanbase.obtools.dbdiff.model.oracle.AbstractOracleTablespace;
import com.oceanbase.obtools.dbdiff.model.oracle11g.Oracle11gSchema;
import java.util.Iterator;
import java.util.List;

public class Oracle11gTablespace
extends AbstractOracleTablespace {
    public Oracle11gTablespace(Oracle11gSchema schema) {
        super(schema);
    }

    @Override
    public List<ObjectDefine> buildDefinition() throws UnsupportedGrammarException {
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE");
        String bigfile = this.getBigfile();
        if ("YES".equals(bigfile)) {
            sb.append(" BIGFILE");
        } else if ("NO".equals(bigfile)) {
            sb.append(" SMALLFILE");
        }
        String contents = this.getContents();
        String objectName = this.getObjectName();
        if ("UNDO".equals(contents)) {
            sb.append((CharSequence)this.buildUndoTablespaceClause(objectName));
        }
        if ("PERMANENT".equals(contents)) {
            sb.append((CharSequence)this.buildPermanentTablespaceClause(objectName));
        }
        if ("TEMPORARY".equals(contents)) {
            sb.append((CharSequence)this.buildTemporaryTablespaceClause(objectName));
        }
        return Lists.newArrayList((Object[])new ObjectDefine[]{new CreateObjectDefine(ObjectType.TABLESPACE, objectName, sb.toString())});
    }

    private StringBuilder buildTemporaryTablespaceClause(String objectName) {
        StringBuilder sb = new StringBuilder();
        sb.append(" TEMPORARY TABLESPACE ").append(objectName);
        sb.append("\n").append("TEMPFILE").append((CharSequence)this.buildFileSpecifications());
        sb.append("\n").append("TABLESPACE GROUP ");
        String groupName = this.getGroupName();
        if (StringUtils.isBlank((CharSequence)groupName)) {
            sb.append("''");
        } else {
            sb.append(groupName);
        }
        return sb.append((CharSequence)this.buildExtentManagementClause());
    }

    private StringBuilder buildUndoTablespaceClause(String objectName) {
        StringBuilder sb = new StringBuilder();
        sb.append(" UNDO TABLESPACE ").append(objectName);
        sb.append("\n").append("DATAFILE").append((CharSequence)this.buildFileSpecifications());
        sb.append((CharSequence)this.buildExtentManagementClause());
        return sb.append(" RETENTION ").append(this.getRetention());
    }

    private StringBuilder buildPermanentTablespaceClause(String objectName) {
        StringBuilder sb = new StringBuilder();
        sb.append(" TABLESPACE ").append(objectName);
        sb.append("\n").append("DATAFILE").append((CharSequence)this.buildFileSpecifications());
        sb.append("\n").append("MINIMUM EXTENT ").append(this.getMinExtents());
        sb.append("\n").append("BLOCKSIZE ").append(this.getBlockSize());
        sb.append("\n").append(this.getLogging());
        if ("YES".equals(this.getForceLogging())) {
            sb.append("\n").append("FORCE LOGGING");
        }
        if ("YES".equals(this.getEncrypted())) {
            sb.append("\n").append(" ENCRYPTION USING 'encrypt_algorithm'");
            sb.append(" IDENTIFIED BY password [ NO ] SALT");
        }
        if ("ENABLED".equals(this.getDefTabCompression())) {
            String compressFor = this.getCompressFor();
            if (StringUtils.isNotBlank((CharSequence)compressFor)) {
                sb.append("\n").append("DEFAULT COMPRESS [ FOR { ALL | DIRECT_LOAD } OPERATIONS ]");
            }
        } else {
            sb.append("\n").append("NOCOMPRESS");
        }
        sb.append("\n").append("STORAGE (");
        sb.append("\n\t").append("INITIAL ").append(this.getInitialExtent());
        sb.append("\n\t").append("NEXT ").append(this.getNextExtent());
        sb.append("\n\t").append("MINEXTENTS ").append(this.getMinExtents());
        Long maxExtents = this.getMaxExtents();
        if (maxExtents != null && maxExtents > 0L) {
            sb.append("\n\t").append("MAXEXTENTS ").append(maxExtents);
        } else {
            sb.append("\n\t").append("MAXEXTENTS UNLIMITED");
        }
        Long maxSize = this.getMaxSize();
        if (maxSize != null && maxSize > 0L) {
            sb.append("\n\t").append("MAXSIZE ").append(maxSize);
        } else {
            sb.append("\n\t").append("MAXSIZE UNLIMITED");
        }
        Long pctIncrease = this.getPctIncrease();
        if (pctIncrease != null && pctIncrease > 0L) {
            sb.append("\n\t").append("PCTINCREASE ").append(pctIncrease);
        }
        sb.append("\n").append(")");
        sb.append("\n").append(this.getStatus());
        sb.append((CharSequence)this.buildExtentManagementClause());
        return sb.append("\n").append("SEGMENT SPACE MANAGEMENT ").append(this.getSegmentSpaceManagement());
    }

    private StringBuilder buildExtentManagementClause() {
        StringBuilder sb = new StringBuilder();
        String extentManagement = this.getExtentManagement();
        if ("LOCAL".equals(extentManagement)) {
            sb.append("\n").append("EXTENT MANAGEMENT LOCAL");
            String allocationType = this.getAllocationType();
            if ("SYSTEM".equals(allocationType)) {
                sb.append(" AUTOALLOCATE");
            } else if ("UNIFORM".equals(allocationType)) {
                sb.append(" UNIFORM SIZE ").append("size_clause");
            }
        } else if ("DICTIONARY".equals(extentManagement)) {
            sb.append("\n").append("EXTENT MANAGEMENT DICTIONARY");
        }
        return sb;
    }

    private StringBuilder buildFileSpecifications() {
        StringBuilder sb = new StringBuilder();
        Iterator<FileSpecification> iter = this.getFileSpecifications().iterator();
        while (iter.hasNext()) {
            FileSpecification fs = iter.next();
            sb.append("\n\t").append("'").append(fs.getFileName()).append("'");
            sb.append(" SIZE ").append(fs.getBytes());
            sb.append(" REUSE");
            String autoExtensible = fs.getAutoExtensible();
            if ("NO".equals(autoExtensible)) {
                sb.append(" AUTOEXTEND OFF");
            } else if ("YES".equals(autoExtensible)) {
                sb.append(" AUTOEXTEND ON");
            }
            if (!iter.hasNext()) continue;
            sb.append(",");
        }
        return sb;
    }

    @Override
    public List<ObjectDefine> compareTo(AbstractTablespace other) {
        if (!(other instanceof Oracle11gTablespace)) {
            throw new UnmatchedObjectTypeException("Raw type is not matched");
        }
        return null;
    }

    public static class FileSpecification {
        private Long fileId;
        private String fileName;
        private Long bytes;
        private Long blocks;
        private String status;
        private Long relativeFno;
        private String autoExtensible;
        private Long maxBytes;
        private Long maxBlocks;
        private Long incrementBy;
        private Long userBytes;
        private Long userBlocks;
        private String onlineStatus;

        public Long getFileId() {
            return this.fileId;
        }

        public void setFileId(Long fileId) {
            this.fileId = fileId;
        }

        public String getFileName() {
            return this.fileName;
        }

        public void setFileName(String fileName) {
            this.fileName = fileName;
        }

        public Long getBytes() {
            return this.bytes;
        }

        public void setBytes(Long bytes) {
            this.bytes = bytes;
        }

        public Long getBlocks() {
            return this.blocks;
        }

        public void setBlocks(Long blocks) {
            this.blocks = blocks;
        }

        public String getStatus() {
            return this.status;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public Long getRelativeFno() {
            return this.relativeFno;
        }

        public void setRelativeFno(Long relativeFno) {
            this.relativeFno = relativeFno;
        }

        public String getAutoExtensible() {
            return this.autoExtensible;
        }

        public void setAutoExtensible(String autoExtensible) {
            this.autoExtensible = autoExtensible;
        }

        public Long getMaxBytes() {
            return this.maxBytes;
        }

        public void setMaxBytes(Long maxBytes) {
            this.maxBytes = maxBytes;
        }

        public Long getMaxBlocks() {
            return this.maxBlocks;
        }

        public void setMaxBlocks(Long maxBlocks) {
            this.maxBlocks = maxBlocks;
        }

        public Long getIncrementBy() {
            return this.incrementBy;
        }

        public void setIncrementBy(Long incrementBy) {
            this.incrementBy = incrementBy;
        }

        public Long getUserBytes() {
            return this.userBytes;
        }

        public void setUserBytes(Long userBytes) {
            this.userBytes = userBytes;
        }

        public Long getUserBlocks() {
            return this.userBlocks;
        }

        public void setUserBlocks(Long userBlocks) {
            this.userBlocks = userBlocks;
        }

        public String getOnlineStatus() {
            return this.onlineStatus;
        }

        public void setOnlineStatus(String onlineStatus) {
            this.onlineStatus = onlineStatus;
        }
    }
}

